/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.CollectionFun;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvFun;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvRootDsGroup;
import com.intellij.database.view.structure.DvSimpleDsGroup;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeModelLayer;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 P2\u00020\u0001:\u0003PQRB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\u0018\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\b\u0010&\u001a\u00020\u001dH\u0002J\b\u0010'\u001a\u00020\u001dH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0002J\u001a\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001002\b\u0010-\u001a\u0004\u0018\u000102H\u0002J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020#H\u0016J\f\u00108\u001a\b\u0012\u0004\u0012\u00020)0\"J\u001c\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u001a\u0010<\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030=0\"2\u0006\u0010>\u001a\u000206H\u0002J\u001c\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u001c\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u0002060\"2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J!\u0010A\u001a\u000f\u0012\u0006\b\u0001\u0012\u0002060\"\u00a2\u0006\u0002\b\u00132\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u001c\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u0015\u0010C\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bDJ\u0012\u0010E\u001a\u00020\u000e2\b\u0010F\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#H\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010\u000e2\u0006\u0010I\u001a\u00020)H\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u000206H\u0002J\u0016\u0010K\u001a\u0004\u0018\u00010#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\b\u0010L\u001a\u00020\u001dH\u0002J\u0010\u0010M\u001a\u00020\r2\u0006\u0010$\u001a\u00020#H\u0016J\u0014\u0010N\u001a\u00020\r2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u0010\u0010O\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/intellij/database/view/structure/DvTreeModelLayer;", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "service", "Lcom/intellij/database/view/structure/DvTreeStructureService;", "(Lcom/intellij/database/view/structure/DvTreeContext;Lcom/intellij/database/view/structure/DvTreeStructureService;)V", "base", "Lcom/intellij/database/view/structure/DvTreeLayer;", "getBase", "()Lcom/intellij/database/view/structure/DvTreeLayer;", "dsGroups", "Ljava/util/TreeMap;", "", "Lcom/intellij/database/view/structure/DvDsGroup;", "knownViewOptionsCounter", "", "psiFacade", "Lcom/intellij/database/psi/DbPsiFacade;", "Lorg/jetbrains/annotations/NotNull;", "root", "Lcom/intellij/database/view/structure/DvRootDsGroup;", "getRoot", "()Lcom/intellij/database/view/structure/DvRootDsGroup;", "getService", "()Lcom/intellij/database/view/structure/DvTreeStructureService;", "withGroups", "", "addDSN", "", "ds", "Lcom/intellij/database/dataSource/AbstractDataSource;", "checkViewOptionsChanged", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNode;", "node", "clearAll", "clearGroupCache", "ensureGroupCache", "getDSN", "Lcom/intellij/database/view/DataSourceNode;", "dasDS", "Lcom/intellij/database/model/DasDataSource;", "getDataSourceNodeFor", "model", "Lcom/intellij/database/model/DasModel;", "getObjectFilterForRegularObjects", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/database/model/DasObject;", "Lcom/intellij/database/model/basic/BasicModel;", "getScope", "Lcom/intellij/database/util/TreePattern;", "host", "Lcom/intellij/database/model/basic/BasicElement;", "isAlwaysLeaf", "listAllDataSourceNodes", "listDatabases", "family", "Lcom/intellij/database/model/families/HostFamily;", "listElementFamilies", "Lcom/intellij/database/model/families/Family;", "element", "listFamilyChildren", "listNamespacesToShow", "listRegularFamilyElements", "listSchemas", "notifyDataSourcePathChanged", "notifyDataSourcePathChanged$intellij_database_impl", "obtainGroup", "path", "parentOf", "parentOfDataSource", "dsn", "parentOfElement", "parentOfFamily", "populateGroupCache", "presentableNameOf", "presentableNameOfFamily", "removeDSN", "Companion", "DataSourceManagerListener", "GroupItemsComparator", "intellij.database.impl"})
public final class DvTreeModelLayer
extends DvTreeAbstractLayer {
    @NotNull
    private final DvRootDsGroup root;
    private final TreeMap<String, DvDsGroup> dsGroups;
    private final DbPsiFacade psiFacade;
    private boolean withGroups;
    private long knownViewOptionsCounter;
    @NotNull
    private final DvTreeStructureService service;
    @Deprecated
    @NotNull
    private static final Set<ObjectKind> excludedKinds;
    @Deprecated
    @NotNull
    private static final Set<ObjectKind> alwaysLeafKinds;
    @NotNull
    private static final Companion Companion;

    @Override
    @Nullable
    public DvTreeLayer getBase() {
        return null;
    }

    @Override
    @NotNull
    public DvRootDsGroup getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof BasicElement ? this.parentOfElement((BasicElement)node) : (basicNode instanceof HostFamily ? this.parentOfFamily((HostFamily)node) : (basicNode instanceof DataSourceNode ? (BasicNode)this.parentOfDataSource((DataSourceNode)node) : (basicNode instanceof DvDsGroup ? (BasicNode)((DvDsGroup)node).getParent$intellij_database_impl() : (basicNode instanceof DvHostNode ? (BasicNode)((DvHostNode)node).host : null))));
    }

    private final BasicNode parentOfElement(BasicElement node) {
        if (node instanceof BasicRoot) {
            DbDataSource dbDataSource = this.service.findDbDataSource(node);
            if (dbDataSource == null) {
                return null;
            }
            DbDataSource dbDataSource2 = dbDataSource;
            DataSourceNode dsn = DataSourceNode.Companion.node(dbDataSource2);
            return this.parentOfDataSource(dsn);
        }
        return node.getParentFamily();
    }

    private final BasicNode parentOfFamily(HostFamily<?> node) {
        BasicElement basicElement = node.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"node.host");
        BasicElement parent2 = basicElement;
        if (parent2 instanceof BasicRoot) {
            BasicModel basicModel = ((BasicRoot)parent2).getModel();
            Intrinsics.checkNotNull((Object)basicModel);
            Intrinsics.checkNotNullExpressionValue((Object)basicModel, (String)"parent.model!!");
            return this.getDataSourceNodeFor(basicModel);
        }
        return parent2;
    }

    private final DvDsGroup parentOfDataSource(DataSourceNode dsn) {
        this.checkViewOptionsChanged();
        if (this.withGroups) {
            this.ensureGroupCache();
            String path = dsn.getGroupName();
            CharSequence charSequence = path;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                return this.getRoot();
            }
            return this.dsGroups.get(path);
        }
        return this.getRoot();
    }

    private final DataSourceNode getDataSourceNodeFor(DasModel model) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = (Iterable)this.listAllDataSourceNodes();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                DataSourceNode it2 = (DataSourceNode)element$iv2;
                boolean bl = false;
                DataSourceNode dataSourceNode = it2;
                Intrinsics.checkNotNullExpressionValue((Object)dataSourceNode, (String)"it");
                if (!(dataSourceNode.getModel() == model)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        Intrinsics.checkNotNullExpressionValue(t, (String)"listAllDataSourceNodes()\u2026st { it.model === model }");
        return (DataSourceNode)t;
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isAlwaysLeaf(node)) {
            JBIterable<Family<?>> jBIterable2 = JBIterable.empty();
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"JBIterable.empty()");
        } else {
            BasicNode basicNode = node;
            if (basicNode instanceof BasicElement) {
                jBIterable = this.listElementFamilies((BasicElement)node);
            } else if (basicNode instanceof HostFamily) {
                jBIterable = this.listFamilyChildren((HostFamily)node);
            } else if (basicNode instanceof DataSourceNode) {
                jBIterable = ((DataSourceNode)node).getModelRoot();
                if (jBIterable == null || (jBIterable = jBIterable.getFamilies()) == null || (jBIterable = CollectionFun.toJB((Iterable)jBIterable)) == null) {
                    JBIterable jBIterable3 = JBIterable.empty();
                    jBIterable = jBIterable3;
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.empty()");
                }
            } else if (basicNode instanceof DvDsGroup) {
                this.ensureGroupCache();
                jBIterable = ((DvDsGroup)node).getChildren$intellij_database_impl();
            } else {
                JBIterable jBIterable4 = JBIterable.empty();
                jBIterable = jBIterable4;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"JBIterable.empty()");
            }
        }
        return jBIterable;
    }

    private final JBIterable<Family<?>> listElementFamilies(BasicElement element2) {
        List<? extends Family<? extends BasicElement>> list = element2.getFamilies();
        Intrinsics.checkNotNullExpressionValue(list, (String)"element.families");
        JBIterable jBIterable = CollectionFun.toJB((Iterable)list).filter(new Condition(this){
            final /* synthetic */ DvTreeModelLayer this$0;

            public final boolean value(Family<? extends BasicElement> f) {
                return f instanceof HostFamily && !DvTreeModelLayer.access$Companion().getExcludedKinds().contains(((HostFamily)f).getChildrenKind()) && !this.this$0.getVo().HIDDEN_KINDS.contains(((HostFamily)f).getChildrenKind().code()) && (this.this$0.getVo().SHOW_EMPTY_GROUPS || Intrinsics.areEqual((Object)((HostFamily)f).getChildrenKind(), (Object)ObjectKind.DATABASE) || Intrinsics.areEqual((Object)((HostFamily)f).getChildrenKind(), (Object)ObjectKind.SCHEMA) || ((HostFamily)f).isNotEmpty());
            }
            {
                this.this$0 = dvTreeModelLayer;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"element.families.toJB().\u2026SCHEMA || f.isNotEmpty) }");
        return jBIterable;
    }

    private final JBIterable<? extends BasicNode> listFamilyChildren(HostFamily<?> family) {
        Object object;
        if (family.isEmpty()) {
            JBIterable<? extends BasicNode> jBIterable = JBIterable.empty();
            object = jBIterable;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.empty()");
        } else {
            ObjectKind objectKind = family.getChildrenKind();
            object = Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE) ? this.listDatabases(family) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) ? this.listSchemas(family) : this.listRegularFamilyElements(family));
        }
        return object;
    }

    private final JBIterable<? extends BasicNode> listDatabases(HostFamily<?> family) {
        return this.listNamespacesToShow(family);
    }

    private final JBIterable<? extends BasicNode> listSchemas(HostFamily<?> family) {
        return this.listNamespacesToShow(family);
    }

    private final JBIterable<? extends BasicElement> listNamespacesToShow(HostFamily<?> family) {
        JBIterable jBIterable;
        TreePattern scope;
        BasicElement basicElement = family.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"family.host");
        TreePattern treePattern = scope = this.getScope(basicElement);
        if (treePattern == null) {
            JBIterable jBIterable2 = family.jbi();
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"family.jbi()");
        } else if (Intrinsics.areEqual((Object)treePattern, (Object)TreePattern.EMPTY)) {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.empty()");
        } else {
            JBIterable jBIterable4 = family.jbi().filter(new Condition(scope){
                final /* synthetic */ TreePattern $scope;

                public final boolean value(BasicElement it2) {
                    return DataSourceSchemaMapping.matches(this.$scope, it2);
                }
                {
                    this.$scope = treePattern;
                }
            });
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"family.jbi().filter { Da\u2026ping.matches(scope, it) }");
        }
        JBIterable namespaces2 = jBIterable;
        return namespaces2;
    }

    private final JBIterable<? extends BasicElement> listRegularFamilyElements(HostFamily<?> family) {
        JBIterable jBIterable = family.jbi();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"family.jbi()");
        JBIterable children2 = jBIterable;
        Condition<DasObject> filter2 = this.getObjectFilterForRegularObjects(family.getModel());
        if (filter2 != null) {
            Function1 function1 = (Function1)new Function1<DasObject, Boolean>(filter2){

                public final boolean invoke(DasObject p1) {
                    return ((Condition)this.receiver).value((Object)p1);
                }
            };
            JBIterable jBIterable2 = children2.filter(new Condition(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ boolean value(Object p0) {
                    Object object = this.function.invoke(p0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    return (Boolean)object;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"children.filter(filter::value)");
            children2 = jBIterable2;
        }
        if (!this.getVo().SHOW_GENERATED_OBJECTS) {
            JBIterable jBIterable3 = children2.filter((Condition)listRegularFamilyElements.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"children.filter { !it.isAutoCreated }");
            children2 = jBIterable3;
        }
        return children2;
    }

    private final Condition<DasObject> getObjectFilterForRegularObjects(BasicModel model) {
        Condition<DasObject> condition;
        if (model == null) {
            return null;
        }
        BasicRoot basicRoot = model.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"model.root");
        AbstractDataSource abstractDataSource = this.service.findDataSource(basicRoot);
        if (abstractDataSource == null) {
            return null;
        }
        AbstractDataSource ds = abstractDataSource;
        try {
            condition = DbImplUtilCore.buildObjectFilter(ds);
        }
        catch (PatternSyntaxException _) {
            return null;
        }
        Condition<DasObject> filter2 = condition;
        return filter2;
    }

    private final TreePattern getScope(BasicElement host) {
        if (this.getVo().SHOW_ALL_NAMESPACES) {
            return null;
        }
        DbDataSource dbDataSource = this.service.findDbDataSource(host);
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dbDataSource2 = dbDataSource;
        return DatabaseViewTreeFun.getIntrospectionScope(dbDataSource2);
    }

    @NotNull
    public final JBIterable<DataSourceNode> listAllDataSourceNodes() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.psiFacade.getDataSources()).map((Function)listAllDataSourceNodes.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(psiFacad\u2026 -> dbDataSource.node() }");
        return jBIterable;
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof BasicElement && (alwaysLeafKinds.contains(((BasicElement)node).getKind()) || ((BasicElement)node).getFamilyKinds().isEmpty());
    }

    private final void ensureGroupCache() {
        this.checkViewOptionsChanged();
        if (this.dsGroups.isEmpty()) {
            this.populateGroupCache();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void populateGroupCache() {
        this.withGroups = this.getVo().GROUP_DATA_SOURCES;
        ((Map)this.dsGroups).put("", this.getRoot());
        if (this.withGroups) {
            void $this$mapNotNullTo$iv$iv;
            List list = this.listAllDataSourceNodes().toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listAllDataSourceNodes().toList()");
            List allDataSourceNodes = list;
            Iterable $this$mapNotNull$iv = allDataSourceNodes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                DataSourceNode dsn = (DataSourceNode)element$iv$iv;
                boolean bl2 = false;
                if (dsn.getGroupName() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            SortedSet allPaths = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            for (String path : allPaths) {
                this.obtainGroup(path);
            }
            for (DataSourceNode dsn : allDataSourceNodes) {
                this.obtainGroup(dsn.getGroupName()).addChild$intellij_database_impl(dsn);
            }
        } else {
            JBIterable<DataSourceNode> allDataSourceNodes = this.listAllDataSourceNodes();
            this.getRoot().addChildren$intellij_database_impl((Iterable)allDataSourceNodes);
        }
    }

    private final DvDsGroup obtainGroup(String path) {
        CharSequence charSequence = path;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return this.getRoot();
        }
        DvDsGroup existentGroup = this.dsGroups.get(path);
        if (existentGroup != null) {
            return existentGroup;
        }
        int k = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        DvSimpleDsGroup newGroup = null;
        if (k < 0) {
            newGroup = new DvSimpleDsGroup(this.getRoot(), path);
        } else {
            String string = path;
            int n = 0;
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, k);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String parentPath = string3;
            DvDsGroup parentGroup = this.obtainGroup(parentPath);
            String string4 = path;
            int n2 = k + 1;
            boolean bl4 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String newName = string6;
            newGroup = new DvSimpleDsGroup(parentGroup, newName);
        }
        ((Map)this.dsGroups).put(path, newGroup);
        return newGroup;
    }

    private final void checkViewOptionsChanged() {
        long remoteCounter = this.getVo().getModificationCount();
        if (this.knownViewOptionsCounter < remoteCounter) {
            if (this.withGroups != this.getVo().GROUP_DATA_SOURCES) {
                this.clearGroupCache();
                this.withGroups = this.getVo().GROUP_DATA_SOURCES;
            }
            this.knownViewOptionsCounter = remoteCounter;
        }
    }

    private final void clearGroupCache() {
        this.dsGroups.clear();
        this.getRoot().clear();
        this.withGroups = false;
    }

    @Override
    public void clearAll() {
        this.clearGroupCache();
        this.knownViewOptionsCounter = -1L;
    }

    private final DataSourceNode getDSN(DasDataSource dasDS) {
        DbDataSource dbDataSource;
        DasDataSource dasDataSource = dasDS;
        if (dasDataSource instanceof DbDataSource) {
            dbDataSource = (DbDataSource)dasDS;
        } else if (dasDataSource instanceof AbstractDataSource) {
            Object v3;
            block6: {
                List<DbDataSource> list = this.psiFacade.getDataSources();
                Intrinsics.checkNotNullExpressionValue(list, (String)"psiFacade.dataSources");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DbDataSource d2 = (DbDataSource)element$iv;
                    boolean bl = false;
                    DbDataSource dbDataSource2 = d2;
                    Intrinsics.checkNotNullExpressionValue((Object)dbDataSource2, (String)"d");
                    if (!(dbDataSource2.getDelegate() == dasDS)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            dbDataSource = v3;
        } else {
            dbDataSource = null;
        }
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dbDS = dbDataSource;
        return DataSourceNode.Companion.node(dbDS);
    }

    private final void addDSN(AbstractDataSource ds) {
        DataSourceNode dsn = this.getDSN(ds);
        if (dsn != null) {
            if (this.withGroups) {
                DvDsGroup group;
                String path = dsn.getGroupName();
                DvDsGroup dvDsGroup = group = this.obtainGroup(path);
                if (dvDsGroup != null) {
                    dvDsGroup.addChild$intellij_database_impl(dsn);
                }
            } else {
                this.getRoot().addChild$intellij_database_impl(dsn);
            }
        }
    }

    private final void removeDSN(AbstractDataSource ds) {
        for (DvDsGroup group : this.dsGroups.values()) {
            group.removeChildren$intellij_database_impl(new Predicate(ds){
                final /* synthetic */ AbstractDataSource $ds;

                public final boolean test(@NotNull BasicNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return node instanceof DataSourceNode && ((DataSourceNode)node).realDataSource == this.$ds;
                }
                {
                    this.$ds = abstractDataSource;
                }
            });
            if (!(group instanceof DvSimpleDsGroup) || !group.isEmpty()) continue;
            ((DvSimpleDsGroup)group).drop();
        }
    }

    public final void notifyDataSourcePathChanged$intellij_database_impl(@NotNull AbstractDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        if (this.withGroups) {
            this.removeDSN(ds);
            this.addDSN(ds);
        }
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        if (basicNode instanceof HostFamily) {
            string = this.presentableNameOfFamily((HostFamily)node);
        } else {
            String string2 = node.getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.displayName");
        }
        return string;
    }

    private final String presentableNameOfFamily(HostFamily<?> family) {
        BasicModel basicModel = family.getModel();
        if (basicModel == null) {
            return DvFun.getFamilyPresentableName(family);
        }
        Intrinsics.checkNotNullExpressionValue((Object)basicModel, (String)"family.model ?: return family.presentableName");
        BasicModel model = basicModel;
        ModelHelper helper = ModelFun.getHelper(model);
        String customName = helper.getCustomName(family.getChildrenKind(), true);
        String string = customName;
        if (string == null) {
            string = DvFun.getFamilyPresentableName(family);
        }
        return string;
    }

    @NotNull
    public final DvTreeStructureService getService() {
        return this.service;
    }

    public DvTreeModelLayer(@NotNull DvTreeContext context, @NotNull DvTreeStructureService service) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        super(context);
        this.service = service;
        this.root = new DvRootDsGroup(context);
        this.dsGroups = new TreeMap();
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(context.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dbPsiFacade), (String)"DbPsiFacade.getInstance(context.project)");
        this.psiFacade = dbPsiFacade;
        this.knownViewOptionsCounter = -1L;
        context.project.getMessageBus().connect().subscribe(DataSourceManager.TOPIC, (Object)new DataSourceManagerListener());
    }

    static {
        Companion = new Companion(null);
        excludedKinds = SetsKt.setOf((Object)ObjectKind.ARGUMENT);
        alwaysLeafKinds = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.SEQUENCE, ObjectKind.SYNONYM, ObjectKind.ROUTINE});
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u0002H\u0005H\u0016\u00a2\u0006\u0002\u0010\nJ1\u0010\u000b\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u0001H\u0005H\u0016\u00a2\u0006\u0002\u0010\nJ-\u0010\f\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u0002H\u0005H\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/database/view/structure/DvTreeModelLayer$DataSourceManagerListener;", "Lcom/intellij/database/psi/DataSourceManager$Listener;", "(Lcom/intellij/database/view/structure/DvTreeModelLayer;)V", "dataSourceAdded", "", "T", "Lcom/intellij/database/model/DasDataSource;", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "dataSource", "(Lcom/intellij/database/psi/DataSourceManager;Lcom/intellij/database/model/DasDataSource;)V", "dataSourceChanged", "dataSourceRemoved", "intellij.database.impl"})
    private final class DataSourceManagerListener
    implements DataSourceManager.Listener {
        @Override
        public <T extends DasDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource2) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource2, (String)"dataSource");
            T t = dataSource2;
            if (!(t instanceof AbstractDataSource)) {
                t = null;
            }
            AbstractDataSource abstractDataSource = (AbstractDataSource)t;
            if (abstractDataSource == null) {
                return;
            }
            AbstractDataSource ds = abstractDataSource;
            DvTreeModelLayer.this.addDSN(ds);
        }

        @Override
        public <T extends DasDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource2) {
        }

        @Override
        public <T extends DasDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource2) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource2, (String)"dataSource");
            T t = dataSource2;
            if (!(t instanceof AbstractDataSource)) {
                t = null;
            }
            AbstractDataSource abstractDataSource = (AbstractDataSource)t;
            if (abstractDataSource == null) {
                return;
            }
            AbstractDataSource ds = abstractDataSource;
            DvTreeModelLayer.this.removeDSN(ds);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/view/structure/DvTreeModelLayer$GroupItemsComparator;", "Ljava/util/Comparator;", "Lcom/intellij/database/model/basic/BasicNode;", "()V", "compare", "", "o1", "o2", "intellij.database.impl"})
    public static final class GroupItemsComparator
    implements Comparator<BasicNode> {
        @NotNull
        public static final GroupItemsComparator INSTANCE;

        @Override
        public int compare(@NotNull BasicNode o1, @NotNull BasicNode o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            if (o1 == o2) {
                return 0;
            }
            boolean g1 = o1 instanceof DvDsGroup;
            boolean g2 = o2 instanceof DvDsGroup;
            if (g1 && !g2) {
                return -1;
            }
            if (g2 && !g1) {
                return 1;
            }
            String string = o1.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"o1.displayName");
            String s1 = string;
            String string2 = o2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"o2.displayName");
            String s2 = string2;
            int z = StringsKt.compareTo((String)s1, (String)s2, (boolean)true);
            if (z != 0) {
                return z;
            }
            z = StringsKt.compareTo((String)s1, (String)s2, (boolean)false);
            if (z != 0) {
                return z;
            }
            return o1.hashCode() - o2.hashCode();
        }

        private GroupItemsComparator() {
        }

        static {
            GroupItemsComparator groupItemsComparator;
            INSTANCE = groupItemsComparator = new GroupItemsComparator();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/view/structure/DvTreeModelLayer$Companion;", "", "()V", "alwaysLeafKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getAlwaysLeafKinds", "()Ljava/util/Set;", "excludedKinds", "getExcludedKinds", "intellij.database.impl"})
    private static final class Companion {
        @NotNull
        public final Set<ObjectKind> getExcludedKinds() {
            return excludedKinds;
        }

        @NotNull
        public final Set<ObjectKind> getAlwaysLeafKinds() {
            return alwaysLeafKinds;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

