/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.util.SqlDialects;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectsConfigurable
extends PerFileConfigurableBase<SqlLanguageDialect> {
    private final Trinity<String, Supplier<? extends SqlLanguageDialect>, Consumer<? super SqlLanguageDialect>> myGlobalMapping;

    public SqlDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(0);
        }
        super(project, (PerFileMappingsEx)SqlDialectMappings.getInstance(project));
        this.myGlobalMapping = Trinity.create((Object)SqlBundle.message("global.sql.dialect.setting.text", new Object[0]), () -> SqlDialectMappings.getConfiguredDefaultSqlDialect(), o -> SqlDialectMappings.setDefaultSqlDialect(o));
    }

    protected boolean isGlobalMapping(Trinity<@NlsContexts.Label String, Supplier<? extends SqlLanguageDialect>, Consumer<? super SqlLanguageDialect>> prop) {
        return prop == this.myGlobalMapping || super.isGlobalMapping(prop);
    }

    @Nls
    public String getDisplayName() {
        return SqlBundle.message("sql.dialects.configurable", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.sql.dialects";
    }

    protected void renderValue(@Nullable Object target, @NotNull SqlLanguageDialect dialect, @NotNull ColoredTextContainer renderer) {
        if (dialect == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(1);
        }
        if (renderer == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(2);
        }
        renderer.append(dialect.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(3);
        }
        if (key == DESCRIPTION) {
            return SqlBundle.message("dialog.sql.dialects.caption", ApplicationNamesInfo.getInstance().getProductName(), StringUtil.escapeXmlEntities((String)SqlDialects.getGenericDialect().getDisplayName()));
        }
        if (key == MAPPING_TITLE) {
            return SqlBundle.message("dialog.sql.dialects.value.title", new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return SqlBundle.message("dialog.sql.dialects.override.question", new Object[0]);
        }
        if (key == OVERRIDE_TITLE) {
            return SqlBundle.message("dialog.sql.dialects.override.title", new Object[0]);
        }
        return null;
    }

    protected @NotNull List<Trinity<@Nls String, Supplier<? extends SqlLanguageDialect>, Consumer<? super SqlLanguageDialect>>> getDefaultMappings() {
        List<Trinity<String, Supplier<? extends SqlLanguageDialect>, Consumer<? super SqlLanguageDialect>>> list = Collections.singletonList(this.myGlobalMapping);
        if (list == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void renderDefaultValue(Object target, @NotNull ColoredTextContainer renderer) {
        SqlLanguageDialect t;
        if (renderer == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(5);
        }
        if ((t = (SqlLanguageDialect)this.getNewMapping((VirtualFile)target)) == null) {
            return;
        }
        renderer.append(t.getDisplayName(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
    }

    public static void openDialectsConfigurable(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(6);
        }
        SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            if (virtualFile != null) {
                configurable.selectFile(virtualFile);
            }
        });
    }

    public static void openDialectsConfigurable(@NotNull Project project, @NotNull List<VirtualFile> files2) {
        if (project == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(7);
        }
        if (files2 == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(8);
        }
        SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            for (VirtualFile root2 : files2) {
                configurable.selectFile(root2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectsConfigurable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectsConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderDefaultValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openDialectsConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

