/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.postfixTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CapitalizeMacro;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.EnumMacro;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.providers.SqlJoinSmartCompletionProvider;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.postfixTemplates.SqlAllFromPostfixTemplate;
import com.intellij.sql.postfixTemplates.SqlSelectPostfixTemplateBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlJoinPostfixTemplate
extends SqlSelectPostfixTemplateBase {
    protected SqlJoinPostfixTemplate(@Nullable PostfixTemplateProvider provider) {
        super("join", "select * from authors join | on |", (PostfixTemplateExpressionSelector)SqlJoinPostfixTemplate.getReferenceExpressionSelector((Condition<PsiElement>)((Condition)e -> SqlJoinPostfixTemplate.supportsSimpleJoin(e))), provider);
    }

    private static boolean supportsSimpleJoin(PsiElement e) {
        Dbms dbms = SqlImplUtil.getSqlDialectSafe(e).getDbms();
        return !dbms.isClickHouse() && !dbms.isCassandra();
    }

    @Override
    protected int getCompletionPositionsCount(@NotNull PsiElement element2) {
        Collection<String> candidates2;
        if (element2 == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(0);
        }
        if ((candidates2 = SqlJoinPostfixTemplate.getJoinCandidates(SqlJoinPostfixTemplate.unwrapElement(element2), element2)).isEmpty()) {
            return 2;
        }
        if (candidates2.size() == 1) {
            return 0;
        }
        if (SqlJoinPostfixTemplate.isSuitableCommonPrefix(SqlJoinPostfixTemplate.getCommonPrefix(candidates2))) {
            return 0;
        }
        return 1;
    }

    @Nullable
    public String getTemplateString(@NotNull PsiElement element2) {
        Collection<String> candidates2;
        if (element2 == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(1);
        }
        if ((candidates2 = SqlJoinPostfixTemplate.getJoinCandidates(SqlJoinPostfixTemplate.unwrapElement(element2), element2)).isEmpty()) {
            return "select * from $expr$ join$kword$ $complete0$ on $complete1$$END$";
        }
        if (candidates2.size() == 1) {
            String theCandidate = candidates2.iterator().next();
            return "select * from $expr$ join$kword$ " + theCandidate + "$END$";
        }
        String prefix = SqlJoinPostfixTemplate.getCommonPrefix(candidates2);
        if (SqlJoinPostfixTemplate.isSuitableCommonPrefix(prefix)) {
            return "select * from $expr$ join$kword$ " + prefix + "$pfix$$END$";
        }
        return "select * from $expr$ join$kword$ $complete0$$END$";
    }

    private static boolean isSuitableCommonPrefix(@NotNull String prefix) {
        if (prefix == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(2);
        }
        return prefix.endsWith(".") || prefix.trim().endsWith("=");
    }

    @NotNull
    private static String getCommonPrefix(@NotNull Collection<String> candidates2) {
        if (candidates2 == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(3);
        }
        String prefix = "";
        for (String candidate : candidates2) {
            if (StringUtil.isEmpty((String)prefix)) {
                prefix = candidate;
                continue;
            }
            prefix = StringUtil.commonPrefix((String)prefix, (String)candidate);
        }
        String string = prefix;
        if (string == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setVariables(@NotNull Template template, @NotNull PsiElement element2) {
        boolean unitTestMode;
        if (template == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(6);
        }
        super.setVariables(template, element2);
        Collection<String> candidates2 = SqlJoinPostfixTemplate.getJoinCandidates(SqlJoinPostfixTemplate.unwrapElement(element2), element2);
        String prefix = SqlJoinPostfixTemplate.getCommonPrefix(candidates2);
        if (SqlJoinPostfixTemplate.isSuitableCommonPrefix(prefix)) {
            MacroCallNode name = new MacroCallNode((Macro)new EnumMacro());
            for (String candidate : candidates2) {
                name.addParameter((Expression)new ConstantNode(candidate.substring(prefix.length())));
            }
            template.addVariable("pfix", (Expression)name, (Expression)name, true);
        }
        MacroCallNode name = (unitTestMode = ApplicationManager.getApplication().isUnitTestMode()) ? new MacroCallNode((Macro)new CapitalizeMacro(){

            @NotNull
            public String getDefaultValue() {
                return "";
            }
        }) : new MacroCallNode((Macro)new CompleteMacro(){

            @NotNull
            public String getDefaultValue() {
                return "";
            }
        });
        template.addVariable("kword", (Expression)name, (Expression)name, true);
    }

    @NotNull
    private static Collection<String> getJoinCandidates(@NotNull PsiElement element2, @NotNull PsiElement originalElement) {
        SqlLanguageDialectEx dialect;
        SqlTableType type;
        if (element2 == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(7);
        }
        if (originalElement == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(8);
        }
        if ((type = SqlAllFromPostfixTemplate.getTableType(element2, dialect = SqlImplUtil.getSqlDialectSafe(element2))) != null) {
            PsiElement typeElement = type.getTypeElement();
            SqlSelectStatement selectStatement = (SqlSelectStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlSelectStatement.class);
            PsiReference reference = element2.getReference();
            if (selectStatement != null && typeElement instanceof DasTable && reference instanceof SqlReferenceImpl) {
                Collection<SqlJoinSmartCompletionProvider.TableInfo> tablesForJoin = SqlJoinSmartCompletionProvider.collectTablesForJoin(dialect, element2, (SqlReferenceImpl)reference, Collections.singletonList((DasTable)typeElement), (PsiElement)selectStatement);
                LinkedHashSet<SqlJoinSmartCompletionProvider.TableInfo> tables = new LinkedHashSet<SqlJoinSmartCompletionProvider.TableInfo>(tablesForJoin);
                HashSet<String> joins = new HashSet<String>();
                SqlJoinSmartCompletionProvider.suggestJoinConditions(element2, SqlJoinSmartCompletionProvider.JoinKind.OTHER, dialect, tables, (priority, statement) -> joins.add(statement), Collections.singletonList(new SqlJoinSmartCompletionProvider.TableInfo((DasTable)typeElement, SqlJoinPostfixTemplate.getAlias(originalElement), (SqlExpression)element2)));
                HashSet<String> hashSet = joins;
                if (hashSet == null) {
                    SqlJoinPostfixTemplate.$$$reportNull$$$0(9);
                }
                return hashSet;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    private static ObjectName getAlias(@NotNull PsiElement originalElement) {
        String name;
        if (originalElement == null) {
            SqlJoinPostfixTemplate.$$$reportNull$$$0(11);
        }
        if (originalElement instanceof SqlAsExpression && (name = ((SqlAsExpression)originalElement).getName()) != null) {
            return new ObjectName(name, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/postfixTemplates/SqlJoinPostfixTemplate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/postfixTemplates/SqlJoinPostfixTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonPrefix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionPositionsCount";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableCommonPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPrefix";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setVariables";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJoinCandidates";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlias";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

