/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasScopeAware;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasTypedObjectEx;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasPredefinedSymbol;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.PsiColumnWithSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeService;
import com.intellij.database.types.DasTypeServices;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.Version;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.dialects.SqlDataSourceMappings;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.editor.SqlAnnotator;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCodeBlockElement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlImplicitDeclarationsProvider;
import com.intellij.sql.psi.SqlImplicitTarget;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlScopingExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasDefinitionImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlDeclareStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.SqlValuesParameterInfoUtils;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.psi.stubs.SqlLazyParseablePsiElement;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.symbols.DasInlineSymbol;
import com.intellij.sql.symbols.DasPsiWrappingSymbol;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImplUtil {
    public static final Function<StubElement, PsiElement> STUB_TO_PSI = element2 -> element2.getPsi();
    public static final Function<SqlNameElement, String> IDENT_TO_NAME = element2 -> element2.getName();
    public static final DasTable NO_TABLE = new EmptyTable();
    public static final String NULL_STRING = DasUtil.NO_NAME;
    public static final DasSymbol ANY_SYMBOL = new DasPredefinedSymbol(){

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.UNKNOWN;
            if (dbms == null) {
                1.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.ANY;
            if (objectKind == null) {
                1.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        public boolean isQuoted() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    public static final BracePair[] BRACE_PAIRS = new BracePair[]{new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_PAREN, (IElementType)SqlCommonTokens.SQL_RIGHT_PAREN, true), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_BRACE, (IElementType)SqlCommonTokens.SQL_RIGHT_BRACE, false), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_BRACKET, (IElementType)SqlCommonTokens.SQL_RIGHT_BRACKET, false), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_ANGLES, (IElementType)SqlCommonTokens.SQL_RIGHT_ANGLES, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_RQUOTE, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_PARAM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_PARAM_RQUOTE, false)};
    protected static final Key<PsiElement> CURRENT_QUALIFIER = Key.create((String)"CURRENT_QUALIFIER");
    protected static final Key<PsiElement> IMMEDIATE_QUALIFIER = Key.create((String)"IMMEDIATE_QUALIFIER");
    protected static final Key<PsiElement> IMMEDIATE_TARGET = Key.create((String)"IMMEDIATE_TARGET");
    private static final Key<SqlQueryExpression> LAST_QUERY_EXPRESSION = Key.create((String)"LAST_QUERY_EXPRESSION");
    private static final Logger LOG = Logger.getInstance(SqlImplUtil.class);
    private static final int ITEM_TEXT_LENGTH = 50;
    private static final Pattern SPACES = Pattern.compile("\\s+");

    protected SqlImplUtil() {
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlReferenceList list) {
        List list2 = list == null ? Collections.emptyList() : list.getReferenceList();
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlTableColumnsList list) {
        return list == null ? Collections.emptyList() : SqlImplUtil.getReferenceList(list.getColumnsReferenceList());
    }

    public static Collection<PsiElement> getReferencedElements(@NotNull SqlDefinition o) {
        SqlNameElement nameElement;
        PsiReference reference;
        SqlFileImpl.GroupImpl mirror;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(1);
        }
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        Couple<SqlFileImpl.GroupImpl> mirrorPair = SqlImplUtil.getMirror(o);
        SqlFileImpl.GroupImpl groupImpl = mirrorPair.second != null ? (SqlFileImpl.GroupImpl)mirrorPair.second : (mirror = o.getKind() == SqlDbElementType.BODY ? (SqlFileImpl.GroupImpl)mirrorPair.first : null);
        if (mirror != null) {
            mirror.delegates().addAllTo(result2);
        }
        PsiReference psiReference = reference = (nameElement = o.getNameElement()) != null && nameElement.getTextLength() > 0 ? nameElement.findReferenceAt(nameElement.getTextLength() - 1) : null;
        if (reference != null) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results2;
                for (ResolveResult resolveResult : results2 = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element2 = resolveResult.getElement();
                    result2.add(element2);
                }
            } else {
                PsiElement element3 = reference.resolve();
                result2.add(element3);
            }
        }
        return result2;
    }

    @NotNull
    public static Couple<SqlFileImpl.GroupImpl> getMirror(@NotNull SqlDefinition o) {
        PsiFile file;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(2);
        }
        if ((file = o.getContainingFile()) instanceof SqlFileImpl) {
            Couple<SqlFileImpl.GroupImpl> couple = ((SqlFileImpl)file).getMirror(o);
            if (couple == null) {
                SqlImplUtil.$$$reportNull$$$0(3);
            }
            return couple;
        }
        Couple couple = Couple.getEmpty();
        if (couple == null) {
            SqlImplUtil.$$$reportNull$$$0(4);
        }
        return couple;
    }

    @NotNull
    protected static <T> ResolveState getModifiedState(@NotNull ResolveState state, Key<T> key, T value2) {
        Object qual;
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(5);
        }
        if ((qual = state.get(key)) != null || value2 == null) {
            ResolveState resolveState = state;
            if (resolveState == null) {
                SqlImplUtil.$$$reportNull$$$0(6);
            }
            return resolveState;
        }
        ResolveState resolveState = state.put(key, value2);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(7);
        }
        return resolveState;
    }

    @NotNull
    public static ResolveState setQualifier(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(8);
        }
        return SqlImplUtil.getModifiedState(state, CURRENT_QUALIFIER, qualifier);
    }

    @NotNull
    public static ResolveState setImmediateQualifier(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(9);
        }
        return SqlImplUtil.getModifiedState(state, IMMEDIATE_QUALIFIER, qualifier);
    }

    @NotNull
    public static ResolveState setImmediateTarget(@NotNull ResolveState state, @Nullable PsiElement immediateTarget) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(10);
        }
        return SqlImplUtil.getModifiedState(state, IMMEDIATE_TARGET, immediateTarget);
    }

    public static boolean processQualifier(SqlReferenceExpression reference, SqlScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        Set<ObjectKind> expectedTypes;
        boolean found;
        if (reference == null) {
            return true;
        }
        ObjectKind kind = reference.getReferenceElementType().getTargetKind();
        if (kind != SqlDbElementType.ANY ? !SqlImplUtil.isProcessingChildOf(processor, kind) : !(found = (expectedTypes = ((SqlReferenceImpl)reference.getReference()).getExpectedTypes(true)).stream().anyMatch(expected -> SqlImplUtil.isProcessingChildOf(processor, expected)))) {
            return true;
        }
        if (PsiTreeUtil.isContextAncestor((PsiElement)reference, (PsiElement)place, (boolean)false)) {
            return true;
        }
        try {
            return SqlImplUtil.processQualifierImpl(reference, processor, resolveState, place);
        }
        catch (StackOverflowError e) {
            PsiElement placeParent = place.getParent();
            PsiElement referenceParent = reference.getParent();
            LOG.error("SOE while processing qualifier", (Throwable)e, new Attachment[]{new Attachment("place parent", SqlImplUtil.getInfo(placeParent) + "\n" + SqlImplUtil.getInfo(placeParent == null ? null : placeParent.getParent())), new Attachment("reference parent", SqlImplUtil.getInfo(referenceParent) + "\n" + SqlImplUtil.getInfo(referenceParent == null ? null : referenceParent.getParent()))});
            return true;
        }
    }

    @NotNull
    private static String getInfo(PsiElement placeParent) {
        Object object = placeParent == null ? "" : placeParent.getText() + "\n" + PsiUtilCore.getElementType((PsiElement)placeParent);
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(11);
        }
        return object;
    }

    static boolean processQualifierImpl(@NotNull SqlReferenceExpression reference, SqlScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            SqlImplUtil.$$$reportNull$$$0(12);
        }
        ResolveResult[] results2 = reference.multiResolve(false);
        PsiElement immediateQualifier = reference.getReference().resolveImmediate();
        ResolveState immediateQualifiedState = SqlImplUtil.setImmediateQualifier(resolveState, immediateQualifier);
        if (!SqlImplUtil.processDeclarationsInType((SqlExpression)reference, processor, immediateQualifiedState, place)) {
            return false;
        }
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor);
        Project project = reference.getProject();
        for (ResolveResult result2 : results2) {
            DbNamespace schemaElement;
            DasObject qualifierObject;
            DasSymbol qualifierSymbol = DasSymbolUtil.getSymbol(result2);
            PsiElement qualifierPsi = DasSymbolUtil.getSinglePsiSource(qualifierSymbol);
            DasObject dasObject = qualifierObject = qualifierSymbol != null ? qualifierSymbol.getDasObject() : null;
            if (qualifierPsi == null) {
                if (qualifierObject == null) continue;
                for (DasObject child : qualifierObject.getDasChildren(null)) {
                    if (processor.execute(DasSymbolUtil.wrapObjectToSymbol(child, project), resolveState)) continue;
                    return false;
                }
                continue;
            }
            ResolveState qualifiedState = SqlImplUtil.setQualifier(resolveState, qualifierPsi);
            processor.setResolveContext(qualifierPsi);
            if (!qualifierSymbol.isValid()) continue;
            if (qualifierObject instanceof DasSynonym) {
                qualifierSymbol = DasSymbolUtil.wrapObjectToSymbol(qualifierObject = DasUtil.resolveFinalTarget((DasSynonym)qualifierObject), project);
                if (qualifierSymbol == null || !qualifierSymbol.isValid()) continue;
                qualifierPsi = DasSymbolUtil.getSinglePsiSource(qualifierSymbol);
            }
            if (qualifierSymbol instanceof DasScopeAware && !((DasScopeAware)((Object)qualifierSymbol)).processDeclarations((DasScopeProcessor)processor, qualifiedState, null, place)) {
                return false;
            }
            if (qualifierObject instanceof DasTable) {
                if (!SqlImplUtil.processAlterStatements(processor, qualifiedState, place, qualifierObject)) {
                    return false;
                }
                PsiFile qualFile = qualifierPsi != null ? qualifierPsi.getContainingFile() : null;
                PsiFile placeFile = place.getContainingFile();
                if (!SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifierPsi, qualFile)) {
                    return false;
                }
                if (qualFile != null && qualFile != placeFile && !SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifierPsi, placeFile)) {
                    return false;
                }
            }
            if ((schemaElement = (DbNamespace)ObjectUtils.tryCast((Object)qualifierObject, DbNamespace.class)) == null || schemaElement.getKind() != SqlDbElementType.SCHEMA || !majorChildExpected || SqlImplUtil.processSchemaMajorChildren(processor, schemaElement.createDeclarationProcessor((DasScopeProcessor)processor, qualifiedState, null, place), schemaElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMajorChildExpected(@Nullable SqlScopeProcessor processor) {
        if (processor == null) {
            return false;
        }
        Set expectedTypes = processor.getExpectedTypes();
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        for (ObjectKind type : expectedTypes) {
            if (!processor.getDialect().isMajorChild(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean processOnTableCreateStatements(SqlScopeProcessor processor, ResolveState resolveState, PsiElement qualifier, PsiFile containingFile) {
        PsiFile psiFile = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
        if (containingFile instanceof SqlFile) {
            for (SqlElement statement : ((SqlFile)containingFile).getDdl()) {
                SqlReferenceExpression ref;
                if (!(statement instanceof SqlTargetContextProvider) || !(statement instanceof SqlDefinition) || (ref = ((SqlTargetContextProvider)statement).getTargetContextExpression()) == null || !ref.getReference().isReferenceTo(qualifier) || processor.execute((DasSymbol)((SqlDefinition)statement), resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processAlterStatements(SqlScopeProcessor processor, ResolveState resolveState, PsiElement place, DasObject qualifier) {
        return SqlImplUtil.processAlterStatements(place.getContainingFile(), place, qualifier, (Processor<? super SqlAlterInstruction>)((Processor)instruction2 -> instruction2.processDeclarations(processor, resolveState, null, place)));
    }

    public static boolean processAlterStatements(PsiFile file, PsiElement place, DasObject qualifierTarget, Processor<? super SqlAlterInstruction> processor) {
        if (!(file instanceof SqlFile)) {
            return true;
        }
        SqlFile original = (SqlFile)ObjectUtils.tryCast((Object)file.getOriginalFile(), SqlFile.class);
        if (original == null) {
            return true;
        }
        NameChecker checker = new NameChecker(qualifierTarget, original.getSqlLanguage());
        for (SqlElement ddl : original.getDdl()) {
            SqlReferenceExpression target;
            SqlAlterStatement statement = (SqlAlterStatement)ObjectUtils.tryCast((Object)ddl, SqlAlterStatement.class);
            if (statement == null || place != null && PsiTreeUtil.isContextAncestor((PsiElement)statement, (PsiElement)place, (boolean)false) || (target = statement.getAlterTargetReference()) == null || !checker.checkName((DasNamed)target, null) || !(qualifierTarget instanceof PsiElement) || !target.getReference().isReferenceTo((PsiElement)qualifierTarget) || ContainerUtil.process((Object[])statement.getAlterInstructions(), processor)) continue;
            return false;
        }
        return true;
    }

    public static boolean processPositionalDeclarationInType(SqlType sqlType, SqlScopeProcessor processor, ResolveState state, SqlPositionalReference place) {
        if (!(sqlType instanceof SqlTableType)) {
            return true;
        }
        SqlTableType tableType = (SqlTableType)sqlType;
        int position = place.getPosition();
        if (position < 1 || position > tableType.getColumnCount()) {
            return false;
        }
        PsiElement columnImmediateSource = tableType.getImmediateSourceColumnElement(position - 1);
        DasSymbol columnSourceSymbol = DasSymbolUtil.getSymbolByPsi(columnImmediateSource);
        if (columnSourceSymbol != null) {
            processor.execute(columnSourceSymbol, SqlImplUtil.setImmediateTarget(state, columnImmediateSource));
        }
        return false;
    }

    public static boolean processDeclarationsInType(SqlExpression expression, SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN, SqlDbElementType.TABLE, SqlDbElementType.ROUTINE, SqlDbElementType.METHOD)) {
            return true;
        }
        SqlType t = expression.getSqlType();
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)t, SqlTableType.class);
        return type == null || SqlImplUtil.processDeclarationsInType(type, processor, state, place);
    }

    public static boolean processDeclarationsInType(SqlTableType tableType, SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        if (tableType instanceof SqlTableTypeBase.UnresolvedRefType && place instanceof SqlReferenceExpression && SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN, SqlDbElementType.OBJECT_ATTRIBUTE)) {
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state, tableType.getTypeElement());
            DasSymbol unresolvedSymbol = DasSymbolUtil.getInlineSymbol(((SqlReferenceExpression)place).getReference(), true);
            processor.execute(unresolvedSymbol, qualifiedState);
            return true;
        }
        Project project = place.getProject();
        if (SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.ROUTINE, SqlDbElementType.METHOD)) {
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state, tableType.getTypeElement());
            for (DasObject m : tableType.getMethods()) {
                if (processor.execute(DasSymbolUtil.wrapObjectToSymbol(m, project), qualifiedState)) continue;
                return false;
            }
        }
        if (!SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN, SqlDbElementType.TABLE, SqlDbElementType.OBJECT_ATTRIBUTE)) {
            return true;
        }
        if (SqlImplUtil.isAsteriskRef(place)) {
            SqlReferenceExpression asteriskRef = (SqlReferenceExpression)place;
            PsiElement immediateTypeElement = tableType.getImmediateTypeElement();
            PsiElement context = immediateTypeElement != null ? immediateTypeElement : place;
            SqlAsteriskSymbol target = new SqlAsteriskSymbol(context, tableType);
            return processor.execute(DasSymbolUtil.getInlineSymbol(asteriskRef.getReference()), SqlImplUtil.setImmediateTarget(state, (PsiElement)target));
        }
        if (place instanceof SqlPositionalReference) {
            return SqlImplUtil.processPositionalDeclarationInType((SqlType)tableType, processor, state, (SqlPositionalReference)place);
        }
        int columnCount = tableType.getColumnCount();
        PsiElement prevQualifier = null;
        for (int i2 = 0; i2 < columnCount; ++i2) {
            DasSymbol qualifierSymbol;
            ResolveResult[] results2;
            PsiElement columnQualifier = tableType.getColumnQualifier(i2);
            PsiElement immediateSource = tableType.getImmediateSourceColumnElement(i2);
            ResolveState qualifiedState = SqlImplUtil.setImmediateTarget(SqlImplUtil.setQualifier(state, columnQualifier), immediateSource);
            processor.setResolveContext(columnQualifier);
            PsiElement element2 = tableType.getColumnElement(i2);
            PsiElement sourceElement = tableType.getSourceColumnElement(i2);
            PsiElement source = element2 instanceof SqlDefinition || sourceElement == null ? element2 : sourceElement;
            ResolveResult[] resolveResultArray = results2 = source instanceof SqlReferenceExpression ? ((SqlReferenceExpression)source).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
            if (results2.length > 0) {
                for (ResolveResult result2 : results2) {
                    DasSymbol target = DasSymbolUtil.getSymbol(result2);
                    if (target == null || processor.execute(target, qualifiedState)) continue;
                    return false;
                }
            } else {
                DasSymbol sourceSymbol = DasSymbolUtil.getSymbolByPsi(source);
                if (sourceSymbol != null && !processor.execute(sourceSymbol, qualifiedState)) {
                    return false;
                }
            }
            if (columnQualifier == null || columnQualifier == prevQualifier) continue;
            prevQualifier = columnQualifier;
            if ((processor instanceof SqlCompletionScopeProcessor && !SqlImplUtil.hasAcceptedCompletionSuggestions(processor) || !SqlImplUtil.isQualifiedContext(place)) && (qualifierSymbol = DasSymbolUtil.getSymbolByPsi(columnQualifier)) != null) {
                processor.execute(qualifierSymbol, state);
            }
            if (SqlImplUtil.hasAcceptedCompletionSuggestions(processor) || !(columnQualifier instanceof DasTable) || SqlImplUtil.processAlterStatements(processor, state, place, (DasObject)columnQualifier)) continue;
            return false;
        }
        return SqlImplUtil.getSqlDialectSafe(place).processTypeExtra(tableType, processor, state, place);
    }

    private static boolean isQualifiedContext(@Nullable PsiElement place) {
        return place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getQualifierExpression() != null;
    }

    private static boolean hasAcceptedCompletionSuggestions(@Nullable SqlScopeProcessor processor) {
        return processor instanceof SqlCompletionScopeProcessor && ((SqlCompletionScopeProcessor)processor).hasAcceptedCompletionVariants();
    }

    @Nullable
    public static PsiElement sqlParent(@Nullable PsiElement e) {
        PsiElement tmp2;
        PsiElement psiElement = tmp2 = e == null ? null : SqlImplUtil.getStubOrPsiParent(e);
        while (tmp2 != null) {
            if (PsiUtilCore.getElementType((PsiElement)tmp2) != SqlElementTypes.SQL_DUMMY_BLOCK) {
                return tmp2;
            }
            tmp2 = SqlImplUtil.getStubOrPsiParent(tmp2);
        }
        return null;
    }

    @NotNull
    public static CasingProvider getCasingProvider(@NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<? extends DbDataSource> dataSources) {
        DbDataSource dataSource2;
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(13);
        }
        if (dataSources == null) {
            SqlImplUtil.$$$reportNull$$$0(14);
        }
        DasModel model = (dataSource2 = (DbDataSource)Iterables.getFirst(dataSources, null)) == null ? DasUtil.emptyModel() : dataSource2.getModel();
        CasingProvider casingProvider = model == DasUtil.emptyModel() ? dialect : model;
        if (casingProvider == null) {
            SqlImplUtil.$$$reportNull$$$0(15);
        }
        return casingProvider;
    }

    @NotNull
    public static List<DbDataSource> getDataSources(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(16);
        }
        PsiFile containingFile = element2.getContainingFile();
        List<DbDataSource> list = SqlDataSourceMappings.getInstance(containingFile.getProject()).getDataSources(containingFile);
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    public static int getParentTypes(@NotNull SqlLanguageDialect dialect, ObjectKind type, int minLevel, int maxLevel, @NotNull Set<ObjectKind> ignored, Set<? super ObjectKind> result2) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(18);
        }
        if (ignored == null) {
            SqlImplUtil.$$$reportNull$$$0(19);
        }
        if (maxLevel > 0 && minLevel > maxLevel) {
            throw new IllegalArgumentException();
        }
        if (minLevel <= 0) {
            result2.add(type);
        }
        if (maxLevel == 0) {
            return 0;
        }
        LinkedList queue = new LinkedList();
        dialect.getParentDbTypes(queue, type);
        queue.removeAll(ignored);
        int curLevel = 0;
        int curSize = queue.size();
        LinkedHashSet<ObjectKind> levelSet = new LinkedHashSet<ObjectKind>();
        while (!queue.isEmpty()) {
            ObjectKind cur2 = (ObjectKind)queue.removeFirst();
            boolean isAdded = levelSet.add(cur2);
            if (--curSize == 0) {
                if (minLevel <= ++curLevel && (maxLevel < 0 || curLevel <= maxLevel) && !result2.addAll(levelSet)) break;
                levelSet.clear();
            }
            if (maxLevel > -1 && curLevel == maxLevel) break;
            if (isAdded) {
                dialect.getParentDbTypes(queue, cur2);
            }
            if (curSize != 0) continue;
            curSize = queue.size();
        }
        return curLevel;
    }

    @NotNull
    public static DataType getArrayTypeOf(@NotNull DataType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(20);
        }
        if (type == DataType.UNKNOWN || type.getSpecification().equalsIgnoreCase("anyelement")) {
            DataType dataType = DataTypeFactory.of("anyarray");
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(21);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.of(type.getSpecification() + "[]");
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(22);
        }
        return dataType;
    }

    @NotNull
    public static SqlType getArrayTypeOf(@NotNull SqlType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(23);
        }
        SqlType sqlType = SqlTypeFactory.of(SqlImplUtil.getArrayTypeOf(type.getDataType()), SqlType.Category.ARRAY);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(24);
        }
        return sqlType;
    }

    @NotNull
    public static SqlTableType createType(final String name, final @NotNull List<? extends Column> result2, final @Nullable PsiElement qualifier, String vagueArg) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(25);
        }
        final DataType dataType = DataTypeFactory.ofArgs(null, "table", vagueArg, false);
        return result2.isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new SqlTableTypeBase(){

            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            @NotNull
            public List<DasObject> getMethods() {
                List<DasObject> list = Collections.emptyList();
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            @Nullable
            public String getTypeName() {
                return name;
            }

            public int getColumnCount() {
                return result2.size();
            }

            public String getColumnName(int i2) {
                return ((Column)result2.get((int)i2)).name;
            }

            public boolean isColumnQuoted(int i2) {
                Column column2 = (Column)result2.get(i2);
                Boolean quoted = 2.isQuoted(column2.element);
                return quoted == null ? Boolean.TRUE.equals(2.isQuoted(column2.sourceElement)) : quoted.booleanValue();
            }

            public SqlType getColumnType(int i2) {
                return ((Column)result2.get((int)i2)).type;
            }

            public DasType getColumnDasType(int i2) {
                return ((Column)result2.get((int)i2)).dasType;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                PsiElement psiElement = ((Column)result2.get((int)i2)).element;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return ((Column)result2.get((int)i2)).sourceElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static SqlTableType createType(@NotNull List<? extends Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(26);
        }
        return SqlImplUtil.createType(null, result2, qualifier);
    }

    @NotNull
    public static SqlTableType createType(String name, @NotNull List<? extends Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(27);
        }
        return SqlImplUtil.createType(name, " ", result2, qualifier);
    }

    @NotNull
    public static SqlTableType createType(String name, String typeSeparator, @NotNull List<? extends Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(28);
        }
        StringBuilder args = new StringBuilder();
        for (Column column2 : result2) {
            if (args.length() != 0) {
                args.append(",");
            }
            if (column2.name != null) {
                args.append(column2.name).append(typeSeparator);
            }
            args.append(column2.type.getDataType().getSpecification());
        }
        return SqlImplUtil.createType(name, result2, qualifier, args.toString());
    }

    @NotNull
    public static SqlType getSqlType(@NotNull SqlTypedDefinition definition, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement place) {
        SqlType type;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(29);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(30);
        }
        if ((type = definition.getSqlType()) == SqlType.UNKNOWN || type.getCategory() == SqlType.Category.RECORD) {
            SqlType res2 = dialect.getTypeSystem().getDefinitionType(definition, place);
            SqlType sqlType = res2 == SqlType.UNKNOWN ? type : res2;
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(31);
            }
            return sqlType;
        }
        SqlType sqlType = type;
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(32);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(33);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(34);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(35);
        }
        return SqlImplUtil.getSqlType(object, dialect, (UserDataHolder)context, context, context.getProject());
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect, @NotNull UserDataHolder holder, @Nullable PsiElement context, @NotNull Project project) {
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(36);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(37);
        }
        if (holder == null) {
            SqlImplUtil.$$$reportNull$$$0(38);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(39);
        }
        if (object instanceof SqlTypedDefinition) {
            SqlType sqlType = ((SqlTypedDefinition)object).getSqlType();
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(40);
            }
            return sqlType;
        }
        return SqlImplUtil.getSqlType(object.getDataType(), dialect, holder, context, project);
    }

    @NotNull
    public static DataType getArrayElement(@NotNull DataType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(41);
        }
        if (type.getSpecification().equalsIgnoreCase("anyarray")) {
            DataType dataType = DataTypeFactory.of("anyelement");
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(42);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.of(StringUtil.trimEnd((String)type.getSpecification(), (String)"[]"));
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(43);
        }
        return dataType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasUserDefinedType type, @NotNull PsiElement element2, @NotNull SqlLanguageDialectEx dialect) {
        JBIterable children2;
        List columns;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(44);
        }
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(45);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(46);
        }
        if (!(columns = (children2 = type.getDasChildren(null).filter(DasTypedObject.class)).filter(PsiObject.class).transform(e -> {
            SqlType sqlType = SqlImplUtil.getSqlType((DasTypedObject)((Object)e), dialect, (PsiElement)e);
            DasType dasType = e instanceof DasTypedObjectEx ? ((DasTypedObjectEx)((Object)e)).getDasType() : DasType.UNKNOWN;
            return new Column(e.getName(), sqlType, dasType, (PsiElement)e, (PsiElement)e);
        }).toList()).isEmpty()) {
            return SqlImplUtil.createType(columns, element2);
        }
        DataType dataType = DataTypeFactory.of(type.getName());
        SqlType sqlType = type.getKind() == SqlDbElementType.COLLECTION_TYPE ? SqlTypeFactory.of(dataType, SqlType.Category.ARRAY) : SqlTypeFactory.of(dataType, dialect);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(47);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(48);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(49);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(50);
        }
        return SqlImplUtil.getSqlType(dataType, dialect, (UserDataHolder)context, context, context.getProject());
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect, @NotNull UserDataHolder holder, @Nullable PsiElement context, @NotNull Project project) {
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(51);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(52);
        }
        if (holder == null) {
            SqlImplUtil.$$$reportNull$$$0(53);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(54);
        }
        SqlType sqlType = (SqlType)((ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue(holder, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.create(p2 -> SqlImplUtil.computeSqlType((DataType)p2.first, (SqlLanguageDialect)p2.second, context, project), ContainerUtil::createConcurrentSoftValueMap), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))).get(Pair.create((Object)dataType, (Object)dialect));
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(55);
        }
        return sqlType;
    }

    @NotNull
    private static SqlType computeSqlType(DataType dataType, SqlLanguageDialect language, @Nullable PsiElement context, @NotNull Project project) {
        SqlTypeElement unwrapped;
        SqlTypeElement type;
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(56);
        }
        if ((type = SqlPsiElementFactory.createDataTypeFromText(dataType.getSpecification(), language, project, context, true)) != null) {
            SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)type.getContainingFile(), (Object)true);
        }
        Object object = (unwrapped = type) == null ? SqlType.UNKNOWN : unwrapped.findSqlType();
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(57);
        }
        return object;
    }

    @Nullable
    public static PsiElement getQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(58);
        }
        return (PsiElement)state.get(CURRENT_QUALIFIER);
    }

    @Nullable
    public static PsiElement getImmediateQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(59);
        }
        return (PsiElement)state.get(IMMEDIATE_QUALIFIER);
    }

    @Nullable
    public static PsiElement getImmediateTarget(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(60);
        }
        return (PsiElement)state.get(IMMEDIATE_TARGET);
    }

    @Nullable
    public static SqlQueryExpression getLastQueryExpression(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(61);
        }
        return (SqlQueryExpression)state.get(LAST_QUERY_EXPRESSION);
    }

    @NotNull
    public static ResolveState setLastQueryExpression(@NotNull ResolveState state, @NotNull SqlQueryExpression queryExpression) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(62);
        }
        if (queryExpression == null) {
            SqlImplUtil.$$$reportNull$$$0(63);
        }
        return SqlImplUtil.getModifiedState(state, LAST_QUERY_EXPRESSION, queryExpression);
    }

    @Nullable
    public static PsiElement getQualifier(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getQualifier() : null;
    }

    @Nullable
    public static PsiElement getImmediateTarget(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getImmediateTarget() : null;
    }

    @NotNull
    public static JBIterable<PsiElement> revSiblings(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(64);
        }
        return SqlImplUtil.getSiblingElements(e, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed());
    }

    @NotNull
    protected static JBIterable<PsiElement> getSiblingElements(@NotNull PsiElement e, SyntaxTraverser.ApiEx<PsiElement> api) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(65);
        }
        JBIterable parents2 = api.parents((Object)e).takeWhile(o -> o == e || api.typeOf(o) == SqlElementTypes.SQL_DUMMY_BLOCK);
        JBIterable roots = parents2.flatten(p2 -> p2 == e ? api.siblings(p2) : api.siblings(p2).skip(1));
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoots((Iterable)roots)).expand(Conditions.alwaysFalse())).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(66);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> siblings(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(67);
        }
        return SqlImplUtil.getSiblingElements(e, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApi());
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlRevTraverser(PsiElement element2) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.revPsiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)).withRoot((Object)element2);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(68);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlRevChildren(@Nullable PsiElement element2) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlRevTraverser(element2).expandAndSkip(Conditions.is((Object)element2))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(69);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildrenNoWS(@Nullable PsiElement element2) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren(element2).filter(e -> !(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(70);
        }
        return jBIterable;
    }

    @NotNull
    public static Condition<PsiElement> byElementType(IElementType ... types) {
        if (types == null) {
            SqlImplUtil.$$$reportNull$$$0(71);
        }
        Condition condition = element2 -> ArrayUtil.contains((Object)element2.getNode().getElementType(), (Object[])types);
        if (condition == null) {
            SqlImplUtil.$$$reportNull$$$0(72);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlParents(@Nullable PsiElement e) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterable jBIterable = api.parents((Object)e).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.notEqualTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(73);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<SqlCompositeElement> sqlCompositeElements(@Nullable PsiElement root2) {
        SyntaxTraverser s2 = SqlImplUtil.sqlTraverser(root2).filterTypes(Conditions.notInstanceOf(SqlKeywordTokenType.class));
        JBIterable jBIterable = ((SyntaxTraverser)s2.expand(Conditions.or((Condition)Conditions.is((Object)root2), (Condition)Conditions.compose((Function)s2.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK))))).filter(SqlCompositeElement.class);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(74);
        }
        return jBIterable;
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element2) {
        ASTNode node = element2 == null ? null : element2.getNode();
        return node == null ? null : node.getElementType();
    }

    @Nullable
    private static String getNameOrText(@Nullable PsiElement e) {
        return e instanceof SqlNameElement ? ((SqlNameElement)e).getName() : (e instanceof DasObject ? ((DasObject)e).getName() : (e != null ? e.getText() : null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static SqlTableType getSelectType(@NotNull List<? extends SqlExpression> list, @Nullable PsiElement qualifier) {
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(75);
        }
        SqlTableType result2 = SqlTableTypeBase.EMPTY_TABLE;
        for (SqlExpression sqlExpression : list) {
            boolean flatten;
            void var4_4;
            void var4_7;
            SqlColumnAliasListImpl aliasList;
            if (sqlExpression instanceof SqlAsExpression && (aliasList = (SqlColumnAliasListImpl)PsiTreeUtil.getChildOfType((PsiElement)sqlExpression, SqlColumnAliasListImpl.class)) != null) {
                for (SqlDefinition alias : aliasList.getColumnAliasList()) {
                    SqlType sqlType = aliasList.getAliasedSqlType(alias);
                    DasType dasType = aliasList.getAliasedDasType(alias);
                    result2 = result2.add(SqlTableTypeBase.ensureTableType(sqlType, dasType, (PsiElement)alias, qualifier));
                }
                continue;
            }
            Object type = sqlExpression.getSqlType();
            DasType dasType = sqlExpression.getDasType();
            SqlTypeCastExpression cast = (SqlTypeCastExpression)ObjectUtils.tryCast((Object)sqlExpression, SqlTypeCastExpression.class);
            String name = null;
            String aliasName = null;
            boolean quoted = false;
            if (cast != null) {
                SqlExpression sqlExpression2 = cast.getExpression();
                SqlTypeElement element2 = cast.getTypeElement();
                if (element2 != null) {
                    name = element2.getDisplayName();
                }
            }
            if (var4_7 instanceof SqlFunctionCallExpression) {
                String fooName;
                SqlReferenceExpression fooRef = ((SqlFunctionCallExpression)var4_7).getNameElement();
                String string = fooName = fooRef == null ? null : fooRef.getName();
                if (fooName != null && fooName.equalsIgnoreCase("cast")) {
                    List args;
                    SqlExpressionList params = ((SqlFunctionCallExpression)var4_7).getParameterList();
                    List list2 = args = params == null ? null : params.getExpressionList();
                    if (!ContainerUtil.isEmpty((Collection)args)) {
                        SqlExpression sqlExpression3 = (SqlExpression)args.get(0);
                    }
                }
            }
            if (name == null) {
                name = SqlImplUtil.getNameOrText((PsiElement)var4_4);
                boolean bl = var4_4 instanceof SqlNameElement ? ((SqlNameElement)var4_4).isQuotedIdentifier() : (quoted = var4_4 instanceof SqlDefinition && ((SqlDefinition)var4_4).isNameQuoted());
            }
            if (var4_4 instanceof SqlReferenceExpression) {
                PsiElement columnQualifier = SqlImplUtil.getQualifier(((SqlReferenceExpression)var4_4).resolveSingle());
                aliasName = SqlImplUtil.getNameOrText(columnQualifier);
            }
            boolean bl = flatten = "*".equals(name) || list.size() == 1 && SqlImplUtil.getSqlDialectSafe((PsiElement)var4_4).getDbms() == Dbms.EXASOL;
            type = flatten && type instanceof SqlTableType ? (name == null ? type : ((SqlTableType)type).flattenedAlias(name, qualifier, (SqlElement)var4_4)) : SqlTableTypeBase.createType((PsiElement)var4_4, type, dasType, name, quoted, qualifier, aliasName);
            result2 = result2.add(SqlTableTypeBase.ensureTableType(type, dasType, (PsiElement)var4_4, qualifier));
        }
        if (result2 != SqlTableTypeBase.EMPTY_TABLE) {
            result2 = result2.alias(null, qualifier, Collections.emptyList());
        }
        SqlTableType sqlTableType = result2;
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(76);
        }
        return sqlTableType;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheLeftOfType(@Nullable PsiElement element2, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(77);
        }
        if (element2 == null) {
            return null;
        }
        for (PsiElement psiElement = element2.getPrevSibling(); psiElement != null; psiElement = psiElement.getPrevSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    public static boolean processFromReferences(SqlScopeProcessor processor, ResolveState state, SqlExpression fromExpression, PsiElement place, PsiElement lastParent) {
        SqlType type;
        if (!SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN, SqlDbElementType.TABLE)) {
            return true;
        }
        SqlType sqlType = type = fromExpression == null ? null : SqlImplUtil.getTypeLateralAware(fromExpression, place);
        if (!(type instanceof SqlTableType)) {
            return true;
        }
        ResolveState newState = state;
        if (SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN)) {
            newState = SqlImplUtil.setImmediateQualifier(newState, (PsiElement)fromExpression);
        }
        if (SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.TABLE)) {
            newState = SqlImplUtil.setImmediateTarget(newState, (PsiElement)fromExpression);
        }
        return SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, newState, place);
    }

    @NotNull
    public static SqlType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement end2) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(78);
        }
        Object object = expression instanceof SqlLateralAwareExpression ? ((SqlLateralAwareExpression)expression).getSqlType(end2) : (end2 != null && PsiTreeUtil.isContextAncestor((PsiElement)expression, (PsiElement)end2, (boolean)false) ? SqlTableTypeBase.EMPTY_TABLE : expression.getSqlType());
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(79);
        }
        return object;
    }

    public static List<PsiColumnWithSymbol> createColumnInfos(SqlTableDefinition tableInfo, SqlTableType tableType) {
        int count = tableType.getColumnCount();
        ArrayList<PsiColumnWithSymbol> result2 = new ArrayList<PsiColumnWithSymbol>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            result2.add(new MyColumnInfo(tableInfo, i2, tableType));
        }
        return result2;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element2, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(80);
        }
        return SqlImplUtil.getSiblingToTheRightOfType(element2, strict, null, classes);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element2, boolean strict, @Nullable Condition<? super PsiElement> skip, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(81);
        }
        if (element2 == null) {
            return null;
        }
        for (PsiElement psiElement = element2.getNextSibling(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement || skip != null && skip.value((Object)psiElement)) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> resolveQualified(@Nullable SqlReferenceExpression ref) {
        ResolveResult[] results2;
        ResolveResult[] resolveResultArray = results2 = ref == null ? null : ref.multiResolve(false);
        if (results2 == null || results2.length == 0) {
            List<Pair<PsiElement, PsiElement>> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(82);
            }
            return list;
        }
        ArrayList<Pair<PsiElement, PsiElement>> res2 = new ArrayList<Pair<PsiElement, PsiElement>>();
        for (ResolveResult result2 : results2) {
            DasSymbol symbol = DasSymbolUtil.getSymbol(result2);
            if (symbol instanceof DasInlineSymbol && ((DasInlineSymbol)symbol).isUnresolved()) continue;
            res2.add((Pair<PsiElement, PsiElement>)Pair.create((Object)SqlImplUtil.getQualifier(result2), (Object)result2.getElement()));
        }
        ArrayList<Pair<PsiElement, PsiElement>> arrayList = res2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(83);
        }
        return arrayList;
    }

    public static boolean processObjectParents(@Nullable DasSymbol startSymbol, SqlScopeProcessor processor, ResolveState resolveState) {
        Project project = processor.getPlace().getProject();
        for (DasObject object = startSymbol != null ? startSymbol.getDasObject() : null; object != null; object = object.getDasParent()) {
            DasSymbol symbol = DasSymbolUtil.wrapObjectToSymbol(object, project);
            if (processor.execute(symbol, resolveState)) continue;
            return false;
        }
        return true;
    }

    public static PsiElement getBlockContentElement(@NotNull PsiElement block) {
        if (block == null) {
            SqlImplUtil.$$$reportNull$$$0(84);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (PsiElement)api.children((Object)block).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK))).first();
    }

    public static <T> T @NotNull [] toArray(@Nullable Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            SqlImplUtil.$$$reportNull$$$0(85);
        }
        Object[] objectArray = c2 != null ? c2.toArray(factory.create(c2.size())) : factory.create(0);
        if (objectArray == null) {
            SqlImplUtil.$$$reportNull$$$0(86);
        }
        return objectArray;
    }

    @Nullable
    public static Version getMinDbmsVersion(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(87);
        }
        Version minVersion = null;
        for (DbDataSource dataSource2 : SqlImplUtil.getDataSources(element2)) {
            Version version = Version.parse(dataSource2.getDatabaseVersion().version);
            if (version == null || minVersion != null && version.compareTo(minVersion) >= 0) continue;
            minVersion = version;
        }
        return minVersion;
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialectSafe(@Nullable PsiElement element2) {
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)ObjectUtils.notNull((Object)DbSqlUtilCore.getSqlDialect(element2), (Object)SqlDialectImplUtilCore.getDefaultSqlDialect());
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(88);
        }
        return sqlLanguageDialectEx;
    }

    public static void acceptChildren(SqlElement parent2, SqlVisitor visitor2) {
        for (PsiElement element2 = parent2.getFirstChild(); element2 != null; element2 = element2.getNextSibling()) {
            if (!(element2 instanceof SqlElement)) continue;
            ((SqlElement)element2).accept(visitor2);
        }
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser() {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK));
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(89);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser(PsiElement element2) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoot((Object)element2);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(90);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildren(@Nullable PsiElement element2) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(element2).expandAndSkip(Conditions.is((Object)element2))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(91);
        }
        return jBIterable;
    }

    public static JBIterable<? extends PsiElement> childrenTreeIt(PsiElement element2) {
        return SqlImplUtil.sqlChildren(element2).filter(SqlCompositeElement.class);
    }

    public static JBIterable<? extends PsiElement> childrenStubIt(StubElement<?> element2) {
        return JBIterable.from((Iterable)element2.getChildrenStubs()).transform(STUB_TO_PSI);
    }

    public static JBIterable<? extends PsiElement> childrenIt(PsiElement element2) {
        StubElement stub;
        Object object = element2 instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element2).getStub() : (stub = element2 instanceof PsiFileImpl ? ((PsiFileImpl)element2).getStub() : null);
        if (stub != null) {
            return SqlImplUtil.childrenStubIt(stub);
        }
        return SqlImplUtil.childrenTreeIt(element2);
    }

    public static boolean processDeclarationsDefault(SqlElement element2, boolean processChildrenDeclarations, SqlScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault(element2, SqlImplUtil.childrenTreeIt((PsiElement)element2), processChildrenDeclarations, processor, state, lastParent, place, !(element2 instanceof SqlExpression) && !(element2 instanceof SqlFromClause));
    }

    public static boolean processDeclarationsDefault(SqlElement element2, JBIterable<? extends PsiElement> notableChildren, boolean processChildrenDeclarations, SqlScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, boolean allowForwardReferences) {
        if (lastParent instanceof SqlWithClause || lastParent instanceof SqlOnTargetClauseImpl) {
            return true;
        }
        ObjectKind kind = element2 instanceof DasObject ? ((DasObject)element2).getKind() : SqlDbElementType.NONE;
        boolean checkLastParent = kind != SqlDbElementType.PACKAGE && kind != SqlDbElementType.OBJECT_TYPE && kind != SqlDbElementType.BODY && !(element2 instanceof SqlAlterInstruction);
        for (PsiElement psiElement : notableChildren) {
            PsiElement scope;
            if (checkLastParent && psiElement == lastParent) {
                if (allowForwardReferences) continue;
                break;
            }
            PsiElement psiElement2 = scope = psiElement instanceof SqlLocalDefinition ? ((SqlLocalDefinition)psiElement).getDefinitionScope() : null;
            if (scope != null && !PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)place, (boolean)true) || psiElement instanceof SqlQueryExpression) continue;
            if (psiElement instanceof DasSymbol ? !processor.execute((DasSymbol)psiElement, state) : (psiElement instanceof SqlDeclareStatementImpl || processChildrenDeclarations && (!(psiElement instanceof SqlStatement) || psiElement instanceof SqlDefinitionHolder)) && psiElement instanceof DasScopeAware && !((DasScopeAware)psiElement).processDeclarations((DasScopeProcessor)processor, state, lastParent, place)) {
                return false;
            }
            if (!(psiElement instanceof SqlExtraDeclarationsProvider)) continue;
            ((SqlExtraDeclarationsProvider)psiElement).processExtraDeclarations(processor, state, lastParent, place);
        }
        if (element2 instanceof SqlImplicitDeclarationsProvider && lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)element2, (PsiElement)lastParent, (boolean)true)) {
            SqlImplicitDeclarationsProvider provider = (SqlImplicitDeclarationsProvider)element2;
            processor.setResolveContext((PsiElement)element2);
            boolean stopIfFound = processor.getReferenceName() != null && processor.isResultEmpty() && provider.stopProcessingIfFoundInImplicitContext();
            boolean resume = provider.processImplicitContextDeclarations(processor, state, lastParent, place);
            return resume &= !stopIfFound || processor.isResultEmpty();
        }
        return true;
    }

    public static ObjectKind getBodyParentKind(@Nullable SqlDefinition o) {
        SqlNameElement nameElement = o != null ? o.getNameElement() : null;
        PsiElement lastChild = nameElement == null ? null : nameElement.getLastChild();
        return lastChild instanceof SqlReferenceExpression ? ((SqlReferenceExpression)lastChild).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
    }

    @NotNull
    public static String getCasedPart(@Nullable SqlReferenceExpression tableRef, @NotNull ObjectKind kind) {
        if (kind == null) {
            SqlImplUtil.$$$reportNull$$$0(92);
        }
        if (tableRef == null) {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(93);
            }
            return string;
        }
        ArrayList<Trinity<ObjectKind, Boolean, String>> parts = new ArrayList<Trinity<ObjectKind, Boolean, String>>();
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.tryCast((Object)tableRef.getContainingFile(), SqlFile.class);
        if (casingProvider == null) {
            casingProvider = SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef).getDatabaseDialect();
        }
        SqlFileImpl.splitRef(SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef), tableRef, parts);
        for (Trinity trinity : parts) {
            if (trinity.first != kind) continue;
            String string = casingProvider.getCasing(kind, null).choose((Boolean)trinity.second == false).apply((String)trinity.third);
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(94);
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(95);
        }
        return string;
    }

    public static Dbms getSqlDialectDbms(@Nullable PsiElement element2) {
        return SqlImplUtil.getSqlDialectSafe(element2).getDbms();
    }

    static boolean processSchemaMajorChildren(SqlScopeProcessor processor, Processor<? super DbElement> wrapper, DbElement schemaElement) {
        if (DbImplUtilCore.isExpandable(schemaElement, DbImplUtilCore.getIntrospectionScope(schemaElement.getDataSource()))) {
            Condition majorChildCondition = element2 -> processor.getDialect().isMajorChild(element2.getKind());
            for (DbTable child : schemaElement.getDasChildren(SqlDbElementType.TABLE).filter(DbTable.class)) {
                if (ContainerUtil.process((Iterable)child.getDasChildren(null).filter(majorChildCondition), wrapper)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isProcessingOneOf(@NotNull SqlScopeProcessor processor, ObjectKind ... kinds) {
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(96);
        }
        if (kinds == null) {
            SqlImplUtil.$$$reportNull$$$0(97);
        }
        for (ObjectKind kind : kinds) {
            if (kind != SqlDbElementType.ANY && !processor.mayAccept(kind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProcessingChildOf(@NotNull SqlScopeProcessor processor, @NotNull ObjectKind parent2) {
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(98);
        }
        if (parent2 == null) {
            SqlImplUtil.$$$reportNull$$$0(99);
        }
        return parent2 == SqlDbElementType.ANY || processor.mayAcceptParent(parent2);
    }

    public static boolean isAsteriskRef(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(100);
        }
        return SqlImplUtil.getAsterisk(element2) != null;
    }

    @Nullable
    public static PsiElement getAsterisk(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(101);
        }
        if (!(element2 instanceof SqlReferenceExpression)) {
            return null;
        }
        for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != SqlCommonTokens.SQL_ASTERISK) continue;
            return child;
        }
        return null;
    }

    @Contract(value="null,null->null")
    public static String getPresentableName(@Nullable PsiElement element2, @Nullable String emptyName) {
        String name = SqlImplUtil.getPresentableName(element2);
        return StringUtil.isEmpty((String)name) ? emptyName : name;
    }

    @Nullable
    private static String getPresentableName(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof SqlSelectStatement) {
            SqlTableExpression fromClause;
            SqlQueryExpression qe = ((SqlSelectStatement)element2).getQueryExpression();
            SqlSelectClause selectClause = qe != null ? qe.getSelectClause() : null;
            SqlTableExpression sqlTableExpression = fromClause = qe != null ? qe.getTableExpression() : null;
            if (selectClause != null && fromClause != null) {
                return SqlImplUtil.trimLong(selectClause.getText(), 25) + " " + SqlImplUtil.trimLong(fromClause.getText(), 25);
            }
            return SqlImplUtil.fromText(element2);
        }
        if (element2 instanceof SqlWithClause) {
            return PsiTreeUtil.firstChild((PsiElement)element2).getText();
        }
        if (element2 instanceof DasRoutine) {
            SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe(element2);
            DatabaseDialectEx dialect = sqlDialect.getDatabaseDialect();
            DdlBuilder builder = new DdlBuilder().applyCodeStyle(element2.getProject(), sqlDialect).withDialect(dialect);
            if (element2 instanceof PsiNamedElement) {
                builder.plain(StringUtil.notNullize((String)((PsiNamedElement)element2).getName()));
            }
            return dialect.sqlDefinePrototype(builder, (DasRoutine)element2, false, true).getStatement();
        }
        if (element2 instanceof SqlDefinition) {
            String name;
            SqlDefinition definition = (SqlDefinition)element2;
            SqlNameElement namedElement = definition.getNameElement();
            if (namedElement == null) {
                if (element2 instanceof DasConstraint) {
                    Object info = DbPresentationCore.multiRef(((DasConstraint)element2).getColumnsRef());
                    if (((String)info).isEmpty()) {
                        SqlDefinition type = (SqlDefinition)PsiTreeUtil.findChildOfType((PsiElement)element2, SqlDefinition.class);
                        return SqlImplUtil.getPresentableName((PsiElement)type);
                    }
                    if (element2 instanceof DasForeignKey) {
                        DasForeignKey key = (DasForeignKey)element2;
                        info = (String)info + DbPresentationCore.arrowToColumns(null, key.getRefTableName(), key.getRefColumns());
                    }
                    return info;
                }
                if (element2 instanceof DasIndex) {
                    return DbPresentationCore.multiRef(((DasIndex)element2).getColumnsRef());
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)(name = SqlImplUtil.getPresentableName((PsiElement)namedElement)))) {
                return SqlImplUtil.fromText(element2);
            }
            return name;
        }
        if (element2 instanceof SqlNameElement) {
            String s2 = ((SqlNameElement)element2).getName();
            return StringUtil.isEmptyOrSpaces((String)s2) ? SqlImplUtil.fromText(element2) : s2;
        }
        if (element2 instanceof DasObject) {
            return ((DasObject)element2).getName();
        }
        if (element2 instanceof SqlBlockStatementImpl) {
            return "begin ... end";
        }
        return SqlImplUtil.fromText(element2);
    }

    @NotNull
    private static String fromText(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(102);
        }
        return SqlImplUtil.trimLong(element2.getText(), 50);
    }

    @NotNull
    private static String trimLong(String text2, int limit) {
        if (limit == 0) {
            return "";
        }
        String trim = SqlImplUtil.removeDuplicateSpaces(text2).trim();
        Object object = trim.length() > limit ? trim.subSequence(0, (int)((double)limit * 0.9)) + "..." + trim.subSequence((int)((double)trim.length() - (double)limit * 0.1), trim.length()) : trim;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(103);
        }
        return object;
    }

    @NotNull
    private static String removeDuplicateSpaces(@Nullable String text2) {
        if (StringUtil.isEmptyOrSpaces((String)text2)) {
            return "";
        }
        String string = SPACES.matcher(text2).replaceAll(" ");
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(104);
        }
        return string;
    }

    @NotNull
    static List<SqlLabelDefinitionImpl> getLabels(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(105);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)element2, () -> CachedValueProvider.Result.create(SqlImplUtil.calcLabels(element2), (Object[])new Object[]{element2}));
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(106);
        }
        return list;
    }

    @NotNull
    private static List<SqlLabelDefinitionImpl> calcLabels(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(107);
        }
        List list = SqlImplUtil.sqlTraverser(element2).filter(SqlLabelDefinitionImpl.class).toList();
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(108);
        }
        return list;
    }

    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement e, @Nullable IElementType type) {
        if (e == null || type == null) {
            return null;
        }
        PsiElement child = e.getFirstChild();
        return child == null ? null : PsiTreeUtil.findSiblingForward((PsiElement)child, (IElementType)type, (boolean)false, null);
    }

    public static short calcPosition(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(109);
        }
        short count = 1;
        for (PsiElement element2 : SqlImplUtil.childrenIt(SqlImplUtil.sqlParent((PsiElement)definition))) {
            if (element2 == definition) {
                return count;
            }
            count = (short)(count + 1);
        }
        return 0;
    }

    @Nullable
    public static PsiElement getStubOrPsiParent(@Nullable PsiElement e) {
        if (e == null) {
            return null;
        }
        StubElement stub = e instanceof StubBasedPsiElement ? ((StubBasedPsiElement)e).getStub() : null;
        StubElement parent2 = stub == null ? null : stub.getParentStub();
        return parent2 == null ? e.getParent() : parent2.getPsi();
    }

    @Nullable
    public static PsiReference getReference(@NotNull PsiElement element2, @Nullable SqlIdentifier nameElement) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(110);
        }
        if (nameElement == null) {
            return null;
        }
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)element2, (PsiElement)element2);
        ref.setRangeInElement(nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent()));
        return ref;
    }

    public static boolean forbidGlobalTablesResolve(PsiElement place) {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
        if (ref == null) {
            return false;
        }
        if (SqlImplUtil.getSqlDialectSafe(place).allowGlobalTableResolve(place)) {
            return false;
        }
        if (ref.getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN) {
            return true;
        }
        SqlReferenceExpression parentRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getParent(), SqlReferenceExpression.class);
        if (parentRef == null) {
            return false;
        }
        if (parentRef.getParent() instanceof SqlTypeElement) {
            return false;
        }
        return parentRef.getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN;
    }

    public static boolean ignoreKinds(@NotNull SqlScopeProcessor processor, @NotNull Set<ObjectKind> kinds) {
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(111);
        }
        if (kinds == null) {
            SqlImplUtil.$$$reportNull$$$0(112);
        }
        processor.addIgnoredKinds(kinds);
        return !processor.getExpectedTypes().isEmpty();
    }

    @Nullable
    public static VirtualFile getAnyRoot(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        ProjectFileIndex index2;
        VirtualFile root2;
        if (virtualFile == null) {
            SqlImplUtil.$$$reportNull$$$0(113);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(114);
        }
        if ((root2 = (index2 = ProjectFileIndex.SERVICE.getInstance((Project)project)).getContentRootForFile(virtualFile)) == null) {
            root2 = index2.getClassRootForFile(virtualFile);
        }
        if (root2 == null) {
            root2 = index2.getSourceRootForFile(virtualFile);
        }
        return root2;
    }

    public static Dbms getDbms(@Nullable PsiElement element2) {
        if (element2 instanceof DbElement) {
            return DbImplUtilCore.getDbms((DbElement)element2);
        }
        DbDataSource dataSource2 = element2 == null ? null : DbImplUtilCore.getForcedDataSource(element2.getContainingFile().getOriginalFile());
        Dbms dataSourceDbms = dataSource2 == null ? Dbms.UNKNOWN : dataSource2.getDbms();
        return dataSourceDbms != Dbms.UNKNOWN ? dataSourceDbms : SqlImplUtil.getSqlDialectDbms(element2);
    }

    public static Dbms getDbms(@Nullable DasObject dasObject) {
        return dasObject instanceof PsiElement ? SqlImplUtil.getDbms((PsiElement)dasObject) : DbImplUtilCore.getDbms(dasObject);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static PsiElement wrapObjectToPsi(@Nullable DasObject object, @NotNull Project project) {
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(115);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return new DasPsiWrappingSymbol(object, project);
    }

    @NotNull
    public static ObjectKind getKindSynonymAware(@Nullable DasObject obj) {
        if (obj instanceof SqlAsExpression) {
            SqlType type = ((SqlAsExpression)obj).getSqlType();
            boolean isTable = type instanceof SqlTableType;
            if (type == SqlType.UNKNOWN) {
                PsiElement parent2 = ((SqlAsExpression)obj).getParent();
                isTable = parent2 instanceof SqlJoinExpression || parent2 instanceof SqlFromClause;
            }
            ObjectKind objectKind = isTable ? SqlDbElementType.TABLE : SqlDbElementType.COLUMN;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(116);
            }
            return objectKind;
        }
        if (obj instanceof DasSynonym) {
            DasSynonym synonym = (DasSynonym)obj;
            ObjectKind kind = synonym.getTargetObjectKind();
            if (kind != SqlDbElementType.ANY && kind != SqlDbElementType.NONE) {
                ObjectKind objectKind = kind;
                if (objectKind == null) {
                    SqlImplUtil.$$$reportNull$$$0(117);
                }
                return objectKind;
            }
            DasObject target = DasUtil.resolveFinalTarget(synonym);
            ObjectKind objectKind = target != null ? target.getKind() : SqlDbElementType.ANY;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(118);
            }
            return objectKind;
        }
        ObjectKind objectKind = obj != null ? obj.getKind() : SqlDbElementType.ANY;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(119);
        }
        return objectKind;
    }

    public static PsiFile getTopLevelSqlFile(@NotNull PsiFile tmpFile) {
        PsiFile topLevelFile;
        boolean sql;
        PsiFile contextFile;
        if (tmpFile == null) {
            SqlImplUtil.$$$reportNull$$$0(120);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)tmpFile)) {
            PsiElement context = tmpFile.getContext();
            PsiFile contextFile2 = context == null ? null : context.getContainingFile();
            return contextFile2 == null ? tmpFile : contextFile2;
        }
        if (tmpFile.getContext() != null && SqlImplUtil.isSameSqlFileDialect(tmpFile, contextFile = tmpFile.getContext().getContainingFile())) {
            tmpFile = contextFile;
        }
        if (sql = SqlImplUtil.isSameSqlFileDialect(tmpFile, topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile))) {
            return topLevelFile;
        }
        return tmpFile;
    }

    private static boolean isSameSqlFileDialect(@NotNull PsiFile child, @Nullable PsiFile parent2) {
        if (child == null) {
            SqlImplUtil.$$$reportNull$$$0(121);
        }
        SqlLanguageDialect fileDialect = parent2 instanceof SqlFile ? ((SqlFile)parent2).getSqlLanguage() : null;
        return fileDialect != null && fileDialect.getClass().isInstance(SqlImplUtil.getSqlDialectSafe((PsiElement)child));
    }

    @NotNull
    public static DasTypeService getTypeService(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(122);
        }
        DasTypeService dasTypeService = DasTypeServices.getTypeService(SqlImplUtil.getDbms(element2));
        if (dasTypeService == null) {
            SqlImplUtil.$$$reportNull$$$0(123);
        }
        return dasTypeService;
    }

    @Nullable
    public static BasicMetaObject<?> getMetaObject(@Nullable DasObject object) {
        DasObject unw = (DasObject)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(object), DasObject.class);
        if (unw == null) {
            return null;
        }
        if (unw instanceof BasicElement) {
            return ((BasicElement)unw).getMetaObject();
        }
        if (unw instanceof SqlStubbedDefinitionImpl) {
            return ((SqlStubbedDefinitionImpl)((Object)unw)).getMetaObject();
        }
        if (unw instanceof SqlExplicitTableExpression) {
            return null;
        }
        if (unw instanceof PsiElement) {
            ObjectKind kind;
            Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)unw).getDbms();
            BasicMetaModel<?> metaModel = DbImplUtilCore.getMetaModel(dbms);
            ArrayList objects2 = ContainerUtil.newArrayList(metaModel.findMetaObjects(kind = unw.getKind()));
            if (objects2.size() <= 1) {
                return (BasicMetaObject)ContainerUtil.getFirstItem((List)objects2);
            }
            BasicMetaObject<?> pMeta = SqlImplUtil.getMetaObject(unw.getDasParent());
            return BasicMetaUtils.findChild(pMeta, kind);
        }
        return null;
    }

    public static boolean isOracleDbLinkedTableRef(@Nullable SqlElement element2) {
        if (element2 == null) {
            return false;
        }
        Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)element2).getDbms();
        PsiElement parent2 = element2.getParent();
        return dbms.isOracle() && parent2 instanceof SqlReferenceExpression && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element2)) == SqlCommonTokens.SQL_AT_SIGN;
    }

    @Nullable
    public static SqlType getScopingType(@NotNull PsiElement element2) {
        SqlScopingExpression scopingExpression;
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(124);
        }
        if ((scopingExpression = SqlImplUtil.getScopingExpression(element2)) == null) {
            return null;
        }
        SqlTypeElement typeElement = scopingExpression.getTypeElement();
        if (typeElement == null) {
            return null;
        }
        return typeElement.findSqlType();
    }

    @Nullable
    public static SqlScopingExpression getScopingExpression(@NotNull PsiElement element2) {
        PsiElement parent2;
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(125);
        }
        if ((parent2 = element2.getParent()) instanceof SqlFunctionCallExpression) {
            parent2 = parent2.getParent();
        }
        return parent2 instanceof SqlScopingExpression ? (SqlScopingExpression)parent2 : null;
    }

    @NotNull
    public static DasType getCacheableDasType(@NotNull PsiElement context, @NotNull Supplier<? extends DasType> computeType) {
        DasType dasType;
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(126);
        }
        if (computeType == null) {
            SqlImplUtil.$$$reportNull$$$0(127);
        }
        DasType dasType2 = (dasType = (DasType)CachedValuesManager.getCachedValue((PsiElement)context, () -> new CachedValueProvider.Result((Object)((DasType)computeType.get()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))) != null ? dasType : DasType.UNKNOWN;
        if (dasType2 == null) {
            SqlImplUtil.$$$reportNull$$$0(128);
        }
        return dasType2;
    }

    public static boolean hasLocationOf(@NotNull SqlFunctionDefinition definition, @NotNull Set<SqlFunctionDefinition.Location> locations) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(129);
        }
        if (locations == null) {
            SqlImplUtil.$$$reportNull$$$0(130);
        }
        for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
            if (!locations.contains((Object)prototype.getLocation())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getResolveScope(@Nullable PsiFile tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        PsiFile file = SqlImplUtil.getTopLevelSqlFile(tmpFile);
        PsiElement context = file.getContext();
        return context instanceof DbElement ? ((DbElement)context).getDataSource() : file;
    }

    public static boolean treeWalkUp(@NotNull DasScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState initialState) {
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(131);
        }
        if (entrance == null) {
            SqlImplUtil.$$$reportNull$$$0(132);
        }
        if (initialState == null) {
            SqlImplUtil.$$$reportNull$$$0(133);
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        ResolveState state = initialState;
        while (scope != null) {
            if (prevParent instanceof SqlQueryExpression) {
                state = SqlImplUtil.setLastQueryExpression(state, (SqlQueryExpression)prevParent);
            }
            if (scope instanceof DasScopeAware && !((DasScopeAware)scope).processDeclarations(processor, state, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    @Nullable
    public static DasObject unwrapPsiToObject(@Nullable PsiElement element2) {
        if (element2 instanceof DasObject) {
            return (DasObject)element2;
        }
        if (element2 instanceof DasSymbol) {
            return ((DasSymbol)element2).getDasObject();
        }
        return null;
    }

    public static boolean canResolveToPgFunctionColumn(@Nullable PsiElement expr) {
        if (!(expr instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expr).getQualifierExpression() == null) {
            return false;
        }
        if (expr.getParent() instanceof SqlFunctionCallExpression) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expr, SqlSelectClause.class) != null;
    }

    public static JBIterable<ResolveResult> resolveVisible(SqlReferenceExpression expression) {
        return SqlImplUtil.resolveVisible((PsiPolyVariantReference)expression.getReference());
    }

    public static JBIterable<ResolveResult> resolveVisible(PsiPolyVariantReference reference) {
        JBIterable targets2 = JBIterable.of((Object[])reference.multiResolve(false));
        if (targets2.single() != null) {
            return targets2;
        }
        return targets2.filter(r -> !(r instanceof SqlResolveResult) || !((SqlResolveResult)r).isHidden());
    }

    public static boolean isMarkedUnresolved(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(134);
        }
        for (ResolveResult result2 : expression.multiResolve(false)) {
            if (!SqlImplUtil.isMarkedUnresolved(result2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMarkedUnresolved(@NotNull ResolveResult resolveResult) {
        if (resolveResult == null) {
            SqlImplUtil.$$$reportNull$$$0(135);
        }
        return DasSymbolUtil.isUnresolved(DasSymbolUtil.getSymbol(resolveResult));
    }

    @Nullable
    public static VirtualFile getTopLevelFile(@NotNull PsiFile file) {
        PsiFile tmpFile;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(136);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)(tmpFile = file))) {
            PsiElement context = tmpFile.getContext();
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)(context == null ? null : context.getContainingFile()), (Object)tmpFile);
        } else {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile);
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)topLevelFile, (Object)tmpFile);
        }
        return tmpFile.getOriginalFile().getVirtualFile();
    }

    public static SqlTableType getTableTypeOfColumnList(@NotNull List<? extends SqlReferenceExpression> colList, @Nullable SqlExpression tableExpression) {
        PsiElement psiElement;
        if (colList == null) {
            SqlImplUtil.$$$reportNull$$$0(137);
        }
        if (colList.isEmpty()) {
            SqlType type;
            SqlType sqlType = type = tableExpression == null ? null : tableExpression.getSqlType();
            if (type instanceof SqlTableType) {
                return (SqlTableType)type;
            }
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (SqlReferenceExpression sqlReferenceExpression : colList) {
            PsiElement element2 = sqlReferenceExpression.resolve();
            if (element2 instanceof SqlColumnDefinition) {
                SqlColumnDefinition column2 = (SqlColumnDefinition)element2;
                columns.add(new Column(column2.getName(), column2.getSqlType(), column2.getDasType(), (PsiElement)sqlReferenceExpression, element2));
                continue;
            }
            if (element2 instanceof DbColumn) {
                DbColumn column2 = (DbColumn)element2;
                SqlType sqlType = SqlImplUtil.getSqlType(column2.getDataType(), SqlImplUtil.getSqlDialectSafe(element2), (PsiElement)tableExpression);
                Object delegate = column2.getDelegate();
                DasType dasType = delegate instanceof DasTypedObjectEx ? ((DasTypedObjectEx)delegate).getDasType() : DasType.UNKNOWN;
                columns.add(new Column(column2.getName(), sqlType, dasType, (PsiElement)sqlReferenceExpression, element2));
                continue;
            }
            columns.add(new Column(sqlReferenceExpression.getName(), (SqlType)SqlType.UNKNOWN, DasType.UNKNOWN, (PsiElement)sqlReferenceExpression, null));
        }
        PsiElement qualifier = null;
        if (tableExpression instanceof SqlReferenceExpression && (psiElement = ((SqlReferenceExpression)tableExpression).resolve()) instanceof SqlCreateTableStatement) {
            qualifier = psiElement;
        }
        return SqlImplUtil.createType(columns, qualifier);
    }

    @Nullable
    public static ObjectKind getIdentifierKind(@NotNull SqlIdentifier identifier) {
        PsiElement parent2;
        if (identifier == null) {
            SqlImplUtil.$$$reportNull$$$0(138);
        }
        if ((parent2 = identifier.getParent()) instanceof SqlReferenceExpression) {
            SqlReferenceExpression refExpression = (SqlReferenceExpression)parent2;
            PsiElement result2 = refExpression.resolve();
            if (result2 instanceof DasObject) {
                return ((DasObject)result2).getKind();
            }
            return refExpression.getReferenceElementType().getTargetKind();
        }
        if (parent2 instanceof SqlColumnDefinition) {
            return SqlDbElementType.COLUMN;
        }
        if (parent2 instanceof SqlColumnAliasDefinitionImpl) {
            return SqlDbElementType.COLUMN_ALIAS;
        }
        if (parent2 instanceof SqlAsExpression) {
            return SqlDbElementType.LOCAL_ALIAS;
        }
        if (parent2 instanceof SqlDefinition) {
            return ((SqlDefinition)parent2).getKind();
        }
        return null;
    }

    @NotNull
    public static List<PsiColumnWithSymbol> processColumnList(@NotNull List<? extends PsiColumnWithSymbol> tgt, @NotNull List<? extends PsiColumnWithSymbol> src, boolean caseSensitive, @Nullable PairFunction<? super PsiColumnWithSymbol, ? super PsiColumnWithSymbol, Boolean> check, boolean skip) {
        if (tgt == null) {
            SqlImplUtil.$$$reportNull$$$0(139);
        }
        if (src == null) {
            SqlImplUtil.$$$reportNull$$$0(140);
        }
        ArrayList<PsiColumnWithSymbol> result2 = new ArrayList<PsiColumnWithSymbol>(tgt.size());
        Map<String, PsiColumnWithSymbol> tgtMap = DasUtil.newCaseAwareMap(caseSensitive);
        for (PsiColumnWithSymbol psiColumnWithSymbol : src) {
            tgtMap.put(psiColumnWithSymbol.getName(), psiColumnWithSymbol);
        }
        for (PsiColumnWithSymbol psiColumnWithSymbol : tgt) {
            boolean matched;
            PsiColumnWithSymbol old = (PsiColumnWithSymbol)tgtMap.remove(psiColumnWithSymbol.getName());
            boolean bl = matched = old != null && (check == null || (Boolean)check.fun((Object)old, (Object)psiColumnWithSymbol) != false);
            if (matched && skip) continue;
            result2.add(matched ? old : psiColumnWithSymbol);
        }
        ArrayList<PsiColumnWithSymbol> arrayList = result2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(141);
        }
        return arrayList;
    }

    @Nullable
    private static TrigEvent getEvent(IElementType e) {
        if (e == SqlCommonKeywords.SQL_SELECT) {
            return TrigEvent.SELECT;
        }
        if (e == SqlCommonKeywords.SQL_INSERT) {
            return TrigEvent.INSERT;
        }
        if (e == SqlCommonKeywords.SQL_UPDATE) {
            return TrigEvent.UPDATE;
        }
        if (e == SqlCommonKeywords.SQL_DELETE) {
            return TrigEvent.DELETE;
        }
        return null;
    }

    @Nullable
    private static TrigEvent getEvent(PsiElement element2) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (TrigEvent)((Object)api.children((Object)element2).transform(api.TO_TYPE).transform(e -> SqlImplUtil.getEvent(e)).filter(Conditions.notNull()).first());
    }

    @NotNull
    public static Set<TrigEvent> getTriggerEvents(@NotNull SqlElement element2) {
        SyntaxTraverser.ApiEx api;
        JBIterable events;
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(142);
        }
        if ((events = (api = SyntaxTraverser.psiApi()).children((Object)element2).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE)).isEmpty()) {
            Set<TrigEvent> set = Collections.emptySet();
            if (set == null) {
                SqlImplUtil.$$$reportNull$$$0(143);
            }
            return set;
        }
        Set set = events.transform(e -> SqlImplUtil.getEvent(e)).filter(Conditions.notNull()).toSet();
        if (set == null) {
            SqlImplUtil.$$$reportNull$$$0(144);
        }
        return set;
    }

    @NotNull
    public static SqlType getTupleType(SqlExpressionList expressionList) {
        boolean tableTypeExpected;
        List list = expressionList.getExpressionList();
        boolean bl = tableTypeExpected = expressionList.getParent() instanceof SqlValuesExpression || PsiUtilCore.getElementType((PsiElement)expressionList.getFirstChild()) == SqlCommonKeywords.SQL_ROW;
        if (list.size() == 0) {
            Object object = tableTypeExpected ? SqlTableTypeBase.EMPTY_TABLE : SqlType.UNKNOWN;
            if (object == null) {
                SqlImplUtil.$$$reportNull$$$0(145);
            }
            return object;
        }
        if (list.size() == 1 && !tableTypeExpected) {
            SqlType sqlType = ((SqlExpression)list.get(0)).getSqlType();
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(146);
            }
            return sqlType;
        }
        return new ValuesTableType(expressionList);
    }

    @NotNull
    public static DasType getTupleDasType(SqlExpressionList expressionList) {
        boolean tableTypeExpected;
        List list = expressionList.getExpressionList();
        boolean bl = tableTypeExpected = expressionList.getParent() instanceof SqlValuesExpression || PsiUtilCore.getElementType((PsiElement)expressionList.getFirstChild()) == SqlCommonKeywords.SQL_ROW;
        if (list.size() == 0) {
            Object object = tableTypeExpected ? SqlTableTypeBase.EMPTY_TABLE : DasType.UNKNOWN;
            if (object == null) {
                SqlImplUtil.$$$reportNull$$$0(147);
            }
            return object;
        }
        if (list.size() == 1 && !tableTypeExpected) {
            DasType dasType = ((SqlExpression)list.get(0)).getDasType();
            if (dasType == null) {
                SqlImplUtil.$$$reportNull$$$0(148);
            }
            return dasType;
        }
        return new ValuesTableType(expressionList);
    }

    @NotNull
    public static JBIterable<Version> getDbVersions(@NotNull SqlFile file) {
        DbDataSource ds;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(149);
        }
        if ((ds = DbImplUtilCore.getForcedDataSource((PsiFile)file)) != null) {
            JBIterable jBIterable = JBIterable.of((Object)ds.getVersion());
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(150);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)file)).filterMap(DasDataSource::getVersion);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(151);
        }
        return jBIterable;
    }

    public static void quoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        String newName;
        PsiElement target = SqlAnnotator.getTargetByIdElement((PsiElement)identifier);
        if (target instanceof DbElement) {
            DbElement dbTarget = (DbElement)target;
            newName = dbTarget.getName();
        } else {
            newName = identifier.getName();
            if (target instanceof DasObject && dialect instanceof SqlLanguageDialectEx) {
                DasObject dasTarget = (DasObject)target;
                newName = ((SqlLanguageDialectEx)dialect).getCasing((ObjectKind)dasTarget.getKind(), (DasObject)dasTarget).plain.apply(newName);
            }
        }
        NamingService namingService = NamingServices.getNamingService(SqlImplUtil.getDbms((PsiElement)identifier));
        String quotedName = namingService.enquote(newName, SqlImplUtil.getIdentifierKind(identifier));
        identifier.setName(quotedName);
    }

    public static void unquoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        SqlIdentifier newId = SqlPsiElementFactory.createIdentifierFromText(identifier.getName(), dialect, project);
        if (newId != null) {
            identifier.replace((PsiElement)newId);
        }
    }

    public static boolean canUnquote(@NotNull String newText, @Nullable ObjectKind kind, @NotNull NamingService namingService) {
        if (newText == null) {
            SqlImplUtil.$$$reportNull$$$0(152);
        }
        if (namingService == null) {
            SqlImplUtil.$$$reportNull$$$0(153);
        }
        return StringUtil.equals((CharSequence)namingService.catToScript(newText, kind), (CharSequence)newText);
    }

    @NotNull
    public static ObjectKind getQualifierKind(@NotNull PsiElement element2) {
        PsiElement target;
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(154);
        }
        SqlExpression qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        PsiElement psiElement = target = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
        if (qualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element2, SqlQueryClause.class) != null) {
            ObjectKind objectKind = SqlDbElementType.TABLE;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(155);
            }
            return objectKind;
        }
        ObjectKind objectKind = target instanceof DasObject ? SqlImplUtil.getKindSynonymAware((DasObject)target) : SqlDbElementType.NONE;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(156);
        }
        return objectKind;
    }

    @NotNull
    public static SqlType getQualifierType(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(157);
        }
        SqlExpression qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        Object object = qualifier != null ? qualifier.getSqlType() : SqlType.UNKNOWN;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(158);
        }
        return object;
    }

    public static boolean isAutoVal(@NotNull SqlColumnDefinition col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(159);
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)col).isAutoIncrementColumn((DasColumn)col);
    }

    public static boolean isAutoVal(@NotNull DasColumn col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(160);
        }
        return col instanceof SqlColumnDefinition ? SqlImplUtil.isAutoVal((SqlColumnDefinition)col) : DasUtil.isAutoGenerated(col);
    }

    public static boolean isComputedVal(@NotNull SqlColumnDefinition col) {
        SqlColumnStub stub;
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(161);
        }
        SqlColumnStub sqlColumnStub = stub = col instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)col).getGreenStub() : null;
        if (stub != null) {
            BasicTableOrViewColumn tc = (BasicTableOrViewColumn)ObjectUtils.tryCast((Object)stub.getElement(), BasicTableOrViewColumn.class);
            return tc != null && tc.isComputed();
        }
        ASTNode node = col.getNode();
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE) != null;
    }

    public static boolean isComputedVal(@NotNull DasColumn col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(162);
        }
        return col instanceof SqlColumnDefinition ? SqlImplUtil.isComputedVal((SqlColumnDefinition)col) : DasUtil.isComputed(col);
    }

    @NotNull
    public static JBIterable<SqlStatement> iterateStatementsBackward(@NotNull PsiFile file, int offset) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(163);
        }
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)file)).expand(element2 -> element2.getTextRange().getStartOffset() < offset && (!(element2 instanceof SqlStatement) || element2.getTextRange().getEndOffset() >= offset))).postOrderDfsTraversal().filter(SqlStatement.class).filter(stmt -> stmt.getTextRange().getEndOffset() <= offset);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(164);
        }
        return jBIterable;
    }

    public static void mergeColumnListInto(@NotNull List<PsiColumnWithSymbol> a2, @NotNull List<? extends PsiColumnWithSymbol> b2, boolean caseSensitive, @Nullable PairFunction<? super PsiColumnWithSymbol, ? super PsiColumnWithSymbol, Boolean> mergeCheck) {
        if (a2 == null) {
            SqlImplUtil.$$$reportNull$$$0(165);
        }
        if (b2 == null) {
            SqlImplUtil.$$$reportNull$$$0(166);
        }
        a2.addAll(SqlImplUtil.processColumnList(b2, a2, caseSensitive, mergeCheck, true));
    }

    public static boolean hasSameTypes(@Nullable PsiColumn a2, @Nullable PsiColumn b2) {
        if (a2 == null || b2 == null) {
            return a2 == b2;
        }
        return a2.getDataType().equals(b2.getDataType());
    }

    public static boolean equalsInsensitiveOrTrue(@Nullable String a2, @Nullable String b2, boolean compare) {
        return !compare || Comparing.strEqual((String)a2, (String)b2, (boolean)false);
    }

    public static PsiElement @NotNull [] getRelatedElements(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(167);
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)definition, () -> CachedValueProvider.Result.create((Object)SqlImplUtil.calcRelatedElements(definition), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiElementArray == null) {
            SqlImplUtil.$$$reportNull$$$0(168);
        }
        return psiElementArray;
    }

    private static PsiElement @NotNull [] calcRelatedElements(@NotNull SqlDefinition definition) {
        SqlReferenceExpression ref;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(169);
        }
        if ((ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)definition.getNameElement(), SqlReferenceExpression.class)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(170);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(ref.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)definition), ref.getReferenceElementType(), (PsiElement)definition);
        if (newRef == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(171);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResolveResult[] results2 = newRef.multiResolve(false);
        if (results2.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(172);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] related = new PsiElement[results2.length];
        for (int i2 = 0; i2 < results2.length; ++i2) {
            related[i2] = results2[i2].getElement();
        }
        if (related == null) {
            SqlImplUtil.$$$reportNull$$$0(173);
        }
        return related;
    }

    public static boolean isBodyLazyBlock(@Nullable PsiElement e) {
        return e instanceof LazyParseablePsiElement && !(e instanceof SqlLazyParseablePsiElement) || e instanceof SqlCodeBlockElement;
    }

    @NotNull
    protected static IntRange indicesOfImmediateSource(@NotNull SqlTableType type, @NotNull PsiElement source) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(174);
        }
        if (source == null) {
            SqlImplUtil.$$$reportNull$$$0(175);
        }
        int columnCount = type.getColumnCount();
        int from = -1;
        int to = columnCount;
        for (int i2 = 0; i2 < columnCount; ++i2) {
            boolean isMatched;
            PsiElement actualSource = type.getImmediateSourceColumnElement(i2);
            while (actualSource instanceof SqlImplicitTarget) {
                actualSource = ((SqlImplicitTarget)actualSource).getContextElement();
            }
            boolean bl = isMatched = actualSource == source || source instanceof SqlReferenceExpression && actualSource == ((SqlReferenceExpression)source).resolve();
            if (isMatched && from < 0) {
                from = i2;
                continue;
            }
            if (isMatched || from < 0) continue;
            to = i2;
            break;
        }
        return new IntRange(from, to - 1);
    }

    protected static boolean inColumnProvidingContext(@NotNull SqlQueryExpression query) {
        if (query == null) {
            SqlImplUtil.$$$reportNull$$$0(176);
        }
        for (PsiElement parent2 : SqlImplUtil.sqlParents((PsiElement)query)) {
            if (parent2 instanceof SqlResultSetExpression || parent2 instanceof SqlClause && parent2.getParent() instanceof SqlCreateViewStatement) continue;
            if (parent2 instanceof SqlInsertDmlInstruction) {
                return true;
            }
            if (!(parent2 instanceof SqlCreateViewStatement) || ((SqlCreateViewStatement)parent2).getColumnAliases().length <= 0) break;
            return true;
        }
        return false;
    }

    @Nullable
    protected static SqlExpression getSelectExpression(@NotNull SqlSelectClause selectClause, @NotNull PsiElement element2) {
        if (selectClause == null) {
            SqlImplUtil.$$$reportNull$$$0(177);
        }
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(178);
        }
        for (SqlExpression expression : selectClause.getExpressions()) {
            if (!expression.getTextRange().contains(element2.getTextRange().getStartOffset())) continue;
            return expression;
        }
        return null;
    }

    @Nullable
    protected static SqlElement getResultSetExpressionList(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        SqlExpressionList list = SqlValuesParameterInfoUtils.findExpressions(element2);
        if (list != null) {
            return list;
        }
        SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlSelectClause.class);
        if (selectClause != null) {
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)selectClause, SqlQueryExpression.class);
            return query != null && SqlImplUtil.inColumnProvidingContext(query) ? selectClause : null;
        }
        return null;
    }

    @Nullable
    public static IntRange getImmediateColumnSourceIndices(@Nullable PsiElement element2, @Nullable SqlElement anExpressionList, boolean strict) {
        SqlElement expressionList;
        if (element2 == null) {
            return null;
        }
        SqlElement sqlElement = expressionList = anExpressionList != null ? anExpressionList : SqlImplUtil.getResultSetExpressionList(element2);
        if (strict && element2.getParent() != expressionList) {
            return null;
        }
        if (expressionList instanceof SqlExpressionList) {
            int index2 = SqlValuesParameterInfoUtils.getCurrentParameterIndex((SqlExpressionList)expressionList, element2.getTextRange().getStartOffset());
            return index2 >= 0 ? new IntRange(index2, index2) : null;
        }
        if (expressionList instanceof SqlSelectClause) {
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expressionList, SqlQueryExpression.class);
            if (query == null) {
                return null;
            }
            SqlType type = query.getSqlType();
            if (!(type instanceof SqlTableType)) {
                return null;
            }
            SqlExpression expression = SqlImplUtil.getSelectExpression((SqlSelectClause)expressionList, element2);
            if (expression == null) {
                return null;
            }
            IntRange indices = SqlImplUtil.indicesOfImmediateSource((SqlTableType)type, (PsiElement)expression);
            return indices.getStart() >= 0 ? indices : null;
        }
        return null;
    }

    @NotNull
    public static JBIterable<? extends DasObject> unwrapFake(@Nullable DasObject obj) {
        JBIterable<SqlDefinition> jBIterable = obj instanceof SqlFileImpl.GroupImpl ? ((SqlFileImpl.GroupImpl)obj).delegates() : JBIterable.of((Object)obj);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(179);
        }
        return jBIterable;
    }

    public static boolean isColumnQualifier(@NotNull PsiElement place) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(180);
        }
        return SqlImplUtil.isQualifier(place, SqlDbElementType.COLUMN);
    }

    public static boolean isQualifier(@NotNull PsiElement place, @NotNull ObjectKind qualifiedKind) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(181);
        }
        if (qualifiedKind == null) {
            SqlImplUtil.$$$reportNull$$$0(182);
        }
        if (!(place instanceof SqlReferenceExpression)) {
            return false;
        }
        PsiElement parent2 = place.getParent();
        if (!(parent2 instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlReferenceExpression parentRef = (SqlReferenceExpression)parent2;
        return parentRef.getQualifierExpression() == place && parentRef.getReferenceElementType().getTargetKind() == qualifiedKind;
    }

    public static boolean isColumnReference(@NotNull PsiElement place) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(183);
        }
        return place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN;
    }

    @NotNull
    public static JBIterable<? extends DasObject> getSiblingObjects(@NotNull SqlDefinition anchor2, @NotNull Class<? extends SqlDefinition> targetClass) {
        if (anchor2 == null) {
            SqlImplUtil.$$$reportNull$$$0(184);
        }
        if (targetClass == null) {
            SqlImplUtil.$$$reportNull$$$0(185);
        }
        JBIterable jBIterable = SqlImplUtil.sqlChildren(SqlImplUtil.sqlParent((PsiElement)anchor2)).filter(targetClass).filter(DbSqlUtilCore.byName((DasObject)anchor2, null, DbImplUtilCore.getCasingProvider((DasObject)anchor2)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(186);
        }
        return jBIterable;
    }

    @NotNull
    public static SqlType createObjectColumnType(@NotNull SqlLanguageDialectEx dialect, @NotNull DasColumn column2, JBIterable<DasColumn> children2) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(187);
        }
        if (column2 == null) {
            SqlImplUtil.$$$reportNull$$$0(188);
        }
        ProgressManager.checkCanceled();
        if (!children2.isEmpty()) {
            PsiElement resolved = DbSqlUtilCore.getPsiDelegate(column2);
            return SqlImplUtil.createTableTypeWithColumns(dialect, children2, resolved, (DasSymbol)((Object)column2));
        }
        if (column2 instanceof SqlTypedDefinition) {
            SqlType sqlType = ((SqlTypedDefinition)column2).getSqlType();
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(189);
            }
            return sqlType;
        }
        SqlType sqlType = SqlTypeFactory.of(column2.getDataType(), dialect);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(190);
        }
        return sqlType;
    }

    @NotNull
    public static DasType getObjectColumnDasType(@NotNull SqlLanguageDialectEx dialect, @NotNull DasColumn column2, JBIterable<DasColumn> children2) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(191);
        }
        if (column2 == null) {
            SqlImplUtil.$$$reportNull$$$0(192);
        }
        ProgressManager.checkCanceled();
        if (!children2.isEmpty()) {
            PsiElement resolved = DbSqlUtilCore.getPsiDelegate(column2);
            return SqlImplUtil.createTableTypeWithColumns(dialect, children2, resolved, (DasSymbol)((Object)column2));
        }
        DasType dasType = column2 instanceof DasTypedObjectEx ? ((DasTypedObjectEx)((Object)column2)).getDasType() : DasType.UNKNOWN;
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(193);
        }
        return dasType;
    }

    @NotNull
    public static SqlTableType createTableTypeWithColumns(@NotNull SqlLanguageDialectEx dialect, @NotNull JBIterable<DasColumn> dasColumns, @Nullable PsiElement resolved, @NotNull DasSymbol symbol) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(194);
        }
        if (dasColumns == null) {
            SqlImplUtil.$$$reportNull$$$0(195);
        }
        if (symbol == null) {
            SqlImplUtil.$$$reportNull$$$0(196);
        }
        ProgressManager.checkCanceled();
        String prefix = symbol.getKind() == SqlDbElementType.COLUMN ? symbol.getName() + "." : "";
        ArrayList<Column> columns = new ArrayList<Column>();
        List sortedColumns = dasColumns.sort(Comparator.comparing(DasNamed::getName)).toList();
        for (int i2 = 0; i2 < sortedColumns.size(); ++i2) {
            DasColumn current = (DasColumn)sortedColumns.get(i2);
            ArrayList<DasColumn> children2 = new ArrayList<DasColumn>();
            String currentName = current.getName();
            while (i2 + 1 < sortedColumns.size() && ((DasColumn)sortedColumns.get(i2 + 1)).getName().startsWith(currentName + ".")) {
                children2.add((DasColumn)sortedColumns.get(i2 + 1));
                ++i2;
            }
            SqlType sqlType = SqlImplUtil.createObjectColumnType(dialect, current, (JBIterable<DasColumn>)JBIterable.from(children2));
            DasType dasType = SqlImplUtil.getObjectColumnDasType(dialect, current, (JBIterable<DasColumn>)JBIterable.from(children2));
            columns.add(new Column(currentName.substring(prefix.length()), sqlType, dasType, (DbColumn)current, (DbColumn)current));
        }
        return SqlImplUtil.createType(null, ":", columns, resolved);
    }

    @Nullable
    private static PsiElement getPossiblyInjectedElement(@NotNull PsiFile file, int offset) {
        PsiElement result2;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(197);
        }
        if ((result2 = InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, offset)) == null) {
            result2 = file.findElementAt(offset);
        }
        return result2;
    }

    @Nullable
    public static <T extends PsiElement> T getElementBySelection(@NotNull PsiFile file, int start2, int end2, @NotNull Class<T> elementClass) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(198);
        }
        if (elementClass == null) {
            SqlImplUtil.$$$reportNull$$$0(199);
        }
        PsiElement element1 = SqlImplUtil.getPossiblyInjectedElement(file, start2);
        PsiElement element2 = SqlImplUtil.getPossiblyInjectedElement(file, end2 - 1);
        if (element1 instanceof PsiWhiteSpace) {
            element1 = file.findElementAt(element1.getTextRange().getEndOffset());
        }
        if (element2 instanceof PsiWhiteSpace) {
            element2 = file.findElementAt(element2.getTextRange().getStartOffset() - 1);
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)parent2, elementClass, (boolean)false);
    }

    @NotNull
    public static String getEffectiveName(@NotNull String name, boolean isQuoted, @NotNull Casing casing) {
        Case aCase;
        if (name == null) {
            SqlImplUtil.$$$reportNull$$$0(200);
        }
        if (casing == null) {
            SqlImplUtil.$$$reportNull$$$0(201);
        }
        if ((aCase = casing.choose(!isQuoted)) == Case.MIXED) {
            aCase = Case.LOWER;
        }
        String string = aCase.apply(name);
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(202);
        }
        return string;
    }

    @NotNull
    public static DataType getNormalizedDataType(@NotNull SqlReferenceExpression expression) {
        SmartList refs;
        String typeName;
        Casing casing;
        block8: {
            if (expression == null) {
                SqlImplUtil.$$$reportNull$$$0(203);
            }
            casing = NamingServices.getNamingService(SqlImplUtil.getDbms((PsiElement)expression)).getDefaultCasing();
            typeName = SqlImplUtil.getEffectiveName(expression.getName(), expression.isQuoted(), casing);
            if (expression.getQualifierExpression() == null) {
                DataType dataType = DataTypeFactory.ofArgs(null, typeName, null, true);
                if (dataType == null) {
                    SqlImplUtil.$$$reportNull$$$0(204);
                }
                return dataType;
            }
            refs = new SmartList();
            SqlReferenceExpression ref = expression;
            while (true) {
                refs.add(ref);
                SqlExpression qualifier = ref.getQualifierExpression();
                if (qualifier == null) break block8;
                if (!(qualifier instanceof SqlReferenceExpression)) break;
                ref = (SqlReferenceExpression)qualifier;
            }
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(205);
            }
            return dataType;
        }
        if (refs.size() > 3) {
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(206);
            }
            return dataType;
        }
        SqlReferenceExpression leftmostRef = (SqlReferenceExpression)refs.get(refs.size() - 1);
        String schemaName = refs.size() > 1 ? SqlImplUtil.getEffectiveName(leftmostRef.getName(), leftmostRef.isQuoted(), casing) : null;
        String packageName = refs.size() == 3 ? SqlImplUtil.getEffectiveName(((SqlReferenceExpression)refs.get(1)).getName(), ((SqlReferenceExpression)refs.get(1)).isQuoted(), casing) : null;
        DataType dataType = DataTypeFactory.of(schemaName, packageName, typeName, -1, 0, null, null, false, true);
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(207);
        }
        return dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 71: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 92: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 157: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 188: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 203: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 71: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 92: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 157: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 188: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 203: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: 
            case 18: 
            case 30: 
            case 34: 
            case 37: 
            case 46: 
            case 49: 
            case 52: 
            case 187: 
            case 191: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 16: 
            case 45: 
            case 87: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 110: 
            case 122: 
            case 124: 
            case 125: 
            case 142: 
            case 154: 
            case 157: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 20: 
            case 23: 
            case 41: 
            case 44: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 29: 
            case 109: 
            case 129: 
            case 167: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 35: 
            case 50: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 38: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 39: 
            case 54: 
            case 56: 
            case 114: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryExpression";
                break;
            }
            case 64: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 77: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 78: 
            case 134: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 96: 
            case 98: 
            case 111: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 97: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpFile";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeType";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 136: 
            case 149: 
            case 163: 
            case 197: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colList";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectClause";
                break;
            }
            case 180: 
            case 181: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedKind";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 188: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasColumns";
                break;
            }
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceList";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 71: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 92: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 157: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 188: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 203: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeOf";
                break;
            }
            case 31: 
            case 32: 
            case 40: 
            case 47: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElement";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSqlType";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingElements";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevTraverser";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevChildren";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildrenNoWS";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "byElementType";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlParents";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCompositeElements";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectType";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeLateralAware";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualified";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectSafe";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTraverser";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildren";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasedPart";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLong";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicateSpaces";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabels";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLabels";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindSynonymAware";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeService";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheableDasType";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "processColumnList";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "getTriggerEvents";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleType";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleDasType";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbVersions";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierKind";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateStatementsBackward";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedElements";
                break;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRelatedElements";
                break;
            }
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFake";
                break;
            }
            case 186: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingObjects";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectColumnType";
                break;
            }
            case 193: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectColumnDasType";
                break;
            }
            case 202: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveName";
                break;
            }
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedDataType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModifiedState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setImmediateQualifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setImmediateTarget";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processQualifierImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeOf";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElement";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "computeSqlType";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateQualifier";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateTarget";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getLastQueryExpression";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setLastQueryExpression";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "revSiblings";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingElements";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "siblings";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "byElementType";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getSelectType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheLeftOfType";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getTypeLateralAware";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheRightOfType";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getBlockContentElement";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getMinDbmsVersion";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getCasedPart";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingOneOf";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingChildOf";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "isAsteriskRef";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getAsterisk";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getLabels";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "calcLabels";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "calcPosition";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "ignoreKinds";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getAnyRoot";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "wrapObjectToPsi";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelSqlFile";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "isSameSqlFileDialect";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getTypeService";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getScopingType";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getScopingExpression";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getCacheableDasType";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "hasLocationOf";
                break;
            }
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "treeWalkUp";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "isMarkedUnresolved";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getTableTypeOfColumnList";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierKind";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "processColumnList";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getTriggerEvents";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getDbVersions";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "canUnquote";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierKind";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierType";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "isAutoVal";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "isComputedVal";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "iterateStatementsBackward";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "mergeColumnListInto";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedElements";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "calcRelatedElements";
                break;
            }
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "indicesOfImmediateSource";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "inColumnProvidingContext";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getSelectExpression";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "isColumnQualifier";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "isQualifier";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "isColumnReference";
                break;
            }
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingObjects";
                break;
            }
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "createObjectColumnType";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "getObjectColumnDasType";
                break;
            }
            case 194: 
            case 195: 
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "createTableTypeWithColumns";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "getPossiblyInjectedElement";
                break;
            }
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "getElementBySelection";
                break;
            }
            case 200: 
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveName";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedDataType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 71: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 92: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 157: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 188: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 203: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ValuesTableType
    extends SqlTableTypeBase {
        private final SqlExpressionList myExpressionList;
        private final List<SqlColumnSymbol> myColumns = new ArrayList<SqlColumnSymbol>();

        private ValuesTableType(SqlExpressionList list) {
            this.myExpressionList = list;
            Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)list).getDbms();
            String prefix = ValuesTableType.getColumnNamePrefix(dbms);
            boolean needQuotes = prefix.isEmpty();
            List expressions2 = this.myExpressionList.getExpressionList();
            int size = expressions2.size();
            for (int i2 = 0; i2 < size; ++i2) {
                final SqlExpression expression = (SqlExpression)expressions2.get(i2);
                String name = this.calcColumnName(i2, prefix, dbms);
                SqlColumnSymbol symbol = new SqlColumnSymbol(name, needQuotes, (PsiElement)expression, i2, null, null){

                    @Override
                    @NotNull
                    public SqlType getType() {
                        SqlType sqlType = expression.getSqlType();
                        if (sqlType == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return sqlType;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType$1", "getType"));
                    }
                };
                this.myColumns.add(symbol);
            }
        }

        @NotNull
        private static String getColumnNamePrefix(@NotNull Dbms dbms) {
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(0);
            }
            if (dbms.isH2() || dbms.isHsqldb()) {
                return "C";
            }
            if (dbms.isSqlite() || dbms == Dbms.POSTGRES || dbms == Dbms.GREENPLUM || dbms == Dbms.COCKROACH) {
                return "column";
            }
            if (dbms.isSnowflake()) {
                return "COLUMN";
            }
            return "";
        }

        @NotNull
        private String calcColumnName(int i2, @NotNull String prefix, @NotNull Dbms dbms) {
            if (prefix == null) {
                ValuesTableType.$$$reportNull$$$0(1);
            }
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(2);
            }
            int num = i2 + 1;
            if (!prefix.isEmpty()) {
                String string = prefix + num;
                if (string == null) {
                    ValuesTableType.$$$reportNull$$$0(3);
                }
                return string;
            }
            PsiElement columnElement = this.getColumnElement(i2);
            if (dbms == Dbms.MARIA) {
                String string = columnElement instanceof SqlStringLiteralExpression ? StringUtil.notNullize((String)((SqlStringLiteralExpression)columnElement).getValue()) : columnElement.getText();
                if (string == null) {
                    ValuesTableType.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = columnElement instanceof SqlDefinition ? ((SqlDefinition)columnElement).getName() : String.valueOf(num);
            if (string == null) {
                ValuesTableType.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                ValuesTableType.$$$reportNull$$$0(6);
            }
            return dataType;
        }

        @NotNull
        public List<DasObject> getMethods() {
            List<DasObject> list = Collections.emptyList();
            if (list == null) {
                ValuesTableType.$$$reportNull$$$0(7);
            }
            return list;
        }

        public int getColumnCount() {
            return this.myExpressionList.getExpressionList().size();
        }

        public String getColumnName(int i2) {
            return this.myColumns.get(i2).getName();
        }

        public boolean isColumnQuoted(int i2) {
            return this.myColumns.get(i2).isQuoted();
        }

        public SqlType getColumnType(int i2) {
            return ((SqlExpression)this.myExpressionList.getExpressionList().get(i2)).getSqlType();
        }

        public DasType getColumnDasType(int i2) {
            return ((SqlExpression)this.myExpressionList.getExpressionList().get(i2)).getDasType();
        }

        @Nullable
        public PsiElement getColumnQualifier(int i2) {
            return this.myExpressionList;
        }

        @NotNull
        public PsiElement getColumnElement(int i2) {
            PsiElement psiElement = (PsiElement)this.myExpressionList.getExpressionList().get(i2);
            if (psiElement == null) {
                ValuesTableType.$$$reportNull$$$0(8);
            }
            return psiElement;
        }

        @Nullable
        public PsiElement getSourceColumnElement(int i2) {
            return (PsiElement)this.myColumns.get(i2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcColumnName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethods";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnNamePrefix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "calcColumnName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyColumnInfo
    extends RenameableFakePsiElement
    implements PsiColumn,
    SqlTypedDefinition,
    PsiColumnWithSymbol {
        final SqlTableDefinition myTableInfo;
        final int myIndex;
        final SqlTableType myTableType;
        final DasObject myInfo;

        MyColumnInfo(@NotNull SqlTableDefinition parent2, int index2, @NotNull SqlTableType tableType) {
            if (parent2 == null) {
                MyColumnInfo.$$$reportNull$$$0(0);
            }
            if (tableType == null) {
                MyColumnInfo.$$$reportNull$$$0(1);
            }
            super((PsiElement)parent2.getContainingFile());
            this.myTableInfo = parent2;
            this.myIndex = index2;
            this.myTableType = tableType;
            PsiElement columnElement = tableType.getSourceColumnElement(index2);
            this.myInfo = (DasObject)ObjectUtils.tryCast((Object)columnElement, DasObject.class);
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this.myTableInfo);
            if (dbms == null) {
                MyColumnInfo.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        @Override
        @NotNull
        public PsiColumn getDasObject() {
            MyColumnInfo myColumnInfo = this;
            if (myColumnInfo == null) {
                MyColumnInfo.$$$reportNull$$$0(3);
            }
            return myColumnInfo;
        }

        public boolean isNameQuoted() {
            return this.myTableType.isColumnQuoted(this.myIndex);
        }

        @Override
        public DasTable getTable() {
            return this.myTableInfo;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.COLUMN;
            if (objectKind == null) {
                MyColumnInfo.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myTableType.getColumnName(this.myIndex), (String)DasUtil.NO_NAME);
            if (string == null) {
                MyColumnInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        public String getComment() {
            return this.myInfo == null ? null : this.myInfo.getComment();
        }

        @Override
        public DasObject getDasParent() {
            return this.getTable();
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDataType() : DataTypeFactory.of(this.myTableType.getColumnType(this.myIndex).getDisplayName());
            if (dataType == null) {
                MyColumnInfo.$$$reportNull$$$0(6);
            }
            return dataType;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = DasType.UNKNOWN;
            if (dasType == null) {
                MyColumnInfo.$$$reportNull$$$0(7);
            }
            return dasType;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = this.myTableType.getColumnType(this.myIndex);
            if (sqlType == null) {
                MyColumnInfo.$$$reportNull$$$0(8);
            }
            return sqlType;
        }

        @Override
        public boolean isNotNull() {
            return this.myInfo instanceof DasTypedObject && ((DasTypedObject)this.myInfo).isNotNull();
        }

        @Override
        public String getDefault() {
            return this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDefault() : null;
        }

        public PsiElement getParent() {
            return this.myTableInfo;
        }

        public String getTypeName() {
            return DbPresentationCore.getPresentableName(this.getKind(), DbImplUtilCore.getDbms((DasObject)this.myTableInfo));
        }

        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myTableType.getColumnElement(this.myIndex);
            if (psiElement == null) {
                MyColumnInfo.$$$reportNull$$$0(9);
            }
            return psiElement;
        }

        @Override
        public short getPosition() {
            return (short)(this.myIndex + 1);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return null;
        }

        public void accept(SqlVisitor visitor2) {
            visitor2.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor2) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
        }

        public boolean isEquivalentTo(PsiElement another) {
            if (!(another instanceof MyColumnInfo)) {
                return false;
            }
            MyColumnInfo info = (MyColumnInfo)another;
            return this.myIndex == info.myIndex && Objects.equals(this.myTableInfo, info.myTableInfo) && Objects.equals(this.myInfo, info.myInfo);
        }

        public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                MyColumnInfo.$$$reportNull$$$0(10);
            }
            if (state == null) {
                MyColumnInfo.$$$reportNull$$$0(11);
            }
            if (place == null) {
                MyColumnInfo.$$$reportNull$$$0(12);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasObject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Column {
        public final String name;
        public final SqlType type;
        public final DasType dasType;
        public final PsiElement element;
        public final PsiElement sourceElement;

        public Column(String name, SqlType type, DasType dasType, @NotNull PsiElement element2, PsiElement sourceElement) {
            if (element2 == null) {
                Column.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.type = type;
            this.dasType = dasType;
            this.element = element2;
            this.sourceElement = sourceElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$Column", "<init>"));
        }
    }

    private static class EmptyTable
    implements DasTable {
        private EmptyTable() {
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.TABLE;
            if (objectKind == null) {
                EmptyTable.$$$reportNull$$$0(0);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                EmptyTable.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isQuoted() {
            return true;
        }

        @Override
        public boolean isSystem() {
            return false;
        }

        @Override
        public boolean isTemporary() {
            return false;
        }

        @Override
        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c2) {
            if (c2 instanceof PsiElement && SqlImplUtil.getSqlDialectSafe((PsiElement)c2).isAutoIncrementColumn(c2)) {
                EnumSet<DasColumn.Attribute> enumSet = EnumSet.of(DasColumn.Attribute.AUTO_GENERATED);
                if (enumSet == null) {
                    EmptyTable.$$$reportNull$$$0(2);
                }
                return enumSet;
            }
            Set<DasColumn.Attribute> set = DasUtil.NO_ATTRS;
            if (set == null) {
                EmptyTable.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Override
        @NotNull
        public JBIterable<? extends DasObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyTable.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public DasObject getDasParent() {
            return null;
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

