/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.structuralsearch.predicates;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate;", "Lcom/intellij/structuralsearch/impl/matcher/predicates/MatchPredicate;", "isCaseSensitive", "", "(Z)V", "()Z", "match", "matchedNode", "Lcom/intellij/psi/PsiElement;", "start", "", "end", "context", "Lcom/intellij/structuralsearch/impl/matcher/MatchContext;", "matchType", "sqlType", "Lcom/intellij/sql/psi/SqlType;", "ByTypeList", "ByTypeRegex", "Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeList;", "Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeRegex;", "intellij.database.sql.impl"})
public abstract class SqlExpressionTypePredicate
extends MatchPredicate {
    private final boolean isCaseSensitive;

    protected abstract boolean matchType(@NotNull SqlType var1, @NotNull PsiElement var2, @NotNull MatchContext var3);

    public boolean match(@NotNull PsiElement matchedNode, int start2, int end2, @NotNull MatchContext context) {
        SqlType sqlType;
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = matchedNode;
        if (psiElement instanceof SqlExpression) {
            sqlType = ((SqlExpression)matchedNode).getSqlType();
        } else if (psiElement instanceof SqlTypeElement) {
            sqlType = ((SqlTypeElement)matchedNode).findSqlType();
        } else {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlType, (String)"when (matchedNode) {\n   \u2026lse -> return false\n    }");
        SqlType sqlType2 = sqlType;
        return this.matchType(sqlType2, matchedNode, context);
    }

    protected final boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    private SqlExpressionTypePredicate(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public /* synthetic */ SqlExpressionTypePredicate(boolean isCaseSensitive, DefaultConstructorMarker $constructor_marker) {
        this(isCaseSensitive);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\fj\b\u0012\u0004\u0012\u00020\u0003`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeList;", "Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate;", "typePattern", "", "isCaseSensitive", "", "(Ljava/lang/String;Z)V", "categories", "Ljava/util/HashSet;", "Lcom/intellij/sql/psi/SqlType$Category;", "Lkotlin/collections/HashSet;", "types", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "matchType", "sqlType", "Lcom/intellij/sql/psi/SqlType;", "matchedNode", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/structuralsearch/impl/matcher/MatchContext;", "intellij.database.sql.impl"})
    public static final class ByTypeList
    extends SqlExpressionTypePredicate {
        private final ArrayList<String> types;
        private final HashSet<SqlType.Category> categories;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean matchType(@NotNull SqlType sqlType, @NotNull PsiElement matchedNode, @NotNull MatchContext context) {
            String it2;
            Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
            Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (this.categories.contains(sqlType.getCategory())) return true;
            Iterable $this$any$iv = this.types;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it2 = (String)element$iv;
                boolean bl = false;
            } while (!StringsKt.equals((String)sqlType.getDisplayName(), (String)it2, (!this.isCaseSensitive() ? 1 : 0) != 0));
            return true;
        }

        public ByTypeList(@NotNull String typePattern, boolean isCaseSensitive) {
            Intrinsics.checkNotNullParameter((Object)typePattern, (String)"typePattern");
            super(isCaseSensitive, null);
            this.types = new ArrayList();
            this.categories = new HashSet();
            Iterator iterator = StringUtil.split((String)typePattern, (String)"|").iterator();
            while (iterator.hasNext()) {
                String item;
                String string = item = (String)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item");
                Object object = string;
                boolean bl = false;
                String string2 = object;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String typeText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (StringsKt.startsWith$default((String)typeText, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)typeText, (String)"]", (boolean)false, (int)2, null)) {
                    int n;
                    String string3;
                    object = this.categories;
                    try {
                        Locale locale;
                        string3 = typeText;
                        n = 1;
                        int n2 = StringsKt.getLastIndex((CharSequence)typeText);
                        boolean bl2 = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        string3 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
                        n2 = 0;
                        String string6 = string3;
                        boolean bl3 = false;
                        String string7 = string6;
                        if (string7 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string8 = string7.toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toUpperCase(locale)");
                        string3 = string8;
                        string3 = (SqlType.Category)((Enum)SqlType.Category.valueOf((String)string3));
                    }
                    catch (Exception e) {
                        string3 = SqlType.Category.UNKNOWN;
                    }
                    n = 0;
                    object.add(string3);
                    continue;
                }
                object = this.types;
                bl = false;
                object.add(typeText);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate$ByTypeRegex;", "Lcom/intellij/sql/structuralsearch/predicates/SqlExpressionTypePredicate;", "typePattern", "", "name", "isTarget", "", "isCaseSensitive", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "regexPredicate", "Lcom/intellij/structuralsearch/impl/matcher/predicates/RegExpPredicate;", "matchType", "sqlType", "Lcom/intellij/sql/psi/SqlType;", "matchedNode", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/structuralsearch/impl/matcher/MatchContext;", "intellij.database.sql.impl"})
    public static final class ByTypeRegex
    extends SqlExpressionTypePredicate {
        private final RegExpPredicate regexPredicate;

        @Override
        protected boolean matchType(@NotNull SqlType sqlType, @NotNull PsiElement matchedNode, @NotNull MatchContext context) {
            Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
            Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.regexPredicate.doMatch(sqlType.getDisplayName(), context, matchedNode) || this.regexPredicate.doMatch("" + '[' + sqlType.getCategory() + ']', context, matchedNode);
        }

        public ByTypeRegex(@NotNull String typePattern, @NotNull String name, boolean isTarget, boolean isCaseSensitive) {
            Intrinsics.checkNotNullParameter((Object)typePattern, (String)"typePattern");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(isCaseSensitive, null);
            this.regexPredicate = new RegExpPredicate(typePattern, isCaseSensitive, name, false, isTarget);
        }
    }
}

