/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.MakefileFileType;
import com.jetbrains.lang.makefile.psi.MakefileCommand;
import com.jetbrains.lang.makefile.psi.MakefileFunction;
import com.jetbrains.lang.makefile.psi.MakefileNormalPrerequisites;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisite;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisites;
import com.jetbrains.lang.makefile.psi.MakefileRecipe;
import com.jetbrains.lang.makefile.psi.MakefileRule;
import com.jetbrains.lang.makefile.psi.MakefileSubstitution;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import com.jetbrains.lang.makefile.psi.MakefileTargetLine;
import com.jetbrains.lang.makefile.psi.MakefileVariable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\""}, d2={"Lcom/jetbrains/lang/makefile/psi/MakefileElementFactory;", "", "()V", "createChars", "Lcom/intellij/lang/ASTNode;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "chars", "", "createEOL", "Lcom/intellij/psi/PsiElement;", "whitespace", "createFile", "Lcom/jetbrains/lang/makefile/MakefileFile;", "text", "createFunction", "Lcom/jetbrains/lang/makefile/psi/MakefileFunction;", "createPrerequisite", "Lcom/jetbrains/lang/makefile/psi/MakefilePrerequisite;", "name", "createRecipe", "Lcom/jetbrains/lang/makefile/psi/MakefileRecipe;", "createRule", "Lcom/jetbrains/lang/makefile/psi/MakefileRule;", "target", "createSubstitution", "Lcom/jetbrains/lang/makefile/psi/MakefileSubstitution;", "createTarget", "Lcom/jetbrains/lang/makefile/psi/MakefileTarget;", "createVariable", "Lcom/jetbrains/lang/makefile/psi/MakefileVariable;", "createWhiteSpace", "Lcom/intellij/psi/PsiWhiteSpace;", "intellij.makefile"})
public final class MakefileElementFactory {
    @NotNull
    public static final MakefileElementFactory INSTANCE;

    @NotNull
    public final MakefileFile createFile(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("Makefile", (FileType)MakefileFileType.INSTANCE, (CharSequence)text);
        if (psiFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.MakefileFile");
        }
        return (MakefileFile)psiFile;
    }

    @NotNull
    public final MakefileRule createRule(@NotNull Project project, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        PsiElement psiElement = this.createFile(project, target + ':').getFirstChild();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileRule");
        }
        return (MakefileRule)psiElement;
    }

    @NotNull
    public final MakefileTarget createTarget(@NotNull Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiElement psiElement = this.createRule(project, name).getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createRule(project, name).firstChild");
        PsiElement psiElement2 = psiElement.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createRule(project, name).firstChild.firstChild");
        PsiElement psiElement3 = psiElement2.getFirstChild();
        if (psiElement3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileTarget");
        }
        return (MakefileTarget)psiElement3;
    }

    @NotNull
    public final MakefileVariable createVariable(@NotNull Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiElement psiElement = this.createFile(project, name + " := ''").getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFile(project, \"$name := ''\").firstChild");
        PsiElement psiElement2 = psiElement.getFirstChild();
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileVariable");
        }
        return (MakefileVariable)psiElement2;
    }

    @NotNull
    public final MakefilePrerequisite createPrerequisite(@NotNull Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiElement psiElement = this.createFile(project, "a: " + name).getFirstChild();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileRule");
        }
        MakefileTargetLine makefileTargetLine = ((MakefileRule)psiElement).getTargetLine();
        Intrinsics.checkNotNullExpressionValue((Object)makefileTargetLine, (String)"(createFile(project, \"a:\u2026 MakefileRule).targetLine");
        MakefilePrerequisites makefilePrerequisites = makefileTargetLine.getPrerequisites();
        Intrinsics.checkNotNull((Object)makefilePrerequisites);
        Intrinsics.checkNotNullExpressionValue((Object)makefilePrerequisites, (String)"(createFile(project, \"a:\u2026argetLine.prerequisites!!");
        MakefileNormalPrerequisites makefileNormalPrerequisites = makefilePrerequisites.getNormalPrerequisites();
        Intrinsics.checkNotNullExpressionValue((Object)makefileNormalPrerequisites, (String)"(createFile(project, \"a:\u2026tes!!.normalPrerequisites");
        PsiElement psiElement2 = makefileNormalPrerequisites.getFirstChild();
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefilePrerequisite");
        }
        return (MakefilePrerequisite)psiElement2;
    }

    @NotNull
    public final PsiWhiteSpace createWhiteSpace(@NotNull Project project, @NotNull String whitespace) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)whitespace, (String)"whitespace");
        PsiElement psiElement = this.createFile(project, whitespace).getFirstChild();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiWhiteSpace");
        }
        return (PsiWhiteSpace)psiElement;
    }

    public final ASTNode createChars(@NotNull Project project, @NotNull String chars) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        PsiElement psiElement = this.createFile(project, chars).getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFile(project, chars).firstChild");
        return psiElement.getNode();
    }

    public final PsiElement createEOL(@NotNull Project project, @NotNull String whitespace) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)whitespace, (String)"whitespace");
        return this.createFile(project, whitespace).getFirstChild();
    }

    @NotNull
    public final MakefileRecipe createRecipe(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiElement psiElement = this.createRule(project, "target:\n\t" + text).getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createRule(project, \"target:\\n\\t$text\").firstChild");
        PsiElement psiElement2 = psiElement.getNextSibling();
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileRecipe");
        }
        return (MakefileRecipe)psiElement2;
    }

    @NotNull
    public final MakefileFunction createFunction(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiElement psiElement = this.createFile(project, text).getFirstChild();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileFunction");
        }
        return (MakefileFunction)psiElement;
    }

    @NotNull
    public final MakefileSubstitution createSubstitution(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<MakefileCommand> list = this.createRecipe(project, text).getCommandList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"createRecipe(project, text).commandList");
        Object object = CollectionsKt.first(list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createRecipe(project, text).commandList.first()");
        List<MakefileSubstitution> list2 = ((MakefileCommand)object).getSubstitutionList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"createRecipe(project, te\u2026.first().substitutionList");
        Object object2 = CollectionsKt.first(list2);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"createRecipe(project, te\u2026.substitutionList.first()");
        return (MakefileSubstitution)object2;
    }

    private MakefileElementFactory() {
    }

    static {
        MakefileElementFactory makefileElementFactory;
        INSTANCE = makefileElementFactory = new MakefileElementFactory();
    }
}

