/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.makefile.psi.MakefileElementType;
import com.jetbrains.lang.makefile.psi.MakefileTokenType;
import com.jetbrains.lang.makefile.psi.impl.MakefileBlockImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileCommandImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileCommentImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileConditionImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileConditionalElseImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileConditionalImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileDefineImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileDirectiveImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileDirectoryImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileDocCommentImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileExportImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileFilenameImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileFunctionImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileFunctionNameImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileFunctionParamImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileIdentifierImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileIncludeImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileInlineCommandImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileNormalPrerequisitesImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileOrderOnlyPrerequisitesImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileOverrideImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefilePatternImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefilePrerequisiteImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefilePrerequisitesImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefilePrivatevarImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileRecipeImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileRuleImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileStringImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileSubstitutionImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileTargetImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileTargetLineImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileTargetPatternImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileTargetsImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileUndefineImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileUnexportImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileVariableAssignmentImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileVariableImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileVariableUsageImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileVariableValueImpl;
import com.jetbrains.lang.makefile.psi.impl.MakefileVpathImpl;
import com.jetbrains.lang.makefile.stub.MakefileTargetStubElementType;

public interface MakefileTypes {
    public static final IElementType BLOCK = new MakefileElementType("BLOCK");
    public static final IElementType COMMAND = new MakefileElementType("COMMAND");
    public static final IElementType COMMENT = new MakefileElementType("COMMENT");
    public static final IElementType CONDITION = new MakefileElementType("CONDITION");
    public static final IElementType CONDITIONAL = new MakefileElementType("CONDITIONAL");
    public static final IElementType CONDITIONAL_ELSE = new MakefileElementType("CONDITIONAL_ELSE");
    public static final IElementType DEFINE = new MakefileElementType("DEFINE");
    public static final IElementType DIRECTIVE = new MakefileElementType("DIRECTIVE");
    public static final IElementType DIRECTORY = new MakefileElementType("DIRECTORY");
    public static final IElementType DOC_COMMENT = new MakefileElementType("DOC_COMMENT");
    public static final IElementType EXPORT = new MakefileElementType("EXPORT");
    public static final IElementType FILENAME = new MakefileElementType("FILENAME");
    public static final IElementType FUNCTION = new MakefileElementType("FUNCTION");
    public static final IElementType FUNCTION_NAME = new MakefileElementType("FUNCTION_NAME");
    public static final IElementType FUNCTION_PARAM = new MakefileElementType("FUNCTION_PARAM");
    public static final IElementType IDENTIFIER = new MakefileElementType("IDENTIFIER");
    public static final IElementType INCLUDE = new MakefileElementType("INCLUDE");
    public static final IElementType INLINE_COMMAND = new MakefileElementType("INLINE_COMMAND");
    public static final IElementType NORMAL_PREREQUISITES = new MakefileElementType("NORMAL_PREREQUISITES");
    public static final IElementType ORDER_ONLY_PREREQUISITES = new MakefileElementType("ORDER_ONLY_PREREQUISITES");
    public static final IElementType OVERRIDE = new MakefileElementType("OVERRIDE");
    public static final IElementType PATTERN = new MakefileElementType("PATTERN");
    public static final IElementType PREREQUISITE = new MakefileElementType("PREREQUISITE");
    public static final IElementType PREREQUISITES = new MakefileElementType("PREREQUISITES");
    public static final IElementType PRIVATEVAR = new MakefileElementType("PRIVATEVAR");
    public static final IElementType RECIPE = new MakefileElementType("RECIPE");
    public static final IElementType RULE = new MakefileElementType("RULE");
    public static final IElementType STRING = new MakefileElementType("STRING");
    public static final IElementType SUBSTITUTION = new MakefileElementType("SUBSTITUTION");
    public static final IElementType TARGET = MakefileTargetStubElementType.getInstance("TARGET");
    public static final IElementType TARGETS = new MakefileElementType("TARGETS");
    public static final IElementType TARGET_LINE = new MakefileElementType("TARGET_LINE");
    public static final IElementType TARGET_PATTERN = new MakefileElementType("TARGET_PATTERN");
    public static final IElementType UNDEFINE = new MakefileElementType("UNDEFINE");
    public static final IElementType UNEXPORT = new MakefileElementType("UNEXPORT");
    public static final IElementType VARIABLE = new MakefileElementType("VARIABLE");
    public static final IElementType VARIABLE_ASSIGNMENT = new MakefileElementType("VARIABLE_ASSIGNMENT");
    public static final IElementType VARIABLE_USAGE = new MakefileElementType("VARIABLE_USAGE");
    public static final IElementType VARIABLE_VALUE = new MakefileElementType("VARIABLE_VALUE");
    public static final IElementType VPATH = new MakefileElementType("VPATH");
    public static final IElementType ASSIGN = new MakefileTokenType("=");
    public static final IElementType BACKTICK = new MakefileTokenType("`");
    public static final IElementType CHARS = new MakefileTokenType("chars");
    public static final IElementType CLOSE_CURLY = new MakefileTokenType("}");
    public static final IElementType CLOSE_PAREN = new MakefileTokenType(")");
    public static final IElementType COLON = new MakefileTokenType(":");
    public static final IElementType COMMA = new MakefileTokenType(",");
    public static final IElementType DOLLAR = new MakefileTokenType("$");
    public static final IElementType DOUBLEQUOTE = new MakefileTokenType("\"");
    public static final IElementType EOL = new MakefileTokenType("EOL");
    public static final IElementType ESCAPED_DOUBLEQUOTE = new MakefileTokenType("\\\\\"");
    public static final IElementType KEYWORD_DEFINE = new MakefileTokenType("define");
    public static final IElementType KEYWORD_ELSE = new MakefileTokenType("else");
    public static final IElementType KEYWORD_ENDEF = new MakefileTokenType("endef");
    public static final IElementType KEYWORD_ENDIF = new MakefileTokenType("endif");
    public static final IElementType KEYWORD_EXPORT = new MakefileTokenType("export");
    public static final IElementType KEYWORD_IFDEF = new MakefileTokenType("ifdef");
    public static final IElementType KEYWORD_IFEQ = new MakefileTokenType("ifeq");
    public static final IElementType KEYWORD_IFNDEF = new MakefileTokenType("ifndef");
    public static final IElementType KEYWORD_IFNEQ = new MakefileTokenType("ifneq");
    public static final IElementType KEYWORD_INCLUDE = new MakefileTokenType("include");
    public static final IElementType KEYWORD_OVERRIDE = new MakefileTokenType("override");
    public static final IElementType KEYWORD_PRIVATE = new MakefileTokenType("private");
    public static final IElementType KEYWORD_UNDEFINE = new MakefileTokenType("undefine");
    public static final IElementType KEYWORD_UNEXPORT = new MakefileTokenType("unexport");
    public static final IElementType KEYWORD_VPATH = new MakefileTokenType("vpath");
    public static final IElementType MACRO = new MakefileTokenType("macro");
    public static final IElementType OPEN_CURLY = new MakefileTokenType("{");
    public static final IElementType OPEN_PAREN = new MakefileTokenType("(");
    public static final IElementType PIPE = new MakefileTokenType("|");
    public static final IElementType QUOTE = new MakefileTokenType("'");
    public static final IElementType SEMICOLON = new MakefileTokenType(";");
    public static final IElementType SPLIT = new MakefileTokenType("split");
    public static final IElementType TAB = new MakefileTokenType("\\t");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == BLOCK) {
                return new MakefileBlockImpl(node);
            }
            if (type == COMMAND) {
                return new MakefileCommandImpl(node);
            }
            if (type == COMMENT) {
                return new MakefileCommentImpl(node);
            }
            if (type == CONDITION) {
                return new MakefileConditionImpl(node);
            }
            if (type == CONDITIONAL) {
                return new MakefileConditionalImpl(node);
            }
            if (type == CONDITIONAL_ELSE) {
                return new MakefileConditionalElseImpl(node);
            }
            if (type == DEFINE) {
                return new MakefileDefineImpl(node);
            }
            if (type == DIRECTIVE) {
                return new MakefileDirectiveImpl(node);
            }
            if (type == DIRECTORY) {
                return new MakefileDirectoryImpl(node);
            }
            if (type == DOC_COMMENT) {
                return new MakefileDocCommentImpl(node);
            }
            if (type == EXPORT) {
                return new MakefileExportImpl(node);
            }
            if (type == FILENAME) {
                return new MakefileFilenameImpl(node);
            }
            if (type == FUNCTION) {
                return new MakefileFunctionImpl(node);
            }
            if (type == FUNCTION_NAME) {
                return new MakefileFunctionNameImpl(node);
            }
            if (type == FUNCTION_PARAM) {
                return new MakefileFunctionParamImpl(node);
            }
            if (type == IDENTIFIER) {
                return new MakefileIdentifierImpl(node);
            }
            if (type == INCLUDE) {
                return new MakefileIncludeImpl(node);
            }
            if (type == INLINE_COMMAND) {
                return new MakefileInlineCommandImpl(node);
            }
            if (type == NORMAL_PREREQUISITES) {
                return new MakefileNormalPrerequisitesImpl(node);
            }
            if (type == ORDER_ONLY_PREREQUISITES) {
                return new MakefileOrderOnlyPrerequisitesImpl(node);
            }
            if (type == OVERRIDE) {
                return new MakefileOverrideImpl(node);
            }
            if (type == PATTERN) {
                return new MakefilePatternImpl(node);
            }
            if (type == PREREQUISITE) {
                return new MakefilePrerequisiteImpl(node);
            }
            if (type == PREREQUISITES) {
                return new MakefilePrerequisitesImpl(node);
            }
            if (type == PRIVATEVAR) {
                return new MakefilePrivatevarImpl(node);
            }
            if (type == RECIPE) {
                return new MakefileRecipeImpl(node);
            }
            if (type == RULE) {
                return new MakefileRuleImpl(node);
            }
            if (type == STRING) {
                return new MakefileStringImpl(node);
            }
            if (type == SUBSTITUTION) {
                return new MakefileSubstitutionImpl(node);
            }
            if (type == TARGET) {
                return new MakefileTargetImpl(node);
            }
            if (type == TARGETS) {
                return new MakefileTargetsImpl(node);
            }
            if (type == TARGET_LINE) {
                return new MakefileTargetLineImpl(node);
            }
            if (type == TARGET_PATTERN) {
                return new MakefileTargetPatternImpl(node);
            }
            if (type == UNDEFINE) {
                return new MakefileUndefineImpl(node);
            }
            if (type == UNEXPORT) {
                return new MakefileUnexportImpl(node);
            }
            if (type == VARIABLE) {
                return new MakefileVariableImpl(node);
            }
            if (type == VARIABLE_ASSIGNMENT) {
                return new MakefileVariableAssignmentImpl(node);
            }
            if (type == VARIABLE_USAGE) {
                return new MakefileVariableUsageImpl(node);
            }
            if (type == VARIABLE_VALUE) {
                return new MakefileVariableValueImpl(node);
            }
            if (type == VPATH) {
                return new MakefileVpathImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

