/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.wizard.AbstractWizardEx;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.DownloadAction;
import com.jetbrains.plugins.webDeployment.actions.createproject.ActionTypeDescription;
import com.jetbrains.plugins.webDeployment.actions.createproject.AddServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.BaseStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseRemotePathStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseScenarioStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseWebPathStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import com.jetbrains.plugins.webDeployment.actions.createproject.FileChooserStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.PublishOptionsStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.SpecifyLocalPathStep;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.statistic.DeploymentActivitiesUsageTriggerCollector;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreateWebProjectWizard
extends AbstractWizardEx {
    private static final Logger LOG = Logger.getInstance(CreateWebProjectWizard.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final Component myComponent;
    private final CreateProjectModel myModel;
    private static final int MAX_ERRORS_IN_BALLOON = 2;

    public static CreateWebProjectWizard createInstance(@Nullable Project project, @NotNull Component component) {
        if (component == null) {
            CreateWebProjectWizard.$$$reportNull$$$0(0);
        }
        CreateProjectModel model = new CreateProjectModel();
        ArrayList<BaseStep> steps = new ArrayList<BaseStep>();
        steps.add(new ChooseScenarioStep(model));
        steps.add(new ChooseServerStep(model));
        steps.add(new AddServerStep(model));
        steps.add(new ChooseRemotePathStep(model));
        steps.add(new ChooseWebPathStep(model));
        steps.add(new SpecifyLocalPathStep(model));
        steps.add(new FileChooserStep(model, CreateProjectModel.Scenario.NoServer));
        steps.add(new FileChooserStep(model, CreateProjectModel.Scenario.LocalServer));
        steps.add(new PublishOptionsStep(model));
        return new CreateWebProjectWizard(project, component, model, steps);
    }

    private CreateWebProjectWizard(@Nullable Project project, @NotNull Component component, CreateProjectModel model, List<? extends AbstractWizardStepEx> steps) {
        if (component == null) {
            CreateWebProjectWizard.$$$reportNull$$$0(1);
        }
        super(WDBundle.message("create.web.project", new Object[0]), project, steps);
        this.myProject = project;
        this.myComponent = component;
        this.myModel = model;
    }

    protected boolean canFinish() {
        return super.canFinish() && ((AbstractWizardStepEx)this.getCurrentStepObject()).getNextStepId() == null;
    }

    public void show() {
        super.show();
        if (this.isOK()) {
            this.doCreateProject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateProject() {
        File parent;
        DeploymentActivitiesUsageTriggerCollector.logCreateProjectFromExistingSources(this.myModel.scenario);
        if (this.myModel.scenario == CreateProjectModel.Scenario.NoServer) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.myModel.localPath);
            LOG.assertTrue(file != null && file.isValid());
            VirtualFile parent2 = file.getParent();
            if (parent2 != null) {
                RecentProjectsManager.getInstance().setLastProjectCreationLocation(parent2.getPath());
            }
            ActionTypeDescription.LOCAL_RESOURCE_ROOTS_ACTION_DESCRIPTION.apply(this.myModel.getLocalActionPaths(), file, null);
            Project newProject = PlatformProjectOpenProcessor.getInstance().doOpenProject(file, null, false);
            if (newProject != null) {
                ActionTypeDescription.LOCAL_EXCLUDE_FOLDERS_ACTION_DESCRIPTION.apply(this.myModel.getLocalActionPaths(), file, newProject);
                ActionTypeDescription.LOCAL_TEST_ROOTS_ACTION_DESCRIPTION.apply(this.myModel.getLocalActionPaths(), file, newProject);
            }
            return;
        }
        DeploymentPathMapping mapping = new DeploymentPathMapping();
        mapping.setLocalPath(this.myModel.localPath);
        if (this.myModel.getServer().needsTransfer()) {
            if (this.myModel.getServer().getFileTransferConfig().getAccessType().isProtocolBased()) {
                mapping.setDeployPath(this.myModel.getServerPath().path);
            } else {
                String remainder = DeploymentPathUtils.getPathRemainder(this.myModel.getServer().getFileTransferConfig().getMountedFolder(), this.myModel.getServerPath().path, SystemInfo.isFileSystemCaseSensitive);
                if (remainder == null || remainder.length() == 0) {
                    remainder = this.myModel.getServer().getFileTransferConfig().getAccessType().isProtocolBased() ? "/" : File.separator;
                }
                mapping.setDeployPath(remainder);
            }
        }
        mapping.setWebPath(this.myModel.webPath.length() > 0 ? this.myModel.webPath : "/");
        final String title = WDBundle.message("create.web.project", new Object[0]);
        File location = new File(this.myModel.localPath);
        if (!location.exists() && !location.mkdirs()) {
            if (this.myProject != null) {
                Messages.showErrorDialog((Project)this.myProject, (String)WDBundle.message("failed.to.create.project.directory", location), (String)title);
            } else {
                Messages.showErrorDialog((Component)this.myComponent, (String)WDBundle.message("failed.to.create.project.directory", location), (String)title);
            }
            return;
        }
        final VirtualFile baseDir = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.myModel.localPath)));
        baseDir.refresh(false, true);
        PublishConfig publishConfig = this.myModel.getConfig();
        publishConfig.setDefaultGroupOrServerName(this.myModel.getServer().getName());
        publishConfig.setPathMappings(this.myModel.getServer().getId(), Collections.singletonList(mapping));
        HashMap<String, List<DeploymentPathMapping>> newEntries = new HashMap<String, List<DeploymentPathMapping>>();
        for (Map.Entry<String, List<DeploymentPathMapping>> entry : publishConfig.getAllPathMappings().entrySet()) {
            ArrayList<DeploymentPathMapping> newList = new ArrayList<DeploymentPathMapping>(entry.getValue().size());
            for (DeploymentPathMapping map : entry.getValue()) {
                if (map instanceof ChooseRemotePathStep.TempDeploymentPathMapping) {
                    newList.add(((ChooseRemotePathStep.TempDeploymentPathMapping)map).cloneAsDeploymentPathMapping());
                    continue;
                }
                newList.add(map.clone());
            }
            newEntries.put(entry.getKey(), newList);
        }
        publishConfig.setPathMappings(newEntries);
        final ArrayList<String> downloadErrors = new ArrayList<String>();
        if (this.myModel.getServer().needsTransfer()) {
            PublishConfig downloadConfig = publishConfig.clone();
            downloadConfig.setStopOnFirstError(false);
            final Ref result = new Ref();
            DeploymentRevisionTrackerBase revisionTracker = new DeploymentRevisionTrackerBase(this.myProject, new File(this.myModel.localPath).getName(), this.myModel.localPath){
                {
                    this.clearFiles();
                }
            };
            try {
                new TransferTask.ListBased(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject, this.myComponent), false, downloadConfig, Deployable.create(this.myModel.getServer(), null), WDBundle.message("downloading.project.files", new Object[0]), false, false, true, revisionTracker){

                    @Override
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        try {
                            result.set((Object)this.doRun(indicator));
                        }
                        finally {
                            if (result.isNull()) {
                                result.set((Object)Boolean.FALSE);
                            }
                        }
                    }

                    @Override
                    @NotNull
                    protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                        TransferTask.ListBased.ResultWithErrors resultWithErrors = DownloadAction.scanFiles(context, Collections.singletonList(baseDir));
                        if (resultWithErrors == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return resultWithErrors;
                    }

                    @Override
                    protected void print(String text, ConsoleViewContentType contentType) {
                        if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
                            downloadErrors.add(text);
                        }
                    }

                    @Override
                    protected void showBalloon(MessageType type, @NlsContexts.DialogMessage String text, boolean isSummary) {
                        if (isSummary && type == MessageType.ERROR) {
                            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)text, (String)title));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/CreateWebProjectWizard$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/CreateWebProjectWizard$2";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "buildOperationsList";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "run";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                }.queue();
            }
            finally {
                Disposer.dispose((Disposable)revisionTracker);
            }
            if (!((Boolean)result.get()).booleanValue()) {
                return;
            }
        }
        if ((parent = location.getParentFile()) != null) {
            RecentProjectsManager.getInstance().setLastProjectCreationLocation(parent.getPath());
        }
        ActionTypeDescription.REMOTE_RESOURCE_ROOTS_ACTION_DESCRIPTION.apply(this.myModel.getRemoteActionPaths(), baseDir, null, this.myModel.getServer(), publishConfig);
        ActionTypeDescription.LOCAL_RESOURCE_ROOTS_ACTION_DESCRIPTION.apply(this.myModel.getLocalActionPaths(), baseDir, null);
        final Project newProject = PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, null, false);
        if (newProject != null) {
            if (!StringUtil.isEmpty((String)this.myModel.projectName)) {
                Module module;
                ((ProjectEx)newProject).setProjectName(this.myModel.projectName);
                newProject.save();
                Module[] modules = ModuleManager.getInstance((Project)newProject).getModules();
                if (modules.length == 1 && !this.myModel.projectName.equals((module = modules[0]).getName())) {
                    ProjectUtil.modifyModules((Project)newProject, model -> {
                        try {
                            model.renameModule(module, this.myModel.projectName);
                        }
                        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                            LOG.error("Module's old name differs from new, but exception was thrown while renaming", (Throwable)moduleWithNameAlreadyExists);
                        }
                        return null;
                    });
                }
            }
            if (newProject.isDisposed()) {
                return;
            }
            publishConfig.copyTo(PublishConfig.getInstance(newProject));
            ActionTypeDescription.REMOTE_EXCLUDE_FOLDERS_ACTION_DESCRIPTION.apply(this.myModel.getRemoteActionPaths(), baseDir, newProject, this.myModel.getServer(), publishConfig);
            ActionTypeDescription.LOCAL_EXCLUDE_FOLDERS_ACTION_DESCRIPTION.apply(this.myModel.getLocalActionPaths(), baseDir, newProject);
            ActionTypeDescription.LOCAL_TEST_ROOTS_ACTION_DESCRIPTION.apply(this.myModel.getLocalActionPaths(), baseDir, newProject);
            if (newProject.isDisposed()) {
                return;
            }
            AutoUploadComponent.getInstance(newProject).addOrRemoveListener(newProject);
            if (!downloadErrors.isEmpty()) {
                String text = CreateWebProjectWizard.getBalloonText(downloadErrors);
                if (newProject.isDisposed()) {
                    return;
                }
                NotificationListener.Adapter listener = new NotificationListener.Adapter(){

                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                        if (notification == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (e == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        Messages.showWarningDialog((Project)newProject, (String)CreateWebProjectWizard.getBalloonTextFromMessages(downloadErrors), (String)WDBundle.message("create.project.error.dialog.title", new Object[0]));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/CreateWebProjectWizard$3";
                        objectArray[2] = "hyperlinkActivated";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                ToolWindowManager mgr = ToolWindowManager.getInstance((Project)newProject);
                mgr.invokeLater(() -> this.lambda$doCreateProject$2(newProject, text, (NotificationListener)listener));
            }
        }
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getBalloonText(List<String> downloadErrors) {
        String text = CreateWebProjectWizard.getBalloonTextFromMessages(ContainerUtil.getFirstItems(downloadErrors, (int)2));
        Object object = downloadErrors.size() > 2 ? "\n" + WDBundle.message("show.all.errors.hyperlink", new Object[0]) : text;
        if (object == null) {
            CreateWebProjectWizard.$$$reportNull$$$0(2);
        }
        return object;
    }

    @NlsContexts.DialogMessage
    private static String getBalloonTextFromMessages(Collection<@Nls String> messages) {
        ArrayList<String> allMessages = new ArrayList<String>();
        allMessages.add(WDBundle.message("create.web.project.errors", new Object[0]));
        allMessages.addAll(messages);
        return StringUtil.join(allMessages, (String)"\n");
    }

    private /* synthetic */ void lambda$doCreateProject$2(Project newProject, String text, NotificationListener listener) {
        FileTransferToolWindow.printWithTimestamp(newProject, this.myModel.getServer(), text, ConsoleViewContentType.ERROR_OUTPUT);
        DeploymentNotifier.notifyWithBalloon(null, text, NotificationType.WARNING, listener, newProject, FileTransferToolWindow.ID_PROVIDER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/CreateWebProjectWizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/CreateWebProjectWizard";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

