/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.statistic;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeploymentServersUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "deployment.servers";
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        List<WebServerConfig> servers;
        if (project == null) {
            DeploymentServersUsagesCollector.$$$reportNull$$$0(0);
        }
        if ((servers = GroupedServersConfigManager.getInstance(project).getFlattenedServers()).isEmpty()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                DeploymentServersUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        for (WebServerConfig server : servers) {
            String rootPathKey;
            if (!server.isUsedInProject(project, publishConfig, true)) continue;
            FeatureUsageData data = new FeatureUsageData();
            AccessType type = server.getFileTransferConfig().getAccessType();
            data.addData("type", StringUtil.toLowerCase((String)type.name()));
            if (type == AccessType.SFTP) {
                data.addData("auth", StringUtil.toLowerCase((String)server.getFileTransferConfig().getAuthType().name()));
            } else if (type == AccessType.FTP || type == AccessType.FTPS) {
                AdvancedOptionsConfig options = server.getFileTransferConfig().getAdvancedOptions();
                data.addData("passiveMode", options.isPassiveMode());
                data.addData("hiddenFiles", options.isShowHiddenFiles());
                if (type == AccessType.FTP) {
                    data.addData("compatibilityMode", options.isCompatibilityMode());
                }
            }
            List<DeploymentPathMapping> mappings = publishConfig.getPathMappings(server.getId());
            int deploy = 0;
            int web = 0;
            for (DeploymentPathMapping mapping : mappings) {
                if (StringUtil.isEmpty((String)mapping.getLocalPath())) continue;
                if (!StringUtil.isEmpty((String)mapping.getDeployPath())) {
                    ++deploy;
                }
                if (StringUtil.isEmpty((String)mapping.getWebPath())) continue;
                ++web;
            }
            data.addData("mappingsTogether", mappings.size());
            data.addData("mappingsDeploy", deploy);
            data.addData("mappingsWeb", web);
            String folder = server.getFileTransferConfig().getRootFolder();
            if (StringUtil.isEmptyOrSpaces((String)folder)) {
                rootPathKey = "empty";
            } else if ("/".equals(folder)) {
                rootPathKey = "trivial";
            } else {
                rootPathKey = "nontrivial";
                data.addData("rootPathSize", rootPathKey.length());
            }
            data.addData("rootPath", rootPathKey);
            result.add(MetricEventFactoryKt.newMetric((String)"server", (FeatureUsageData)data));
        }
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            DeploymentServersUsagesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/statistic/DeploymentServersUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/statistic/DeploymentServersUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

