/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.testDiscovery.instrumentation.DefaultConstructorDetectionVisitor;
import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsFilter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumentationUtils;
import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumenter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

class InstrumentedMethodsCollector
extends ClassVisitor {
    private static final String INIT_METHOD_NAME = "<init>";
    private final TestDiscoveryInstrumenter instrumenter;
    private final List<String> instrumentedMethods;
    private final InstrumentedMethodsFilter methodsFilter;
    private int defaultConstructorIndex = -1;

    InstrumentedMethodsCollector(int api, ClassVisitor cv, TestDiscoveryInstrumenter instrumenter, String className) {
        super(api, cv);
        this.instrumenter = instrumenter;
        this.methodsFilter = new InstrumentedMethodsFilter(className);
        this.instrumentedMethods = new ArrayList<String>();
    }

    String[] instrumentedMethods() {
        return this.instrumentedMethods.toArray(new String[0]);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.methodsFilter.visit(version, access, name, signature, superName, interfaces);
        this.instrumenter.myClassVersion = version;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, final String desc, String signature, String[] exceptions) {
        InstrumentedMethodsFilter.Decision decision = this.methodsFilter.shouldVisitMethod(access, name, desc, signature, exceptions, this.instrumenter.myInstrumentConstructors);
        if (decision == InstrumentedMethodsFilter.Decision.YES) {
            this.instrumentedMethods.add(TestDiscoveryInstrumentationUtils.getMethodId(name, desc));
            if (INIT_METHOD_NAME.equals(name) && !this.instrumenter.myInstrumentConstructors) {
                this.instrumentAllConstructors();
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (decision == InstrumentedMethodsFilter.Decision.NO) {
            return null;
        }
        assert (decision == InstrumentedMethodsFilter.Decision.CHECK_IS_CONSTRUCTOR_DEFAULT);
        assert (INIT_METHOD_NAME.equals(name));
        return new DefaultConstructorDetectionVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

            void onDecisionDone(boolean isDefault) {
                if (!isDefault) {
                    InstrumentedMethodsCollector.this.instrumentAllConstructors();
                    InstrumentedMethodsCollector.this.instrumentedMethods.add(TestDiscoveryInstrumentationUtils.getMethodId(InstrumentedMethodsCollector.INIT_METHOD_NAME, desc));
                } else {
                    InstrumentedMethodsCollector.this.defaultConstructorIndex = InstrumentedMethodsCollector.this.instrumentedMethods.size();
                }
            }
        };
    }

    private void instrumentAllConstructors() {
        this.instrumenter.myInstrumentConstructors = true;
        if (this.defaultConstructorIndex != -1) {
            this.instrumentedMethods.add(this.defaultConstructorIndex, TestDiscoveryInstrumentationUtils.getMethodId(INIT_METHOD_NAME, "()V"));
            this.defaultConstructorIndex = -1;
        }
    }
}

