/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.ConfigurableUiEx;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Component;
import java.awt.Container;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;
import org.jetbrains.settingsRepository.RepositoryListEditorKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/settingsRepository/IcsConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "Lcom/intellij/openapi/Disposable;", "()V", "autoSync", "Ljavax/swing/JCheckBox;", "editors", "", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "includeHostIntoCommitMessage", "repositoryListEditor", "Lcom/intellij/ui/layout/ConfigurableUiEx;", "apply", "", "settings", "dispose", "getComponent", "Lcom/intellij/openapi/ui/DialogPanel;", "isModified", "", "reset", "intellij.settingsRepository"})
public final class IcsConfigurableUi
implements ConfigurableUi<IcsSettings>,
Disposable {
    private final IcsManager icsManager;
    private final ConfigurableUiEx<IcsSettings> repositoryListEditor;
    private final List<ConfigurableUi<IcsSettings>> editors;
    private final JCheckBox autoSync;
    private final JCheckBox includeHostIntoCommitMessage;

    public void dispose() {
        this.icsManager.getAutoSyncManager$intellij_settingsRepository().setEnabled(true);
    }

    public void reset(@NotNull IcsSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.icsManager.getAutoSyncManager$intellij_settingsRepository().setEnabled(false);
        this.autoSync.setSelected(settings.getAutoSync());
        this.includeHostIntoCommitMessage.setSelected(settings.getIncludeHostIntoCommitMessage());
        Iterable $this$forEach$iv = this.editors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurableUi it = (ConfigurableUi)element$iv;
            boolean bl = false;
            it.reset((Object)settings);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified(@NotNull IcsSettings settings) {
        ConfigurableUi it;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (this.autoSync.isSelected() != settings.getAutoSync()) return true;
        if (this.includeHostIntoCommitMessage.isSelected() != settings.getIncludeHostIntoCommitMessage()) return true;
        Iterable $this$any$iv = this.editors;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (ConfigurableUi)element$iv;
            boolean bl = false;
        } while (!it.isModified((Object)settings));
        return true;
    }

    public void apply(@NotNull IcsSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        settings.setAutoSync(this.autoSync.isSelected());
        settings.setIncludeHostIntoCommitMessage(this.includeHostIntoCommitMessage.isSelected());
        Iterable $this$forEach$iv = this.editors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurableUi it = (ConfigurableUi)element$iv;
            boolean bl = false;
            if (!it.isModified((Object)settings)) continue;
            it.apply((Object)settings);
        }
        IcsSettingsKt.saveSettings(settings, this.icsManager.getSettingsFile());
    }

    @NotNull
    public DialogPanel getComponent() {
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        this.repositoryListEditor.buildUi($this$panel);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ IcsConfigurableUi this$0;
            {
                this.this$0 = icsConfigurableUi;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                CCFlags[] cCFlagsArray = new CCFlags[]{};
                GrowPolicy growPolicy = null;
                String string = IcsBundle.message("settings.auto.sync.comment", new Object[0]);
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)IcsConfigurableUi.access$getAutoSync$p(this.this$0), (CCFlags[])cCFlagsArray, growPolicy, (String)string, (int)2, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ IcsConfigurableUi this$0;
            {
                this.this$0 = icsConfigurableUi;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)IcsConfigurableUi.access$getIncludeHostIntoCommitMessage$p(this.this$0), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ IcsConfigurableUi this$0;
            {
                this.this$0 = icsConfigurableUi;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                String string = IcsBundle.message("settings.read.only.sources.table.header", new Object[0]);
                JComponent jComponent = ((ConfigurableUi)IcsConfigurableUi.access$getEditors$p(this.this$0).get(1)).getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editors.get(1).component");
                $this$row.panel(string, (Component)jComponent, false);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        return panel$iv;
    }

    public IcsConfigurableUi() {
        IcsManager icsManager2;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            Path path = PathManager.getConfigDir().resolve("settingsRepository");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getConfigDir\u2026lve(\"settingsRepository\")");
            icsManager2 = new IcsManager(path, this, null, 4, null);
        } else {
            icsManager2 = IcsManagerKt.getIcsManager();
        }
        this.icsManager = icsManager2;
        this.repositoryListEditor = RepositoryListEditorKt.createRepositoryListEditor(this.icsManager);
        this.editors = CollectionsKt.listOf((Object[])new ConfigurableUi[]{(ConfigurableUi)this.repositoryListEditor, ReadOnlySourcesEditorKt.createReadOnlySourcesEditor()});
        this.autoSync = new JCheckBox(IcsBundle.message("settings.auto.sync.checkbox", new Object[0]));
        this.includeHostIntoCommitMessage = new JCheckBox(IcsBundle.message("settings.include.hostname.into.commit.message.checkbox", new Object[0]));
    }

    public static final /* synthetic */ JCheckBox access$getAutoSync$p(IcsConfigurableUi $this) {
        return $this.autoSync;
    }

    public static final /* synthetic */ JCheckBox access$getIncludeHostIntoCommitMessage$p(IcsConfigurableUi $this) {
        return $this.includeHostIntoCommitMessage;
    }

    public static final /* synthetic */ List access$getEditors$p(IcsConfigurableUi $this) {
        return $this.editors;
    }
}

