/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.cache.internal.FileContentCache;
import org.gradle.cache.internal.FileContentCacheFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Serializer;

public class SplitFileContentCacheFactory
implements FileContentCacheFactory,
Closeable {
    private final FileContentCacheFactory globalFactory;
    private final FileContentCacheFactory localFactory;
    private final GlobalCacheLocations globalCacheLocations;

    public SplitFileContentCacheFactory(FileContentCacheFactory globalFactory, FileContentCacheFactory localFactory, GlobalCacheLocations globalCacheLocations) {
        this.globalFactory = globalFactory;
        this.localFactory = localFactory;
        this.globalCacheLocations = globalCacheLocations;
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable(this.localFactory).stop();
    }

    @Override
    public <V> FileContentCache<V> newCache(String name, int normalizedCacheSize, FileContentCacheFactory.Calculator<? extends V> calculator, Serializer<V> serializer) {
        FileContentCache<? extends V> globalCache = this.globalFactory.newCache(name, normalizedCacheSize, calculator, serializer);
        FileContentCache<? extends V> localCache = this.localFactory.newCache(name, normalizedCacheSize, calculator, serializer);
        return new SplitFileContentCache(globalCache, localCache, this.globalCacheLocations);
    }

    private static final class SplitFileContentCache<V>
    implements FileContentCache<V> {
        private final FileContentCache<V> globalCache;
        private final FileContentCache<V> localCache;
        private final GlobalCacheLocations globalCacheLocations;

        private SplitFileContentCache(FileContentCache<V> globalCache, FileContentCache<V> localCache, GlobalCacheLocations globalCacheLocations) {
            this.globalCache = globalCache;
            this.localCache = localCache;
            this.globalCacheLocations = globalCacheLocations;
        }

        @Override
        public V get(File file) {
            if (this.globalCacheLocations.isInsideGlobalCache(file.getPath())) {
                return this.globalCache.get(file);
            }
            return this.localCache.get(file);
        }
    }
}

