/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.operations.trace.BuildOperationRecord;

public class BuildOperationTree {
    public final List<BuildOperationRecord> roots;
    public final Map<Long, BuildOperationRecord> records;

    BuildOperationTree(List<BuildOperationRecord> roots) {
        ImmutableMap.Builder records = ImmutableMap.builder();
        for (BuildOperationRecord record : roots) {
            this.visit((ImmutableMap.Builder<Long, BuildOperationRecord>)records, record);
        }
        this.roots = BuildOperationRecord.ORDERING.immutableSortedCopy(roots);
        this.records = records.build();
    }

    private void visit(ImmutableMap.Builder<Long, BuildOperationRecord> records, BuildOperationRecord record) {
        records.put((Object)record.id, (Object)record);
        for (BuildOperationRecord child : record.children) {
            this.visit(records, child);
        }
    }

    static List<Map<String, ?>> serialize(List<BuildOperationRecord> roots) {
        return Lists.transform(roots, (Function)new Function<BuildOperationRecord, Map<String, ?>>(){

            public Map<String, ?> apply(BuildOperationRecord input) {
                return input.toSerializable();
            }
        });
    }
}

