/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonDependency;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitutionImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowablePairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageJsonData {
    private static final Logger LOG = Logger.getInstance(PackageJsonData.class);
    private static final Key<CachedPackageJsonData> CACHED_PACKAGE_JSON_DATA_KEY = Key.create((String)"js.cached.package-json.data");
    private static final String DESCRIPTION = "description";
    private static final String JSNEXT_MAIN = "jsnext:main";
    private static final String ESNEXT = "esnext";
    private static final String MODULE = "module";
    private static final String ES2015 = "es2015";
    private static final String MAIN = "main";
    private static final String WEB_TYPES = "web-types";
    private static final Map<String, PairConsumer<Holder, String>> ourParsers = ContainerUtil.immutableMapBuilder().put((Object)"name", (holder, value) -> {
        holder.myName = value;
    }).put((Object)"main", (holder, value) -> {
        holder.myMain = value;
    }).put((Object)"description", (holder, value) -> {
        holder.myDescription = value;
    }).put((Object)"version", (holder, value) -> {
        holder.myVersion = value;
    }).put((Object)"types", (holder, value) -> {
        holder.myTypings = value;
    }).put((Object)"typings", (holder, value) -> {
        holder.myTypings = value;
    }).put((Object)"jsnext:main", (holder, value) -> holder.myAdditionalMainProperties.put(JSNEXT_MAIN, (String)value)).put((Object)"module", (holder, value) -> holder.myAdditionalMainProperties.put(MODULE, (String)value)).put((Object)"es2015", (holder, value) -> holder.myAdditionalMainProperties.put(ES2015, (String)value)).put((Object)"tsconfig", (holder, value) -> {
        holder.myTsConfig = value;
    }).build();
    private static final Map<String, ThrowablePairConsumer<Holder, JsonReader, IOException>> ourCustomParsers = ContainerUtil.newHashMap((Pair)Pair.create((Object)"bin", (holder, reader) -> {
        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
            reader.beginObject();
            holder.myBinMap = new HashMap<String, String>(1);
            while (reader.hasNext()) {
                String name = reader.nextName();
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                if (name == null || value == null) continue;
                holder.myBinMap.put(name, value);
            }
            reader.endObject();
        } else {
            holder.myBinMap = Collections.singletonMap(null, JsonUtil.nextStringOrSkip((JsonReader)reader));
        }
    }), (Pair[])new Pair[]{Pair.create((Object)"workspaces", (holder, reader) -> {
        holder.myWorkspaces = PackageJsonData.parseWorkspaces(reader);
    }), Pair.create((Object)"esnext", (holder, reader) -> {
        JsonToken tokenType = reader.peek();
        String value = tokenType == JsonToken.BEGIN_OBJECT ? JsonUtil.getChildAsString((JsonReader)reader, (String)MAIN, null) : JsonUtil.nextStringOrSkip((JsonReader)reader);
        holder.myAdditionalMainProperties.put(ESNEXT, value);
    }), Pair.create((Object)"typesVersions", (holder, reader) -> {
        holder.myTypingsVersionMappings = PackageJsonData.parseTypingsVersionMappings(reader);
    }), Pair.create((Object)"web-types", (holder, reader) -> {
        holder.myWebTypes = PackageJsonData.parseWebTypes(reader);
    })});
    private final VirtualFile myPackageJsonFile;
    private final String myName;
    private final String myMain;
    private final String myTypings;
    private final String myDescription;
    private final Map<String, String> myBinMap;
    private final SemVer myVersion;
    private final Map<String, PackageJsonDependencyEntry> myDependencyMap;
    private final Map<String, String> myAdditionalMainProperties;
    private final Set<String> myScopes;
    private final Set<String> myTopLevelProperties;
    private final List<String> myWorkspaces;
    private final String myTsConfig;
    private final List<String> myWebTypes;
    @NotNull
    private final Map<String, List<JSModulePathSubstitution>> myTypingsVersionMappings;

    private static List<String> parseWebTypes(JsonReader reader) {
        JsonElement element = JsonParser.parseReader((JsonReader)reader);
        String singleValue = JsonUtil.getString((JsonElement)element);
        if (singleValue != null) {
            return Collections.singletonList(singleValue);
        }
        List list2 = JsonUtil.getAsStringList((JsonElement)element);
        if (list2 != null) {
            return list2;
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Map<String, List<JSModulePathSubstitution>> parseTypingsVersionMappings(@NotNull JsonReader reader) {
        JsonElement element;
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(0);
        }
        if (!((element = JsonParser.parseReader((JsonReader)reader)) instanceof JsonObject)) {
            Map<String, List<JSModulePathSubstitution>> map = Collections.emptyMap();
            if (map == null) {
                PackageJsonData.$$$reportNull$$$0(1);
            }
            return map;
        }
        LinkedHashMap<String, List<JSModulePathSubstitution>> map = new LinkedHashMap<String, List<JSModulePathSubstitution>>();
        for (Map.Entry mappingsEntry : ((JsonObject)element).entrySet()) {
            Set entries;
            JsonElement mappings;
            String version = (String)mappingsEntry.getKey();
            if (StringUtil.isEmpty((String)version) || !((mappings = (JsonElement)mappingsEntry.getValue()) instanceof JsonObject) || (entries = ((JsonObject)mappings).entrySet()).isEmpty()) continue;
            SmartList list2 = new SmartList();
            for (Map.Entry mappingEntry : ((JsonObject)mappings).entrySet()) {
                String nestedString;
                String mapping = (String)mappingEntry.getKey();
                if (StringUtil.isEmpty((String)mapping)) continue;
                JsonElement value = (JsonElement)mappingEntry.getValue();
                List<String> nested = JsonUtil.getAsStringList((JsonElement)value);
                if (nested.isEmpty() && (nestedString = JsonUtil.getString((JsonElement)value)) != null) {
                    nested = Collections.singletonList(nestedString);
                }
                list2.add((Object)new JSModulePathSubstitutionImpl(mapping, (Collection<String>)nested));
            }
            map.put(version, (List<JSModulePathSubstitution>)list2);
        }
        LinkedHashMap<String, List<JSModulePathSubstitution>> linkedHashMap = map;
        if (linkedHashMap == null) {
            PackageJsonData.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    @NotNull
    private static List<String> parseWorkspaces(@NotNull JsonReader reader) {
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(3);
        }
        JsonElement element = JsonParser.parseReader((JsonReader)reader);
        List result2 = null;
        if (element instanceof JsonObject) {
            result2 = JsonUtil.getChildAsStringList((JsonObject)((JsonObject)element), (String)"packages");
        } else if (element instanceof JsonArray) {
            result2 = JsonUtil.getAsStringList((JsonElement)element);
        }
        List list2 = ContainerUtil.notNullize((List)result2);
        if (list2 == null) {
            PackageJsonData.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private PackageJsonData(@NotNull VirtualFile packageJsonFile, @NotNull Holder holder) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            PackageJsonData.$$$reportNull$$$0(6);
        }
        this.myPackageJsonFile = packageJsonFile;
        this.myName = holder.myName;
        this.myMain = holder.myMain;
        this.myAdditionalMainProperties = holder.myAdditionalMainProperties;
        this.myDescription = holder.myDescription;
        this.myTypings = holder.myTypings;
        this.myTopLevelProperties = holder.myTopLevelProperties;
        this.myBinMap = PackageJsonData.fixBinaryNameMap(holder.myBinMap, this.myName);
        this.myTsConfig = holder.myTsConfig;
        this.myVersion = SemVer.parseFromText((String)StringUtil.notNullize((String)holder.myVersion));
        this.myWebTypes = holder.myWebTypes;
        this.myWorkspaces = ImmutableList.copyOf(holder.myWorkspaces);
        HashMap<String, PackageJsonDependencyEntry> dependenciesByName = new HashMap<String, PackageJsonDependencyEntry>();
        HashSet<String> scopes = new HashSet<String>();
        for (Map.Entry<PackageJsonDependency, List<PackageJsonDependencyEntry>> entry : holder.myDependenciesByType.entrySet()) {
            for (PackageJsonDependencyEntry dependency : entry.getValue()) {
                String dependencyName = dependency.getName();
                dependenciesByName.put(dependencyName, dependency);
                PackageJsonData.addScope(dependencyName, scopes);
            }
        }
        this.myScopes = Set.copyOf(scopes);
        this.myDependencyMap = dependenciesByName;
        this.myTypingsVersionMappings = holder.myTypingsVersionMappings;
    }

    @NotNull
    private static Map<String, String> fixBinaryNameMap(@NotNull Map<String, String> binaryNameToPathMap, @Nullable String name) {
        Map.Entry<String, String> entry;
        if (binaryNameToPathMap == null) {
            PackageJsonData.$$$reportNull$$$0(7);
        }
        if (binaryNameToPathMap.size() == 1 && (entry = binaryNameToPathMap.entrySet().iterator().next()).getKey() == null) {
            Map<String, String> map = Collections.singletonMap(name, entry.getValue());
            if (map == null) {
                PackageJsonData.$$$reportNull$$$0(8);
            }
            return map;
        }
        return new HashMap<String, String>(binaryNameToPathMap);
    }

    private static void addScope(@NotNull String dependencyName, @NotNull Set<String> scopes) {
        String scope;
        if (dependencyName == null) {
            PackageJsonData.$$$reportNull$$$0(9);
        }
        if (scopes == null) {
            PackageJsonData.$$$reportNull$$$0(10);
        }
        if ((scope = NodeModuleSearchUtil.getScopeByPackageName(dependencyName)) != null) {
            scopes.add(scope);
        }
    }

    public boolean containsDependencyWithScope(@NotNull String scope) {
        if (scope == null) {
            PackageJsonData.$$$reportNull$$$0(11);
        }
        return this.myScopes.contains(scope);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public VirtualFile getPackageJsonFile() {
        VirtualFile virtualFile = this.myPackageJsonFile;
        if (virtualFile == null) {
            PackageJsonData.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    @Nullable
    public String getTsConfig() {
        return this.myTsConfig;
    }

    @Nullable
    @NlsSafe
    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public String getMain() {
        return this.myMain;
    }

    @Nullable
    public String getJsNextMain() {
        String esnext = this.myAdditionalMainProperties.get(ESNEXT);
        if (esnext != null) {
            return esnext;
        }
        String module = this.myAdditionalMainProperties.get(MODULE);
        if (module != null) {
            return module;
        }
        String es2015 = this.myAdditionalMainProperties.get(ES2015);
        if (!StringUtil.isEmptyOrSpaces((String)es2015)) {
            return es2015;
        }
        String jsNext = this.myAdditionalMainProperties.get(JSNEXT_MAIN);
        if (!StringUtil.isEmptyOrSpaces((String)jsNext)) {
            return jsNext;
        }
        return null;
    }

    @NotNull
    public Map<String, List<JSModulePathSubstitution>> getTypingsVersionMappings() {
        Map<String, List<JSModulePathSubstitution>> map = this.myTypingsVersionMappings;
        if (map == null) {
            PackageJsonData.$$$reportNull$$$0(13);
        }
        return map;
    }

    public Set<String> getTopLevelProperties() {
        return this.myTopLevelProperties;
    }

    @NotNull
    public Collection<String> getAdditionalMains() {
        Collection<String> collection = this.myAdditionalMainProperties.values();
        if (collection == null) {
            PackageJsonData.$$$reportNull$$$0(14);
        }
        return collection;
    }

    public boolean hasTypingsProperty() {
        return !StringUtil.isEmptyOrSpaces((String)this.myTypings);
    }

    public boolean hasTypings() {
        return !StringUtil.isEmptyOrSpaces((String)this.getTypings());
    }

    @Nullable
    public String getTypings() {
        if (!StringUtil.isEmptyOrSpaces((String)this.myTypings)) {
            return this.myTypings;
        }
        String main = StringUtil.trimEnd((String)((String)ObjectUtils.notNull((Object)this.getMain(), (Object)"index")), (String)".js");
        String path2 = main + ".d.ts";
        return this.myPackageJsonFile.getParent().findFileByRelativePath(path2) != null ? path2 : null;
    }

    @Nullable
    public String getDefaultMain() {
        String typings = this.getTypings();
        if (!StringUtil.isEmptyOrSpaces((String)typings)) {
            return typings;
        }
        String additionalMain = this.getJsNextMain();
        if (!StringUtil.isEmptyOrSpaces((String)additionalMain)) {
            return additionalMain;
        }
        return this.myMain;
    }

    @NotNull
    public Map<String, String> getBinaryNameToPathMap() {
        Map<String, String> map = this.myBinMap;
        if (map == null) {
            PackageJsonData.$$$reportNull$$$0(15);
        }
        return map;
    }

    @Nullable
    public String getBinPath(@NotNull String executableName) {
        String value;
        if (executableName == null) {
            PackageJsonData.$$$reportNull$$$0(16);
        }
        String string = value = Objects.equals(this.myName, executableName) ? this.myBinMap.get(null) : null;
        if (value == null) {
            value = this.myBinMap.get(executableName);
        }
        return value;
    }

    @Nullable
    public SemVer getVersion() {
        return this.myVersion;
    }

    @NotNull
    public List<String> getWebTypes() {
        List<String> list2 = this.myWebTypes;
        if (list2 == null) {
            PackageJsonData.$$$reportNull$$$0(17);
        }
        return list2;
    }

    public boolean isDependencyOfAnyType(@NotNull String name) {
        if (name == null) {
            PackageJsonData.$$$reportNull$$$0(18);
        }
        return this.myDependencyMap.containsKey(name);
    }

    public boolean containsOneOfDependencyOfAnyType(String ... names) {
        if (names == null) {
            PackageJsonData.$$$reportNull$$$0(19);
        }
        for (String name : names) {
            if (!this.myDependencyMap.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isDependencyOfAnyTypeExcludeDev(@NotNull String name) {
        PackageJsonDependencyEntry dependency;
        if (name == null) {
            PackageJsonData.$$$reportNull$$$0(20);
        }
        return (dependency = this.myDependencyMap.get(name)) != null && dependency.getDependencyType() != PackageJsonDependency.devDependencies;
    }

    @NotNull
    public Set<String> getAllDependencies() {
        Set<String> set = this.myDependencyMap.keySet();
        if (set == null) {
            PackageJsonData.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    public Map<String, PackageJsonDependencyEntry> getAllDependencyEntries() {
        Map<String, PackageJsonDependencyEntry> map = this.myDependencyMap;
        if (map == null) {
            PackageJsonData.$$$reportNull$$$0(22);
        }
        return map;
    }

    @NotNull
    public List<String> getWorkspaces() {
        List<String> list2 = this.myWorkspaces;
        if (list2 == null) {
            PackageJsonData.$$$reportNull$$$0(23);
        }
        return list2;
    }

    public String toString() {
        return this.myName + "@" + this.myVersion + " " + this.myDependencyMap.keySet();
    }

    @NotNull
    public static PackageJsonData getOrCreateWithPreferredProject(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            PackageJsonData.$$$reportNull$$$0(24);
        }
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(25);
        }
        PackageJsonData packageJsonData = (PackageJsonData)ProjectLocator.computeWithPreferredProject((VirtualFile)packageJson, (Project)project, () -> PackageJsonData.getOrCreate(packageJson));
        if (packageJsonData == null) {
            PackageJsonData.$$$reportNull$$$0(26);
        }
        return packageJsonData;
    }

    @NotNull
    public static PackageJsonData getOrCreate(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(27);
        }
        PackageJsonData packageJsonData = (PackageJsonData)ReadAction.compute(() -> {
            long documentModificationStamp;
            if (!packageJson.isValid()) {
                LOG.error("Invalid file: " + packageJson);
            }
            Document document2 = FileDocumentManager.getInstance().getCachedDocument(packageJson);
            CachedPackageJsonData cached = (CachedPackageJsonData)CACHED_PACKAGE_JSON_DATA_KEY.get((UserDataHolder)packageJson);
            long l = documentModificationStamp = document2 != null ? document2.getModificationStamp() : -1L;
            if (cached == null || cached.getDocumentModificationStamp() != documentModificationStamp || cached.getFileModificationStamp() != packageJson.getModificationStamp()) {
                PackageJsonData data = PackageJsonData.doParse(packageJson, document2);
                cached = new CachedPackageJsonData(data, packageJson.getModificationStamp(), documentModificationStamp);
                CACHED_PACKAGE_JSON_DATA_KEY.set((UserDataHolder)packageJson, (Object)cached);
            }
            return cached.getData();
        });
        if (packageJsonData == null) {
            PackageJsonData.$$$reportNull$$$0(28);
        }
        return packageJsonData;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static PackageJsonData parse(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(29);
        }
        return PackageJsonData.getOrCreate(packageJsonFile);
    }

    @NotNull
    private static PackageJsonData doParse(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        CharSequence text;
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(30);
        }
        if (!StringUtil.isEmpty((CharSequence)(text = PackageJsonData.loadText(packageJsonFile, packageJsonDocument)))) {
            try {
                Holder holder = PackageJsonData.doParse(packageJsonFile, text);
                return new PackageJsonData(packageJsonFile, holder);
            }
            catch (Exception e) {
                LOG.info("Failed to parse " + packageJsonFile.getPath() + ": " + e.getMessage());
            }
        }
        return new PackageJsonData(packageJsonFile, new Holder());
    }

    @Nullable
    private static CharSequence loadText(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(31);
        }
        if (packageJsonDocument != null) {
            return packageJsonDocument.getCharsSequence();
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)packageJsonFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static Holder doParse(@NotNull VirtualFile packageJson, @NotNull CharSequence text) throws IOException {
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(32);
        }
        if (text == null) {
            PackageJsonData.$$$reportNull$$$0(33);
        }
        JsonReader reader = new JsonReader((Reader)new CharSequenceReader(text));
        reader.setLenient(true);
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Top level element should be object");
        }
        reader.beginObject();
        Holder holder = new Holder();
        EnumMap<PackageJsonDependency, List<PackageJsonDependencyEntry>> dependenciesByType = new EnumMap<PackageJsonDependency, List<PackageJsonDependencyEntry>>(PackageJsonDependency.class);
        while (reader.hasNext()) {
            String key = reader.nextName();
            holder.myTopLevelProperties.add(key);
            if (ourCustomParsers.containsKey(key)) {
                ourCustomParsers.get(key).consume((Object)holder, (Object)reader);
                continue;
            }
            if (ourParsers.containsKey(key)) {
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                ourParsers.get(key).consume((Object)holder, (Object)value);
                continue;
            }
            PackageJsonDependency dependencyType = PackageJsonDependency.findDependencyByName(key);
            if (dependencyType != null) {
                List<PackageJsonDependencyEntry> dependencies = PackageJsonData.readPackages(reader, packageJson, dependencyType);
                dependenciesByType.put(dependencyType, dependencies);
                continue;
            }
            reader.skipValue();
        }
        holder.myDependenciesByType = dependenciesByType;
        reader.endObject();
        Holder holder2 = holder;
        if (holder2 == null) {
            PackageJsonData.$$$reportNull$$$0(34);
        }
        return holder2;
    }

    @NotNull
    private static List<PackageJsonDependencyEntry> readPackages(@NotNull JsonReader reader, @NotNull VirtualFile packageJson, @NotNull PackageJsonDependency dependencyType) throws IOException {
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(35);
        }
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(36);
        }
        if (dependencyType == null) {
            PackageJsonData.$$$reportNull$$$0(37);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            LOG.info("Failed to parse '" + dependencyType + "' of " + packageJson.getPath() + ": expected " + JsonToken.BEGIN_OBJECT + ", actual " + reader.peek());
            reader.skipValue();
            List<PackageJsonDependencyEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                PackageJsonData.$$$reportNull$$$0(38);
            }
            return list2;
        }
        reader.beginObject();
        ArrayList<PackageJsonDependencyEntry> packages = new ArrayList<PackageJsonDependencyEntry>();
        while (reader.hasNext()) {
            String name = reader.nextName();
            String version = JsonUtil.nextStringOrSkip((JsonReader)reader);
            if (name == null || version == null) continue;
            packages.add(new PackageJsonDependencyEntry(name, version, dependencyType));
        }
        reader.endObject();
        ArrayList<PackageJsonDependencyEntry> arrayList = packages;
        if (arrayList == null) {
            PackageJsonData.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 34: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 34: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 34: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/PackageJsonData";
                break;
            }
            case 5: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryNameToPathMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: 
            case 27: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/PackageJsonData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypingsVersionMappings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWorkspaces";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fixBinaryNameMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypingsVersionMappings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalMains";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryNameToPathMap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebTypes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencyEntries";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaces";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateWithPreferredProject";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseTypingsVersionMappings";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 34: 
            case 38: 
            case 39: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseWorkspaces";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fixBinaryNameMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsDependencyWithScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOfAnyType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "containsOneOfDependencyOfAnyType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOfAnyTypeExcludeDev";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateWithPreferredProject";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 34: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedPackageJsonData {
        private final PackageJsonData myData;
        private final long myFileModificationStamp;
        private final long myDocumentModificationStamp;

        /*
         * WARNING - void declaration
         */
        CachedPackageJsonData(@NotNull PackageJsonData data, long fileModificationStamp, long l) {
            void documentModificationStamp;
            if (data == null) {
                CachedPackageJsonData.$$$reportNull$$$0(0);
            }
            this.myData = data;
            this.myFileModificationStamp = fileModificationStamp;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public PackageJsonData getData() {
            PackageJsonData packageJsonData = this.myData;
            if (packageJsonData == null) {
                CachedPackageJsonData.$$$reportNull$$$0(1);
            }
            return packageJsonData;
        }

        public long getFileModificationStamp() {
            return this.myFileModificationStamp;
        }

        public long getDocumentModificationStamp() {
            return this.myDocumentModificationStamp;
        }

        public String toString() {
            return "data=" + this.myData + ", fileModificationStamp=" + this.myFileModificationStamp + ", documentModificationStamp=" + this.myDocumentModificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/PackageJsonData$CachedPackageJsonData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/PackageJsonData$CachedPackageJsonData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PackageJsonDependencyEntry {
        @NotNull
        private final String myName;
        @NotNull
        private final String myVersionRange;
        @NotNull
        private final PackageJsonDependency myDependencyType;

        PackageJsonDependencyEntry(@NotNull String name, @NotNull String versionRange, @NotNull PackageJsonDependency dependencyType) {
            if (name == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(0);
            }
            if (versionRange == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(1);
            }
            if (dependencyType == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(2);
            }
            this.myName = name;
            this.myVersionRange = versionRange;
            this.myDependencyType = dependencyType;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public SemVer parseVersion() {
            String version = this.getVersionRange();
            if (StringUtil.isEmpty((String)version)) {
                return null;
            }
            String versionStr = !StringUtil.isDecimalDigit((char)version.charAt(0)) ? version.substring(1) : version;
            return SemVer.parseFromText((String)versionStr);
        }

        @NotNull
        public String getVersionRange() {
            String string = this.myVersionRange;
            if (string == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public PackageJsonDependency getDependencyType() {
            PackageJsonDependency packageJsonDependency = this.myDependencyType;
            if (packageJsonDependency == null) {
                PackageJsonDependencyEntry.$$$reportNull$$$0(5);
            }
            return packageJsonDependency;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/PackageJsonData$PackageJsonDependencyEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/PackageJsonData$PackageJsonDependencyEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersionRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencyType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Holder {
        private List<String> myWebTypes = Collections.emptyList();
        private String myName;
        private final Map<String, String> myAdditionalMainProperties = new HashMap<String, String>();
        private String myMain;
        private String myTypings;
        private String myDescription;
        private Map<String, String> myBinMap = Collections.emptyMap();
        private String myTsConfig;
        private String myVersion;
        private Map<PackageJsonDependency, List<PackageJsonDependencyEntry>> myDependenciesByType = Collections.emptyMap();
        private final Set<String> myTopLevelProperties = new HashSet<String>();
        private List<String> myWorkspaces = Collections.emptyList();
        private Map<String, List<JSModulePathSubstitution>> myTypingsVersionMappings = Collections.emptyMap();

        private Holder() {
        }
    }
}

