/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreModulesCatalog;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesSnapshot;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreLibraryManager
implements Disposable {
    public static final String LIBRARY_NAME = "Node.js Core";
    private static final RegistryValue USE_TYPINGS = Registry.get((String)"nodejs.core.library.use.typings");
    private final Project myProject;
    private JSLibraryMappings myMappings;
    @Nullable
    private volatile NodeCoreSourcesSnapshot mySnapshot;

    public NodeCoreLibraryManager(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(0);
        }
        this.myMappings = null;
        this.myProject = project;
        USE_TYPINGS.addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> JSLibraryManager.getInstance(NodeCoreLibraryManager.this.myProject).commitChanges()), NodeCoreLibraryManager.this.myProject.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager$1", "afterValueChanged"));
            }
        }, (Disposable)this);
        this.mySnapshot = NodeCoreLibraryManager.getInitialSnapshot(project);
    }

    public void dispose() {
    }

    @Nullable
    private static NodeCoreSourcesSnapshot getInitialSnapshot(@NotNull Project project) {
        NodeCoreLibraryConfigurator.NodeLibraryVersion version;
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(1);
        }
        if ((version = NodeCoreLibraryConfigurator.getConfiguredCoreLibraryVersion(project)) == null) {
            return null;
        }
        return NodeCoreLibraryConfigurator.getSnapshot(NodeCoreLibraryConfigurator.getCoreModulesSrcDir(version.getNodeVersion()));
    }

    @NotNull
    public static NodeCoreLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(2);
        }
        NodeCoreLibraryManager nodeCoreLibraryManager = (NodeCoreLibraryManager)project.getService(NodeCoreLibraryManager.class);
        if (nodeCoreLibraryManager == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(3);
        }
        return nodeCoreLibraryManager;
    }

    @Nullable
    NodeCoreSourcesSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    void setSnapshot(@Nullable NodeCoreSourcesSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public static boolean isCoreModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(4);
        }
        return NodeCoreModulesCatalog.INSTANCE.isPublicCoreModule(moduleName);
    }

    public boolean isCoreModuleLibraryFile(@NotNull VirtualFile virtualFile) {
        NodeCoreSourcesSnapshot snapshot;
        if (virtualFile == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(5);
        }
        return (snapshot = this.mySnapshot) != null && snapshot.isCoreModuleFile(virtualFile);
    }

    public boolean isCoreLibraryFile(@NotNull VirtualFile virtualFile) {
        SyntheticLibrary syntheticLibrary;
        ScriptingLibraryModel libraryModel;
        if (virtualFile == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(6);
        }
        return ProjectFileIndex.getInstance((Project)this.myProject).isInLibrary(virtualFile) && (libraryModel = JSLibraryManager.getInstance(this.myProject).getLibraryByName(LIBRARY_NAME)) instanceof ScriptingLibraryModelBackedBySyntheticLibrary && (syntheticLibrary = ((ScriptingLibraryModelBackedBySyntheticLibrary)libraryModel).getSyntheticLibrary()) != null && VfsUtilCore.isUnder((VirtualFile)virtualFile, new HashSet(syntheticLibrary.getAllRoots()));
    }

    @NotNull
    public Collection<String> listCoreModuleNames() {
        ImmutableList<String> immutableList = NodeCoreModulesCatalog.INSTANCE.getPublicCoreModules();
        if (immutableList == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @Nullable
    public VirtualFile findCoreModuleFileByName(@NotNull String moduleName) {
        NodeCoreSourcesSnapshot snapshot;
        if (moduleName == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(8);
        }
        return (snapshot = this.mySnapshot) != null ? snapshot.getFileByModuleName(moduleName) : null;
    }

    public static boolean isAssociatedWithNodeCoreLibrary(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(9);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        return NodeCoreLibraryManager.isAssociatedWithNodeCoreLibrary(psiFile.getProject(), virtualFile);
    }

    public static boolean isAssociatedWithNodeCoreLibrary(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(11);
        }
        NodeCoreLibraryManager manager2 = NodeCoreLibraryManager.getInstance(project);
        return manager2.isAssociatedWithNodeCoreLibrary(file2);
    }

    public boolean isAssociatedWithNodeCoreLibrary(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(12);
        }
        JSLibraryMappings mappings = this.getLibraryMappings();
        return mappings.isLibraryInScopeFor(file2, LIBRARY_NAME);
    }

    public boolean hasAssociatedRoots() {
        JSLibraryMappings mappings = this.getLibraryMappings();
        return !mappings.getMappingsByLibraryName(LIBRARY_NAME).isEmpty();
    }

    @NotNull
    public List<VirtualFile> getAssociatedRoots() {
        JSLibraryMappings mappings = this.getLibraryMappings();
        List list2 = mappings.getMappingsByLibraryName(LIBRARY_NAME);
        if (list2 == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private JSLibraryMappings getLibraryMappings() {
        JSLibraryMappings mappings = this.myMappings;
        if (mappings == null) {
            this.myMappings = mappings = JSLibraryMappings.getInstance(this.myProject);
        }
        JSLibraryMappings jSLibraryMappings = mappings;
        if (jSLibraryMappings == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(14);
        }
        return jSLibraryMappings;
    }

    public static boolean shouldUseNodeTypings() {
        return USE_TYPINGS.asBoolean();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listCoreModuleNames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleLibraryFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCoreLibraryFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCoreModuleFileByName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWithNodeCoreLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

