/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.frameworks.modules.JSBaseModuleReferenceContributor;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolverImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnTypesModuleReferenceContributor
extends JSBaseModuleReferenceContributor {
    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            YarnTypesModuleReferenceContributor.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    protected PsiReference @NotNull [] getReferences(@NotNull String modulePath, final @NotNull PsiElement host, int modulePathOffsetInHost, @Nullable PsiReferenceProvider provider, boolean isCommonJS) {
        if (modulePath == null) {
            YarnTypesModuleReferenceContributor.$$$reportNull$$$0(1);
        }
        if (host == null) {
            YarnTypesModuleReferenceContributor.$$$reportNull$$$0(2);
        }
        Pair<Integer, String> path2 = JSModuleReferenceContributor.getActualPath(modulePath);
        String requiredModulePath = (String)path2.second;
        if (NodeModuleSearchUtil.isFileModuleRequired(requiredModulePath) || YarnPnpManager.getInstance(host.getProject()).getPnpFiles().isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                YarnTypesModuleReferenceContributor.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final boolean isSoft = TypeScriptModuleReferenceContributor.isSoftTypeScriptRef(host, isCommonJS);
        PsiReference[] psiReferenceArray = new PsiReference[]{new TypeScriptNodeReference(host, requiredModulePath, modulePathOffsetInHost + (Integer)path2.first){

            @Override
            public boolean isSoft() {
                return isSoft;
            }

            @Override
            @Nullable
            protected ResolvedModuleInfo doResolveModule() {
                VirtualFile requester = this.getContainingFile();
                if (requester != null) {
                    String requiredModuleName = this.getRequiredModuleName();
                    if (requiredModuleName.startsWith("@")) {
                        requiredModuleName = TypeScriptFileImportsResolverImpl.Companion.convertToTypesDirectory(requiredModuleName);
                    }
                    String typings = TypeScriptDefinitionsUtils.getTypingsPackageName(requiredModuleName);
                    return NodeModuleSearchUtil.resolveYarnModule(this.getElement().getProject(), typings, this.fixRequester(requester), TS_PROCESSOR);
                }
                return null;
            }

            @NotNull
            private VirtualFile fixRequester(@NotNull VirtualFile requester) {
                ArchiveFileSystem system;
                if (requester == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((system = (ArchiveFileSystem)ObjectUtils.tryCast((Object)requester.getFileSystem(), ArchiveFileSystem.class)) == null) {
                    VirtualFile virtualFile = requester;
                    if (virtualFile == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return virtualFile;
                }
                VirtualFile localRoot = system.getLocalByEntry(requester);
                ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.getElement().getProject());
                if (localRoot != null && fileIndex.isInContent(localRoot)) {
                    VirtualFile virtualFile = localRoot;
                    if (virtualFile == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return virtualFile;
                }
                Set<VirtualFile> files = PackageJsonFileManager.getInstance(host.getProject()).getValidPackageJsonFiles();
                if (files.size() == 1) {
                    VirtualFile virtualFile = (VirtualFile)ContainerUtil.getFirstItem(files, (Object)requester);
                    if (virtualFile == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return virtualFile;
                }
                VirtualFile root = ProjectUtil.guessProjectDir((Project)this.getElement().getProject());
                VirtualFile virtualFile = (VirtualFile)ObjectUtils.coalesce((Object)root, (Object)requester);
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(4);
                }
                return virtualFile;
            }

            @Override
            protected CompletionModuleInfo @NotNull [] getModuleInfos(VirtualFile requester) {
                return new CompletionModuleInfo[0];
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "requester";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/reference/YarnTypesModuleReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/reference/YarnTypesModuleReferenceContributor$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fixRequester";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fixRequester";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }};
        if (psiReferenceArray == null) {
            YarnTypesModuleReferenceContributor.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/reference/YarnTypesModuleReferenceContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/reference/YarnTypesModuleReferenceContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

