/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.testFramework.coverage.CoverageSerializationUtils;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverageProjectDataLoader {
    private static final Logger LOG = Logger.getInstance(CoverageProjectDataLoader.class);

    @NotNull
    public static ProjectData readProjectData(@NotNull File lcovFile, @NotNull File basePath, @Nullable NodeJsInterpreter interpreter) throws IOException {
        if (lcovFile == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(0);
        }
        if (basePath == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(1);
        }
        ProjectData projectData = new ProjectData();
        LcovCoverageReport report = CoverageSerializationUtils.readLCOV(lcovFile, basePath, (Function<? super String, String>)((Function)path2 -> {
            String localPath = NodeInterpreterUtil.convertRemotePathToLocal(path2, interpreter);
            if (interpreter instanceof WslNodeInterpreter) {
                localPath = CoverageProjectDataLoader.driveLetterToUpperCase(localPath);
            }
            return localPath;
        }));
        String targetBaseDir = CoverageProjectDataLoader.dereferenceBasePath(basePath);
        for (Map.Entry<String, List<LcovCoverageReport.LineHits>> entry : report.getInfo().entrySet()) {
            String filePath = entry.getKey();
            ClassData classData = projectData.getOrCreateClassData(filePath);
            int max = 0;
            List<LcovCoverageReport.LineHits> lineHitsList = entry.getValue();
            if (lineHitsList.size() > 0) {
                LcovCoverageReport.LineHits lastLineHits = lineHitsList.get(lineHitsList.size() - 1);
                max = lastLineHits.getLineNumber();
            }
            LineData[] lines = new LineData[max + 1];
            for (LcovCoverageReport.LineHits lineHits : lineHitsList) {
                LineData lineData = new LineData(lineHits.getLineNumber(), null);
                lineData.setHits(lineHits.getHits());
                lines[lineHits.getLineNumber()] = lineData;
            }
            classData.setLines(lines);
            if (targetBaseDir == null || !filePath.startsWith(targetBaseDir)) continue;
            File fileInsideBasePath = new File(basePath, filePath.substring(targetBaseDir.length()));
            ClassData classData2 = projectData.getOrCreateClassData(fileInsideBasePath.getAbsolutePath());
            classData2.setLines(lines);
        }
        ProjectData projectData2 = projectData;
        if (projectData2 == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(2);
        }
        return projectData2;
    }

    @Nullable
    private static String dereferenceBasePath(@NotNull File file2) {
        if (file2 == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(3);
        }
        String path2 = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        try {
            File canonicalFile = file2.getCanonicalFile();
            String canonicalPath = FileUtil.toSystemIndependentName((String)canonicalFile.getAbsolutePath());
            if (!canonicalPath.equals(path2)) {
                return StringUtil.trimEnd((String)canonicalPath, (char)'/') + "/";
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to dereference " + path2, (Throwable)e);
        }
        return null;
    }

    @NotNull
    private static String driveLetterToUpperCase(@NotNull String path2) {
        if (path2 == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isWindows && FileUtil.isWindowsAbsolutePath((String)path2)) {
            String string = Character.toUpperCase(path2.charAt(0)) + path2.substring(1);
            if (string == null) {
                CoverageProjectDataLoader.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/CoverageProjectDataLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/CoverageProjectDataLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readProjectData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "driveLetterToUpperCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readProjectData";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceBasePath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "driveLetterToUpperCase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

