/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.DefaultInjectedLanguageBlockBuilder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStringInterpolationInjectedLanguageBlockBuilder
extends DefaultInjectedLanguageBlockBuilder {
    private static final Logger LOG = Logger.getInstance(JSStringInterpolationInjectedLanguageBlockBuilder.class);

    public JSStringInterpolationInjectedLanguageBlockBuilder(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JSStringInterpolationInjectedLanguageBlockBuilder.$$$reportNull$$$0(0);
        }
        super(settings);
    }

    public boolean supportsMultipleFragments() {
        return true;
    }

    protected void addInjectedLanguageBlocks(List<? super Block> result2, PsiFile injectedFile, Indent indent, int offset, TextRange injectedEditableRange, List<PsiLanguageInjectionHost.Shred> shreds) {
        PsiLanguageInjectionHost host = shreds.get(0).getHost();
        if (host == null || JSStringInterpolationInjectedLanguageBlockBuilder.isEmptyRange((ASTNode)injectedFile.getNode(), (TextRange)injectedEditableRange)) {
            return;
        }
        Language injectedLanguage = injectedFile.getLanguage();
        Block injectedBlock = this.createBlockForPsi((PsiElement)injectedFile);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)injectedFile.getProject());
        TextRange rootBlockHostRange = JSStringInterpolationInjectedLanguageBlockBuilder.shiftTextRange(injectedLanguageManager, injectedFile, injectedFile.getTextRange());
        if (rootBlockHostRange == null) {
            return;
        }
        InjectedBlock rootInjectedBlock = new InjectedBlock(injectedBlock, indent, injectedLanguage, rootBlockHostRange, injectedFile);
        result2.add((Block)rootInjectedBlock);
        List outerBlocks = ContainerUtil.map(this.getArgumentBlocks(this.createBlockForPsi((PsiElement)host).getSubBlocks()), block -> new OuterLanguageBlockWrapper((Block)block, injectedLanguage));
        for (Block block2 : outerBlocks) {
            rootInjectedBlock.addOuterChild(block2);
        }
    }

    public boolean canProcessFragment(String text, ASTNode injectionHost) {
        return true;
    }

    @NotNull
    protected abstract List<Block> getArgumentBlocks(@NotNull List<Block> var1);

    @NotNull
    private Block createBlockForPsi(@NotNull PsiElement psiElement) {
        Language childLanguage;
        FormattingModelBuilder builder;
        if (psiElement == null) {
            JSStringInterpolationInjectedLanguageBlockBuilder.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((builder = LanguageFormatting.INSTANCE.forContext(childLanguage = psiElement.getLanguage(), psiElement)) != null);
        FormattingContext formattingContext = FormattingContext.create((PsiElement)psiElement, (CodeStyleSettings)this.getSettings());
        FormattingModel childModel = builder.createModel(formattingContext);
        Block block = childModel.getRootBlock();
        if (block == null) {
            JSStringInterpolationInjectedLanguageBlockBuilder.$$$reportNull$$$0(2);
        }
        return block;
    }

    @Nullable
    private static TextRange shiftTextRange(@NotNull InjectedLanguageManager manager2, @NotNull PsiFile injectedFile, @NotNull TextRange originalRange) {
        if (manager2 == null) {
            JSStringInterpolationInjectedLanguageBlockBuilder.$$$reportNull$$$0(3);
        }
        if (injectedFile == null) {
            JSStringInterpolationInjectedLanguageBlockBuilder.$$$reportNull$$$0(4);
        }
        if (originalRange == null) {
            JSStringInterpolationInjectedLanguageBlockBuilder.$$$reportNull$$$0(5);
        }
        int startOffset = manager2.injectedToHost((PsiElement)injectedFile, originalRange.getStartOffset(), true);
        int endOffset = manager2.injectedToHost((PsiElement)injectedFile, originalRange.getEndOffset(), true);
        if (endOffset <= startOffset) {
            return null;
        }
        return new TextRange(startOffset, endOffset);
    }

    @Nullable
    private static Spacing adjustDependantSpacingIfNeeded(@NotNull InjectedLanguageManager manager2, @NotNull PsiFile injectedFile, @Nullable Spacing spacing) {
        if (manager2 == null) {
            JSStringInterpolationInjectedLanguageBlockBuilder.$$$reportNull$$$0(6);
        }
        if (injectedFile == null) {
            JSStringInterpolationInjectedLanguageBlockBuilder.$$$reportNull$$$0(7);
        }
        if (spacing instanceof DependantSpacingImpl) {
            DependantSpacingImpl hostSpacing = (DependantSpacingImpl)spacing;
            List shiftedRanges = ContainerUtil.map((Collection)hostSpacing.getDependentRegionRanges(), range -> (TextRange)ObjectUtils.coalesce((Object)JSStringInterpolationInjectedLanguageBlockBuilder.shiftTextRange(manager2, injectedFile, range), (Object)range));
            return new DependantSpacingImpl(hostSpacing.getMinSpaces(), hostSpacing.getMaxSpaces(), shiftedRanges, hostSpacing.shouldKeepLineFeeds(), hostSpacing.getKeepBlankLines(), DependentSpacingRule.DEFAULT);
        }
        return spacing;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockForPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBlockForPsi";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shiftTextRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustDependantSpacingIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OuterLanguageBlockWrapper
    extends BlockWrapper {
        @Nullable
        private final Language myLanguageForIndent;
        @Nullable
        private List<Block> myBlocks;
        @Nullable
        private OuterLanguageBlockWrapper myRightHandBlock;
        @Nullable
        Spacing myRightHandSpacing;

        private OuterLanguageBlockWrapper(@NotNull Block original, @Nullable Language indent) {
            if (original == null) {
                OuterLanguageBlockWrapper.$$$reportNull$$$0(0);
            }
            super(original);
            this.myLanguageForIndent = indent;
        }

        @Override
        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                OuterLanguageBlockWrapper.$$$reportNull$$$0(1);
            }
            return this.myOriginal.getSpacing(child1 instanceof BlockWrapper ? ((BlockWrapper)child1).myOriginal : child1, child2 instanceof BlockWrapper ? ((BlockWrapper)child2).myOriginal : child2);
        }

        @Nullable
        public Language getLanguage() {
            return this.myLanguageForIndent;
        }

        @Override
        @NotNull
        public List<Block> getSubBlocks() {
            if (this.myBlocks != null) {
                List<Block> list2 = this.myBlocks;
                if (list2 == null) {
                    OuterLanguageBlockWrapper.$$$reportNull$$$0(2);
                }
                return list2;
            }
            List blocks = this.myOriginal.getSubBlocks();
            ArrayList<Block> result2 = new ArrayList<Block>(blocks.size());
            OuterLanguageBlockWrapper prevWrapper = null;
            for (Block block : blocks) {
                OuterLanguageBlockWrapper currWrapper = new OuterLanguageBlockWrapper(block, this.myLanguageForIndent);
                result2.add((Block)currWrapper);
                if (prevWrapper != null) {
                    prevWrapper.setRightHandSpacing(currWrapper, this.myOriginal.getSpacing(prevWrapper.myOriginal, currWrapper.myOriginal));
                }
                prevWrapper = currWrapper;
            }
            this.myBlocks = result2;
            if (this.myBlocks == null) {
                OuterLanguageBlockWrapper.$$$reportNull$$$0(3);
            }
            return this.myBlocks;
        }

        public void setRightHandSpacing(@NotNull OuterLanguageBlockWrapper rightHandBlock, @Nullable Spacing rightHandSpacing) {
            if (rightHandBlock == null) {
                OuterLanguageBlockWrapper.$$$reportNull$$$0(4);
            }
            this.myRightHandBlock = rightHandBlock;
            this.myRightHandSpacing = rightHandSpacing;
        }

        @Nullable
        public Spacing getRightHandSpacing(@NotNull OuterLanguageBlockWrapper rightHandBlock) {
            if (rightHandBlock == null) {
                OuterLanguageBlockWrapper.$$$reportNull$$$0(5);
            }
            return this.myRightHandBlock == rightHandBlock ? this.myRightHandSpacing : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder$OuterLanguageBlockWrapper";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightHandBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder$OuterLanguageBlockWrapper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setRightHandSpacing";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getRightHandSpacing";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InjectedBlockFragment
    extends BlockWrapper {
        @Nullable
        private final Language myLanguage;
        @NotNull
        private final TextRange myRange;

        private InjectedBlockFragment(@NotNull Block block, @Nullable Language language, @NotNull TextRange range) {
            if (block == null) {
                InjectedBlockFragment.$$$reportNull$$$0(0);
            }
            if (range == null) {
                InjectedBlockFragment.$$$reportNull$$$0(1);
            }
            super(block);
            this.myLanguage = language;
            this.myRange = range;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                InjectedBlockFragment.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @Nullable
        public Language getLanguage() {
            return this.myLanguage;
        }

        @Override
        @NotNull
        public List<Block> getSubBlocks() {
            List list2 = AbstractBlock.EMPTY;
            if (list2 == null) {
                InjectedBlockFragment.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @Nullable
        public String getDebugName() {
            return "Fragment: {" + this.myOriginal.getDebugName() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder$InjectedBlockFragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder$InjectedBlockFragment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InjectedBlock
    extends BlockWrapper {
        @Nullable
        private final Indent myIndent;
        @Nullable
        private final Language myLanguage;
        @Nullable
        private List<Block> myBlocks;
        @NotNull
        private final TextRange myTextRange;
        @Nullable
        private List<Block> myOuterBlocks;
        @NotNull
        private final PsiFile myInjectedFile;
        @NotNull
        private final InjectedLanguageManager myInjectedLanguageManager;

        private InjectedBlock(@NotNull Block original, @Nullable Indent indent, @Nullable Language language, @NotNull TextRange textRange, @NotNull PsiFile injectedFile) {
            if (original == null) {
                InjectedBlock.$$$reportNull$$$0(0);
            }
            if (textRange == null) {
                InjectedBlock.$$$reportNull$$$0(1);
            }
            if (injectedFile == null) {
                InjectedBlock.$$$reportNull$$$0(2);
            }
            super(original);
            this.myIndent = indent;
            this.myLanguage = language;
            this.myTextRange = textRange;
            this.myInjectedFile = injectedFile;
            this.myInjectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.myInjectedFile.getProject());
        }

        @Override
        public Indent getIndent() {
            return (Indent)ObjectUtils.coalesce((Object)this.myIndent, (Object)super.getIndent());
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myTextRange;
            if (textRange == null) {
                InjectedBlock.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @Nullable
        public Language getLanguage() {
            return this.myLanguage;
        }

        @Override
        @NotNull
        public List<Block> getSubBlocks() {
            if (this.myBlocks == null) {
                this.myBlocks = this.buildBlocks();
            }
            List<Block> list2 = this.myBlocks;
            if (list2 == null) {
                InjectedBlock.$$$reportNull$$$0(4);
            }
            return list2;
        }

        public void addOuterChild(@NotNull Block block) {
            if (block == null) {
                InjectedBlock.$$$reportNull$$$0(5);
            }
            if (this.myOuterBlocks == null) {
                this.myOuterBlocks = new SmartList();
            }
            this.myOuterBlocks.add(block);
        }

        @NotNull
        private List<Block> buildBlocks() {
            List originalBlocks = this.myOriginal.getSubBlocks();
            if (originalBlocks.isEmpty()) {
                if (!ContainerUtil.isEmpty(this.myOuterBlocks)) {
                    return InjectedBlock.splitBlockIntoFragments(this, this.myOuterBlocks);
                }
                List list2 = AbstractBlock.EMPTY;
                if (list2 == null) {
                    InjectedBlock.$$$reportNull$$$0(6);
                }
                return list2;
            }
            List wrappedInjected = ContainerUtil.mapNotNull((Collection)originalBlocks, this::wrap);
            if (ContainerUtil.isEmpty(this.myOuterBlocks)) {
                return new ArrayList<Block>(wrappedInjected);
            }
            return this.mergeBlocks(wrappedInjected, ContainerUtil.filter(this.myOuterBlocks, outer -> this.myTextRange.contains(outer.getTextRange())));
        }

        @NotNull
        private List<Block> mergeBlocks(@NotNull List<InjectedBlock> injectedBlocks, @NotNull List<Block> outerBlocks) {
            if (injectedBlocks == null) {
                InjectedBlock.$$$reportNull$$$0(7);
            }
            if (outerBlocks == null) {
                InjectedBlock.$$$reportNull$$$0(8);
            }
            ArrayList<Block> result2 = new ArrayList<Block>(injectedBlocks.size());
            int injectedIndex = 0;
            int outerIndex = 0;
            while (injectedIndex < injectedBlocks.size() && outerIndex < outerBlocks.size()) {
                InjectedBlock injected = injectedBlocks.get(injectedIndex);
                TextRange injectedRange = injected.getTextRange();
                Block outer = outerBlocks.get(outerIndex);
                TextRange outerRange = outer.getTextRange();
                if (outerRange.getStartOffset() >= injectedRange.getEndOffset()) {
                    result2.add((Block)injected);
                    ++injectedIndex;
                    continue;
                }
                if (outerRange.getEndOffset() <= injectedRange.getStartOffset()) {
                    result2.add(outer);
                    ++outerIndex;
                    continue;
                }
                if (outerRange.getStartOffset() > injectedRange.getStartOffset() || outerRange.getStartOffset() == injectedRange.getStartOffset() && outerRange.getEndOffset() <= injectedRange.getEndOffset()) {
                    Block lastOuter;
                    while (outerIndex < outerBlocks.size() && injectedRange.contains(outerBlocks.get(outerIndex).getTextRange())) {
                        injected.addOuterChild(outerBlocks.get(outerIndex));
                        ++outerIndex;
                    }
                    if (outerIndex < outerBlocks.size() && injectedRange.intersectsStrict((lastOuter = outerBlocks.get(outerIndex)).getTextRange())) {
                        Pair<List<Block>, List<Block>> pair = InjectedBlock.splitBlocksByRightBound(lastOuter, injectedRange);
                        for (Block block : (List)pair.first) {
                            injected.addOuterChild(block);
                        }
                        outerBlocks.remove(outerIndex);
                        outerBlocks.addAll(outerIndex, (Collection)pair.second);
                    }
                    result2.add((Block)injected);
                    ++injectedIndex;
                    continue;
                }
                while (injectedIndex < injectedBlocks.size() && outerRange.contains(injectedRange = (injected = injectedBlocks.get(injectedIndex)).getTextRange())) {
                    ++injectedIndex;
                }
                result2.add(outer);
                ++outerIndex;
            }
            while (injectedIndex < injectedBlocks.size()) {
                result2.add((Block)injectedBlocks.get(injectedIndex));
                ++injectedIndex;
            }
            while (outerIndex < outerBlocks.size()) {
                Block outer = outerBlocks.get(outerIndex);
                if (this.myTextRange.contains(outer.getTextRange())) {
                    result2.add(outer);
                }
                ++outerIndex;
            }
            ArrayList<Block> arrayList = result2;
            if (arrayList == null) {
                InjectedBlock.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @NotNull
        static List<Block> splitBlockIntoFragments(@NotNull InjectedBlock block, @NotNull List<Block> outerBlocks) {
            if (block == null) {
                InjectedBlock.$$$reportNull$$$0(10);
            }
            if (outerBlocks == null) {
                InjectedBlock.$$$reportNull$$$0(11);
            }
            ArrayList<Block> children = new ArrayList<Block>(5);
            TextRange range = block.getTextRange();
            int childStartOffset = range.getStartOffset();
            for (Block outerBlock : outerBlocks) {
                TextRange outerBlockRange = outerBlock.getTextRange();
                if (outerBlockRange.getStartOffset() > childStartOffset) {
                    TextRange fragmentRange = new TextRange(childStartOffset, outerBlockRange.getStartOffset());
                    children.add((Block)new InjectedBlockFragment((Block)block, block.myLanguage, fragmentRange));
                }
                children.add(outerBlock);
                childStartOffset = outerBlockRange.getEndOffset();
            }
            if (range.getEndOffset() > childStartOffset) {
                TextRange textRange = new TextRange(childStartOffset, range.getEndOffset());
                children.add((Block)new InjectedBlockFragment((Block)block, block.myLanguage, textRange));
            }
            ArrayList<Block> arrayList = children;
            if (arrayList == null) {
                InjectedBlock.$$$reportNull$$$0(12);
            }
            return arrayList;
        }

        @NotNull
        public static Pair<List<Block>, List<Block>> splitBlocksByRightBound(@NotNull Block parent, @NotNull TextRange bounds) {
            List subBlocks;
            if (parent == null) {
                InjectedBlock.$$$reportNull$$$0(13);
            }
            if (bounds == null) {
                InjectedBlock.$$$reportNull$$$0(14);
            }
            if ((subBlocks = parent.getSubBlocks()).size() == 0) {
                Pair pair = Pair.create(Collections.emptyList(), Collections.emptyList());
                if (pair == null) {
                    InjectedBlock.$$$reportNull$$$0(15);
                }
                return pair;
            }
            ArrayList<Block> before = new ArrayList<Block>(subBlocks.size() / 2);
            ArrayList<Block> after = new ArrayList<Block>(subBlocks.size() / 2);
            InjectedBlock.splitByRightBoundAndCollectBlocks(subBlocks, before, after, bounds);
            return new Pair(before, after);
        }

        private static void splitByRightBoundAndCollectBlocks(@NotNull List<Block> blocks, @NotNull List<Block> before, @NotNull List<Block> after, @NotNull TextRange bounds) {
            if (blocks == null) {
                InjectedBlock.$$$reportNull$$$0(16);
            }
            if (before == null) {
                InjectedBlock.$$$reportNull$$$0(17);
            }
            if (after == null) {
                InjectedBlock.$$$reportNull$$$0(18);
            }
            if (bounds == null) {
                InjectedBlock.$$$reportNull$$$0(19);
            }
            for (Block block : blocks) {
                TextRange textRange = block.getTextRange();
                if (bounds.contains(textRange)) {
                    before.add(block);
                    continue;
                }
                if (bounds.getEndOffset() <= textRange.getStartOffset()) {
                    after.add(block);
                    continue;
                }
                InjectedBlock.splitByRightBoundAndCollectBlocks(block.getSubBlocks(), before, after, bounds);
            }
        }

        @Nullable
        private InjectedBlock wrap(@NotNull Block injected) {
            TextRange hostRange;
            if (injected == null) {
                InjectedBlock.$$$reportNull$$$0(20);
            }
            if ((hostRange = JSStringInterpolationInjectedLanguageBlockBuilder.shiftTextRange(this.myInjectedLanguageManager, this.myInjectedFile, injected.getTextRange())) == null || !this.myTextRange.contains(hostRange)) {
                return null;
            }
            return new InjectedBlock(injected, null, this.myLanguage, hostRange, this.myInjectedFile);
        }

        @Override
        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                InjectedBlock.$$$reportNull$$$0(21);
            }
            if (child1 instanceof InjectedBlock && child2 instanceof InjectedBlock) {
                Spacing spacing = this.myOriginal.getSpacing(((InjectedBlock)child1).myOriginal, ((InjectedBlock)child2).myOriginal);
                return JSStringInterpolationInjectedLanguageBlockBuilder.adjustDependantSpacingIfNeeded(this.myInjectedLanguageManager, this.myInjectedFile, spacing);
            }
            if (child1 instanceof OuterLanguageBlockWrapper && child2 instanceof OuterLanguageBlockWrapper) {
                return ((OuterLanguageBlockWrapper)child1).getRightHandSpacing((OuterLanguageBlockWrapper)child2);
            }
            return null;
        }

        @Override
        public boolean isLeaf() {
            return super.isLeaf() && ContainerUtil.isEmpty(this.myOuterBlocks);
        }

        @Override
        @Nullable
        public String getDebugName() {
            String originalDebugName = this.myOriginal.getDebugName();
            if (originalDebugName == null) {
                originalDebugName = this.myOriginal.getClass().getSimpleName();
            }
            return "wrapped " + originalDebugName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 12: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 12: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectedFile";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder$InjectedBlock";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectedBlocks";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerBlocks";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 14: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "before";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "after";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injected";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder$InjectedBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildBlocks";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mergeBlocks";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitBlockIntoFragments";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitBlocksByRightBound";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 12: 
                case 15: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addOuterChild";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeBlocks";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "splitBlockIntoFragments";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "splitBlocksByRightBound";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "splitByRightBoundAndCollectBlocks";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 12: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class BlockWrapper
    implements BlockEx,
    ASTBlock {
        @NotNull
        protected final Block myOriginal;

        protected BlockWrapper(@NotNull Block original) {
            if (original == null) {
                BlockWrapper.$$$reportNull$$$0(0);
            }
            this.myOriginal = original;
        }

        @Nullable
        public ASTNode getNode() {
            return this.myOriginal instanceof ASTBlock ? ((ASTBlock)this.myOriginal).getNode() : null;
        }

        public Indent getIndent() {
            return this.myOriginal.getIndent();
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                BlockWrapper.$$$reportNull$$$0(1);
            }
            return this.myOriginal.getSpacing(child1, child2);
        }

        @Nullable
        public Alignment getAlignment() {
            return this.myOriginal.getAlignment();
        }

        @Nullable
        public Wrap getWrap() {
            return this.myOriginal.getWrap();
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myOriginal.getTextRange();
            if (textRange == null) {
                BlockWrapper.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @NotNull
        public List<Block> getSubBlocks() {
            List list2 = this.myOriginal.getSubBlocks();
            if (list2 == null) {
                BlockWrapper.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = this.myOriginal.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                BlockWrapper.$$$reportNull$$$0(4);
            }
            return childAttributes;
        }

        public boolean isIncomplete() {
            return this.myOriginal.isIncomplete();
        }

        public boolean isLeaf() {
            return this.myOriginal.isLeaf();
        }

        public String toString() {
            return this.myOriginal.toString();
        }

        @Nullable
        public String getDebugName() {
            return this.myOriginal.getDebugName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder$BlockWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/formatter/JSStringInterpolationInjectedLanguageBlockBuilder$BlockWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

