/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.BooleanStack;
import org.jetbrains.annotations.NotNull;

public class JSFileCachedDataEvaluator
extends JSElementVisitor {
    @NotNull
    protected final JSFileCachedData myCachedData;
    private final BooleanStack mySkipChildren;
    private boolean mySkipCurrentElementChildren;

    public JSFileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(0);
        }
        this.mySkipChildren = new BooleanStack();
        this.myCachedData = outCachedData;
    }

    public void setSkipChildren() {
        this.mySkipCurrentElementChildren = true;
    }

    public boolean isSkipChildren() {
        return !this.mySkipChildren.isEmpty() && this.mySkipChildren.peek();
    }

    public void startElement(@NotNull PsiElement element) {
        if (element == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(1);
        }
        this.mySkipCurrentElementChildren = this.isSkipChildren();
        if (!this.mySkipCurrentElementChildren) {
            element.accept((PsiElementVisitor)this);
        }
        this.mySkipChildren.push(this.mySkipCurrentElementChildren);
    }

    public void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(2);
        }
        this.mySkipCurrentElementChildren = this.mySkipChildren.pop();
    }

    @Override
    public void visitJSFile(JSFile file2) {
        super.visitJSFile(file2);
        if (FlowJSAnnotation.findFlowFlagComment(file2) != null) {
            this.myCachedData.setHasFlowFlag(true);
            String name = file2.getName();
            String extension = FileUtilRt.getExtension((String)name);
            if ("mjs".equals(extension)) {
                this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
            } else if ("cjs".equals(extension)) {
                this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.COMMONJS);
            }
        }
    }

    @Override
    public void visitJSCallExpression(JSCallExpression node) {
        if (node.isRequireCall()) {
            this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker(node));
        }
    }

    @Override
    public void visitJSReferenceExpression(JSReferenceExpression node) {
        super.visitJSReferenceExpression(node);
        if (JSSymbolUtil.isExportReference(node)) {
            this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker(node));
        }
    }

    @NotNull
    private static JSModuleStatusOwner.ModuleStatus getStatusForCommonJSMarker(JSExpression element) {
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        JSModuleStatusOwner.ModuleStatus moduleStatus = (statement instanceof JSExpressionStatement || statement instanceof JSVarStatement) && statement.getParent() instanceof PsiFile ? JSModuleStatusOwner.ModuleStatus.COMMONJS : JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS;
        if (moduleStatus == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(3);
        }
        return moduleStatus;
    }

    @Override
    public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
        this.processImportExportDeclaration(importDeclaration);
        String moduleText = importDeclaration.getImportModuleText();
        if (moduleText != null) {
            this.myCachedData.addReferencedPath(moduleText);
        }
    }

    @Override
    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        this.processImportExportDeclaration(exportDeclaration);
    }

    @Override
    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    @Override
    public void visitES6ImportCall(ES6ImportCall importCall) {
        this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
        this.myCachedData.setHasES6Syntax();
    }

    @Override
    public void visitJSVariable(JSVariable node) {
        this.checkIfExportStatement(node);
    }

    @Override
    public void visitJSClass(JSClass aClass) {
        this.checkIfExportStatement(aClass);
        this.setSkipChildren();
    }

    @Override
    public void visitJSFunctionDeclaration(JSFunction node) {
        this.checkIfExportStatement(node);
        this.setSkipChildren();
    }

    @Override
    public void visitTypeScriptModule(TypeScriptModule module) {
        this.checkIfExportStatement(module);
        this.setSkipChildren();
    }

    private void checkIfExportStatement(@NotNull JSAttributeListOwner node) {
        JSAttributeList attributeList;
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(4);
        }
        if ((attributeList = node.getAttributeList()) != null && attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD) != null) {
            this.myCachedData.setHasES6Syntax();
            PsiElement scope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)node);
            if (!(scope instanceof TypeScriptModule)) {
                this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
            }
        }
    }

    protected void processImportExportDeclaration(@NotNull ES6ImportExportDeclaration declaration) {
        String path2;
        String text;
        if (declaration == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(5);
        }
        this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
        this.myCachedData.setHasES6Syntax();
        ES6FromClause clause = declaration.getFromClause();
        if (clause != null && (text = clause.getReferenceText()) != null && !StringUtil.isEmpty((String)(path2 = StringUtil.unquoteString((String)text)))) {
            this.myCachedData.addReferencedPath(path2);
        }
        this.setSkipChildren();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outCachedData";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusForCommonJSMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "finishElement";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkIfExportStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processImportExportDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

