/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSAccessibilityCheckInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSInspectionUiService;
import com.intellij.lang.javascript.inspections.JSUnresolvedVariableInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPipeExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.lang.javascript.validation.JavaScriptReferenceProblemReporter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnresolvedFunctionInspection
extends JSInspection {
    public boolean myStrictlyCheckGlobalDefinitions;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSUnresolvedFunctionInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnresolvedFunctionInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSUnresolvedFunctionInspection.$$$reportNull$$$0(2);
        }
        return new JSUnresolvedFunctionInspectionVisitor(new JavaScriptReferenceProblemReporter(holder){

            @Override
            @Nullable
            public Void registerProblem(PsiElement referenceNameElement, @Nullable TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                PsiElement parent;
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JSUnresolvedFunctionInspection.this.myStrictlyCheckGlobalDefinitions && (parent = referenceNameElement.getParent()) instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null) {
                    highlightType = ProblemHighlightType.ERROR;
                }
                return super.registerProblem(referenceNameElement, rangeWithinElement, message, highlightType, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/inspections/JSUnresolvedFunctionInspection$1", "registerProblem"));
            }
        });
    }

    public JComponent createOptionsPanel() {
        return JSInspectionUiService.getInstance().createSingleCheckboxOptionsPanel(JavaScriptBundle.message("javascript.strictly.check.global.functions", new Object[0]), (InspectionProfileEntry)this, "myStrictlyCheckGlobalDefinitions");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnresolvedFunctionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSUnresolvedFunctionInspectionVisitor
    extends JSReferenceInspectionVisitor {
        public JSUnresolvedFunctionInspectionVisitor(@NotNull JSProblemReporter<?> reporter) {
            if (reporter == null) {
                JSUnresolvedFunctionInspectionVisitor.$$$reportNull$$$0(0);
            }
            super(reporter);
        }

        @Override
        public void visitJSReferenceExpression(JSReferenceExpression node) {
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            JSCallLikeExpression callExpression = JSUnresolvedVariableInspection.getCallIfMethodExpression(node);
            if (callExpression == null) {
                return;
            }
            ResolveResult[] results = node.multiResolve(false);
            if (JSAccessibilityCheckInspection.isSymbolNotAccessible(results)) {
                return;
            }
            JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkCallReferences(node, callExpression instanceof JSNewExpression);
        }

        @Override
        public void visitJSCallExpression(JSCallExpression node) {
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            JSExpression methodExpression = node.getMethodExpression();
            if (methodExpression instanceof JSNewExpression) {
                JSAnalysisHandlersFactory.forElement((PsiElement)methodExpression).getReferenceChecker(this.myReporter).checkNewExpressionInsideCallReferences((JSNewExpression)methodExpression);
            }
        }

        @Override
        public void visitJSPipeExpression(JSPipeExpression node) {
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            JSExpression methodExpression = node.getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkCallReferences((JSReferenceExpression)methodExpression, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/lang/javascript/inspections/JSUnresolvedFunctionInspection$JSUnresolvedFunctionInspectionVisitor", "<init>"));
        }
    }
}

