/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public final class GlobPatternUtil {
    private GlobPatternUtil() {
    }

    public static boolean isFileMatchingGlobPattern(@NotNull Project project, @NotNull String pattern2, @NotNull VirtualFile file2) {
        List<VirtualFile> files;
        if (project == null) {
            GlobPatternUtil.$$$reportNull$$$0(0);
        }
        if (pattern2 == null) {
            GlobPatternUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GlobPatternUtil.$$$reportNull$$$0(2);
        }
        return (files = GlobPatternUtil.filterFilesMatchingGlobPattern(project, pattern2, Collections.singletonList(file2))).size() == 1 && file2.equals(files.get(0));
    }

    @NotNull
    public static List<VirtualFile> filterFilesMatchingGlobPattern(@NotNull Project project, @NotNull String globPattern, @NotNull List<VirtualFile> files) {
        List list2;
        if (project == null) {
            GlobPatternUtil.$$$reportNull$$$0(3);
        }
        if (globPattern == null) {
            GlobPatternUtil.$$$reportNull$$$0(4);
        }
        if (files == null) {
            GlobPatternUtil.$$$reportNull$$$0(5);
        }
        try {
            String glob = "glob:" + globPattern;
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher(glob);
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            list2 = ContainerUtil.mapNotNull(files, file2 -> {
                if (file2 != null && file2.isInLocalFileSystem() && fileIndex.isInContent(file2) && matcher.matches(Paths.get(GlobPatternUtil.getPathToMatch(project, file2), new String[0]))) {
                    return file2;
                }
                return null;
            });
        }
        catch (PatternSyntaxException ignore) {
            List<VirtualFile> list3 = Collections.emptyList();
            if (list3 == null) {
                GlobPatternUtil.$$$reportNull$$$0(7);
            }
            return list3;
        }
        if (list2 == null) {
            GlobPatternUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    private static String getPathToMatch(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            GlobPatternUtil.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            GlobPatternUtil.$$$reportNull$$$0(9);
        }
        String path2 = file2.getPath();
        String basePath = project.getBasePath();
        if (basePath != null && path2.startsWith(basePath + "/")) {
            String string = path2.substring(basePath.length() + 1);
            if (string == null) {
                GlobPatternUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file2);
        if (contentRoot != null && path2.startsWith(contentRoot.getPath() + "/")) {
            String string = path2.substring(contentRoot.getPath().length() + 1);
            if (string == null) {
                GlobPatternUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            GlobPatternUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/GlobPatternUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/GlobPatternUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFilesMatchingGlobPattern";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToMatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileMatchingGlobPattern";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterFilesMatchingGlobPattern";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPathToMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

