/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public abstract class TypedJSAnnotatingVisitor
extends JSAnnotatingVisitor {
    public TypedJSAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    protected static ASTNode findElementForAccessModifierError(@NotNull JSFunction o, JSAttributeList attributeList) {
        PsiElement accessTypeElement;
        if (o == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        if (attributeList != null && (accessTypeElement = attributeList.findAccessTypeElement()) != null) {
            return accessTypeElement.getNode();
        }
        return o.findNameIdentifier();
    }

    @Override
    public void visitJSClass(JSClass jsClass) {
        super.visitJSClass(jsClass);
        JSReferenceList extendsList = jsClass.getExtendsList();
        JSReferenceList implementsList = jsClass.getImplementsList();
        if (implementsList != null || DialectDetector.isTypeScript(jsClass)) {
            this.checkImplementedMethods(jsClass, new JSAnnotatingVisitor.SimpleErrorReportingClient());
        }
        if (extendsList != null) {
            this.checkOverriddenMethods(jsClass);
        }
    }

    @Override
    public void visitJSReferenceList(JSReferenceList referenceList) {
        boolean isImplements;
        JSClass jsClass = (JSClass)referenceList.getParent();
        if (JSResolveUtil.isArtificialClassUsedForReferenceList(jsClass)) {
            return;
        }
        boolean isExtends = jsClass.getExtendsList() == referenceList;
        boolean bl = isImplements = jsClass.getImplementsList() == referenceList;
        if (isImplements && jsClass.isInterface()) {
            this.myProblemReporter.registerGenericError((PsiElement)referenceList, JavaScriptBundle.message("javascript.validation.message.implements.for.interface.not.allowed", new Object[0]), JSFixFactory.getInstance().replaceImplementsKeywordByExtendsFix(referenceList));
            return;
        }
        HashSet<JSExpression> hasErrorExpressions = new HashSet<JSExpression>();
        HashSet<JSExpression> hasCircularErrorErrorExpressions = new HashSet<JSExpression>();
        for (JSReferenceListMember pair : referenceList.getMembers()) {
            JSExpression expr = pair.getExpression();
            Collection<JSClass> second = pair.getClasses();
            for (JSClass clazz : second) {
                if (isImplements && !hasErrorExpressions.contains(expr)) {
                    if (!this.checkImplementsRef(clazz, expr)) {
                        hasErrorExpressions.add(expr);
                    }
                } else if (isExtends && !hasErrorExpressions.contains(expr) && !this.checkExtendsRef(jsClass, clazz, expr)) {
                    hasErrorExpressions.add(expr);
                }
                if (clazz != jsClass || hasCircularErrorErrorExpressions.contains(expr)) continue;
                this.myProblemReporter.registerGenericError((PsiElement)expr, JavaScriptBundle.message("javascript.validation.message.circular.dependency", new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.circular.dependency", (PsiElement)referenceList)});
                hasCircularErrorErrorExpressions.add(expr);
            }
        }
    }

    protected boolean checkExtendsRef(JSClass jsClass, JSClass referencedClass, JSExpression expr) {
        if (referencedClass.isInterface() != jsClass.isInterface()) {
            this.myProblemReporter.registerGenericError((PsiElement)expr, JavaScriptBundle.message(jsClass.isInterface() ? "javascript.validation.message.interface.name.expected.here" : "javascript.validation.message.class.name.expected.here", new Object[0]), new IntentionAction[0]);
            return false;
        }
        return true;
    }

    protected boolean checkImplementsRef(JSClass jsClass, JSExpression expr) {
        if (!jsClass.isInterface()) {
            this.myProblemReporter.registerGenericError((PsiElement)expr, JavaScriptBundle.message("javascript.validation.message.interface.name.expected.here", new Object[0]), new IntentionAction[0]);
            return false;
        }
        return true;
    }

    protected void checkImplementedMethods(@NotNull JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        if (jsClass == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(3);
        }
    }

    protected void checkOverriddenMethods(JSClass aClass) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/TypedJSAnnotatingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForAccessModifierError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkImplementedMethods";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

