/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotationResult
extends JSLanguageServiceAnnotationResult {
    private static final int CANNOT_FIND_NAME_CODE = 2304;
    private static final String SUGGESTION = "suggestion";
    private final int myErrorCode;
    @Nullable
    private final String mySource;

    @NotNull
    public static TypeScriptLanguageServiceAnnotationResult buildAnnotation(@Nullable String fileName, @NotNull TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic) {
        String category;
        if (diagnostic == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(category = diagnostic.category))) {
            category = "error";
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo start = diagnostic.start;
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo end = diagnostic.end;
        String simpleErrorText = StringUtil.notNullize((String)diagnostic.text, (String)"error").trim();
        int newLine = simpleErrorText.indexOf("\n");
        String relatedErrors = TypeScriptLanguageServiceAnnotationResult.parseRelatedErrors(diagnostic.relatedInformation);
        String tooltip = newLine > 0 || !relatedErrors.isEmpty() ? TypeScriptLanguageServiceAnnotationResult.convertHtmlAndSpaces(simpleErrorText) + relatedErrors : null;
        return new TypeScriptLanguageServiceAnnotationResult(simpleErrorText, fileName, category, diagnostic.source, tooltip, diagnostic.code, start == null ? 0 : start.line, start == null ? 0 : start.offset, end == null ? 0 : end.line, end == null ? 0 : end.offset);
    }

    @NotNull
    private static String parseRelatedErrors(TypeScriptDiagnosticsResponse.DiagnosticRelatedInformation[] relatedInformation) {
        if (relatedInformation == null || relatedInformation.length == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder("<br />");
        for (TypeScriptDiagnosticsResponse.DiagnosticRelatedInformation information : relatedInformation) {
            String message = information.message;
            if (StringUtil.isEmpty((String)message)) continue;
            result2.append("<br />");
            TypeScriptResponseCommon.FileSpan fileSpan = information.span;
            if (fileSpan != null && fileSpan.file != null) {
                result2.append(TypeScriptLanguageServiceAnnotationResult.buildLink(fileSpan));
            }
            result2.append(TypeScriptLanguageServiceAnnotationResult.convertHtmlAndSpaces(message));
        }
        String string = result2.toString();
        if (string == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String buildLink(TypeScriptResponseCommon.FileSpan span) {
        LocalFilePath file2 = span.file;
        String path2 = file2.getPath();
        if (!StringUtil.isEmpty((String)path2) && span.start != null) {
            String fileName = new File(path2).getName();
            String uri = "#navigation_logical/" + path2 + ":" + span.start.line + ":" + span.start.offset;
            String text = fileName + "(" + span.start.line + ", " + span.start.offset + ")";
            String string = new HtmlBuilder().appendLink(uri, text).append(": ").toString();
            if (string == null) {
                TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    @NotNull
    private static String convertHtmlAndSpaces(@NotNull String fullErrorText) {
        if (fullErrorText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(3);
        }
        String text = XmlStringUtil.escapeString((String)fullErrorText);
        Object[] rows = text.split("\n");
        String string = StringUtil.join((Object[])rows, row -> {
            String withoutLeading = StringUtil.trimLeading((String)row);
            int spacesSize = row.length() - withoutLeading.length();
            return StringUtil.repeat((String)"&nbsp;", (int)spacesSize) + withoutLeading;
        }, (String)"<br>");
        if (string == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(4);
        }
        return string;
    }

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String infoText, @Nullable String fileAbsolutePath) {
        if (infoText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(5);
        }
        this(infoText, fileAbsolutePath, "info", null, null, -1, 0, 0, 0, 0);
    }

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String errorText, @Nullable String fileAbsolutePath, @Nullable String category, @Nullable String source2, @Nullable String tooltipText, int errorCode, int line, int column, int lineEnd, int columnEnd) {
        if (errorText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(6);
        }
        super(errorText, tooltipText, fileAbsolutePath, category, line, column, lineEnd, columnEnd);
        this.myErrorCode = errorCode == -1 ? TypeScriptLanguageServiceAnnotationResult.getErrorCodeImpl(errorText) : errorCode;
        this.mySource = source2;
    }

    public int getErrorCode() {
        return this.myErrorCode;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getDescription() {
        return this.getTextWithSourcePrefix(super.getDescription());
    }

    @Override
    @Nullable
    public String getTooltipText() {
        String tooltipText = super.getTooltipText();
        if (tooltipText == null) {
            return null;
        }
        return this.getTextWithSourcePrefix(tooltipText);
    }

    @NotNull
    @NlsSafe
    private String getTextWithSourcePrefix(@NotNull String text) {
        if (text == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(7);
        }
        if (this.mySource != null) {
            String string = this.mySource + ": " + text;
            if (string == null) {
                TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(8);
            }
            return string;
        }
        Object object = text.startsWith("TS") || this.myErrorCode <= 0 ? text : "TS" + this.myErrorCode + ": " + text;
        if (object == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Nullable
    public String getSource() {
        return this.mySource;
    }

    @Override
    @Nullable
    public String getCategory() {
        String category = super.getCategory();
        return SUGGESTION.equals(category) ? "hide" : category;
    }

    private static int getErrorCodeImpl(String myErrorText) {
        String prefix = "TS";
        if (myErrorText.startsWith(prefix)) {
            int endCode = myErrorText.indexOf(":");
            if (endCode == -1) {
                return -1;
            }
            String code = myErrorText.substring(prefix.length(), endCode);
            try {
                return Integer.valueOf(code.trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public ProblemHighlightType getHighlightType() {
        int code = this.getErrorCode();
        if (code != -1 && 2304 == code) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeScriptLanguageServiceAnnotationResult result2 = (TypeScriptLanguageServiceAnnotationResult)o;
        return this.myErrorCode == result2.myErrorCode && Objects.equals(this.mySource, result2.mySource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myErrorCode, this.mySource);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullErrorText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRelatedErrors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertHtmlAndSpaces";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithSourcePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotation";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertHtmlAndSpaces";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithSourcePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

