/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.modules.TypeScriptTypingsMapper;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNodeReference
extends NodeFileModulePsiReferenceBase
implements BindablePsiReference {
    public static final TypeScriptNodeModuleDirectorySearchProcessor TS_PROCESSOR = new TypeScriptNodeModuleDirectorySearchProcessor();
    public static final Function<CompletionModuleInfo, CompletionModuleInfo> MAP_COMPLETION_MODULE = info -> {
        String name = info.getName();
        if (name.startsWith("@types/")) {
            name = ES6CreateImportUtil.convertScopedTypesName(name.substring("@types/".length()));
        }
        return new CompletionModuleInfo(name, info.getVirtualFile(), info.getType()){

            @Override
            @NotNull
            public String getPresentablePath(@Nullable VirtualFile requester) {
                VirtualFile file2 = this.getVirtualFile();
                assert (file2 != null);
                String string = file2.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptNodeReference$1", "getPresentablePath"));
            }
        };
    };

    public TypeScriptNodeReference(@NotNull PsiElement literalExpression, @NotNull String requiredModuleName, int offset) {
        if (literalExpression == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(0);
        }
        if (requiredModuleName == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(1);
        }
        super(literalExpression, requiredModuleName, offset);
    }

    @Override
    @Nullable
    protected ResolvedModuleInfo doResolveModule() {
        VirtualFile requester = this.getContainingFile();
        if (requester != null) {
            String requiredModuleName = this.getRequiredModuleName();
            return this.resolveModuleInfoFromNodeModulesDir(requester, requiredModuleName);
        }
        return null;
    }

    private ResolvedModuleInfo resolveModuleInfoFromNodeModulesDir(@NotNull VirtualFile requester, @NotNull String requiredModuleName) {
        ResolvedModuleInfo info;
        if (requester == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(2);
        }
        if (requiredModuleName == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(3);
        }
        if ((info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(requester, requiredModuleName, TS_PROCESSOR)) == null) {
            info = NodeModuleSearchUtil.resolveYarnModule(this.getElement().getProject(), requiredModuleName, requester, TS_PROCESSOR);
        }
        return info;
    }

    @Override
    protected CompletionModuleInfo @NotNull [] getModuleInfos(VirtualFile requester) {
        HashMap<String, CompletionModuleInfo> modules2 = new HashMap<String, CompletionModuleInfo>();
        Project project = this.getElement().getProject();
        Condition condition = info -> {
            VirtualFile file2 = info.getVirtualFile();
            if (file2 != null) {
                VirtualFile packageJson = null;
                for (VirtualFile virtualFile : file2.getChildren()) {
                    if (TypeScriptUtil.isDefinitionFile(virtualFile)) {
                        return true;
                    }
                    if (!PackageJsonUtil.isPackageJsonFile(virtualFile)) continue;
                    packageJson = virtualFile;
                }
                if (packageJson != null) {
                    return PackageJsonData.getOrCreate(packageJson).hasTypings();
                }
            }
            return false;
        };
        Collection<CompletionModuleInfo> collection = NodeModuleSearchUtil.collectVisibleNodeModules(modules2, project, requester);
        List infos = ContainerUtil.filter(collection, (Condition)condition);
        CompletionModuleInfo[] completionModuleInfoArray = (CompletionModuleInfo[])ContainerUtil.map2Array((Collection)infos, (Object[])new CompletionModuleInfo[infos.size()], MAP_COMPLETION_MODULE);
        if (completionModuleInfoArray == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(4);
        }
        return completionModuleInfoArray;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            TypeScriptNodeReference.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requester";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/modules/TypeScriptNodeReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptNodeReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleInfoFromNodeModulesDir";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeScriptNodeModuleDirectorySearchProcessor
    extends NodeModuleDirectorySearchProcessor {
        public TypeScriptNodeModuleDirectorySearchProcessor() {
            super(TypeScriptFileImportsResolver.TS_EXTENSIONS);
        }

        public TypeScriptNodeModuleDirectorySearchProcessor(String @NotNull [] extensionsWithDot) {
            if (extensionsWithDot == null) {
                TypeScriptNodeModuleDirectorySearchProcessor.$$$reportNull$$$0(0);
            }
            super(extensionsWithDot);
        }

        @Override
        protected String findPathInPackageJson(@NotNull PackageJsonData data, @NotNull VirtualFile packageJson) {
            String extension;
            if (data == null) {
                TypeScriptNodeModuleDirectorySearchProcessor.$$$reportNull$$$0(1);
            }
            if (packageJson == null) {
                TypeScriptNodeModuleDirectorySearchProcessor.$$$reportNull$$$0(2);
            }
            if (data.hasTypings()) {
                return TypeScriptTypingsMapper.substituteTypings(data.getDefaultMain(), packageJson, data, true);
            }
            String main = data.getDefaultMain();
            if (main != null && (extension = JSFileReference.findExtension(main, TypeScriptUtil.TYPESCRIPT_EXTENSIONS)) != null) {
                return main;
            }
            return null;
        }

        @Override
        @Nullable
        public ResolvedModuleInfo loadDirectory(@Nullable VirtualFile moduleSourceRoot, @NotNull VirtualFile dir, @NotNull ModuleType type, boolean respectPackageJson) {
            ResolvedModuleInfo info;
            String main;
            VirtualFile packageJson;
            if (dir == null) {
                TypeScriptNodeModuleDirectorySearchProcessor.$$$reportNull$$$0(3);
            }
            if (type == null) {
                TypeScriptNodeModuleDirectorySearchProcessor.$$$reportNull$$$0(4);
            }
            if (moduleSourceRoot == null) {
                moduleSourceRoot = dir;
            }
            if (respectPackageJson && (packageJson = dir.findChild("package.json")) != null && (main = this.findPathInPackageJson(PackageJsonData.getOrCreate(packageJson), packageJson)) != null && (info = this.doResolveModule(moduleSourceRoot, type, dir, main = StringUtil.trimEnd((String)main, (char)'/'), true, false)) != null) {
                return info;
            }
            return this.doResolveModule(moduleSourceRoot, type, dir, "index", false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionsWithDot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptNodeReference$TypeScriptNodeModuleDirectorySearchProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPathInPackageJson";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadDirectory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

