/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClangLanguageServiceStartupActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ClangLanguageServiceStartupActivity.runStartupActivity(project);
    }

    public static void runStartupActivity(final @NotNull Project project) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(1);
        }
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            final ClangLanguageServiceProvider provider = ClangLanguageServiceProvider.getProvider(project);
            if (provider == null) {
                return;
            }
            final ClangLanguageServiceProvider[] providers = new ClangLanguageServiceProvider[]{provider};
            if (ClangUtils.isClangdOn(project)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(providers, project);
            }
            project.getMessageBus().connect().subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

                public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                    ClangLanguageService indexer;
                    ClangLanguageService service;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (ClangdBridge.isClangdOnlyMode() && (service = provider.getIfStarted()) != null) {
                        service.notifySetCDB(ClangLanguageServiceStartupActivity.getProjectRoots(project));
                    }
                    if ((indexer = provider.getIfStartedIndexer()) != null) {
                        indexer.notifySetCDB(ClangLanguageServiceStartupActivity.getProjectRoots(project));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$1", "workspaceChanged"));
                }
            });
            project.getMessageBus().connect().subscribe(ClangdSettingsListener.TOPIC, (Object)new MyClangdSettingsListener(project, providers));
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
                    for (ClangLanguageServiceProvider provider : providers) {
                        ClangLanguageService indexer;
                        if (file == null) continue;
                        ClangLanguageService service = provider.getIfStarted();
                        if (service != null) {
                            service.notifyDocumentChanged(file, event);
                        }
                        if ((indexer = provider.getIfStartedIndexer()) == null) continue;
                        indexer.notifyDocumentChanged(file, event);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$2", "documentChanged"));
                }
            }, (Disposable)project);
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                public void editorCreated(@NotNull EditorFactoryEvent event) {
                    VirtualFile file;
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument())) != null) {
                        for (ClangLanguageServiceProvider provider : providers) {
                            ClangLanguageService indexer;
                            ClangLanguageService service = provider.getIfStarted();
                            if (service != null) {
                                service.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                            }
                            if ((indexer = provider.getIfStartedIndexer()) == null) continue;
                            indexer.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                        }
                    }
                }

                public void editorReleased(@NotNull EditorFactoryEvent event) {
                    VirtualFile file;
                    if (event == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if ((file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument())) != null) {
                        for (ClangLanguageServiceProvider provider : providers) {
                            ClangLanguageService indexer;
                            ClangLanguageService service = provider.getIfStarted();
                            if (service != null) {
                                service.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                            }
                            if ((indexer = provider.getIfStartedIndexer()) == null) continue;
                            indexer.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "editorCreated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "editorReleased";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)project);
            project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                    if (events == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    for (VFileEvent vFileEvent : events) {
                        VirtualFile file;
                        VFileMoveEvent event;
                        if (vFileEvent instanceof VFileMoveEvent) {
                            event = (VFileMoveEvent)vFileEvent;
                            file = event.getFile();
                            String oldUrl = event.getOldParent().getUrl() + "/" + file.getName();
                            String newUrl = file.getUrl();
                            for (ClangLanguageServiceProvider provider : providers) {
                                ClangLanguageService indexer;
                                ClangLanguageService service = provider.getIfStarted();
                                if (service != null) {
                                    service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                                }
                                if ((indexer = provider.getIfStarted()) == null) continue;
                                indexer.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                            }
                            continue;
                        }
                        if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) {
                            event = (VFilePropertyChangeEvent)vFileEvent;
                            if (Objects.equals(event.getNewValue(), event.getOldValue())) continue;
                            String newName = (String)event.getNewValue();
                            String newUrl = event.getFile().getUrl();
                            assert (newUrl.endsWith(newName));
                            String oldName = (String)event.getOldValue();
                            String oldUrl = newUrl.substring(0, newUrl.length() - newName.length()) + oldName;
                            for (ClangLanguageServiceProvider provider : providers) {
                                ClangLanguageService indexer;
                                ClangLanguageService service = provider.getIfStarted();
                                if (service != null) {
                                    service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                                }
                                if ((indexer = provider.getIfStarted()) == null) continue;
                                indexer.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                            }
                            continue;
                        }
                        if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                        event = (VFileContentChangeEvent)vFileEvent;
                        if (!vFileEvent.isFromSave()) continue;
                        file = event.getFile();
                        for (ClangLanguageServiceProvider provider : providers) {
                            ClangLanguageService indexer;
                            ClangLanguageService service = provider.getIfStarted();
                            if (service != null) {
                                service.notifyDocumentSaved(file);
                            }
                            if ((indexer = provider.getIfStartedIndexer()) == null) continue;
                            indexer.notifyDocumentSaved(file);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$4", "after"));
                }
            });
        });
    }

    private static void initLanguageServices(ClangLanguageServiceProvider @NotNull [] providers, @NotNull Project project) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(2);
        }
        if (providers == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(3);
        }
        for (ClangLanguageServiceProvider provider : providers) {
            final ClangLanguageService service = provider.getOrStart();
            ClangLanguageService indexer = provider.getOrStartIndexer();
            ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.run(() -> {
                ClangLanguageServiceStartupActivity.openAtService(project, service);
                ClangLanguageServiceStartupActivity.openAtService(project, indexer);
            }));
            DumbService.getInstance((Project)project).runWhenSmart(() -> ReadAction.run(() -> {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                if (project.isDisposed()) {
                    return;
                }
                if (service.isActive() && ClangdBridge.isClangdOnlyMode()) {
                    service.notifySetCDB(ClangLanguageServiceStartupActivity.getProjectRoots(project));
                }
                if (indexer.isActive()) {
                    indexer.notifySetCDB(ClangLanguageServiceStartupActivity.getProjectRoots(project));
                }
            }));
            if (indexer.isDummy()) continue;
            indexer.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

                @Override
                public void onIndexingFinished(@NotNull String path) {
                    if (path == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    service.notifyLoadIndex(path);
                }

                @Override
                public void onGraphFinished(@NotNull String path) {
                    if (path == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    service.notifyLoadGraph(path);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "path";
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onIndexingFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onGraphFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static Set<VirtualFile> getProjectRoots(@NotNull Project project) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(4);
        }
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)project).getConfigurations()) {
            sources.addAll(config.getSources());
        }
        return sources;
    }

    private static void openAtService(@NotNull Project project, @NotNull ClangLanguageService service) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(5);
        }
        if (service == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(6);
        }
        if (project.isDisposed()) {
            return;
        }
        if (!service.isActive()) {
            return;
        }
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject != project || (vFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) continue;
            service.notifyDocumentOpened(vFile, new EditorOpenRequestId(editor));
        }
    }

    private static void stopLanguageServices(ClangLanguageServiceProvider @NotNull [] providers) {
        if (providers == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(7);
        }
        for (ClangLanguageServiceProvider provider : providers) {
            provider.stop();
            provider.stopIndexer();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runStartupActivity";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initLanguageServices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "openAtService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "stopLanguageServices";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyClangdSettingsListener
    implements ClangdSettingsListener {
        @NotNull
        private final Project myProject;
        private final ClangLanguageServiceProvider @NotNull [] myProviders;

        MyClangdSettingsListener(@NotNull Project project, ClangLanguageServiceProvider @NotNull [] providers) {
            if (project == null) {
                MyClangdSettingsListener.$$$reportNull$$$0(0);
            }
            if (providers == null) {
                MyClangdSettingsListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myProviders = providers;
        }

        @Override
        public void onClangdOnChanged(boolean value) {
            if (ClangUtils.isClangdOn(this.myProject)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(this.myProviders, this.myProject);
            } else {
                ClangLanguageServiceStartupActivity.stopLanguageServices(this.myProviders);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providers";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$MyClangdSettingsListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

