/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerCommandExecutor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModuleMemory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrSourceFileLocator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrAddressBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointHandler;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.jetbrains.cidr.util.events.CidrEventTracerKt;
import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrDebugProcess
extends XDebugProcess
implements DebuggerDriver.Handler,
UserDataHolderEx {
    public static final long ABORT_COMMAND_TIMEOUT = 3000L;
    public static final String BACKEND_CONTENT_ID = "DEBUGGER_BACKEND_CONSOLE";
    public static final String MEMORY_VIEW_CONTENT_ID = "DEBUGGER_MEMORY_VIEW";
    public static final Key<CidrDebugProcess> DEBUG_PROCESS_KEY = Key.create((String)CidrDebugProcess.class.getSimpleName());
    public static final Key THROW_ON_THREAD_COLLECTION = Key.create((String)"THROW_ON_THREAD_COLLECTION");
    public static final Key THROW_ON_FRAME_COLLECTION = Key.create((String)"THROW_ON_FRAME_COLLECTION");
    private final UserDataHolderBase myUserDataHolder;
    private final Disposable myProcessDisposable;
    private final CidrDebuggerCommandExecutor myDebuggerCommandExecutor;
    private final Disposable myUiDisposable;
    private final MyProcessHandler myProcessHandler;
    private final DebuggerDriver myDriverDoNotUse;
    @NlsSafe
    private final String myDriverName;
    private final DebuggerDriverConfiguration myConfiguration;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final CidrBreakpointHandler myBreakpointHandler;
    private final CidrWatchpointHandler myWatchpointHandler;
    private final CidrAddressBreakpointHandler myAddressBreakpointHandler;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final CidrExceptionBreakpointHandler myExceptionBreakpointHandler;
    @Nullable
    private final CidrSymbolicBreakpointHandler mySymbolicBreakpointHandler;
    private final Semaphore myAttachedSemaphore;
    protected final ConsoleView myConsole;
    protected boolean showConsole;
    private final List<Filter> myBackendConsoleFilters;
    private volatile LanguageConsoleView myBackendConsole;
    @Nullable
    private final MemoryViewPanel myHexdumpViewPanel;
    @NotNull
    private final CidrDebuggerModuleMemory myMemory;
    protected final RunParameters myRunParameters;
    private final ConcurrentMap<String, CidrDebuggerTypesHelperBase> myTypesHelpers;
    private final List<Couple<File>> mySymbolFiles;
    final ExecutionResult<DebuggerDriver.Inferior> myInferiorResult;
    private volatile State myState;
    @Nls
    private volatile String myCurrentStateMessage;
    private final CidrSourceFileLocator mySourceFileLocator;

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws com.intellij.execution.ExecutionException {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(0);
        }
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(1);
        }
        if (consoleBuilder == null) {
            CidrDebugProcess.$$$reportNull$$$0(2);
        }
        this(parameters, session, consoleBuilder, it -> Filter.EMPTY_ARRAY);
    }

    public CidrDebugProcess(@NotNull RunParameters parameters, final @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsoleFilterProvider backendConsoleFilterProvider) throws com.intellij.execution.ExecutionException {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(3);
        }
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(4);
        }
        if (consoleBuilder == null) {
            CidrDebugProcess.$$$reportNull$$$0(5);
        }
        if (backendConsoleFilterProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(6);
        }
        super(session);
        this.myUserDataHolder = new UserDataHolderBase();
        this.myAttachedSemaphore = new Semaphore(0);
        this.showConsole = true;
        this.myTypesHelpers = new ConcurrentHashMap<String, CidrDebuggerTypesHelperBase>();
        this.mySymbolFiles = new ArrayList<Couple<File>>();
        this.myInferiorResult = new ExecutionResult();
        this.myState = State.INITIALIZED;
        this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connecting", (Object[])new Object[0]);
        this.mySourceFileLocator = new CidrSourceFileLocator(this);
        session.setPauseActionSupported(true);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myRunParameters = parameters;
        this.myConfiguration = parameters.getDebuggerDriverConfiguration();
        this.myDriverName = this.myConfiguration.getDriverName();
        this.myProcessDisposable = Disposer.newDisposable((String)"CidrDebugProcess");
        Disposer.register((Disposable)this.getProject(), (Disposable)this.myProcessDisposable);
        this.myUiDisposable = Disposer.newDisposable();
        this.myProcessHandler = new MyProcessHandler();
        this.myDriverDoNotUse = this.myConfiguration.createDriver(this, ArchitectureType.forArchitecture((String)parameters.getArchitectureId()));
        this.myDebuggerCommandExecutor = new CidrDebuggerCommandExecutor(this, this.myDriverDoNotUse, this.myProcessDisposable);
        final BaseProcessHandler driverProcessHandler = this.myDriverDoNotUse.getProcessHandler();
        driverProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((exitCode = event.getExitCode()) == 0) {
                    return;
                }
                boolean isRemote = CidrDebugProcess.this.myConfiguration.getHostMachine().isRemote();
                if (isRemote && (exitCode == -1 || exitCode == 137)) {
                    return;
                }
                Platform platform = CidrDebugProcess.this.myConfiguration.getHostMachine().getOSType().toPlatform();
                String exitCodeStringified = ProcessTerminatedListener.stringifyExitCode((Platform)platform, (int)exitCode);
                String message = new HtmlBuilder().append(CidrDebuggerBundle.message("debug.popup.error.crashed", exitCodeStringified)).appendLink("Restart", CidrDebugProcess.this.getRestartDebuggerMessage()).toString();
                CidrDebugProcess.this.getSession().reportMessage(message, MessageType.ERROR, new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        CidrDebugProcess.this.restartDebugger(session);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$1", "processTerminated"));
            }
        });
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                driverProcessHandler.startNotify();
            }

            private boolean shouldDetach(boolean willBeDestroyed) {
                boolean detach;
                boolean bl = detach = !willBeDestroyed;
                if (detach && !(detach = CidrDebugProcess.this.isDetachDefault())) {
                    CidrDebuggerLog.LOG.error("Detaching the debug process is not supported");
                }
                return detach;
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                CidrDebugProcess.this.myAttachedSemaphore.release();
                Alarm forceTerminateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
                CidrDebugProcess.this.postCommand(driver -> {
                    try {
                        CidrDebugProcess.this.doDisconnectTarget(CidrDebugProcess.this.myInferiorResult.get(), !this.shouldDetach(willBeDestroyed));
                    }
                    finally {
                        if (forceTerminateAlarm.cancelAllRequests() > 0) {
                            CidrDebugProcess.this.myConfiguration.getHostMachine().destroyProcess(driverProcessHandler);
                        }
                    }
                    driver.checkErrors();
                });
                forceTerminateAlarm.addRequest(() -> {
                    CidrDebuggerLog.LOG.warn("Cannot detach/abort. Forcing driver termination");
                    CidrDebugProcess.this.myConfiguration.getHostMachine().destroyProcess(driverProcessHandler);
                }, 3000L, ModalityState.any());
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                CidrDebugProcess.this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
                CidrDebugProcess.this.myState = State.FINISHED;
                Disposer.dispose((Disposable)CidrDebugProcess.this.myProcessDisposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myProcessDisposable);
        this.myEditorsProvider = this.createEditorsProvider(session.getRunProfile());
        this.myBreakpointHandler = this.createBreakpointHandler();
        this.myWatchpointHandler = new CidrWatchpointHandler(this);
        this.myAddressBreakpointHandler = new CidrAddressBreakpointHandler(this);
        this.myExceptionBreakpointHandler = this.createExceptionHandler();
        this.mySymbolicBreakpointHandler = this.createSymbolicHandler();
        List handlersList = ContainerUtil.packNullables((Object[])new XBreakpointHandler[]{this.myBreakpointHandler, this.myWatchpointHandler, this.myAddressBreakpointHandler, this.myExceptionBreakpointHandler, this.mySymbolicBreakpointHandler});
        this.myBreakpointHandlers = handlersList.toArray(XBreakpointHandler.EMPTY_ARRAY);
        this.myConsole = consoleBuilder.getConsole();
        this.myBackendConsoleFilters = new SmartList((Object[])backendConsoleFilterProvider.getDefaultFilters(this.getProject()));
        this.myMemory = new CidrDebuggerModuleMemory(this, this.myUiDisposable);
        this.myHexdumpViewPanel = MemoryViewPanel.create(this.getProject(), (VirtualFile)this.myMemory.getHexdumpDoc().getVirtualFile());
        this.getSession().addSessionListener((XDebugSessionListener)new MySuspensionGutterIconManager());
    }

    protected void restartDebugger(@NotNull XDebugSession session) {
        XDebugSessionTab sessionTab;
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(7);
        }
        if ((sessionTab = ((XDebugSessionImpl)session).getSessionTab()) == null || Disposer.isDisposed((Disposable)sessionTab)) {
            return;
        }
        RunContentDescriptor runContentDescriptor = sessionTab.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            return;
        }
        JComponent component = runContentDescriptor.getComponent();
        if (component == null) {
            return;
        }
        DataContext context2 = DataManager.getInstance().getDataContext((Component)component);
        ExecutionEnvironment environment = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(context2);
        if (environment == null) {
            return;
        }
        ExecutionUtil.restart((ExecutionEnvironment)environment);
    }

    @NlsContexts.LinkLabel
    @NotNull
    protected String getRestartDebuggerMessage() {
        String string = CidrDebuggerBundle.message("debug.popup.rerun", this.getSession().getSessionName());
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getCurrentStateMessage() {
        String string = this.myCurrentStateMessage;
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            CidrDebugProcess.$$$reportNull$$$0(10);
        }
        return consoleView;
    }

    @NotNull
    private XDebuggerEditorsProvider createEditorsProvider(RunProfile profile) throws com.intellij.execution.ExecutionException {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = CidrDebuggerLanguageSupportManager.getInstance().createEditor(this.getProject(), profile);
        if (xDebuggerEditorsProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(11);
        }
        return xDebuggerEditorsProvider;
    }

    public boolean isDetachDefault() {
        return false;
    }

    public boolean supportsWatchpoints() {
        return this.myDriverDoNotUse.supportsWatchpoints();
    }

    public boolean supportsWatchpointLifetime() {
        return this.myDriverDoNotUse.supportsWatchpointLifetime();
    }

    public boolean supportsJumpToLine() {
        return !((XDebugSessionImpl)this.getSession()).isReadOnly() && this.myDriverDoNotUse.supportsJumpToLine();
    }

    @NotNull
    public Project getProject() {
        Project project = this.getSession().getProject();
        if (project == null) {
            CidrDebugProcess.$$$reportNull$$$0(12);
        }
        return project;
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        if (driver == null) {
            CidrDebugProcess.$$$reportNull$$$0(13);
        }
        if (frame == null) {
            CidrDebugProcess.$$$reportNull$$$0(14);
        }
        EvaluationContext evaluationContext = this.myConfiguration.createEvaluationContext(driver, expirable, frame.getThreadId(), frame.getFrameIndex(), frame);
        if (evaluationContext == null) {
            CidrDebugProcess.$$$reportNull$$$0(15);
        }
        return evaluationContext;
    }

    public boolean driverSupportsArrayEvaluation() {
        return this.myConfiguration.supportsArrayEvaluation();
    }

    public boolean driverSupportsCodeFragmentEvaluation() {
        return this.myConfiguration.isCodeFragmentEvaluationSupported();
    }

    public boolean driverSupportsDisasm() {
        return this.myDriverDoNotUse.supportsDisasm();
    }

    @TestOnly
    public DebuggerDriver getDriverInTests() {
        return this.myDriverDoNotUse;
    }

    @TestOnly
    public DebuggerDriver.Inferior getInferiorInTests() {
        try {
            return this.myInferiorResult.get();
        }
        catch (com.intellij.execution.ExecutionException e) {
            return null;
        }
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logStack(@NotNull XSuspendContext suspendContext, @NotNull XDebugSession session) {
        if (suspendContext == null) {
            CidrDebugProcess.$$$reportNull$$$0(16);
        }
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(17);
        }
        XExecutionStack activeExecutionStack = suspendContext.getActiveExecutionStack();
        CidrExecutionStack cidrExecutionStack = null;
        if (activeExecutionStack instanceof CidrExecutionStack) {
            cidrExecutionStack = (CidrExecutionStack)activeExecutionStack;
        }
        try {
            if (cidrExecutionStack != null) {
                cidrExecutionStack.setRequestsBatching(false);
            }
            super.logStack(suspendContext, session);
        }
        finally {
            if (cidrExecutionStack != null) {
                cidrExecutionStack.setRequestsBatching(true);
            }
        }
    }

    protected boolean waitForTermination() {
        return this.myDriverDoNotUse.getProcessHandler().waitFor();
    }

    @TestOnly
    boolean waitForAttach(int timeout) throws InterruptedException {
        return this.myAttachedSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public final void start() {
        this.myState = State.STARTING;
        this.myBackendConsole = new LanguageConsoleImpl(this.getProject(), this.myDriverName, this.myDriverDoNotUse.getConsoleLanguage());
        this.myBackendConsoleFilters.forEach(arg_0 -> ((LanguageConsoleView)this.myBackendConsole).addMessageFilter(arg_0));
        this.myBackendConsole.getConsoleEditor().getDocument().putUserData(DEBUG_PROCESS_KEY, (Object)this);
        this.myBackendConsole.setEditable(false);
        CidrDebugProcess.registerTabCompletion((Editor)this.myBackendConsole.getConsoleEditor());
        this.postCommand((DebuggerDriver driver) -> {
            DebuggerDriver.Inferior inferior;
            try {
                inferior = this.doLoadTarget(driver);
                List<Couple<File>> list = this.mySymbolFiles;
                synchronized (list) {
                    for (Couple<File> file : this.mySymbolFiles) {
                        driver.addSymbolsFile((File)file.first, (File)file.second);
                    }
                    this.mySymbolFiles.clear();
                }
                this.myState = State.STARTED;
            }
            catch (com.intellij.execution.ExecutionException e) {
                this.myInferiorResult.setException(e);
                throw e;
            }
            this.myInferiorResult.set(inferior);
        });
        for (CidrDebugProcessConfigurator configurator : (CidrDebugProcessConfigurator[])CidrDebugProcessConfigurator.EP_NAME.getExtensions()) {
            configurator.configure(this);
        }
    }

    protected static void registerTabCompletion(final Editor editor) {
        AnAction action = ActionManager.getInstance().getAction("CodeCompletion");
        if (action == null) {
            return;
        }
        EmptyAction.MyDelegatingAction wrappedAction = new EmptyAction.MyDelegatingAction(action){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.update(e);
                LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)editor);
                e.getPresentation().setEnabled(lookup == null || !lookup.isAvailableToUser());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$3", "update"));
            }
        };
        wrappedAction.registerCustomShortcutSet(9, 0, editor.getContentComponent());
    }

    @NotNull
    protected abstract DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException;

    @Nullable
    public MemoryViewPanel getHexdumpViewPanel() {
        return this.myHexdumpViewPanel;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
                if (ui == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (console == null) {
                    4.$$$reportNull$$$0(1);
                }
                Content content = ui.createContent("ConsoleContent", console.getComponent(), XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]), AllIcons.Debugger.Console, console.getPreferredFocusableComponent());
                content.setCloseable(false);
                if (CidrDebugProcess.this.showConsole) {
                    ui.addContent(content, 1, PlaceInGrid.bottom, false);
                }
                Content content2 = content;
                if (content2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                return content2;
            }

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    4.$$$reportNull$$$0(3);
                }
                Disposer.register((Disposable)ui.getContentManager(), (Disposable)CidrDebugProcess.this.myUiDisposable);
                Content backendConsoleContent = ui.createContent(CidrDebugProcess.BACKEND_CONTENT_ID, CidrDebugProcess.this.myBackendConsole.getComponent(), CidrDebugProcess.this.myDriverName, AllIcons.Debugger.Console, CidrDebugProcess.this.myBackendConsole.getPreferredFocusableComponent());
                Disposer.register((Disposable)CidrDebugProcess.this.myUiDisposable, (Disposable)CidrDebugProcess.this.myBackendConsole);
                backendConsoleContent.setCloseable(false);
                this.addContent(ui, backendConsoleContent);
                for (BackendConsoleInjectionHelper helper : (BackendConsoleInjectionHelper[])BackendConsoleInjectionHelper.EP_NAME.getExtensions()) {
                    helper.subscribeToInjection(CidrDebugProcess.this.getSession());
                }
                LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)CidrDebugProcess.this.myBackendConsole, text -> CidrDebugProcess.this.executeConsoleCommand((String)text), (String)"AppCode.Debug.Console", null, null);
                if (CidrDebugProcess.this.myHexdumpViewPanel != null) {
                    Content memoryViewContent = ui.createContent(CidrDebugProcess.MEMORY_VIEW_CONTENT_ID, CidrDebugProcess.this.myHexdumpViewPanel.getComponent(), CidrDebuggerBundle.message("debug.memory.view.process", new Object[0]), null, CidrDebugProcess.this.myHexdumpViewPanel.getPreferredFocusableComponent());
                    Disposer.register((Disposable)CidrDebugProcess.this.myUiDisposable, (Disposable)CidrDebugProcess.this.myHexdumpViewPanel);
                    memoryViewContent.setCloseable(false);
                    this.addContent(ui, memoryViewContent);
                }
                CidrDebugProcess.this.getSession().addSessionListener(new XDebugSessionListener(){
                    private CidrEventSpan myStateSpan;

                    public void sessionPaused() {
                        this.traceState(null);
                        CidrEventTracerKt.traceMarker((String)"debug", (String)"session paused", null);
                        this.enableConsole(true);
                    }

                    public void sessionResumed() {
                        CidrEventTracerKt.traceMarker((String)"debug", (String)"session resumed");
                        this.traceState(new CidrEventSpan("debug", "session running", null, "<DebugSession>"));
                        this.enableConsole(false);
                    }

                    public void sessionStopped() {
                        this.traceState(null);
                        CidrEventTracerKt.traceMarker((String)"debug", (String)"sessionStopped", null);
                        this.enableConsole(false);
                    }

                    private void enableConsole(boolean enabled) {
                        if (CidrDebugProcess.this.getProject().isDisposed() || Disposer.isDisposed((Disposable)CidrDebugProcess.this.myBackendConsole)) {
                            return;
                        }
                        CidrDebugProcess.this.myBackendConsole.setEditable(enabled);
                    }

                    private void traceState(@Nullable CidrEventSpan eventSpan) {
                        if (this.myStateSpan != null) {
                            this.myStateSpan.close();
                        }
                        this.myStateSpan = eventSpan;
                    }
                });
            }

            private void addContent(@NotNull RunnerLayoutUi ui, Content content) {
                boolean newDebugWindowView;
                if (ui == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (newDebugWindowView = Registry.is((String)"debugger.new.debug.tool.window.view")) {
                    ui.addContent(content);
                } else {
                    ui.addContent(content, 0, PlaceInGrid.center, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ui";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "registerConsoleContent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "registerConsoleContent";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "registerAdditionalContent";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "addContent";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public boolean checkCanPerformCommands() {
        if (this.myDriverDoNotUse.isInPromptMode()) {
            this.getSession().reportMessage(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]), MessageType.WARNING);
            RunnerLayoutUi ui = this.getSession().getUI();
            Content gdbContent = ui.findContent(BACKEND_CONTENT_ID);
            ui.selectAndFocus(gdbContent, true, true);
            return false;
        }
        return true;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.myEditorsProvider;
        if (xDebuggerEditorsProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(18);
        }
        return xDebuggerEditorsProvider;
    }

    @NotNull
    protected CidrBreakpointHandler createBreakpointHandler() {
        return new CidrBreakpointHandler(this);
    }

    @NotNull
    protected CidrExceptionBreakpointHandler createExceptionHandler() {
        return new CidrExceptionBreakpointHandler(this, (Class<? extends CidrExceptionBreakpointType>)CidrExceptionBreakpointType.class);
    }

    @Nullable
    private CidrSymbolicBreakpointHandler createSymbolicHandler() {
        CidrSymbolicBreakpointType symbolicBreakpointType = (CidrSymbolicBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class));
        return symbolicBreakpointType != null ? new CidrSymbolicBreakpointHandler(this, (Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>>)((Object)((Object)symbolicBreakpointType)).getClass()) : null;
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            CidrDebugProcess.$$$reportNull$$$0(19);
        }
        return this.myBreakpointHandlers;
    }

    @NotNull
    public ConsoleView createConsole() {
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            CidrDebugProcess.$$$reportNull$$$0(20);
        }
        return consoleView;
    }

    public LanguageConsoleView getDebuggerConsole() {
        return this.myBackendConsole;
    }

    public void sessionInitialized() {
        this.postCommand((DebuggerDriver driver) -> {
            if (this.myState != State.STARTED) {
                return;
            }
            this.doStartTarget(this.myInferiorResult.get());
            this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
            this.getSession().rebuildViews();
        });
    }

    protected long doStartTarget(@NotNull DebuggerDriver.Inferior inferior) throws com.intellij.execution.ExecutionException {
        if (inferior == null) {
            CidrDebugProcess.$$$reportNull$$$0(21);
        }
        return inferior.start();
    }

    protected void doDisconnectTarget(@NotNull DebuggerDriver.Inferior inferior, boolean shouldDestroy) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (inferior == null) {
            CidrDebugProcess.$$$reportNull$$$0(22);
        }
        if (shouldDestroy) {
            inferior.destroy();
        } else {
            inferior.detach();
        }
    }

    public void stop() {
        ModalityUiUtil.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            this.myWatchpointHandler.cleanup();
            this.myAddressBreakpointHandler.cleanup();
        }, (ModalityState)ModalityState.defaultModalityState());
        this.getProcessHandler().destroyProcess();
    }

    public void startPausing() {
        this.postCommand(DebuggerDriver::interrupt);
    }

    public void resume(@Nullable XSuspendContext context2) {
        this.postCommand(DebuggerDriver::resume);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context2) {
        if (position == null) {
            CidrDebugProcess.$$$reportNull$$$0(23);
        }
        Address address = this.positionToAddress(position);
        this.postCommand((DebuggerDriver driver) -> {
            if (address != null) {
                driver.runTo(address);
            } else {
                driver.runTo(position.getFile().getPath(), position.getLine());
            }
        });
    }

    public boolean jumpToLine(@NotNull LLThread thread, @NotNull VirtualFile file, int line) {
        XSuspendContext context2;
        if (thread == null) {
            CidrDebugProcess.$$$reportNull$$$0(24);
        }
        if (file == null) {
            CidrDebugProcess.$$$reportNull$$$0(25);
        }
        if ((context2 = this.getSession().getSuspendContext()) == null) {
            return false;
        }
        this.jumpToLineImpl(thread, file, line, false, context2).thenAccept(askToRetry -> {
            if (!askToRetry.booleanValue()) {
                return;
            }
            ModalityUiUtil.invokeLaterIfNeeded(() -> {
                MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"", (String)CidrDebuggerBundle.message("debug.jumpToLine.warning", new Object[0])).icon(Messages.getWarningIcon());
                if (yesNo.ask(this.getProject())) {
                    XSuspendContext newContext = this.getSession().getSuspendContext();
                    if (newContext == null) {
                        return;
                    }
                    this.jumpToLineImpl(thread, file, line, true, newContext);
                }
            }, (ModalityState)ModalityState.defaultModalityState());
        });
        return true;
    }

    @NotNull
    private CompletableFuture<Boolean> jumpToLineImpl(@NotNull LLThread thread, @NotNull VirtualFile file, int line, boolean canLeaveFunction, @NotNull XSuspendContext context2) {
        Address address;
        if (thread == null) {
            CidrDebugProcess.$$$reportNull$$$0(26);
        }
        if (file == null) {
            CidrDebugProcess.$$$reportNull$$$0(27);
        }
        if (context2 == null) {
            CidrDebugProcess.$$$reportNull$$$0(28);
        }
        String path = file.getPath();
        XSourcePosition position = XDebuggerUtil.getInstance().createPosition(file, line);
        Address address2 = address = position != null ? this.positionToAddress(position) : null;
        if (this.fileToMemoryDoc(file) != null && address == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                CidrDebugProcess.$$$reportNull$$$0(29);
            }
            return completableFuture;
        }
        this.handleRunning();
        CompletionStage completionStage = this.postCommand((DebuggerDriver driver) -> {
            try {
                if (address != null) {
                    return driver.jumpToAddress(thread, address, canLeaveFunction);
                }
                return driver.jumpToLine(thread, path, line, canLeaveFunction);
            }
            catch (DebuggerDriver.JumpToLineOutsideCurrentFunctionException ignored) {
                return null;
            }
            catch (DebuggerCommandException ex) {
                String message = StringUtil.escapeXmlEntities((String)ex.getMessage());
                this.getSession().reportMessage(message, MessageType.ERROR);
                throw ex;
            }
        }).handle((stopPlace, ex) -> {
            boolean askToRetry = false;
            if (ex != null) {
                this.getSession().positionReached(context2);
            } else if (stopPlace == null) {
                this.getSession().positionReached(context2);
                askToRetry = true;
            } else {
                this.handleInterrupted((DebuggerDriver.StopPlace)stopPlace);
            }
            return askToRetry;
        });
        if (completionStage == null) {
            CidrDebugProcess.$$$reportNull$$$0(30);
        }
        return completionStage;
    }

    @Nullable
    private Address positionToAddress(@NotNull XSourcePosition position) {
        CidrMemoryDoc<?> memoryDoc;
        if (position == null) {
            CidrDebugProcess.$$$reportNull$$$0(31);
        }
        return (memoryDoc = this.fileToMemoryDoc(position.getFile())) == null ? null : memoryDoc.getAddress(position);
    }

    @Nullable
    public CidrMemoryDoc<?> fileToMemoryDoc(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CidrDebugProcess.$$$reportNull$$$0(32);
        }
        if (!(virtualFile instanceof MemoryViewFile)) {
            return null;
        }
        MemoryViewFile memoryViewFile = (MemoryViewFile)virtualFile;
        CidrMemoryDoc<?> memoryDoc = memoryViewFile.getMemoryDoc();
        if (memoryDoc != null && !this.myMemory.contains(memoryDoc)) {
            return null;
        }
        return memoryDoc;
    }

    private static boolean isDisassemblyContext(@Nullable XSuspendContext context2) {
        if (context2 == null) {
            return false;
        }
        XExecutionStack stack = context2.getActiveExecutionStack();
        if (stack == null) {
            return false;
        }
        XStackFrame frame = stack.getTopFrame();
        if (!(frame instanceof CidrStackFrame)) {
            return false;
        }
        return !((CidrStackFrame)frame).hasSourceFile();
    }

    public void startStepOver(@Nullable XSuspendContext context2) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context2);
        this.postCommand((DebuggerDriver driver) -> driver.stepOver(stepByInstruction));
    }

    public void startStepInto(@Nullable XSuspendContext context2) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context2);
        this.postCommand((DebuggerDriver driver) -> driver.stepInto(false, stepByInstruction));
    }

    public void startForceStepInto(@Nullable XSuspendContext context2) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context2);
        this.postCommand((DebuggerDriver driver) -> driver.stepInto(true, stepByInstruction));
    }

    public void startStepOut(@Nullable XSuspendContext context2) {
        this.postCommand(DebuggerDriver::stepOut);
    }

    @NotNull
    public Pair<XSourcePosition, Boolean> createSourceOrDisasmPosition(@Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, @NotNull Address pc) {
        XSourcePosition sourcePosition;
        if (pc == null) {
            CidrDebugProcess.$$$reportNull$$$0(33);
        }
        if (file != null && (sourcePosition = this.createSourcePosition(file, hash, line)) != null) {
            Pair pair = Pair.create((Object)sourcePosition, (Object)true);
            if (pair == null) {
                CidrDebugProcess.$$$reportNull$$$0(34);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)this.createDisasmPosition(pc), (Object)false);
        if (pair == null) {
            CidrDebugProcess.$$$reportNull$$$0(35);
        }
        return pair;
    }

    @Nullable
    public XSourcePosition createSourcePosition(@NotNull String file, @Nullable DebuggerSourceFileHash hash, int line) {
        if (file == null) {
            CidrDebugProcess.$$$reportNull$$$0(36);
        }
        try {
            VirtualFile resolvedFile = this.resolveFile(file, hash);
            return resolvedFile != null ? XDebuggerUtil.getInstance().createPosition(resolvedFile, line) : null;
        }
        catch (ProcessCanceledException ignore) {
            return null;
        }
    }

    @Nullable
    public VirtualFile resolveFile(@NotNull String file, @Nullable DebuggerSourceFileHash hash) {
        if (file == null) {
            CidrDebugProcess.$$$reportNull$$$0(37);
        }
        return (VirtualFile)ReadAction.compute(() -> {
            VirtualFile vFile = this.mySourceFileLocator.locate(file, hash);
            if (vFile == null) {
                return null;
            }
            VirtualFile resolvedFile = ProjectRootUtil.findSymlinkedFileInContent((Project)this.getProject(), (VirtualFile)vFile);
            if (CidrDebuggerLog.LOG.isTraceEnabled() && !vFile.equals(resolvedFile)) {
                CidrDebuggerLog.LOG.trace("Debugger path resolved: " + vFile + " -> " + resolvedFile);
            }
            return resolvedFile;
        });
    }

    @Nullable
    public XSourcePosition createDisasmPosition(@NotNull Address address) {
        if (address == null) {
            CidrDebugProcess.$$$reportNull$$$0(38);
        }
        if (!this.driverSupportsDisasm()) {
            return null;
        }
        return this.myMemory.getDisasmDoc().getAddressPosition(address);
    }

    protected void executeConsoleCommand(@NotNull String text) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(39);
        }
        long threadId = this.getCurrentThreadId();
        int frameIndex = this.getCurrentFrameIndex();
        this.postCommand((DebuggerDriver driver) -> {
            try {
                driver.executeConsoleCommand(threadId, frameIndex, text);
            }
            catch (DebuggerCommandException e) {
                this.printlnToConsole(e.getMessage());
            }
        });
    }

    @NotNull
    public CompletableFuture<Void> postCommand(@NotNull VoidDebuggerCommand command) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(40);
        }
        CompletableFuture<Void> completableFuture = this.postCommand((DebuggerCommand)command);
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(41);
        }
        return completableFuture;
    }

    @NotNull
    public <T> CompletableFuture<T> postCommand(@NotNull DebuggerCommand<T> command) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(42);
        }
        CompletableFuture<T> completableFuture = this.myDebuggerCommandExecutor.executeCommandAsync(command, command.canExecuteWhileRunning());
        if (completableFuture == null) {
            CidrDebugProcess.$$$reportNull$$$0(43);
        }
        return completableFuture;
    }

    @NotNull
    public CidrDebuggerCommandExecutor getDebuggerCommandExecutor() {
        CidrDebuggerCommandExecutor cidrDebuggerCommandExecutor = this.myDebuggerCommandExecutor;
        if (cidrDebuggerCommandExecutor == null) {
            CidrDebugProcess.$$$reportNull$$$0(44);
        }
        return cidrDebuggerCommandExecutor;
    }

    public void completeConsoleCommand(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(45);
        }
        if (result2 == null) {
            CidrDebugProcess.$$$reportNull$$$0(46);
        }
        String command = parameters.getOriginalFile().getText();
        int offset = parameters.getOffset();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        DebuggerDriver.ResultList<String> completions = this.completeConsoleCommand(command, offset, progressIndicator);
        if (!completions.list.isEmpty()) {
            if (completions.hasMore && completions.list.size() > 1) {
                result2.addLookupAdvertisement(CidrDebuggerBundle.message("debug.console.completions.tooManyCompletions", completions.list.size()));
            }
            result2.addAllElements((Iterable)ContainerUtil.map(completions.list, lookupString -> LookupElementBuilder.create((String)(lookupString + " "))));
        }
    }

    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int offset, @NotNull ProgressIndicator progressIndicator) {
        DebuggerDriver.ResultList resultList;
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(47);
        }
        if (progressIndicator == null) {
            CidrDebugProcess.$$$reportNull$$$0(48);
        }
        CompletableFuture completionFuture = this.postCommand((DebuggerDriver driver) -> {
            if (driver.isInPromptMode()) {
                return DebuggerDriver.ResultList.empty();
            }
            return driver.completeConsoleCommand(command, offset);
        });
        try {
            resultList = (DebuggerDriver.ResultList)ApplicationUtil.runWithCheckCanceled(completionFuture, (ProgressIndicator)progressIndicator);
        }
        catch (ExecutionException e) {
            DebuggerDriver.ResultList<String> resultList2 = DebuggerDriver.ResultList.empty();
            if (resultList2 == null) {
                CidrDebugProcess.$$$reportNull$$$0(50);
            }
            return resultList2;
        }
        if (resultList == null) {
            CidrDebugProcess.$$$reportNull$$$0(49);
        }
        return resultList;
    }

    @Nullable
    public PsiElement getDebuggerContext() {
        return this.getDebuggerContext(this.getCurrentPosition());
    }

    @Nullable
    public PsiElement getDebuggerContext(@Nullable XSourcePosition position) {
        if (position == null) {
            return null;
        }
        return (PsiElement)ReadAction.compute(() -> {
            CidrDebuggerTypesHelperBase typesHelper = this.getTypesHelper(position);
            if (!(typesHelper instanceof CidrDebuggerTypesHelper)) {
                return null;
            }
            return ((CidrDebuggerTypesHelper)typesHelper).getContextElement(position);
        });
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(51);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(52);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(53);
        }
        if (value == null) {
            CidrDebugProcess.$$$reportNull$$$0(54);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            CidrDebugProcess.$$$reportNull$$$0(55);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(56);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebuggerTypesHelperBase getTypesHelper(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            CidrDebugProcess.$$$reportNull$$$0(57);
        }
        return this.getTypesHelper(CidrDebuggerLanguageSupportManager.getInstance().getLanguage(frame));
    }

    @NotNull
    public CidrDebuggerTypesHelperBase getTypesHelper(@NotNull XSourcePosition position) {
        if (position == null) {
            CidrDebugProcess.$$$reportNull$$$0(58);
        }
        return this.getTypesHelper(CidrDebuggerLanguageSupportManager.getInstance().getLanguage(position));
    }

    @NotNull
    private CidrDebuggerTypesHelperBase getTypesHelper(@Nullable Language language) {
        Language key = language == null ? Language.ANY : language;
        CidrDebuggerTypesHelperBase cidrDebuggerTypesHelperBase = this.myTypesHelpers.computeIfAbsent(key.getID(), langId -> CidrDebuggerLanguageSupportManager.getInstance().createTypesHelper(language, this));
        if (cidrDebuggerTypesHelperBase == null) {
            CidrDebugProcess.$$$reportNull$$$0(59);
        }
        return cidrDebuggerTypesHelperBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbolsFile(File dSYM, File module) {
        CidrDebuggerLog.LOG.assertTrue(this.myState == State.INITIALIZED, (Object)("Session is already started: " + this.myState));
        List<Couple<File>> list = this.mySymbolFiles;
        synchronized (list) {
            this.mySymbolFiles.add((Couple<File>)Couple.of((Object)dSYM, (Object)module));
        }
    }

    @NotNull
    public RunParameters getRunParameters() {
        RunParameters runParameters = this.myRunParameters;
        if (runParameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(60);
        }
        return runParameters;
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull DebuggerCommand<?> command, @NotNull com.intellij.execution.ExecutionException exception) {
        DebuggerIllegalStateException illegalState;
        if (driver == null) {
            CidrDebugProcess.$$$reportNull$$$0(61);
        }
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(62);
        }
        if (exception == null) {
            CidrDebugProcess.$$$reportNull$$$0(63);
        }
        if ((illegalState = (DebuggerIllegalStateException)((Object)ExceptionUtil.findCause((Throwable)exception, DebuggerIllegalStateException.class))) != null) {
            CidrDebuggerLog.LOG.info((Throwable)exception);
            String message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)illegalState));
            if (!(command instanceof DebuggerUIUpdateCommand)) {
                this.getSession().reportMessage(message, MessageType.WARNING);
            }
            return;
        }
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class)) {
            if (!ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                CidrDebuggerLog.LOG.debug((Throwable)exception);
            }
            this.getSession().stop();
            return;
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DebuggerFatalException.class);
        if (command instanceof DebuggerStartupCommand || isFatalError) {
            CidrDebuggerLog.LOG.debug((Throwable)exception);
            this.printlnToConsole(exception.getMessage());
            if (!this.reportEvaluationTimeOutError(exception)) {
                this.reportErrorInRedBalloon(exception);
            }
            if (isFatalError) {
                driver.getProcessHandler().destroyProcess();
            } else {
                this.getSession().stop();
            }
            return;
        }
        if (!(exception instanceof ThrowInTest.TestException)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                CidrDebuggerLog.LOG.warn((Throwable)exception);
            } else {
                CidrDebuggerLog.LOG.error((Throwable)exception);
            }
        }
    }

    private void reportErrorInRedBalloon(com.intellij.execution.ExecutionException e) {
        DebuggerCommandException dce = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
        String message = (dce != null ? dce : e).getMessage();
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            CidrDebuggerLog.LOG.error("Execution errors must have error description", (Throwable)e);
            message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e));
        }
        this.getSession().reportMessage(message, MessageType.ERROR, (HyperlinkListener)ExceptionUtil.findCause((Throwable)e, HyperlinkListener.class));
    }

    private boolean reportEvaluationTimeOutError(@NotNull com.intellij.execution.ExecutionException e) {
        DebuggerEvaluationTimedOutException evaluationTimedOutException;
        if (e == null) {
            CidrDebugProcess.$$$reportNull$$$0(64);
        }
        if ((evaluationTimedOutException = (DebuggerEvaluationTimedOutException)((Object)ExceptionUtil.findCause((Throwable)e, DebuggerEvaluationTimedOutException.class))) == null) {
            return false;
        }
        String message = CidrDebuggerBundle.message("debug.command.error.evaluationTimedOut", evaluationTimedOutException.getExpression(), CidrDebuggerBundle.message("debug.settings.enableValueRenderers.action", new Object[0]));
        this.getSession().reportMessage(message, MessageType.ERROR, eventType -> {
            if (eventType.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                CidrDebuggerSettings.getInstance().RENDERERS_ENABLED = false;
            }
        });
        return true;
    }

    public void printlnToConsole(@Nullable String message) {
        if (message != null && !this.getProject().isDisposed()) {
            if (!StringUtil.endsWithLineBreak((CharSequence)(message = StringUtil.stripHtml((String)message, (boolean)true)))) {
                message = (String)message + "\n";
            }
            this.getProcessHandler().notifyTextAvailable((String)message, ProcessOutputTypes.SYSTEM);
        }
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame != null ? frame.getSourcePosition() : null;
    }

    public long getCurrentThreadId() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getThreadId() : -1L;
    }

    public int getCurrentFrameIndex() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getFrameIndex() : -1;
    }

    @Override
    public void handleRunning() {
        this.getSession().sessionResumed();
    }

    @Override
    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(65);
        }
        this.getSession().positionReached((XSuspendContext)new CidrSuspendContext(stopPlace, null));
    }

    @Override
    public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(66);
        }
        if (signal == null) {
            CidrDebugProcess.$$$reportNull$$$0(67);
        }
        if (meaning == null) {
            CidrDebugProcess.$$$reportNull$$$0(68);
        }
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause(CidrDebuggerBundle.message("debug.signal.suspension.cause", new Object[0]), signal + " (" + meaning + ")", stopPlace.frame.getFile(), stopPlace.frame.getHash(), stopPlace.frame.getLine(), stopPlace.frame.getProgramCounter()));
    }

    @Override
    public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(69);
        }
        if (exceptionAddress == null) {
            CidrDebugProcess.$$$reportNull$$$0(70);
        }
        if (description == null) {
            CidrDebugProcess.$$$reportNull$$$0(71);
        }
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause(CidrDebuggerBundle.message("debug.signal.exception.cause", new Object[0]), description, exceptionFile, exceptionHash, exceptionLine, exceptionAddress));
    }

    private void doHandleSignalled(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull CidrSuspensionCause cause) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(72);
        }
        if (cause == null) {
            CidrDebugProcess.$$$reportNull$$$0(73);
        }
        this.printlnToConsole(cause.getDisplayString());
        ((XDebugSessionImpl)this.getSession()).positionReached((XSuspendContext)new CidrSuspendContext(stopPlace, cause), true);
    }

    @Override
    public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
        Object b;
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(74);
        }
        if ((b = this.myBreakpointHandler.getCodepoint(breakpointNumber)) == null) {
            b = this.myAddressBreakpointHandler.getCodepoint(breakpointNumber);
        }
        if (b == null) {
            b = this.myExceptionBreakpointHandler.getCodepoint(breakpointNumber);
        }
        if (b == null && this.mySymbolicBreakpointHandler != null) {
            b = this.mySymbolicBreakpointHandler.getCodepoint(breakpointNumber);
        }
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleWatchpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int watchpointNumber) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(75);
        }
        Object b = this.myWatchpointHandler.getCodepoint(watchpointNumber);
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleAttached(int pid) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.attachedTo", pid));
        this.myAttachedSemaphore.release();
    }

    @Override
    public void handleConnected(@NotNull String connection) {
        if (connection == null) {
            CidrDebugProcess.$$$reportNull$$$0(76);
        }
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.connectedTo", connection));
    }

    @Override
    public void handleDetached() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.detached", new Object[0]));
        this.getSession().stop();
    }

    @Override
    public void handleDisconnected() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.disconnected", new Object[0]));
        this.getSession().stop();
    }

    protected void handleCodepoint(@NotNull DebuggerDriver.StopPlace stopPlace, @Nullable XBreakpoint<?> b) {
        XBreakpointProperties props;
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(77);
        }
        CidrSuspensionCause cause = null;
        XBreakpointProperties xBreakpointProperties = props = b != null ? b.getProperties() : null;
        if (props instanceof CidrExceptionBreakpointType.Properties) {
            cause = new CidrSuspensionCause(CidrDebuggerBundle.message("debug.signal.exception.cause", new Object[0]), "Exception breakpoint", stopPlace.frame.getFile(), stopPlace.frame.getHash(), stopPlace.frame.getLine(), stopPlace.frame.getProgramCounter());
        }
        CidrSuspendContext suspendContext = new CidrSuspendContext(stopPlace, cause);
        if (b == null) {
            ((XDebugSessionImpl)this.getSession()).positionReached((XSuspendContext)suspendContext, true);
            return;
        }
        XExpression expressionObject = b.getLogExpressionObject();
        if (expressionObject == null) {
            boolean shouldSuspend = this.getSession().breakpointReached(b, null, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(DebuggerDriver::resume);
            }
            return;
        }
        String expression = expressionObject.getExpression();
        this.postCommand((DebuggerDriver driver) -> {
            String evaluatedLogExpression;
            XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
            XStackFrame frame = executionStack != null ? executionStack.getTopFrame() : null;
            XSourcePosition sourcePosition = frame != null ? frame.getSourcePosition() : null;
            CidrEvaluator evaluator = (CidrEvaluator)(frame != null ? frame.getEvaluator() : null);
            if (evaluator != null) {
                try {
                    CidrEvaluatedValue evaluatedValue = evaluator.doEvaluate(driver, sourcePosition, (XExpression)XExpressionImpl.fromText((String)expression));
                    evaluatedLogExpression = expression + " = " + evaluatedValue.getConsoleDescription(evaluatedValue.createEvaluationContext(driver, null));
                }
                catch (DebuggerCommandException e) {
                    evaluatedLogExpression = "error evaluating " + expression + ": " + e.getMessage();
                }
            } else {
                evaluatedLogExpression = "error evaluating " + expression;
            }
            return evaluatedLogExpression;
        }).whenComplete((evaluatedLogExpression, e) -> {
            Object expressionString = null;
            if (evaluatedLogExpression != null) {
                expressionString = evaluatedLogExpression;
            } else if (e != null) {
                expressionString = "error evaluating " + expression + ": " + e.getMessage();
            }
            boolean shouldSuspend = this.getSession().breakpointReached(b, (String)expressionString, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(DebuggerDriver::resume);
            }
        });
    }

    @Override
    public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(78);
        }
        if (type == null) {
            CidrDebugProcess.$$$reportNull$$$0(79);
        }
        this.myProcessHandler.notifyTextAvailable(text, type);
    }

    @Override
    public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(80);
        }
        if (type == null) {
            CidrDebugProcess.$$$reportNull$$$0(81);
        }
        ConsoleViewContentType contentType = ProcessOutputType.isStdout((Key)type) ? ConsoleViewContentType.NORMAL_OUTPUT : (ProcessOutputType.isStderr((Key)type) ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.SYSTEM_OUTPUT);
        ModalityUiUtil.invokeLaterIfNeeded(() -> this.myBackendConsole.print(text, contentType), (ModalityState)ModalityState.any());
    }

    @Override
    public void handlePrompt(@NotNull String prompt) {
        if (prompt == null) {
            CidrDebugProcess.$$$reportNull$$$0(82);
        }
        LanguageConsoleView backendConsole = this.getDebuggerConsole();
        if (this.getProject().isDisposed() || backendConsole == null || Disposer.isDisposed((Disposable)backendConsole)) {
            return;
        }
        backendConsole.setPrompt(prompt);
    }

    @Override
    public void handleTargetFinished(int code, @Nullable String description) {
        this.myProcessHandler.setExitCode(code);
        if (description != null) {
            this.myProcessHandler.notifyTextAvailable(description + "\n", ProcessOutputTypes.SYSTEM);
        }
        this.getSession().stop();
    }

    @Override
    public void handleTargetTerminated() {
        this.getSession().stop();
    }

    @Override
    public void handleExited(int code) {
        this.getSession().stop();
    }

    @Override
    public void handleWatchpointScope(int watchpointNumber) {
        ModalityUiUtil.invokeLaterIfNeeded(() -> this.myWatchpointHandler.handleWatchpointScope(watchpointNumber), (ModalityState)ModalityState.any());
        this.postCommand(DebuggerDriver::resume);
    }

    @Override
    public void handleModulesLoaded(@NotNull List<LLModule> modules) {
        if (modules == null) {
            CidrDebugProcess.$$$reportNull$$$0(83);
        }
    }

    @Override
    public void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        XLineBreakpoint lineBreakpoint;
        if (breakpoint == null) {
            CidrDebugProcess.$$$reportNull$$$0(84);
        }
        if ((lineBreakpoint = (XLineBreakpoint)this.myBreakpointHandler.getCodepoint(breakpoint.getId())) != null) {
            return;
        }
        this.myBreakpointHandler.handleBreakpointAdded(breakpoint);
    }

    @Override
    public void handleBreakpointRemoved(@NotNull LLBreakpoint breakpoint) {
        XLineBreakpoint lineBreakpoint;
        if (breakpoint == null) {
            CidrDebugProcess.$$$reportNull$$$0(85);
        }
        if ((lineBreakpoint = (XLineBreakpoint)this.myBreakpointHandler.getCodepoint(breakpoint.getId())) == null) {
            return;
        }
        this.myBreakpointHandler.handleBreakpointRemoved(lineBreakpoint);
    }

    @Override
    public void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
        XLineBreakpoint addressBreakpoint;
        XLineBreakpoint lineBreakpoint;
        if (breakpoint == null) {
            CidrDebugProcess.$$$reportNull$$$0(86);
        }
        if ((lineBreakpoint = (XLineBreakpoint)this.myBreakpointHandler.getCodepoint(breakpoint.getId())) != null) {
            this.myBreakpointHandler.handleBreakpointUpdated(lineBreakpoint, breakpoint);
        }
        if ((addressBreakpoint = (XLineBreakpoint)this.myAddressBreakpointHandler.getCodepoint(breakpoint.getId())) != null) {
            this.myAddressBreakpointHandler.handleBreakpointUpdated(addressBreakpoint, breakpoint);
        }
    }

    @NotNull
    public CidrSourceFileLocator getSourceFileLocator() {
        CidrSourceFileLocator cidrSourceFileLocator = this.mySourceFileLocator;
        if (cidrSourceFileLocator == null) {
            CidrDebugProcess.$$$reportNull$$$0(87);
        }
        return cidrSourceFileLocator;
    }

    @NotNull
    protected XExecutionStack newExecutionStack(@NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause cause) {
        if (thread == null) {
            CidrDebugProcess.$$$reportNull$$$0(88);
        }
        return new CidrExecutionStack(this, thread, frame, current, cause);
    }

    public static boolean viewsUpdatesDisabledInTests(@NotNull Object container) {
        if (container == null) {
            CidrDebugProcess.$$$reportNull$$$0(89);
        }
        return ApplicationManager.getApplication().isUnitTestMode() && !container.getClass().getSimpleName().contains("XTest");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 50: 
            case 55: 
            case 59: 
            case 60: 
            case 87: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 50: 
            case 55: 
            case 59: 
            case 60: 
            case 87: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendConsoleFilterProvider";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 50: 
            case 55: 
            case 59: 
            case 60: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess";
                break;
            }
            case 13: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 14: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferior";
                break;
            }
            case 23: 
            case 31: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 24: 
            case 26: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 25: 
            case 27: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pc";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 39: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 40: 
            case 42: 
            case 47: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 74: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signal";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meaning";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionAddress";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartDebuggerMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentStateMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorsProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluationContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToLineImpl";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createSourceOrDisasmPosition";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "postCommand";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerCommandExecutor";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "completeConsoleCommand";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesHelper";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunParameters";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileLocator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restartDebugger";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 50: 
            case 55: 
            case 59: 
            case 60: 
            case 87: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "logStack";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doStartTarget";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doDisconnectTarget";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "jumpToLine";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "jumpToLineImpl";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "positionToAddress";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fileToMemoryDoc";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createSourceOrDisasmPosition";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSourcePosition";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resolveFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createDisasmPosition";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "executeConsoleCommand";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "postCommand";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "completeConsoleCommand";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getTypesHelper";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "handleCommandException";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "reportEvaluationTimeOutError";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "handleInterrupted";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "doHandleSignalled";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpoint";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "handleWatchpoint";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "handleConnected";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "handleCodepoint";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetOutput";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "handleDebuggerOutput";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "handlePrompt";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "handleModulesLoaded";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointAdded";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointRemoved";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointUpdated";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "newExecutionStack";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "viewsUpdatesDisabledInTests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 50: 
            case 55: 
            case 59: 
            case 60: 
            case 87: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySuspensionGutterIconRenderer
    extends GutterIconRenderer {
        @NotNull
        private final CidrSuspensionCause mySuspensionCause;

        private MySuspensionGutterIconRenderer(@NotNull CidrSuspensionCause suspensionCause) {
            if (suspensionCause == null) {
                MySuspensionGutterIconRenderer.$$$reportNull$$$0(0);
            }
            this.mySuspensionCause = suspensionCause;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.mySuspensionCause.icon;
            if (icon == null) {
                MySuspensionGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @NotNull
        public String getTooltipText() {
            String string = this.mySuspensionCause.getDisplayString();
            if (string == null) {
                MySuspensionGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MySuspensionGutterIconRenderer renderer = (MySuspensionGutterIconRenderer)((Object)o);
            return this.mySuspensionCause.equals(renderer.mySuspensionCause);
        }

        public int hashCode() {
            return Objects.hash(this.mySuspensionCause);
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspensionCause";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MySuspensionGutterIconRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MySuspensionGutterIconRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MySuspensionGutterIconManager
    implements XDebugSessionListener {
        @NotNull
        private final XDebugSession mySession;
        @NotNull
        private final ExecutionPointHighlighter myExecutionPointHighlighter;

        MySuspensionGutterIconManager() {
            this.mySession = CidrDebugProcess.this.getSession();
            this.myExecutionPointHighlighter = new ExecutionPointHighlighter(CidrDebugProcess.this.getProject());
        }

        public void sessionPaused() {
            this.update();
        }

        public void sessionResumed() {
            this.update();
        }

        public void sessionStopped() {
            this.update();
        }

        public void stackFrameChanged() {
            this.update();
        }

        public void settingsChanged() {
            this.update();
        }

        private void update() {
            this.myExecutionPointHighlighter.hide();
            @Nullable XSuspendContext suspendContext = this.mySession.getSuspendContext();
            if (suspendContext == null) {
                return;
            }
            @Nullable XExecutionStack suspendExecutionStack = suspendContext.getActiveExecutionStack();
            if (!(suspendExecutionStack instanceof CidrExecutionStack)) {
                return;
            }
            @Nullable CidrSuspensionCause suspensionCause = ((CidrExecutionStack)suspendExecutionStack).mySuspensionCause;
            if (suspensionCause == null) {
                return;
            }
            @Nullable XSourcePosition position = (XSourcePosition)CidrDebugProcess.this.createSourceOrDisasmPosition((String)suspensionCause.file, (DebuggerSourceFileHash)suspensionCause.hash, (int)suspensionCause.line, (Address)suspensionCause.address).first;
            if (position == null) {
                return;
            }
            @Nullable XStackFrame suspendFrame = suspendExecutionStack.getTopFrame();
            if (suspendFrame == null || this.mySession.getCurrentStackFrame() != suspendFrame) {
                return;
            }
            this.myExecutionPointHighlighter.show(position, suspendFrame.getSourcePosition() != position, (GutterIconRenderer)new MySuspensionGutterIconRenderer(suspensionCause));
        }
    }

    private class CidrSuspendContext
    extends XSuspendContext {
        @NotNull
        private final XExecutionStack myActiveStack;
        private final LLThread myActiveThread;

        CidrSuspendContext(@Nullable DebuggerDriver.StopPlace stopPlace, CidrSuspensionCause cause) {
            if (stopPlace == null) {
                CidrSuspendContext.$$$reportNull$$$0(0);
            }
            this.myActiveStack = CidrDebugProcess.this.newExecutionStack(stopPlace.thread, stopPlace.frame, true, cause);
            this.myActiveThread = stopPlace.thread;
        }

        @Nullable
        public XExecutionStack getActiveExecutionStack() {
            return this.myActiveStack;
        }

        public void computeExecutionStacks(XSuspendContext.XExecutionStackContainer container) {
            if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
                return;
            }
            CidrDebugProcess.this.postCommand(driver -> {
                try {
                    ThrowInTest.doThrow((UserDataHolder)CidrDebugProcess.this, THROW_ON_THREAD_COLLECTION);
                    List<LLThread> threads = driver.getThreads();
                    ArrayList<XExecutionStack> stacks = new ArrayList<XExecutionStack>(threads.size());
                    for (LLThread each : threads) {
                        stacks.add(each.equals(this.myActiveThread) ? this.myActiveStack : CidrDebugProcess.this.newExecutionStack(each, null, false, null));
                    }
                    container.addExecutionStack(stacks, true);
                }
                catch (DebuggerCommandException e) {
                    container.errorOccurred(e.getMessage());
                }
                catch (com.intellij.execution.ExecutionException e) {
                    container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopPlace", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$CidrSuspendContext", "<init>"));
        }
    }

    private class MyProcessHandler
    extends ProcessHandler {
        private final AtomicReference<Integer> myExitCode = new AtomicReference();
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

        private MyProcessHandler() {
        }

        public void setExitCode(int exitCode) {
            this.myExitCode.set(exitCode);
        }

        @NotNull
        public Integer getExitCode() {
            Integer exitCode = this.myExitCode.get();
            Integer n = exitCode == null ? 0 : exitCode;
            if (n == null) {
                MyProcessHandler.$$$reportNull$$$0(0);
            }
            return n;
        }

        protected void destroyProcessImpl() {
            this.doDestroyOrDetach(false);
        }

        protected void detachProcessImpl() {
            this.doDestroyOrDetach(true);
        }

        private void doDestroyOrDetach(boolean detach) {
            ProcessIOExecutorService.INSTANCE.execute(() -> {
                if (CidrDebugProcess.this.waitForTermination()) {
                    if (detach) {
                        this.notifyProcessDetached();
                    } else {
                        this.notifyProcessTerminated(this.getExitCode());
                    }
                }
            });
        }

        public boolean detachIsDefault() {
            return CidrDebugProcess.this.isDetachDefault();
        }

        public OutputStream getProcessInput() {
            return CidrDebugProcess.this.myDriverDoNotUse.getProcessInput();
        }

        public final void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                MyProcessHandler.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                MyProcessHandler.$$$reportNull$$$0(2);
            }
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (x$0, x$1) -> super.notifyTextAvailable(x$0, x$1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MyProcessHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExitCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MyProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DebuggerUIUpdateCommand
    extends VoidDebuggerCommand,
    SuspendedDebuggerCommand<Void> {
    }

    public static interface DebuggerStartupCommand
    extends VoidDebuggerCommand {
    }

    @FunctionalInterface
    public static interface VoidDebuggerCommand
    extends DebuggerCommand<Void> {
        public void run(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @Override
        default public Void call(@NotNull DebuggerDriver driver) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (driver == null) {
                VoidDebuggerCommand.$$$reportNull$$$0(0);
            }
            this.run(driver);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$VoidDebuggerCommand", "call"));
        }
    }

    @FunctionalInterface
    public static interface SuspendedDebuggerCommand<R>
    extends DebuggerCommand<R> {
        @Override
        default public boolean canExecuteWhileRunning() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface DebuggerCommand<R> {
        public R call(@NotNull DebuggerDriver var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        default public boolean canExecuteWhileRunning() {
            return true;
        }
    }

    static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        FINISHED;

    }
}

