/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CidrEvaluator
extends XDebuggerEvaluator {
    public static final Key THROW_ON_EVALUATION = Key.create((String)"THROW_ON_EVALUATION");
    @NotNull
    protected final CidrStackFrame myFrame;

    public CidrEvaluator(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            CidrEvaluator.$$$reportNull$$$0(0);
        }
        this.myFrame = frame;
    }

    @NotNull
    public CidrEvaluatedValue doEvaluate(@NotNull DebuggerDriver driver, @Nullable XSourcePosition valuePosition, @NotNull XExpression expression) throws ExecutionException, DebuggerCommandException {
        String expr;
        LLValue val;
        if (driver == null) {
            CidrEvaluator.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            CidrEvaluator.$$$reportNull$$$0(2);
        }
        ThrowInTest.doThrow((UserDataHolder)this.myFrame.getProcess(), THROW_ON_EVALUATION);
        EvaluationContext context2 = this.createEvaluationContext(driver);
        if (expression.getMode() == EvaluationMode.EXPRESSION) {
            Pair<LLValue, String> pair = CidrEvaluatorHelper.getInstance().convertAndEvaluate(this.myFrame.getProcess(), driver, expression, valuePosition, this.myFrame);
            val = (LLValue)((Object)pair.first);
            expr = (String)pair.second;
        } else {
            val = context2.evaluate(expression.getExpression());
            expr = expression.getExpression();
        }
        return new CidrEvaluatedValue(val, this.myFrame.getProcess(), valuePosition, this.myFrame, expr);
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return this.myFrame.getProcess().driverSupportsCodeFragmentEvaluation();
    }

    protected EvaluationContext createEvaluationContext(DebuggerDriver driver) {
        return this.myFrame.getProcess().createEvaluationContext(driver, null, this.myFrame);
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            CidrEvaluator.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            CidrEvaluator.$$$reportNull$$$0(4);
        }
        this.evaluate((XExpression)XExpressionImpl.fromText((String)expression), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            CidrEvaluator.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            CidrEvaluator.$$$reportNull$$$0(6);
        }
        this.myFrame.getProcess().postCommand(new CidrDebugProcess.DebuggerUIUpdateCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    1.$$$reportNull$$$0(0);
                }
                XSourcePosition valuePosition = expressionPosition == null ? CidrEvaluator.this.myFrame.getSourcePosition() : expressionPosition;
                try {
                    CidrEvaluatedValue evaluatedValue = CidrEvaluator.this.doEvaluate(driver, valuePosition, expression);
                    callback.evaluated((XValue)evaluatedValue);
                }
                catch (DebuggerCommandException e) {
                    callback.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/CidrEvaluator$1", "run"));
            }
        });
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(final @NotNull Project project, final @NotNull Document document2, final int offset, final boolean sideEffectsAllowed) {
        if (project == null) {
            CidrEvaluator.$$$reportNull$$$0(7);
        }
        if (document2 == null) {
            CidrEvaluator.$$$reportNull$$$0(8);
        }
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(project, new TaskInfo(){

            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            public String getTitle() {
                String string = CidrDebuggerBundle.message("debug.evaluating.expression", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nls(capitalization=Nls.Capitalization.Title)
            public String getCancelText() {
                return CidrDebuggerBundle.message("debug.evaluating.expression.cancel", new Object[0]);
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            public String getCancelTooltipText() {
                return CidrDebuggerBundle.message("debug.evaluating.expression.cancel.tooltip", new Object[0]);
            }

            public boolean isCancellable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrEvaluator$2", "getTitle"));
            }
        }, PerformInBackgroundOption.DEAF){

            protected void showDialog() {
            }
        };
        JobScheduler.getScheduler().schedule(() -> {
            if (!indicator.isCanceled()) {
                indicator.background();
            }
        }, 500L, TimeUnit.MILLISECONDS);
        final AsyncPromise promise = new AsyncPromise();
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(project, CidrDebuggerBundle.message("debug.evaluating.expression", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                promise.setResult((Object)CidrEvaluator.this.getExpressionInfoAtOffset(project, document2, offset, sideEffectsAllowed));
            }

            public void onCancel() {
                promise.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/execution/debugger/CidrEvaluator$4", "run"));
            }
        }, (ProgressIndicator)indicator);
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            CidrEvaluator.$$$reportNull$$$0(9);
        }
        return asyncPromise;
    }

    @NotNull
    public <T> Promise<T> getWhenDataIsReady(@NotNull Editor editor, @NotNull T data) {
        Project project;
        if (editor == null) {
            CidrEvaluator.$$$reportNull$$$0(10);
        }
        if (data == null) {
            CidrEvaluator.$$$reportNull$$$0(11);
        }
        if ((project = editor.getProject()) == null) {
            Promise promise = Promises.resolvedPromise(data);
            if (promise == null) {
                CidrEvaluator.$$$reportNull$$$0(12);
            }
            return promise;
        }
        Document document2 = editor.getDocument();
        Promise promise = this.getExpressionInfoAtOffsetAsync(project, document2, document2.getText().length() - 1, true).then(unusedInfo -> data);
        if (promise == null) {
            CidrEvaluator.$$$reportNull$$$0(13);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrEvaluator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrEvaluator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhenDataIsReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWhenDataIsReady";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

