/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.memory.AbstractDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 4*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00014B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00122\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nH\u0002J\u0014\u0010\u0014\u001a\u00020\u00122\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u0019H$J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0017H$J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0014J$\u0010!\u001a\u00020\u00122\n\u0010\"\u001a\u00060#j\u0002`$2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000&H$J\u0014\u0010'\u001a\u00020\u00122\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u0010(\u001a\u00020\u00122\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u0010)\u001a\u00020\u00122\n\u0010*\u001a\u00060+j\u0002`,H\u0002J\b\u0010-\u001a\u00020.H\u0016J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000600*\u0002012\u0006\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0019H\u0002R\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00065"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/AbstractDocRegion;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;)V", "data", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "getData", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "deleteFromDocument", "", "doRenderReallocated", "doRenderSeamless", "oldRegion", "getAddressForLineNumberInDocument", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "line", "", "getAddressForLineNumberInsideRegion", "lineNumber", "getLineNumberInDocument", "address", "getLineNumberInsideRegion", "getOffsetInDocument", "getOffsetInsideLine", "renderEntry", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderFooter", "renderHeader", "replaceSafely", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toString", "", "getProtectedRanges", "", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "startOffset", "endOffset", "Companion", "intellij.cidr.debugger"})
public abstract class BaseDocRegion<T>
extends AbstractDocRegion<T> {
    @NotNull
    private final CidrMemoryData.Data<T> data;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final CidrMemoryData.Data<T> getData() {
        return this.data;
    }

    protected void doRenderSeamless(@NotNull BaseDocRegion<?> oldRegion) {
        Intrinsics.checkNotNullParameter(oldRegion, (String)"oldRegion");
        StringBuilder sb = new StringBuilder();
        this.renderHeader(sb);
        Iterable<CidrMemoryData.DataEntry<T>> $this$forEach$iv = this.data.getEntries();
        boolean $i$f$forEach = false;
        Iterator<CidrMemoryData.DataEntry<T>> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            CidrMemoryData.DataEntry<T> element$iv;
            CidrMemoryData.DataEntry<T> entry = element$iv = iterator2.next();
            boolean bl = false;
            this.renderEntry(sb, entry);
        }
        this.renderFooter(sb);
        if (oldRegion.getTextRange().getLength() == sb.length()) {
            super.replaceSafely(sb);
        } else {
            this.getDocument().replaceString(this.getRangeMarker().getStartOffset(), this.getRangeMarker().getEndOffset(), (CharSequence)sb);
        }
    }

    private final void doRenderReallocated(AddressSpace<DocRegion<T>> reallocatedSpace) {
        StringBuilder sb = new StringBuilder();
        int lastOffset = this.getRangeMarker().getStartOffset();
        this.renderHeader(sb);
        for (CidrMemoryData.DataEntry<T> entry : this.data.getEntries()) {
            Iterable $this$forEach$iv = reallocatedSpace.get(entry.getRange()).filterRegions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DocRegion reallocatedRegion = (DocRegion)element$iv;
                boolean bl = false;
                boolean bl2 = reallocatedRegion.getDocument() == this.getDocument();
                boolean bl3 = false;
                boolean bl4 = false;
                bl4 = false;
                boolean bl5 = false;
                if (!bl2) {
                    boolean bl6 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                this.getDocument().insertString(lastOffset, (CharSequence)sb);
                Unit unit = Unit.INSTANCE;
                bl3 = false;
                bl4 = false;
                Unit it = unit;
                boolean bl7 = false;
                lastOffset += sb.length();
                sb.setLength(0);
                reallocatedRegion.deleteFromDocument();
            }
            this.renderEntry(sb, entry);
        }
        this.renderFooter(sb);
        this.getDocument().replaceString(lastOffset, this.getRangeMarker().getEndOffset(), (CharSequence)sb);
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceSafely(StringBuilder sb) {
        if (this.getRangeMarker().isValid()) {
            Document document2 = this.getDocument();
            if (document2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
            }
            DocumentEx documentEx = (DocumentEx)document2;
            boolean bl = false;
            boolean bl2 = false;
            DocumentEx $this$with = documentEx;
            boolean bl3 = false;
            int offset = this.getRangeMarker().getStartOffset();
            List<TextRange> protectedRanges = this.getProtectedRanges($this$with, offset, this.getRangeMarker().getEndOffset());
            for (TextRange textRange : protectedRanges) {
                void startOffset;
                int n = BaseDocRegion.Companion.component1(textRange);
                int endOffset = BaseDocRegion.Companion.component2(textRange);
                $this$with.replaceString((int)startOffset, endOffset, (CharSequence)sb.substring((int)(startOffset - offset), endOffset - offset));
            }
            this.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deleteFromDocument() {
        if (this.getRangeMarker().isValid()) {
            int n;
            Document document2 = this.getDocument();
            if (document2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
            }
            DocumentEx documentEx = (DocumentEx)document2;
            boolean bl = false;
            boolean bl2 = false;
            DocumentEx $this$with = documentEx;
            boolean bl3 = false;
            List<TextRange> protectedRanges = this.getProtectedRanges($this$with, this.getRangeMarker().getStartOffset(), this.getRangeMarker().getEndOffset());
            for (TextRange textRange : CollectionsKt.reversed((Iterable)protectedRanges)) {
                void startOffset;
                n = BaseDocRegion.Companion.component1(textRange);
                int endOffset = BaseDocRegion.Companion.component2(textRange);
                $this$with.deleteString((int)startOffset, endOffset);
            }
            boolean bl4 = this.getTextRange().isEmpty();
            boolean bl5 = false;
            n = 0;
            if (!bl4) {
                boolean bl6 = false;
                String string = "DocRegion text range is not empty after deleting it";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> getProtectedRanges(DocumentEx $this$getProtectedRanges, int startOffset, int endOffset) {
        List list;
        boolean bl = false;
        Set protectedOffsets = new LinkedHashSet();
        int length = endOffset - startOffset;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        int n = startOffset;
        IntRange range = new IntRange(n, endOffset);
        Processor processor2 = new Processor(range, protectedOffsets, startOffset){
            final /* synthetic */ IntRange $range;
            final /* synthetic */ Set $protectedOffsets;
            final /* synthetic */ int $startOffset;

            public final boolean process(RangeMarker eachMarker) {
                boolean bl;
                Integer n;
                Collection collection;
                RangeMarker rangeMarker = eachMarker;
                Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"eachMarker");
                int n2 = rangeMarker.getStartOffset();
                boolean bl2 = false;
                boolean bl3 = false;
                int it = n2;
                boolean bl4 = false;
                if (this.$range.contains(it)) {
                    collection = this.$protectedOffsets;
                    n = it - this.$startOffset;
                    bl = false;
                    collection.add(n);
                }
                n2 = eachMarker.getEndOffset();
                bl2 = false;
                bl3 = false;
                it = n2;
                boolean bl5 = false;
                if (this.$range.contains(it)) {
                    collection = this.$protectedOffsets;
                    n = it - this.$startOffset;
                    bl = false;
                    collection.add(n);
                }
                return true;
            }
            {
                this.$range = intRange;
                this.$protectedOffsets = set;
                this.$startOffset = n;
            }
        };
        $this$getProtectedRanges.processRangeMarkersOverlappingWith(startOffset, endOffset, processor2);
        EditorFactory.getInstance().editors((Document)$this$getProtectedRanges).forEach(new Consumer(startOffset, endOffset, processor2){
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ Processor $processor;

            public final void accept(Editor editor) {
                block1: {
                    EditorEx editorEx;
                    Editor editor2 = editor;
                    if (!(editor2 instanceof EditorEx)) {
                        editor2 = null;
                    }
                    if ((editorEx = (EditorEx)editor2) == null || (editorEx = editorEx.getMarkupModel()) == null) break block1;
                    editorEx.processRangeHighlightersOverlappingWith(this.$startOffset, this.$endOffset, this.$processor);
                }
            }
            {
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$processor = processor2;
            }
        });
        boolean bl2 = protectedOffsets.contains(0);
        boolean bl3 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl2 = protectedOffsets.contains(length);
        bl3 = false;
        bl4 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable $this$zipWithNext$iv = CollectionsKt.sorted((Iterable)protectedOffsets);
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            boolean bl7 = false;
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void eachEndOffset;
                void eachStartOffset;
                Object next$iv = iterator$iv.next();
                int n2 = ((Number)next$iv).intValue();
                int n3 = ((Number)current$iv).intValue();
                List list2 = result$iv;
                boolean bl8 = false;
                TextRange textRange = new TextRange(startOffset + eachStartOffset, startOffset + eachEndOffset);
                list2.add(textRange);
                current$iv = next$iv;
            }
            list = result$iv;
        }
        return list;
    }

    protected abstract void renderEntry(@NotNull Appendable var1, @NotNull CidrMemoryData.DataEntry<? extends T> var2);

    protected void renderHeader(@NotNull Appendable buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
    }

    protected void renderFooter(@NotNull Appendable buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
    }

    @Nullable
    protected abstract Address getAddressForLineNumberInsideRegion(int var1);

    protected abstract int getLineNumberInsideRegion(@NotNull Address var1);

    protected int getOffsetInsideLine(@NotNull Address address, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return 0;
    }

    @Override
    @Nullable
    public Address getAddressForLineNumberInDocument(int line) {
        IntRange regionLineRange = this.getLineRangeInDocument();
        int n = RangesKt.coerceIn((int)line, (ClosedRange)((ClosedRange)regionLineRange));
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        if (it != line) {
            CidrDebuggerLog.LOG.warn("Line number " + line + " is outside the region line range " + regionLineRange);
        }
        int lineNumberInsideRegion = n - regionLineRange.getStart();
        return this.getAddressForLineNumberInsideRegion(lineNumberInsideRegion);
    }

    @Override
    public int getLineNumberInDocument(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        boolean bl = this.getRangeMarker().isValid();
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Region is disposed or otherwise removed from the Document";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int regionLineNumber = this.getDocument().getLineNumber(this.getRangeMarker().getStartOffset());
        int lineNumber = !this.getRange().contains((Comparable)address) ? 0 : this.getLineNumberInsideRegion(address);
        n = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(regionLineNumber + lineNumber), (int)(this.getDocument().getLineCount() - 1)), (int)0);
        boolean bl4 = false;
        boolean bl5 = false;
        int it = n;
        boolean bl6 = false;
        if (regionLineNumber + lineNumber != it) {
            CidrDebuggerLog.LOG.warn("Computed line number " + regionLineNumber + '+' + lineNumber + " is outside the document boundary " + it);
        }
        return n;
    }

    @Override
    public int getOffsetInDocument(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int lineNumber = this.getLineNumberInDocument(address);
        int offsetInLine = this.getOffsetInsideLine(address, lineNumber);
        return RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(this.getDocument().getLineStartOffset(lineNumber) + offsetInLine), (int)(this.getDocument().getTextLength() - 1)), (int)0);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(range=" + this.getRange() + ", myRangeMarker=" + this.getRangeMarker() + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public BaseDocRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<T> dataRegion, @NotNull AddressSpace<DocRegion<T>> reallocatedSpace) {
        void $this$withMarkerGreedy$iv;
        Interval interval;
        Interval interval2;
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter(dataRegion, (String)"dataRegion");
        Intrinsics.checkNotNullParameter(reallocatedSpace, (String)"reallocatedSpace");
        super(document2, textRange, dataRegion);
        this.data = dataRegion.getData();
        boolean bl = reallocatedSpace.getRange().contains(this.getRange());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !(dataRegion instanceof CidrMemoryData.DataRegion.Completed.LoadError);
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Interval interval3 = (Interval)CollectionsKt.singleOrNull((Iterable)reallocatedSpace.getIntervals());
        if (interval3 != null) {
            Interval interval4 = interval3;
            bl3 = false;
            bl4 = false;
            Interval it = interval4;
            boolean bl7 = false;
            interval2 = Intrinsics.areEqual(it.getClass(), this.getClass()) && Intrinsics.areEqual((Object)it.getRange(), (Object)this.getRange()) ? interval4 : null;
        } else {
            interval2 = interval = null;
        }
        if (!(interval2 instanceof BaseDocRegion)) {
            interval = null;
        }
        BaseDocRegion seamlessRegionUpdate = (BaseDocRegion)interval;
        RangeMarker rangeMarker = this.getRangeMarker();
        AbstractDocRegion.Companion companion = AbstractDocRegion.Companion;
        boolean value$iv = true;
        boolean $i$f$withMarkerGreedy$intellij_cidr_debugger = false;
        boolean savedToLeft$iv = $this$withMarkerGreedy$iv.isGreedyToLeft();
        boolean savedToRight$iv = $this$withMarkerGreedy$iv.isGreedyToRight();
        $this$withMarkerGreedy$iv.setGreedyToLeft(value$iv);
        $this$withMarkerGreedy$iv.setGreedyToRight(value$iv);
        try {
            boolean bl8 = false;
            if (seamlessRegionUpdate != null) {
                this.doRenderSeamless(seamlessRegionUpdate);
            } else {
                this.doRenderReallocated(reallocatedSpace);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withMarkerGreedy$iv.setGreedyToLeft(savedToLeft$iv);
            $this$withMarkerGreedy$iv.setGreedyToRight(savedToRight$iv);
        }
        boolean bl9 = this.getRangeMarker().getStartOffset() != this.getRangeMarker().getEndOffset();
        boolean bl10 = false;
        bl4 = false;
        if (!bl9) {
            boolean bl11 = false;
            String string = "DocRegion text range is empty after rendering";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0082\u0002J\r\u0010\u0006\u001a\u00020\u0004*\u00020\u0005H\u0082\u0002\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion$Companion;", "", "()V", "component1", "", "Lcom/intellij/openapi/util/TextRange;", "component2", "intellij.cidr.debugger"})
    public static final class Companion {
        private final int component1(TextRange $this$component1) {
            Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"$this$component1");
            return $this$component1.getStartOffset();
        }

        private final int component2(TextRange $this$component2) {
            Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"$this$component2");
            return $this$component2.getEndOffset();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

