/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.remote.ui.SdkScopeController;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil;
import com.jetbrains.plugins.remotesdk.ui.DeploymentProjectLevelSetupForm;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkByDeploymentForm {
    private static final Logger LOG = Logger.getInstance(RemoteSdkByDeploymentForm.class);
    private static final WebDeploymentCredentialsHolder DEPLOYMENT_EMPTY_CREDENTIALS = new WebDeploymentCredentialsHolder();
    private static final Condition<WebServerConfig> mySftpServersFilter = config -> config.getFileTransferConfig().getAccessType() == AccessType.SFTP;
    private JPanel myDeploymentPanel;
    private JBLabel myDeploymentConfigurationLabel;
    protected WebServerCombo myDeploymentConfigurationsCombo;
    private JLabel myDeploymentHostLabel;
    private JLabel myDeploymentUrl;
    protected JPanel myDeploymentProjectLevelServerSetupPanel;
    protected ActionLink myDeploymentMoveServerLink;
    protected HyperlinkLabel myDeploymentLevelWarningLabel;
    protected JBLabel myDeploymentMoveServerLabel;
    protected JPanel myCustomActionPanel;
    private JPanel myDeploymentWarningPanel;
    private JBLabel myDeploymentWarningLabel;
    private final Project myProject;
    private WebDeploymentCredentialsHolder myDeploymentCredentials;
    private final DeploymentProjectLevelSetupForm myDeploymentProjectLevelSetupForm;
    @NotNull
    private final RemoteSdkEditorForm myParentForm;

    public RemoteSdkByDeploymentForm(@Nullable Project project, @NotNull RemoteSdkEditorForm parentForm) {
        if (parentForm == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myParentForm = parentForm;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)parentForm.getDisposable(), (Disposable)this.myDeploymentConfigurationsCombo);
        List<WebServerConfig> serverList = RemoteSdkUtil.getSftpServerList(this.myProject);
        this.myDeploymentWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myDeploymentWarningPanel.setVisible(serverList.isEmpty());
        this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
        this.myDeploymentConfigurationsCombo.setProject(project);
        this.myDeploymentConfigurationsCombo.setWebServerFilter(mySftpServersFilter);
        this.myDeploymentConfigurationsCombo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RemoteSdkByDeploymentForm.this.deploymentSelected();
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect(parentForm.getDisposable()).subscribe(WebDeploymentTopics.WEB_SERVER_CONFIGS, () -> this.myDeploymentWarningPanel.setVisible(RemoteSdkUtil.getSftpServerList(this.myProject).isEmpty()));
        this.myDeploymentProjectLevelSetupForm = new DeploymentProjectLevelSetupForm(project, parentForm.getBundleAccessor(), new DeploymentProjectLevelSetupForm.Listener(){

            @Override
            public void onConfigCopied(@NotNull WebServerConfig global) {
                if (global == null) {
                    2.$$$reportNull$$$0(0);
                }
                RemoteSdkByDeploymentForm.this.setupDeploymentCombo(global);
                RemoteSdkByDeploymentForm.this.deploymentSelected();
            }

            @Override
            public void onConfigMoved(@NotNull WebServerConfig movedServer) {
                if (movedServer == null) {
                    2.$$$reportNull$$$0(1);
                }
                RemoteSdkByDeploymentForm.this.setupDeploymentCombo(movedServer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "global";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "movedServer";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteSdkByDeploymentForm$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConfigCopied";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConfigMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentForm.getSdkScopeController());
        this.myDeploymentProjectLevelServerSetupPanel.setLayout(new BorderLayout());
        this.myDeploymentProjectLevelServerSetupPanel.add((Component)this.myDeploymentProjectLevelSetupForm.getMainPanel(), "Center");
        this.myDeploymentMoveServerLink = this.myDeploymentProjectLevelSetupForm.getDeploymentMoveServerLink();
        this.myDeploymentLevelWarningLabel = this.myDeploymentProjectLevelSetupForm.getDeploymentLevelWarningLabel();
        this.myDeploymentMoveServerLabel = this.myDeploymentProjectLevelSetupForm.getDeploymentMoveServerLabel();
        this.myCustomActionPanel = this.myDeploymentProjectLevelSetupForm.getCustomActionPanel();
        this.setupDeploymentCombo(this.defaultDeploymentConfig(project));
        parentForm.getSdkScopeController().addListener(() -> {
            if (parentForm.isSdkInConsistentState((CredentialsType)WebDeploymentCredentialsType.getInstance())) {
                this.updateWarningPanel();
            }
        });
    }

    private WebServerConfig defaultDeploymentConfig(@Nullable Project project) {
        List<WebServerConfig> serverList;
        PublishConfig config;
        Pair defaultServerOrGroup;
        if (project != null && (defaultServerOrGroup = (config = PublishConfig.getInstance((Project)project)).findDefaultServerOrGroup()) != null) {
            if (defaultServerOrGroup.second != null && ((WebServerConfig)defaultServerOrGroup.second).getAccessType() == AccessType.SFTP) {
                return (WebServerConfig)defaultServerOrGroup.second;
            }
            if (defaultServerOrGroup.first != null) {
                List servers = ((WebServerGroupingWrap)defaultServerOrGroup.first).getServers();
                for (WebServerConfig server : servers) {
                    if (server.getAccessType() != AccessType.SFTP) continue;
                    return server;
                }
            }
        }
        return (serverList = RemoteSdkUtil.getSftpServerList(this.myProject)).isEmpty() ? null : serverList.get(0);
    }

    public void init(@NotNull WebDeploymentCredentialsHolder cred) {
        if (cred == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(1);
        }
        this.setDeploymentCredentials(new WebDeploymentCredentialsHolder().copyFrom(cred));
        WebServerConfig server = GroupedServersConfigManager.getInstance((Project)this.myProject).findServer(cred.getWebServerConfigId());
        if (server != null && mySftpServersFilter.value((Object)server)) {
            this.myDeploymentConfigurationsCombo.selectServer(server);
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(server.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(server)));
        } else {
            this.myDeploymentConfigurationsCombo.resetToServerOrGroup(new ServerOrGroup().setServer(cred.getWebServerConfigId(), cred.getWebServerConfigName()));
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
            LOG.warn("Can not find selected deployment server: " + cred.getWebServerConfigName());
        }
    }

    public JPanel getMainPanel() {
        return this.myDeploymentPanel;
    }

    @NotNull
    public JBLabel getNavigatableLabel() {
        JBLabel jBLabel = this.myDeploymentConfigurationLabel;
        if (jBLabel == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(2);
        }
        return jBLabel;
    }

    private void updateCredentials(@Nullable RemoteCredentials credentials, @NotNull JLabel hostLabel, @NotNull JLabel hostUrl) {
        if (hostLabel == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(3);
        }
        if (hostUrl == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(4);
        }
        CreateRemoteSdkUIUtil.useReferencedCredentials(this.myProject, this.myParentForm.getStatusPanel(), this.myParentForm.getValidator(), credentials, hostLabel, hostUrl, null);
    }

    public WebDeploymentCredentialsHolder getDeploymentCredentials() {
        return this.myDeploymentCredentials;
    }

    public void deploymentSelected() {
        this.useDeploymentSettings(this.myDeploymentConfigurationsCombo.getSelectedServer());
    }

    private void useDeploymentSettings(@Nullable WebServerConfig config) {
        if (config != null) {
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(config.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(config)));
            RemoteCredentials credentials = WebDeploymentCredentialHelper.getRemoteCredentials((WebServerConfig)config, (Project)this.myProject);
            if (credentials != null) {
                this.setDeploymentCredentials(new WebDeploymentCredentialsHolder(config.getId(), config.getName(), credentials));
                return;
            }
        }
        this.setDeploymentCredentials(DEPLOYMENT_EMPTY_CREDENTIALS);
    }

    private void setDeploymentCredentials(WebDeploymentCredentialsHolder deploymentCredentials) {
        this.myDeploymentCredentials = deploymentCredentials;
        RemoteCredentials sshCredentials = RemoteSdkCredentialsProducerImpl.getCredentialsBySftpServerId(this.myProject, this.myDeploymentCredentials.getWebServerConfigId());
        this.updateCredentials(sshCredentials, this.myDeploymentHostLabel, this.myDeploymentUrl);
    }

    protected void createUIComponents() {
        this.myDeploymentConfigurationsCombo = new WebServerCombo(true, -1, false, false);
    }

    private void setupDeploymentCombo(@Nullable WebServerConfig configToSelect) {
        if (configToSelect == null) {
            this.myDeploymentConfigurationsCombo.resetToServerOrGroup(null);
        } else {
            this.myDeploymentConfigurationsCombo.resetToServerOrGroup(new ServerOrGroup().setServer(configToSelect));
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(configToSelect.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(configToSelect)));
        }
    }

    @Nullable
    public ValidationInfo validate() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server == null) {
            return new ValidationInfo(RemoteSdkBundle.message("dialog.message.deployment.configuration.not.selected", new Object[0]), (JComponent)this.myDeploymentConfigurationsCombo);
        }
        String deploymentError = this.validateDeployment(server);
        if (StringUtil.isNotEmpty((String)deploymentError)) {
            return new ValidationInfo(deploymentError, (JComponent)this.myDeploymentConfigurationsCombo);
        }
        return null;
    }

    @Nullable
    @NlsContexts.DialogMessage
    public String validateDeployment(@NotNull WebServerConfig server) {
        SdkScopeController sdkScopeController;
        if (server == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(5);
        }
        if (!(sdkScopeController = this.myParentForm.getSdkScopeController()).isProjectLevel() && server.isProjectLevel()) {
            if (!sdkScopeController.isProjectLevelSupported()) {
                return RemoteSdkBundle.message("dialog.message.project.level.deployment.servers.are.not.currently.supported.please.create.one.using.any.two.links.above", new Object[0]);
            }
            return RemoteSdkBundle.message("remote.interpreter.deployment.level.incompatibility.error", new Object[0]);
        }
        return null;
    }

    public void updateWarningPanel() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server != null) {
            String error = this.validateDeployment(server);
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(server.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)error));
        }
    }

    public String getValidationError() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server != null) {
            return this.validateDeployment(server);
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDeploymentConfigurationsCombo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cred";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/RemoteSdkByDeploymentForm";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostLabel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteSdkByDeploymentForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateCredentials";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateDeployment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        JLabel jLabel2;
        JBLabel jBLabel2;
        JPanel jPanel3;
        this.createUIComponents();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeploymentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeploymentConfigurationLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", RemoteSdkByDeploymentForm.class).getString("label.deployment.configuration"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        WebServerCombo webServerCombo = this.myDeploymentConfigurationsCombo;
        jPanel3.add((Component)webServerCombo, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDeploymentHostLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", RemoteSdkByDeploymentForm.class).getString("label.deployment.host.url"));
        jPanel3.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentUrl = jLabel = new JLabel();
        jLabel.setText("");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, new Dimension(7, -1), null, new Dimension(7, -1)));
        this.myDeploymentProjectLevelServerSetupPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentWarningPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentWarningLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", RemoteSdkByDeploymentForm.class).getString("label.create.sftp.deployment.server.to.configure.connection.credentials.and.path.mappings"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel2.setLabelFor((Component)webServerCombo);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

