/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.DynamicBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.sh.ShBundle;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ShRunConfigurationEditor
extends SettingsEditor<ShRunConfiguration> {
    private JPanel myPanel;
    private JPanel myScriptPathPanel;
    private JPanel myScriptTextPanel;
    private RawCommandLineEditor myScript;
    private TextFieldWithBrowseButton myScriptSelector;
    private RawCommandLineEditor myScriptOptions;
    private TextFieldWithBrowseButton myScriptFileWorkingDirectory;
    private TextFieldWithBrowseButton myScriptWorkingDirectory;
    private TextFieldWithBrowseButton myInterpreterSelector;
    private RawCommandLineEditor myInterpreterOptions;
    private JBCheckBox myExecuteFileInTerminal;
    private JBCheckBox myExecuteScriptInTerminal;
    private EnvironmentVariablesComponent myEnvComponent;
    private EnvironmentVariablesComponent myScriptEnvComponent;
    private ButtonGroup myScriptGroup;
    private JBRadioButton myScriptFileRadioButton;
    private JBRadioButton myScriptTextRadioButton;

    ShRunConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        this.myScriptSelector.addBrowseFolderListener(ShBundle.message("sh.label.choose.shell.script", new Object[0]), "", project, FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.myScriptFileWorkingDirectory.addBrowseFolderListener(ShBundle.message("sh.label.choose.script.working.directory", new Object[0]), "", project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myScriptWorkingDirectory.addBrowseFolderListener(ShBundle.message("sh.label.choose.script.working.directory", new Object[0]), "", project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myInterpreterSelector.addBrowseFolderListener(ShBundle.message("sh.label.choose.interpreter", new Object[0]), "", project, FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.myScriptGroup = new ButtonGroup();
        this.myScriptGroup.add((AbstractButton)this.myScriptTextRadioButton);
        this.myScriptGroup.add((AbstractButton)this.myScriptFileRadioButton);
        this.myScriptFileRadioButton.addActionListener(action -> this.selectMode());
        this.myScriptTextRadioButton.addActionListener(action -> this.selectMode());
        this.selectMode();
    }

    protected void resetEditorFrom(@NotNull ShRunConfiguration configuration) {
        if (configuration == null) {
            ShRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        if (configuration.isExecuteScriptFile()) {
            this.myScriptFileRadioButton.setSelected(true);
        } else {
            this.myScriptTextRadioButton.setSelected(true);
        }
        this.selectMode();
        this.myScript.setText(configuration.getScriptText());
        this.myScriptWorkingDirectory.setText(configuration.getScriptWorkingDirectory());
        this.myExecuteScriptInTerminal.setSelected(configuration.isExecuteInTerminal());
        this.myScriptEnvComponent.setEnvData(configuration.getEnvData());
        this.myScriptSelector.setText(configuration.getScriptPath());
        this.myScriptOptions.setText(configuration.getScriptOptions());
        this.myScriptFileWorkingDirectory.setText(configuration.getScriptWorkingDirectory());
        this.myInterpreterSelector.setText(configuration.getInterpreterPath());
        this.myInterpreterOptions.setText(configuration.getInterpreterOptions());
        this.myExecuteFileInTerminal.setSelected(configuration.isExecuteInTerminal());
        this.myEnvComponent.setEnvData(configuration.getEnvData());
    }

    protected void applyEditorTo(@NotNull ShRunConfiguration configuration) {
        if (configuration == null) {
            ShRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        configuration.setScriptText(this.myScript.getText());
        if (this.myScriptFileRadioButton.isSelected()) {
            configuration.setScriptWorkingDirectory(this.myScriptFileWorkingDirectory.getText());
            configuration.setExecuteInTerminal(this.myExecuteFileInTerminal.isSelected());
            configuration.setEnvData(this.myEnvComponent.getEnvData());
            configuration.setExecuteScriptFile(true);
        } else {
            configuration.setScriptWorkingDirectory(this.myScriptWorkingDirectory.getText());
            configuration.setExecuteInTerminal(this.myExecuteScriptInTerminal.isSelected());
            configuration.setEnvData(this.myScriptEnvComponent.getEnvData());
            configuration.setExecuteScriptFile(false);
        }
        configuration.setScriptPath(this.myScriptSelector.getText());
        configuration.setScriptOptions(this.myScriptOptions.getText());
        configuration.setInterpreterPath(this.myInterpreterSelector.getText());
        configuration.setInterpreterOptions(this.myInterpreterOptions.getText());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ShRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void selectMode() {
        boolean scriptExecutionSelected = this.myScriptFileRadioButton.isSelected();
        this.myScriptFileRadioButton.setSelected(scriptExecutionSelected);
        this.myScriptPathPanel.setVisible(scriptExecutionSelected);
        this.myScriptTextRadioButton.setSelected(!scriptExecutionSelected);
        this.myScriptTextPanel.setVisible(!scriptExecutionSelected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        EnvironmentVariablesComponent environmentVariablesComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBCheckBox jBCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        RawCommandLineEditor rawCommandLineEditor2;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        EnvironmentVariablesComponent environmentVariablesComponent2;
        RawCommandLineEditor rawCommandLineEditor3;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScriptPathPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScriptOptions = rawCommandLineEditor3 = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.script.options"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.working.dir"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvComponent = environmentVariablesComponent2 = new EnvironmentVariablesComponent();
        environmentVariablesComponent2.setLabelLocation("East");
        environmentVariablesComponent2.setText("");
        jPanel2.add((Component)environmentVariablesComponent2, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.environment.variables"));
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.interpreter"));
        jPanel2.add((Component)titledSeparator, new GridConstraints(4, 0, 1, 2, 1, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.interpreter.path"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterSelector = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton4, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myInterpreterOptions = rawCommandLineEditor2 = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor2, new GridConstraints(6, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.interpreter.options"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.script.path"));
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptSelector = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myExecuteFileInTerminal = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setEnabled(true);
        jBCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.execute.terminal"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptFileWorkingDirectory = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myScriptTextPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScript = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.execute.script.text.title"));
        jPanel.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExecuteScriptInTerminal = jBCheckBox = new JBCheckBox();
        jBCheckBox.setEnabled(true);
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.execute.terminal"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.working.dir"));
        jPanel.add((Component)jBLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptWorkingDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel8, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.environment.variables"));
        jPanel.add((Component)jBLabel8, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScriptEnvComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setText("");
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel9, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.execute"));
        jPanel4.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(152, 16), null));
        this.myScriptFileRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setEnabled(true);
        jBRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.execute.script.file"));
        jPanel4.add((Component)jBRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScriptTextRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/ShBundle", ShRunConfigurationEditor.class).getString("sh.run.execute.script.text"));
        jPanel4.add((Component)jBRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

