/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.clion.perf.PerfUtils;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesFixer;
import com.intellij.profiler.linux.OK;
import com.intellij.profiler.linux.VariableValidationResult;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\u0002`\u0018H\u0014J \u0010\u0019\u001a\u00020\b2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\u0002`\u0018H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/clion/perf/RemoteKernelVariablesFixer;", "Lcom/intellij/profiler/linux/KernelVariablesFixer;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "(Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;)V", "createTempExecutableScript", "Ljava/nio/file/Path;", "prefix", "", "suffix", "content", "executeScript", "Lcom/intellij/execution/process/ProcessOutput;", "scriptPath", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "", "getChangeVarsPermanentlyScript", "sysctlPath", "validationResult", "", "Lcom/intellij/profiler/linux/KernelVariable;", "Lcom/intellij/profiler/linux/VariableValidationResult;", "Lcom/intellij/profiler/linux/AllVariablesValidationResult;", "getChangeVarsUntilRestartScriptPath", "intellij.profiler.clion"})
public final class RemoteKernelVariablesFixer
extends KernelVariablesFixer {
    private final CidrToolEnvironment environment;

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getChangeVarsUntilRestartScriptPath(@NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult) {
        void $this$mapTo$iv$iv;
        VariableValidationResult it;
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Map<KernelVariable, ? extends VariableValidationResult> $this$filterValues$iv = validationResult;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        Map<KernelVariable, ? extends VariableValidationResult> map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<KernelVariable, ? extends VariableValidationResult> entry$iv : map2.entrySet()) {
            it = entry$iv.getValue();
            boolean bl2 = false;
            if (!(!(it instanceof OK))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$map$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry<Object, Object> item$iv$iv : $this$mapTo$iv$iv) {
            it = (KernelVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String string = "echo " + it.getRequiredValue() + " > " + it.getPath();
            collection.add(string);
        }
        List echoLines = (List)destination$iv$iv;
        String script = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"#!/bin/sh"), (Iterable)echoLines), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Path path = this.createTempExecutableScript("change_kernel_variables_until_restart", ".sh", script);
        boolean bl4 = false;
        return ((Object)path).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getChangeVarsPermanentlyScript(@NotNull String sysctlPath, @NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        VariableValidationResult it;
        Intrinsics.checkNotNullParameter((Object)sysctlPath, (String)"sysctlPath");
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Object $this$filterValues$iv = validationResult;
        boolean $i$f$filterValues = false;
        LinkedHashMap<KernelVariable, VariableValidationResult> result$iv = new LinkedHashMap<KernelVariable, VariableValidationResult>();
        Map<KernelVariable, ? extends VariableValidationResult> map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<KernelVariable, ? extends VariableValidationResult> entry$iv : map2.entrySet()) {
            it = entry$iv.getValue();
            boolean bl2 = false;
            if (!(!(it instanceof OK))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry<Object, Object> item$iv$iv : $this$mapTo$iv$iv) {
            Path path;
            it = (KernelVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("echo kernel.").append(it.getName()).append('=').append(it.getRequiredValue()).append(" >> ");
            Intrinsics.checkNotNullExpressionValue((Object)this.environment.getHostMachine().getPath(sysctlPath, new String[0]), (String)"environment.hostMachine.getPath(sysctlPath)");
            boolean bl4 = false;
            String string = stringBuilder.append(((Object)path).toString()).toString();
            collection.add(string);
        }
        List sysctlLines = (List)destination$iv$iv;
        String script = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"#!/bin/sh", "set -e"}), (Iterable)sysctlLines), (Object)"sysctl --system"), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Path path = this.createTempExecutableScript("change_kernel_variables_permanently", ".sh", script);
        boolean bl5 = false;
        return ((Object)path).toString();
    }

    @NotNull
    protected ProcessOutput executeScript(@NotNull String scriptPath, @NotNull ProgressIndicator indicator, int timeout) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        BaseProcessHandler handler2 = this.environment.getHostMachine().createProcessBuilder().withElevated(true).build(new GeneralCommandLine(new String[]{scriptPath}));
        ProcessOutput processOutput = CidrToolsUtil.runProcess((BaseProcessHandler)handler2, (ProgressIndicator)indicator, (int)timeout);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CidrToolsUtil.runProcess\u2026dler, indicator, timeout)");
        return processOutput;
    }

    private final Path createTempExecutableScript(String prefix, String suffix, String content) {
        HostMachine hostMachine = this.environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
        Path tempFile = Files.createTempFile(hostMachine.getTempDirectory(), prefix, suffix, new FileAttribute[0]);
        Object object = content;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write(tempFile, byArray, new OpenOption[0]);
        HostMachine hostMachine2 = this.environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine2, (String)"environment.hostMachine");
        if (hostMachine2.isRemote() && !PerfUtils.Companion.isWSL(this.environment)) {
            Files.setPosixFilePermissions(tempFile, PosixFilePermissions.fromString("rwxr-xr-x"));
        } else {
            Path path = tempFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempFile");
            object = path;
            boolean bl2 = false;
            FileUtil.setExecutable((File)new File(object.toString()));
        }
        Path path = tempFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempFile");
        return path;
    }

    public RemoteKernelVariablesFixer(@NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        this.environment = environment2;
    }
}

