/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadCMakeProjectAction
extends DumbAwareAction {
    public static final String ID = "CMake.LoadCMakeProject";

    public LoadCMakeProjectAction() {
        super(CLionCMakeBundle.messagePointer("cmake.action.loadCMakeProject", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadCMakeProjectAction.$$$reportNull$$$0(0);
        }
        Project project = LoadCMakeProjectAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabledAndVisible(project != null && LoadCMakeProjectAction.getProjectDirToLoad(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadCMakeProjectAction.$$$reportNull$$$0(1);
        }
        Project project = LoadCMakeProjectAction.getEventProject((AnActionEvent)e);
        File projectDirToLoad = LoadCMakeProjectAction.getProjectDirToLoad(e);
        if (project != null && projectDirToLoad != null) {
            CMakeWorkspace.getInstance(project).selectProjectDir(projectDirToLoad);
        }
    }

    @Nullable
    private static File getProjectDirToLoad(AnActionEvent e) {
        Project project = LoadCMakeProjectAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return null;
        }
        if (!LoadCMakeProjectAction.canLoadWorkspace(project)) {
            return null;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (!LoadCMakeProjectAction.isCMakeLists(file)) {
            return null;
        }
        CMakeWorkspace workspace = CMakeWorkspace.getInstance(project);
        File parentDir = VfsUtilCore.virtualToIoFile((VirtualFile)file.getParent());
        if (workspace.isInitialized() && FileUtil.filesEqual((File)workspace.getProjectPath().toFile(), (File)parentDir)) {
            return null;
        }
        return parentDir;
    }

    public static boolean isCMakeLists(VirtualFile file) {
        return file != null && !file.isDirectory() && FileUtil.namesEqual((String)file.getName(), (String)"CMakeLists.txt");
    }

    public static boolean canLoadWorkspace(@Nullable Project project) {
        if (project == null || project.isDisposed()) {
            return false;
        }
        List workspaces = CidrWorkspace.getInitializedWorkspaces((Project)project);
        boolean cmakeInitialized = workspaces.stream().anyMatch(workspace -> workspace instanceof CMakeWorkspace);
        if (cmakeInitialized) {
            return true;
        }
        return workspaces.isEmpty() && OCWorkspace.getInstance((Project)project).getConfigurations().isEmpty();
    }

    public static void selectAndLoadCMakeProject(Project project) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return LoadCMakeProjectAction.isCMakeLists(file);
            }
        };
        CMakeWorkspace workspace = CMakeWorkspace.getInstance(project);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)workspace.getEffectiveContentRoot(), file -> workspace.selectProjectDir(VfsUtilCore.virtualToIoFile((VirtualFile)(file.isDirectory() ? file : file.getParent()))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/LoadCMakeProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

