/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeMessage
implements Serializable {
    @NotNull
    private final MessageLevel myLevel;
    @Nullable
    private final File myFile;
    @Nullable
    private final Integer myLine;
    @NotNull
    private final String myText;

    @NotNull
    public static CMakeMessage fatalError(@NlsContexts.DetailedDescription @NotNull String text, @Nullable File file) {
        if (text == null) {
            CMakeMessage.$$$reportNull$$$0(0);
        }
        return new CMakeMessage(MessageLevel.FATAL_ERROR, file, null, text);
    }

    @NotNull
    public static CMakeMessage fromException(@NotNull CMakeException ex, @Nullable File file) {
        if (ex == null) {
            CMakeMessage.$$$reportNull$$$0(1);
        }
        return new CMakeMessage(MessageLevel.FATAL_ERROR, file, null, ex.getMessage());
    }

    public CMakeMessage(@NotNull MessageLevel level, @Nullable File file, @Nullable Integer line, @NlsSafe @NotNull String text) {
        if (level == null) {
            CMakeMessage.$$$reportNull$$$0(2);
        }
        if (text == null) {
            CMakeMessage.$$$reportNull$$$0(3);
        }
        this.myLevel = level;
        this.myFile = file;
        this.myLine = line;
        this.myText = text;
    }

    @NotNull
    public MessageLevel getLevel() {
        MessageLevel messageLevel = this.myLevel;
        if (messageLevel == null) {
            CMakeMessage.$$$reportNull$$$0(4);
        }
        return messageLevel;
    }

    @Nullable
    public File getFile() {
        return this.myFile;
    }

    @Nullable
    public Integer getLine() {
        return this.myLine;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            CMakeMessage.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String toString() {
        return this.myLevel + " " + this.myFile + (String)(this.myLine != null ? ":" + this.myLine : "") + ": " + this.myText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CMakeMessage message = (CMakeMessage)o;
        if (this.myLine != null ? !this.myLine.equals(message.myLine) : message.myLine != null) {
            return false;
        }
        if (this.myLevel != message.myLevel) {
            return false;
        }
        if (this.myFile != null ? !FileUtil.filesEqual((File)this.myFile, (File)message.myFile) : message.myFile != null) {
            return false;
        }
        return this.myText.equals(message.myText);
    }

    public int hashCode() {
        int result = this.myLevel.hashCode();
        result = 31 * result + FileUtil.fileHashCode((File)this.myFile);
        result = 31 * result + (this.myLine != null ? this.myLine.hashCode() : 0);
        result = 31 * result + this.myText.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fatalError";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromException";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MessageLevel {
        WARNING,
        AUTHOR_WARNING,
        ERROR,
        FATAL_ERROR;


        public boolean isWarning() {
            return this.compareTo(WARNING) >= 0 && this.compareTo(AUTHOR_WARNING) <= 0;
        }

        public boolean isError() {
            return this.compareTo(ERROR) >= 0;
        }
    }
}

