/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.google.common.util.concurrent.Runnables;
import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.JpsProjectLoadingManager;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPSettingsUtil;
import com.jetbrains.cidr.cpp.cmake.CMakeProjectOpenProcessor;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.CMakeSettingsListener;
import com.jetbrains.cidr.cpp.cmake.actions.LoadCMakeProjectAction;
import com.jetbrains.cidr.cpp.cmake.actions.OpenCMakeSettingsAction;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeListener;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.presets.CMakePresetLoader;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeOutputConsole;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeReloadStartedListener;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeRemoteUtil;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceLoadDependencyService;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceReloadTask;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceWatcher;
import com.jetbrains.cidr.cpp.cmake.workspace.FileStamp;
import com.jetbrains.cidr.cpp.cmake.workspace.ReloadFlag;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.notifications.CMakeTrustedProjectsNotificationsKt;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsListener;
import com.jetbrains.cidr.fus.CidrWorkspaceUsageCounterCollector;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompiler;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceListener;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.project.workspace.ReloadableWorkspace;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.system.RemoteDeploymentListener;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import kotlin.jvm.functions.Function4;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="CMakeWorkspace")
public final class CMakeWorkspace
extends CidrWorkspace
implements PersistentStateComponent<Element>,
WorkspaceWithEnvironment,
ReloadableWorkspace {
    private static final Key<Boolean> FORCE_RELOAD_ON_OPENING = Key.create((String)"FORCE_RELOAD_ON_OPENING");
    @NotNull
    private static final Logger LOG = Logger.getInstance(CMakeWorkspace.class);
    private static final int SERIALIZATION_VERSION = 129003;
    public static final String CLIENT_KEY = "CMake";
    @NotNull
    public static final String CACHE_DIR_NAME = "cmake";
    @Nullable
    private static Boolean ourSkipReloadOnProjectOpenInTests;
    @Nullable
    private static Boolean ourForceUseStandardDirForGenerationInTests;
    private static int ourSerializationVersionInTests;
    @Nullable
    private static Function4<Project, CMakeSettings.Profile, EnvironmentProblems, Boolean, CPPEnvironment> ourEnvironmentFactory;
    @Nullable
    private static Consumer<CMakeSettings> ourSettingsConfigurator;
    @Nullable
    private static Function<CMakeGenerator.Parameters, CMakeGenerator.Parameters> ourGenerationParametersConfigurator;
    @Nullable
    private static Pair<Integer, Integer> ourPauseOnReloadInTests;
    private static final AtomicInteger ourReloadsCounter;
    private static final Ref<Boolean> ourCheckCachesValidity;
    private volatile boolean myStateWasLoaded;
    @NotNull
    private volatile State myState;
    private volatile boolean myLastReloadWasCanceled;
    private volatile boolean myClearGeneratedFilesBeforeReload;
    @NotNull
    private final CMakeSettings mySettings;
    @NotNull
    private final CMakeWorkspaceWatcher myWorkspaceWatcher;
    private volatile CMakeOutputConsole myOutputConsole;
    private volatile boolean requiredConfigurationOnStartup;
    private final SettingsListener myProfilesListener;

    @TestOnly
    public static void setSkipReloadOnProjectOpenInTests(@Nullable Boolean value) {
        ourSkipReloadOnProjectOpenInTests = value;
    }

    @TestOnly
    public static void setForceUseStandardDirForGenerationInTests(@Nullable Boolean value) {
        ourForceUseStandardDirForGenerationInTests = value;
    }

    @TestOnly
    public static void setEnvironmentFactoryInTests(@Nullable Function4<Project, CMakeSettings.Profile, EnvironmentProblems, Boolean, CPPEnvironment> factory) {
        ourEnvironmentFactory = factory;
    }

    @TestOnly
    public static void setSettingsConfiguratorInTests(@Nullable Consumer<CMakeSettings> configurator2) {
        ourSettingsConfigurator = configurator2;
    }

    @Nullable
    @TestOnly
    public static Consumer<CMakeSettings> getSettingsConfiguratorInTests() {
        return ourSettingsConfigurator;
    }

    @TestOnly
    public static void setGenerationParametersConfigurator(@Nullable Function<CMakeGenerator.Parameters, CMakeGenerator.Parameters> configurator2) {
        ourGenerationParametersConfigurator = configurator2;
    }

    @TestOnly
    public static void setPauseOnReloadInTests(@Nullable Pair<Integer, Integer> value) {
        ourPauseOnReloadInTests = value;
    }

    @TestOnly
    public static int getReloadsCounter() {
        return ourReloadsCounter.get();
    }

    @TestOnly
    public static void setSerializationVersionInTests(int serializationVersion) {
        ourSerializationVersionInTests = serializationVersion;
    }

    @TestOnly
    public static void clearTestSettings() {
        ourSkipReloadOnProjectOpenInTests = null;
        ourForceUseStandardDirForGenerationInTests = null;
        CMakeWorkspace.setBalloonNotifierInTests(null);
        ourEnvironmentFactory = null;
        ourSettingsConfigurator = null;
        ourGenerationParametersConfigurator = null;
        ourPauseOnReloadInTests = null;
        ourSerializationVersionInTests = 129003;
    }

    @NotNull
    public static CMakeWorkspace getInstance(@NotNull Project project) {
        if (project == null) {
            CMakeWorkspace.$$$reportNull$$$0(0);
        }
        CMakeWorkspace cMakeWorkspace = (CMakeWorkspace)((Object)project.getService(CMakeWorkspace.class));
        if (cMakeWorkspace == null) {
            CMakeWorkspace.$$$reportNull$$$0(1);
        }
        return cMakeWorkspace;
    }

    public CMakeWorkspace(@NotNull Project project) {
        if (project == null) {
            CMakeWorkspace.$$$reportNull$$$0(2);
        }
        super(project);
        this.myStateWasLoaded = false;
        this.myState = this.createInitialState(null);
        this.myLastReloadWasCanceled = false;
        this.myClearGeneratedFilesBeforeReload = false;
        this.requiredConfigurationOnStartup = true;
        this.myProfilesListener = new SettingsListener();
        this.mySettings = CMakeSettings.getInstance(project);
        if (!this.shouldLoadWorkspaceForProject()) {
            this.myWorkspaceWatcher = null;
            return;
        }
        CMakeWorkspace.clearCaches(project);
        this.myWorkspaceWatcher = new CMakeWorkspaceWatcher(project, this);
    }

    public static void forceReloadOnOpening(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(3);
        }
        baseDir.putUserData(FORCE_RELOAD_ON_OPENING, (Object)true);
    }

    public boolean load(boolean projectOpening) {
        CMakeProjectOpenProcessor.OpenProjectSpec openSpec;
        if (!this.shouldLoadWorkspaceForProject()) {
            return false;
        }
        if (ourSettingsConfigurator != null) {
            ourSettingsConfigurator.consume((Object)this.getSettings());
            ourSettingsConfigurator = null;
        }
        ReloadFlag reloadFlag = ReloadFlag.RELOAD_ONLY_WHEN_CHANGED_PLUS_FULL_CHECK_ENVIRONMENT;
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            if (baseDir.getUserData(FORCE_RELOAD_ON_OPENING) == Boolean.TRUE) {
                reloadFlag = ReloadFlag.FORCE_RELOAD;
            }
            baseDir.putUserData(FORCE_RELOAD_ON_OPENING, null);
        }
        if ((openSpec = CMakeWorkspace.getAndClearSourceAndGenerationDirToOpen(this.myProject)) != null) {
            this.linkWithProject(openSpec.sourceDir.toPath());
            this.myState = this.createInitialState(openSpec.sourceDir);
            reloadFlag = ReloadFlag.FORCE_RELOAD;
            this.updateSettingsFromOpenSpec(openSpec);
        }
        this.requiredConfigurationOnStartup = this.requiresConfigurationOnStartup();
        if (ourSkipReloadOnProjectOpenInTests == Boolean.TRUE) {
            ((CMakeWorkspaceLoadDependencyService)this.myProject.getService(CMakeWorkspaceLoadDependencyService.class)).getFuture().complete(ReloadFlag.RELOAD_ONLY_WHEN_CHANGED);
            reloadFlag = null;
        }
        return this.isLinked() && this.initialize(reloadFlag, projectOpening);
    }

    private boolean requiresConfigurationOnStartup() {
        return this.isLinked() && !ApplicationManager.getApplication().isHeadlessEnvironment() && AdvancedSettings.getBoolean((String)"cmake.initial.project.configuration") && (this.mySettings.needsCMakeConfiguration() || !CMakeReloadStartedListener.reloaded(this.myProject)) && !AbstractNewProjectStep.created((Project)this.myProject);
    }

    public boolean isRequiredConfigurationOnStartup() {
        return this.requiredConfigurationOnStartup;
    }

    private boolean initialize(@Nullable ReloadFlag reloadFlagOrNullForNoReload, boolean projectOpening) {
        if (!super.initializeAndStart()) {
            return false;
        }
        ModalityUiUtil.invokeLaterIfNeeded(() -> {
            OCRootsSynchronizer.getInstance((Project)this.myProject).installLegacyClasspathStorage(CLIENT_KEY);
            if (projectOpening) {
                JpsProjectLoadingManager.getInstance((Project)this.myProject).jpsProjectLoaded(() -> ModalityUiUtil.invokeLaterIfNeeded(() -> WriteAction.run(() -> this.updateContentRoots(true)), (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed()));
            }
            boolean loadPreviousModelOutput = this.myStateWasLoaded && reloadFlagOrNullForNoReload != ReloadFlag.FORCE_RELOAD;
            this.initToolWindow(loadPreviousModelOutput);
            this.myStateWasLoaded = false;
            this.listenForChanges();
            ((CidrWorkspaceListener)this.myProject.getMessageBus().syncPublisher(CidrWorkspaceListener.TOPIC)).initialized((CidrWorkspace)this);
            if (reloadFlagOrNullForNoReload != null) {
                ((CMakeWorkspaceLoadDependencyService)this.myProject.getService(CMakeWorkspaceLoadDependencyService.class)).getFuture().complete(reloadFlagOrNullForNoReload);
                this.scheduleReload(new CMakeWorkspaceReloadTask(reloadFlagOrNullForNoReload));
            }
        }, (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
        return true;
    }

    private void updateSettingsFromOpenSpec(@NotNull CMakeProjectOpenProcessor.OpenProjectSpec openSpec) {
        if (openSpec == null) {
            CMakeWorkspace.$$$reportNull$$$0(4);
        }
        if (openSpec.generationDir != null) {
            CMakeGeneratorType type;
            File normalizedGenerationDir = openSpec.isInSourceGeneration() ? new File(".") : openSpec.generationDir;
            CMakeSettings.Profile profile = new CMakeSettings.Profile(openSpec.buildType).withGenerationDir(normalizedGenerationDir);
            if (openSpec.generator != null && (type = CMakeGeneratorType.fromGeneratorSpec(openSpec.generator)) != null && type.isExplicit()) {
                profile = profile.withGenerationOptions("-G \"" + openSpec.generator + "\"");
            }
            this.getSettings().setProfiles(Collections.singletonList(profile));
        }
    }

    @Nullable
    private static CMakeProjectOpenProcessor.OpenProjectSpec getAndClearSourceAndGenerationDirToOpen(@NotNull Project project) {
        if (project == null) {
            CMakeWorkspace.$$$reportNull$$$0(5);
        }
        return (CMakeProjectOpenProcessor.OpenProjectSpec)CMakeProjectOpenProcessor.getHelper().getAndClearFileToOpenData(project);
    }

    private void listenForChanges() {
        Disposer.register((Disposable)this.myProject, (Disposable)this.myBusConnectionDisposable);
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect(this.myBusConnectionDisposable);
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this.myBusConnectionDisposable);
        appConnection.subscribe(CPPToolchainsListener.TOPIC, (Object)new CPPToolchainsListener(){

            public void toolchainCMakeEnvironmentChanged(@NotNull Set<CPPToolchains.Toolchain> toolchains2) {
                if (toolchains2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                List changedToolchains = ContainerUtil.map(toolchains2, CPPToolchains.Toolchain::getName);
                CPPToolchains.Toolchain defaultToolchain = CPPToolchains.getInstance().getDefaultToolchain();
                Optional<String> firstChangedUsedToolchain = CMakeWorkspace.this.mySettings.getActiveProfiles().stream().map(item -> {
                    String name2 = item.getToolchainName();
                    if (name2 == null && defaultToolchain != null) {
                        name2 = defaultToolchain.getName();
                    }
                    return name2;
                }).distinct().filter(changedToolchains::contains).findFirst();
                if (defaultToolchain == null || firstChangedUsedToolchain.isPresent()) {
                    CMakeWorkspace.this.scheduleReload(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolchains", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$1", "toolchainCMakeEnvironmentChanged"));
            }
        });
        connection.subscribe(CMakeSettingsListener.Companion.getTOPIC(), (Object)this.myProfilesListener);
        connection.subscribe(RemoteDeploymentListener.TOPIC, () -> this.scheduleReload(true));
        this.myWorkspaceWatcher.listenForChanges();
    }

    public boolean unload(boolean projectClosing) {
        if (!super.unload(projectClosing)) {
            return false;
        }
        this.cancelActiveReload();
        this.myWorkspaceWatcher.shutdown();
        if (this.myOutputConsole != null) {
            this.myOutputConsole.shutdown();
        }
        Disposer.dispose((Disposable)this.myBusConnectionDisposable);
        if (!this.myProject.isDisposed()) {
            ((CidrWorkspaceListener)this.myProject.getMessageBus().syncPublisher(CidrWorkspaceListener.TOPIC)).shutdown((CidrWorkspace)this);
        }
        if (!projectClosing) {
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        }
        return true;
    }

    public void unloadWorkspace() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isInitialized()) {
            return;
        }
        this.linkWithProject(null, true);
        this.scheduleReload(CMakeWorkspaceReloadTask.getInstance(true, () -> this.unload(false)));
    }

    @TestOnly
    public void shutdownWatcher() {
        this.myWorkspaceWatcher.shutdown();
    }

    private void initToolWindow(boolean loadPreviousModelOutput) {
        this.myOutputConsole = new CMakeOutputConsole(this.myProject);
        if (this.myState.model == null) {
            loadPreviousModelOutput = false;
        }
        List<CMakeProfileInfo> infos = this.collectProfilesInfos(this.getSettings().getActiveProfiles(), false);
        this.myOutputConsole.restoreTabs(this.getProjectPathOrNull(), infos, loadPreviousModelOutput);
        this.myOutputConsole.listenForChanges();
    }

    @Nullable
    public static ToolWindow getToolWindow(@NotNull Project project) {
        if (project == null) {
            CMakeWorkspace.$$$reportNull$$$0(6);
        }
        return CMakeOutputConsole.getToolWindow(project);
    }

    @NotNull
    public CMakeOutputConsole getConsole() {
        CMakeOutputConsole cMakeOutputConsole = this.myOutputConsole;
        if (cMakeOutputConsole == null) {
            CMakeWorkspace.$$$reportNull$$$0(7);
        }
        return cMakeOutputConsole;
    }

    @NotNull
    public CMakeSettings getSettings() {
        CMakeSettings cMakeSettings = this.mySettings;
        if (cMakeSettings == null) {
            CMakeWorkspace.$$$reportNull$$$0(8);
        }
        return cMakeSettings;
    }

    @NotNull
    public static Path getProjectCacheDir(@NotNull Project project) {
        if (project == null) {
            CMakeWorkspace.$$$reportNull$$$0(9);
        }
        Path path = ProjectUtil.getProjectDataPath((Project)project, (String)CACHE_DIR_NAME);
        if (path == null) {
            CMakeWorkspace.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    public File getProjectCacheModelFile() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        File file = CMakeWorkspace.getProjectCacheDir(this.myProject).resolve("CMakeModel").toFile();
        if (file == null) {
            CMakeWorkspace.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    public static Path getBrokenMarkerDir() {
        Path path = PathManagerEx.getAppSystemDir().resolve(CACHE_DIR_NAME);
        if (path == null) {
            CMakeWorkspace.$$$reportNull$$$0(12);
        }
        return path;
    }

    @NotNull
    private static Path getBrokenMarkerFile() {
        Path path = CMakeWorkspace.getBrokenMarkerDir().resolve(".broken");
        if (path == null) {
            CMakeWorkspace.$$$reportNull$$$0(13);
        }
        return path;
    }

    public static void invalidateCaches() {
        PathKt.createFile((Path)CMakeWorkspace.getBrokenMarkerFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCaches(@NotNull Project project) {
        if (project == null) {
            CMakeWorkspace.$$$reportNull$$$0(14);
        }
        Ref<Boolean> ref = ourCheckCachesValidity;
        synchronized (ref) {
            if (((Boolean)ourCheckCachesValidity.get()).booleanValue()) {
                ourCheckCachesValidity.set((Object)false);
                if (Files.exists(CMakeWorkspace.getBrokenMarkerFile(), new LinkOption[0])) {
                    PathKt.delete((Path)CMakeWorkspace.getProjectCacheDir(project));
                    ProjectUtil.clearCachesForAllProjects((String)CACHE_DIR_NAME);
                    if (!FileUtil.delete((File)CMakeWorkspace.getBrokenMarkerDir().toFile())) {
                        LOG.warn("Cannot delete broken marker for CMake cache: " + CMakeWorkspace.getBrokenMarkerDir());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void setCheckCachesValidity(boolean value) {
        Ref<Boolean> ref = ourCheckCachesValidity;
        synchronized (ref) {
            ourCheckCachesValidity.set((Object)value);
        }
    }

    public static int getSerializationVersion() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ourSerializationVersionInTests;
        }
        return 129003;
    }

    @NotNull
    public List<File> getEffectiveProfileGenerationDirs(@NotNull @NotNull List<@NotNull Pair<@NotNull String, @Nullable File>> profileNamesWithSpecifiedDirs) {
        if (profileNamesWithSpecifiedDirs == null) {
            CMakeWorkspace.$$$reportNull$$$0(15);
        }
        List<@NotNull String> dirNames = CMakeWorkspace.getProfileGenerationDirNames(ContainerUtil.map(profileNamesWithSpecifiedDirs, it -> (String)it.getFirst()));
        if (ApplicationManager.getApplication().isUnitTestMode() && ourForceUseStandardDirForGenerationInTests != Boolean.TRUE) {
            List list = ContainerUtil.map(dirNames, it -> CMakeWorkspace.getProjectCacheDir(this.myProject).resolve((String)it).toFile());
            if (list == null) {
                CMakeWorkspace.$$$reportNull$$$0(16);
            }
            return list;
        }
        List list = ContainerUtil.map((Iterable)ContainerUtil.zip(profileNamesWithSpecifiedDirs, dirNames), it -> {
            Path configDirPath;
            String configDirName = (String)it.second;
            try {
                configDirPath = Paths.get(configDirName, new String[0]);
            }
            catch (InvalidPathException ex) {
                LOG.error((Throwable)ex);
                configDirPath = Paths.get("", new String[0]);
            }
            File specifiedDir = (File)((Pair)it.first).second;
            Path specifiedPath = null;
            try {
                specifiedPath = specifiedDir != null ? specifiedDir.toPath() : null;
            }
            catch (InvalidPathException ex) {
                LOG.warn((Throwable)ex);
            }
            return this.getProjectSubDir(specifiedPath == null ? configDirPath : specifiedPath).toFile();
        });
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public static @NotNull List<@NotNull String> getProfileGenerationDirNames(@NotNull @NotNull List<@NotNull String> profileNames) {
        if (profileNames == null) {
            CMakeWorkspace.$$$reportNull$$$0(18);
        }
        profileNames = ContainerUtil.map(profileNames, it -> StringUtil.toLowerCase((String)FileUtil.sanitizeFileName((String)it, (boolean)false, (String)"").replaceAll("\\s", "-")));
        profileNames = CPPSettingsUtil.deduplicateNames((List)profileNames, (String)"name-number");
        List list = ContainerUtil.map((Collection)profileNames, it -> "cmake-build-" + it);
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(19);
        }
        return list;
    }

    void clearGeneratedFiles() {
        ArrayList<File> toClear = new ArrayList<File>();
        toClear.addAll(this.myState.getAllGenerationDirs());
        toClear.addAll(this.collectProfilesGenerationDirs(this.getSettings().getProfiles()));
        ContainerUtil.removeDuplicates(toClear);
        for (File eachDir : toClear) {
            CMakeGenerator.cleanGeneratedCMakeFiles(eachDir.toPath());
        }
        CMakeWorkspace.refreshGeneratedDirs(toClear, null);
        this.getProfileInfos().stream().filter(p -> p.getEnvironment() != null).map(p -> p.getEnvironment().getHostMachine().getPath(p.getGenerationDir().getPath(), new String[0])).forEach(dir -> CMakeGenerator.cleanGeneratedCMakeFiles(dir));
    }

    private static void refreshGeneratedDirs(List<File> toRefresh, @Nullable Runnable onFinish) {
        if (!toRefresh.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(toRefresh, true, true, onFinish);
        } else if (onFinish != null) {
            onFinish.run();
        }
    }

    @NotNull
    public List<CMakeModelConfigurationData> getModelConfigurationData() {
        State state = this.myState;
        List<CMakeModelConfigurationData> list = state.model == null ? Collections.emptyList() : state.model.getConfigurationData();
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(20);
        }
        return list;
    }

    public <T> Future<T> lockModelDuring(Callable<? extends T> callable) {
        return this.myWorkspaceWatcher.lockModelDuring(callable);
    }

    @TestOnly
    public void setReloadInBackgroundInTests(boolean value, @NotNull Disposable disposable) {
        if (disposable == null) {
            CMakeWorkspace.$$$reportNull$$$0(21);
        }
        this.myWorkspaceWatcher.setReloadInBackgroundInTests(value, disposable);
    }

    @TestOnly
    public void waitForReloadsToFinish(int millis) throws TimeoutException {
        this.myWorkspaceWatcher.waitForReloadsToFinish(millis);
    }

    public void cancelActiveReload() {
        this.myWorkspaceWatcher.cancelActiveReload();
    }

    @TestOnly
    public void stopReloadsOnDocumentChange() {
        this.myWorkspaceWatcher.stopReloadsOnDocumentChange();
    }

    @TestOnly
    public void resumeReloadsOnDocumentChange() {
        this.myWorkspaceWatcher.resumeReloadsOnDocumentChange();
    }

    public void scheduleReload() {
        this.scheduleReload(true);
    }

    public void scheduleReload(boolean force) {
        this.scheduleReload(CMakeWorkspaceReloadTask.getInstance(force));
    }

    void scheduleReload(@NotNull CMakeWorkspaceReloadTask task2) {
        if (task2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(22);
        }
        if (!this.isInitialized()) {
            return;
        }
        if (!TrustedProjects.isTrusted((Project)this.myProject)) {
            LOG.warn("scheduleReload is ignored for untrusted project: " + this.myProject.getName());
            CMakeTrustedProjectsNotificationsKt.showUntrustedCMakeNotification(this.myProject);
            return;
        }
        this.myWorkspaceWatcher.scheduleReload(indicator -> this.doReload((ProgressIndicator)indicator, task2), task2.getReloadFlag());
    }

    public void selectProjectDir(@NotNull File newProjectDir) {
        if (newProjectDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.linkWithProject(newProjectDir.toPath(), true);
        if (!this.isInitialized()) {
            CidrWorkspaceUsageCounterCollector.logProjectLinked((String)CLIENT_KEY, (Project)this.getProject());
            if (this.isLinked()) {
                this.executePostStartup(() -> this.initialize(ReloadFlag.FORCE_RELOAD, false));
            }
        } else {
            this.scheduleReload(true);
        }
    }

    public void scheduleClearGeneratedFilesAndReload() {
        this.myClearGeneratedFilesBeforeReload = true;
        this.scheduleReload(true);
    }

    private <T> T runReadActionCanceling(Computable<T> computable) {
        return (T)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            ProgressManager.checkCanceled();
            return computable.compute();
        });
    }

    private void runReadActionCanceling(Runnable runnable2) {
        this.runReadActionCanceling(() -> {
            runnable2.run();
            return null;
        });
    }

    public void ignoreNextProfilesChangedEvent(boolean ignore) {
        this.myProfilesListener.ignoreNextProfilesChangedEvent = ignore;
    }

    private void doReload(@NotNull ProgressIndicator indicator, @NotNull CMakeWorkspaceReloadTask task2) {
        if (indicator == null) {
            CMakeWorkspace.$$$reportNull$$$0(24);
        }
        if (task2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(25);
        }
        LOG.trace("doReload");
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new AssertionError((Object)"CMake reloading should not be initiated from writeAction. Will cause a deadlock.");
        }
        long startTime = System.currentTimeMillis();
        if (this.myClearGeneratedFilesBeforeReload) {
            this.myClearGeneratedFilesBeforeReload = false;
            this.clearGeneratedFiles();
        }
        ourReloadsCounter.incrementAndGet();
        if (task2.isUpdateContentRoots()) {
            LOG.trace("doReload.updateContentRoots()");
            WriteAction.runAndWait(() -> {
                if (!this.myProject.isDisposed()) {
                    this.updateContentRoots(true);
                }
            });
        }
        CMakeWorkspaceListener publisher = (CMakeWorkspaceListener)this.runReadActionCanceling(() -> {
            CMakeWorkspaceListener result = (CMakeWorkspaceListener)this.myProject.getMessageBus().syncPublisher(CMakeWorkspaceListener.TOPIC);
            result.reloadingStarted();
            return result;
        });
        CidrWorkspaceManager.getInstance((Project)this.myProject).markLoadingModel((CidrWorkspace)this);
        if (ourPauseOnReloadInTests != null && CMakeWorkspace.ourPauseOnReloadInTests.first != null) {
            try {
                Thread.sleep(((Integer)CMakeWorkspace.ourPauseOnReloadInTests.first).intValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean canceled2 = false;
        try {
            Pair<State, OCWorkspace.ModifiableModel> newStateAndWorkspaceModel;
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            });
            ProgressManager.checkCanceled();
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (task2.getLoadPresets() || task2.getReloadFlag() == ReloadFlag.FORCE_RELOAD) {
                new CMakePresetLoader(this.myProject, this).load(true);
            }
            Ref toRefresh = new Ref();
            Ref modelFile = new Ref();
            Runnable fireGenerationStartedCanceling = () -> this.runReadActionCanceling(() -> publisher.generationStarted());
            Runnable fireGenerationFinishedNonCanceling = () -> ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                publisher.generationFinished();
            });
            Runnable fireFileRefreshedNonCanceling = () -> ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                publisher.filesRefreshedAfterGeneration();
            });
            State previousState = this.myState;
            OCWorkspace.ModifiableModel createdWorkspaceModel = null;
            try {
                newStateAndWorkspaceModel = this.doGenerateProject(this.getProjectPathOrNull(), previousState, indicator, fireGenerationStartedCanceling, fireGenerationFinishedNonCanceling);
                createdWorkspaceModel = (OCWorkspace.ModifiableModel)newStateAndWorkspaceModel.second;
                this.runReadActionCanceling(() -> {
                    toRefresh.set(((State)newStateAndWorkspaceModel.first).getAllGenerationDirs());
                    modelFile.set((Object)this.getProjectCacheModelFile());
                });
            }
            catch (Throwable e) {
                if (createdWorkspaceModel != null) {
                    createdWorkspaceModel.dispose();
                }
                try {
                    fireFileRefreshedNonCanceling.run();
                }
                catch (Throwable suppressed) {
                    e.addSuppressed(suppressed);
                }
                ExceptionUtil.rethrow((Throwable)e);
                throw new RuntimeException(e);
            }
            CMakeWorkspace.refreshGeneratedDirs((List)toRefresh.get(), fireFileRefreshedNonCanceling);
            CMakeWorkspace.saveState((State)newStateAndWorkspaceModel.first, (File)modelFile.get());
            WriteAction.runAndWait(() -> {
                if (this.myProject.isDisposed()) {
                    ((OCWorkspace.ModifiableModel)newStateAndWorkspaceModel.second).dispose();
                    return;
                }
                publisher.beforeApplying();
                State oldState = this.myState;
                this.myState = (State)newStateAndWorkspaceModel.first;
                ((OCWorkspace.ModifiableModel)newStateAndWorkspaceModel.second).commit();
                this.updateExecutionTargets();
                this.updateProjectName(oldState.model, this.myState.model);
                this.updateContentRoots();
                this.reportFilesOutsideContentRoot(CLionCMakeBundle.message("cmake.filesOutsideOfProject", new Object[0]), CLIENT_KEY);
            });
            if (!this.myProject.isDisposed()) {
                publisher.afterApplyingNoLocks();
            }
        }
        catch (ProcessCanceledException e) {
            canceled2 = true;
            throw e;
        }
        finally {
            boolean finalCanceled = canceled2;
            this.myLastReloadWasCanceled = canceled2;
            if (LOG.isTraceEnabled()) {
                LOG.trace("lastReloadWasCanceled = " + this.myLastReloadWasCanceled);
            }
            WriteAction.runAndWait(() -> {
                if (!this.myProject.isDisposed()) {
                    publisher.reloadingFinished(finalCanceled);
                    CidrWorkspaceManager.getInstance((Project)this.myProject).markModelLoaded((CidrWorkspace)this);
                }
            });
            if (task2.getCallback() != null) {
                task2.getCallback().run();
            }
            if (ourPauseOnReloadInTests != null && CMakeWorkspace.ourPauseOnReloadInTests.second != null) {
                try {
                    Thread.sleep(((Integer)CMakeWorkspace.ourPauseOnReloadInTests.second).intValue());
                }
                catch (InterruptedException interruptedException) {}
            }
            LOG.info("Reloading CMake project took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - startTime)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Pair<State, OCWorkspace.ModifiableModel> doGenerateProject(@Nullable Path projectDir, @NotNull State currentState, @NotNull ProgressIndicator indicator, @NotNull Runnable beforeGeneration, @NotNull Runnable afterGeneration) {
        boolean hasValidProfilesOrThereAreNoProfilesAtAll;
        File cmakeLists;
        if (currentState == null) {
            CMakeWorkspace.$$$reportNull$$$0(26);
        }
        if (indicator == null) {
            CMakeWorkspace.$$$reportNull$$$0(27);
        }
        if (beforeGeneration == null) {
            CMakeWorkspace.$$$reportNull$$$0(28);
        }
        if (afterGeneration == null) {
            CMakeWorkspace.$$$reportNull$$$0(29);
        }
        List<CMakeSettings.Profile> profiles = this.mySettings.getActiveProfiles();
        List<CMakeProfileInfo> profileInfos = this.collectProfilesInfos(profiles, true);
        ProfilesAndEnvHash profilesAndEnvHash = CMakeWorkspace.calcProfilesAndEnvHash(profileInfos, true);
        this.myOutputConsole.updateTabs(projectDir, profileInfos);
        this.myOutputConsole.reloadingStarted(indicator);
        boolean hasCMakeLists = false;
        if (projectDir != null && !(hasCMakeLists = (cmakeLists = projectDir.resolve("CMakeLists.txt").toFile()).exists())) {
            CMakeOutputConsole.Fix fix = new CMakeOutputConsole.Fix(CLionCMakeBundle.message("cmake.loadCMakeNotification.action.select", new Object[0]), () -> LoadCMakeProjectAction.selectAndLoadCMakeProject(this.myProject));
            this.myOutputConsole.reportMessage(-1, CMakeMessage.fatalError(CLionCMakeBundle.message("cmake.lists.not.found.in", "CMakeLists.txt", projectDir), cmakeLists), fix);
        }
        if (projectDir == null || !hasCMakeLists || !FileUtil.filesEqual((File)projectDir.toFile(), (File)currentState.projectDir)) {
            currentState = this.createInitialState(projectDir != null ? projectDir.toFile() : null);
        }
        ArrayList<Integer> validProfileIndexes = new ArrayList<Integer>(profiles.size());
        for (int i = 0; i < profileInfos.size(); ++i) {
            CMakeProfileInfo profileInfo = profileInfos.get(i);
            EnvironmentProblems problems = profileInfo.getEnvironmentAndCMakeProblems();
            if (problems.hasProblems()) {
                for (EnvironmentProblems.Problem eachProblem : problems.getProblems()) {
                    CMakeMessage message2 = new CMakeMessage(CMakeMessage.MessageLevel.FATAL_ERROR, null, null, eachProblem.getMessage());
                    ArrayList<EnvironmentProblems.Fix> fixes = new ArrayList<EnvironmentProblems.Fix>(eachProblem.getFixes());
                    fixes.add(new EnvironmentProblems.Fix(CLionCMakeBundle.message("action.disable.profile.text", new Object[0]), () -> ApplicationManager.getApplication().runWriteAction(() -> this.mySettings.setProfiles(CMakeSettings.toggleProfileInList(profileInfo.getProfile(), this.mySettings.getProfiles())))));
                    this.myOutputConsole.reportMessage(i, message2, ContainerUtil.map(fixes, CMakeOutputConsole.Fix::new));
                }
                continue;
            }
            validProfileIndexes.add(i);
        }
        boolean bl = hasValidProfilesOrThereAreNoProfilesAtAll = !validProfileIndexes.isEmpty() || profileInfos.isEmpty();
        if (hasCMakeLists && hasValidProfilesOrThereAreNoProfilesAtAll) {
            CMakeModel model;
            this.syncWithRemoteHosts(profileInfos, projectDir);
            Charset defaultCharset = (Charset)this.runReadActionCanceling(() -> EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
            HashMap<Integer, CMakeProfileInfo> indexedProfileInfos = new HashMap<Integer, CMakeProfileInfo>();
            List parameters = ContainerUtil.mapNotNull(validProfileIndexes, index -> {
                CMakeSettings.Profile profile = (CMakeSettings.Profile)profiles.get((int)index);
                String profileName = profile.getName();
                String buildType2 = profile.getBuildType();
                CMakeProfileInfo profileInfo = (CMakeProfileInfo)profileInfos.get((int)index);
                File effectiveGenerationDir = profileInfo.getGenerationDir();
                CPPEnvironment environment2 = profileInfo.getEnvironment();
                assert (environment2 != null);
                indexedProfileInfos.put((Integer)index, profileInfo);
                CMakeListener listener = new CMakeListener((Integer)index){
                    final /* synthetic */ Integer val$index;
                    {
                        this.val$index = n;
                    }

                    @Override
                    public void message(@NotNull CMakeMessage message) {
                        if (message == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        CMakeWorkspace.this.myOutputConsole.reportMessage(this.val$index, message);
                    }

                    @Override
                    public void attachTo(@NotNull ProcessHandler handler2) {
                        if (handler2 == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        CMakeWorkspace.this.myOutputConsole.attachConsoleToProcess(this.val$index, handler2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "message";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "handler";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "message";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "attachTo";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                int profileId = index;
                CMakeGenerator.Parameters p = new CMakeGenerator.Parameters(profileId, profileName, buildType2, effectiveGenerationDir, profile.getEffectiveGenerationOptionsList(environment2, this.myProject), profile.getPassSystemEnvironment(), profile.getAdditionalEnvironment(), listener, environment2);
                return ourGenerationParametersConfigurator == null ? p : (CMakeGenerator.Parameters)ourGenerationParametersConfigurator.fun((Object)p);
            });
            beforeGeneration.run();
            try {
                model = new CMakeGenerator(this.myProject, projectDir.toFile(), parameters, this.determineEncoding(projectDir.toFile(), defaultCharset), defaultCharset).generate(currentState.model, indicator);
            }
            finally {
                afterGeneration.run();
            }
            ProgressManager.checkCanceled();
            currentState = this.createStateWithModel(profilesAndEnvHash, projectDir.toFile(), model, indexedProfileInfos, currentState);
        }
        ProgressManager.checkCanceled();
        long startTime = System.currentTimeMillis();
        OCWorkspace.ModifiableModel modifiableModel = this.updateOCWorkspace(indicator, currentState.model, currentState.profileInfos, (tabIndex, message) -> this.myOutputConsole.reportMessage((int)tabIndex, (CMakeMessage)message));
        LOG.info("Updating CMake workspace took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - startTime)));
        Pair pair = Pair.create((Object)currentState, (Object)modifiableModel);
        if (pair == null) {
            CMakeWorkspace.$$$reportNull$$$0(30);
        }
        return pair;
    }

    @NotNull
    private List<File> collectProfilesGenerationDirs(@NotNull List<CMakeSettings.Profile> profiles) {
        if (profiles == null) {
            CMakeWorkspace.$$$reportNull$$$0(31);
        }
        List<File> list = this.getEffectiveProfileGenerationDirs(ContainerUtil.map(profiles, it -> Pair.create((Object)it.getName(), (Object)it.getGenerationDir())));
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    private List<CMakeProfileInfo> collectProfilesInfos(@NotNull List<CMakeSettings.Profile> profiles, boolean checkIfEnvironmentFunctional) {
        if (profiles == null) {
            CMakeWorkspace.$$$reportNull$$$0(33);
        }
        List generationDirs = (List)this.runReadActionCanceling(() -> this.collectProfilesGenerationDirs(profiles));
        int[] counter = new int[]{0};
        List list = ContainerUtil.map((Iterable)ContainerUtil.zip(profiles, (Iterable)generationDirs), it -> {
            int n = counter[0];
            counter[0] = n + 1;
            int profileIndex = n;
            ProgressManager.checkCanceled();
            EnvironmentProblems problems = new EnvironmentProblems();
            CPPEnvironment environment2 = ourEnvironmentFactory == null ? CPPToolchains.createCPPEnvironment((Project)this.myProject, (File)this.getProjectPath().toFile(), (String)((CMakeSettings.Profile)it.first).getToolchainName(), (EnvironmentProblems)problems, (boolean)checkIfEnvironmentFunctional, () -> OpenCMakeSettingsAction.openProfile(this.myProject, profileIndex)) : (CPPEnvironment)ourEnvironmentFactory.invoke((Object)this.myProject, (Object)((CMakeSettings.Profile)it.first), (Object)problems, (Object)checkIfEnvironmentFunctional);
            if (checkIfEnvironmentFunctional && environment2 != null) {
                environment2.getCMakeChecked(this.myProject, problems);
            }
            return new CMakeProfileInfo((CMakeSettings.Profile)it.first, (File)it.second, environment2, problems);
        });
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    private static ProfilesAndEnvHash calcProfilesAndEnvHash(List<CMakeProfileInfo> profileInfos, boolean calcEnvHash) {
        long profilesHash = CMakeSettings.calcProfilesHash(profileInfos);
        long envHash = 0L;
        if (calcEnvHash) {
            Application application = ApplicationManager.getApplication();
            LOG.assertTrue(application.isUnitTestMode() || !application.isReadAccessAllowed(), (Object)"calcProfilesAndEnvHash(calcEnvHash=true) must not be called from UI/readAction");
            CRC32 crc = new CRC32();
            profileInfos.forEach(info -> {
                CPPEnvironment env = info.getEnvironment();
                crc.update(env == null ? 0 : 1);
                if (env != null) {
                    crc.update(env.calcToolchainHash().getBytes(StandardCharsets.UTF_8));
                    CMakeExecutableTool cmake = env.getCMake();
                    if (cmake == null) {
                        crc.update(0);
                    } else {
                        crc.update(cmake.calcCMakeHash().getBytes(StandardCharsets.UTF_8));
                    }
                }
            });
            envHash = crc.getValue();
        }
        return new ProfilesAndEnvHash(profilesHash, envHash);
    }

    @Nullable
    private String determineEncoding(@NotNull File projectDir, @NotNull Charset defaultCharset) {
        if (projectDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(35);
        }
        if (defaultCharset == null) {
            CMakeWorkspace.$$$reportNull$$$0(36);
        }
        Charset[] charset = new Charset[]{null};
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            VirtualFile file = VfsUtil.findFileByIoFile((File)new File(projectDir, "CMakeLists.txt"), (boolean)true);
            charset[0] = file == null ? null : file.getCharset();
        });
        if (charset[0] == null || defaultCharset.equals(charset[0])) {
            return null;
        }
        return charset[0].name();
    }

    @NotNull
    private State createInitialState(@Nullable File projectDir) {
        Set cmakeFiles = ContainerUtil.createMaybeSingletonSet((Object)(projectDir == null ? null : new File(projectDir, "CMakeLists.txt")));
        Map<Object, Object> cmakeFilesWithStamps = cmakeFiles.isEmpty() ? Collections.emptyMap() : this.calculateFileStamps(cmakeFiles, Collections.emptyMap());
        return new State(projectDir, cmakeFilesWithStamps);
    }

    @NotNull
    private State createStateWithModel(@NotNull ProfilesAndEnvHash profilesAndEnvHash, @NotNull File projectDir, @NotNull CMakeModel model, @NotNull Map<Integer, CMakeProfileInfo> profileInfos, @NotNull State previousState) {
        if (profilesAndEnvHash == null) {
            CMakeWorkspace.$$$reportNull$$$0(37);
        }
        if (projectDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(38);
        }
        if (model == null) {
            CMakeWorkspace.$$$reportNull$$$0(39);
        }
        if (profileInfos == null) {
            CMakeWorkspace.$$$reportNull$$$0(40);
        }
        if (previousState == null) {
            CMakeWorkspace.$$$reportNull$$$0(41);
        }
        Set dependencyFiles = FileCollectionFactory.createCanonicalFileSet(model.getCMakeDependencyFiles());
        dependencyFiles.add(new File(projectDir, "CMakeLists.txt"));
        Map<File, FileStamp> dependencyFilesWithStamps = this.calculateFileStamps(dependencyFiles, previousState.cmakeDependencyFilesWithStamps);
        return new State(projectDir, profilesAndEnvHash, model, profileInfos, dependencyFilesWithStamps);
    }

    private static boolean needsCCBinFlag(@NotNull OCLanguageKind languageKind, @NotNull CidrSwitchBuilder languageSwitchBuilder, @Nullable String ccbinOption) {
        if (languageKind == null) {
            CMakeWorkspace.$$$reportNull$$$0(42);
        }
        if (languageSwitchBuilder == null) {
            CMakeWorkspace.$$$reportNull$$$0(43);
        }
        if (ccbinOption == null || !languageKind.isCuda()) {
            return false;
        }
        return NVCCCompiler.Companion.getCCBinOption(languageSwitchBuilder.getArgs()) == null;
    }

    @NotNull
    private OCWorkspace.ModifiableModel updateOCWorkspace(@NotNull ProgressIndicator indicator, @Nullable CMakeModel model, @NotNull Map<Integer, CMakeProfileInfo> profileInfos, @NotNull BiConsumer<Integer, CMakeMessage> messagesCollector) {
        if (indicator == null) {
            CMakeWorkspace.$$$reportNull$$$0(44);
        }
        if (profileInfos == null) {
            CMakeWorkspace.$$$reportNull$$$0(45);
        }
        if (messagesCollector == null) {
            CMakeWorkspace.$$$reportNull$$$0(46);
        }
        OCWorkspace.ModifiableModel workspaceModel = OCWorkspace.getInstance((Project)this.myProject).getModifiableModel(CLIENT_KEY, true);
        CompilerInfoCache.Session compilerInfoSession = new CompilerInfoCache().createSession(indicator);
        try {
            String cudaCCBinOption = null;
            workspaceModel.setClientVersion(CMakeWorkspace.getSerializationVersion());
            if (model != null) {
                for (CMakeTarget eachTarget : model.getTargets()) {
                    for (CMakeConfiguration cmakeConfig : eachTarget.getBuildConfigurations()) {
                        CPPEnvironment environment2 = profileInfos.get(cmakeConfig.getProfileId()).getEnvironment();
                        assert (environment2 != null) : "environment should have been checked already";
                        OCResolveConfiguration.ModifiableModel config = workspaceModel.addConfiguration(CMakeWorkspace.getCMakeConfigurationId(cmakeConfig), eachTarget.getName(), new OCVariant(cmakeConfig.getName()), environment2.getSupportedFileSeparators());
                        for (File source : cmakeConfig.getSources()) {
                            CMakeFileSettings settings = cmakeConfig.getFileSettings(source);
                            if (settings == null) continue;
                            OCLanguageKind languageKind = settings.getLanguageKind();
                            CidrCompilerSwitches switches = null;
                            if (settings.hasCustomSettings() || languageKind.isCuda()) {
                                List<String> combinedCompilerFlags = cmakeConfig.getCombinedCompilerFlags(languageKind, source);
                                if (cmakeConfig.getSupportedLanguages().contains(CUDALanguageKind.CUDA)) {
                                    cudaCCBinOption = NVCCCompiler.Companion.getCCBinOption(combinedCompilerFlags);
                                }
                                switches = new CidrCompilerSwitches(combinedCompilerFlags);
                            }
                            config.addSource(VfsUtilCore.fileToUrl((File)source), languageKind).setCompilerSwitches(switches);
                        }
                        for (OCLanguageKind eachLang : cmakeConfig.getSupportedLanguages()) {
                            OCCompilerSettings.ModifiableModel langSettings = config.getLanguageCompilerSettings(eachLang);
                            CMakeConfigurationSettings settings = cmakeConfig.getSettings(eachLang);
                            langSettings.setCompiler(settings == null ? null : settings.getCompiler().getCompilerKind(), settings == null ? null : settings.getCompilerExecutable(), cmakeConfig.getBuildWorkingDir());
                            CidrSwitchBuilder switchBuilder = new CidrSwitchBuilder();
                            switchBuilder.addAllRaw(cmakeConfig.getCombinedCompilerFlags(eachLang, null));
                            if (CMakeWorkspace.needsCCBinFlag(eachLang, switchBuilder, cudaCCBinOption)) {
                                switchBuilder.addSingleRaw(cudaCCBinOption);
                            }
                            langSettings.setCompilerSwitches(switchBuilder.build());
                        }
                        compilerInfoSession.schedule((Object)cmakeConfig.getProfileId(), config, (CidrToolEnvironment)environment2);
                    }
                }
            }
            MultiMap messages = new MultiMap();
            compilerInfoSession.waitForAll(messages);
            workspaceModel.preCommit();
            CompilerInfoCache.flushConsoleMessages((String)CidrWorkspaceBundle.message((String)"collect.compiler.info.error.message", (Object[])new Object[0]), (CompilerInfoCache.Message.Type)CompilerInfoCache.Message.Type.ERROR, (MultiMap)messages, (key, text) -> messagesCollector.accept((Integer)key, new CMakeMessage(CMakeMessage.MessageLevel.ERROR, null, null, (String)text)));
            CompilerInfoCache.flushConsoleMessages((String)CidrWorkspaceBundle.message((String)"collect.compiler.info.warning.message", (Object[])new Object[0]), (CompilerInfoCache.Message.Type)CompilerInfoCache.Message.Type.WARNING, (MultiMap)messages, (key, text) -> messagesCollector.accept((Integer)key, new CMakeMessage(CMakeMessage.MessageLevel.WARNING, null, null, (String)text)));
        }
        catch (Error | RuntimeException e) {
            compilerInfoSession.dispose();
            workspaceModel.dispose();
            throw e;
        }
        OCWorkspace.ModifiableModel modifiableModel = workspaceModel;
        if (modifiableModel == null) {
            CMakeWorkspace.$$$reportNull$$$0(47);
        }
        return modifiableModel;
    }

    @NotNull
    private Map<File, FileStamp> calculateFileStamps(@NotNull Set<File> files, final @NotNull Map<File, FileStamp> alreadyCalculatedStamps) {
        if (files == null) {
            CMakeWorkspace.$$$reportNull$$$0(48);
        }
        if (alreadyCalculatedStamps == null) {
            CMakeWorkspace.$$$reportNull$$$0(49);
        }
        Map result = FileCollectionFactory.createCanonicalFileMap((int)files.size());
        for (final File each : files) {
            FileStamp.FileStampFunction function = new FileStamp.FileStampFunction(){

                @Override
                public FileStamp getAlreadyCalculatedStamp() {
                    return (FileStamp)alreadyCalculatedStamps.get(each);
                }

                @Override
                @Nullable
                public PsiFile getCMakeFile(@NotNull Project project) {
                    VirtualFile file;
                    if (project == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return (file = VfsUtil.findFileByIoFile((File)each, (boolean)false)) == null ? null : FileStamp.createOrGetCMakeFile(project, file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$3", "getCMakeFile"));
                }
            };
            result.put(each, (FileStamp)this.runReadActionCanceling(() -> FileStamp.calcFileStamp(this.myProject, each, function)));
        }
        Map map2 = result;
        if (map2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(50);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveState(@NotNull State state, @NotNull File file) {
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(51);
        }
        if (file == null) {
            CMakeWorkspace.$$$reportNull$$$0(52);
        }
        try {
            if (!FileUtil.createParentDirs((File)file)) {
                throw new IOException("Cannot create directory: " + file.getParent());
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                out.writeInt(CMakeWorkspace.getSerializationVersion());
                out.writeBoolean(state.projectDir != null);
                if (state.projectDir != null) {
                    out.writeObject(state.projectDir.getPath());
                }
                out.writeBoolean(state.myProfilesAndEnvHash != null);
                if (state.myProfilesAndEnvHash != null) {
                    out.writeLong(state.myProfilesAndEnvHash.profilesHash);
                    out.writeLong(state.myProfilesAndEnvHash.envHash);
                }
                out.writeBoolean(state.model != null);
                if (state.model != null) {
                    state.model.save(out);
                    out.writeInt(state.profileInfos.size());
                    for (Map.Entry<Integer, CMakeProfileInfo> entry : state.profileInfos.entrySet()) {
                        out.writeInt(entry.getKey());
                    }
                    out.writeInt(state.cmakeDependencyFilesWithStamps.size());
                    for (Map.Entry<Comparable<Integer>, Object> entry : state.cmakeDependencyFilesWithStamps.entrySet()) {
                        out.writeObject(((File)entry.getKey()).getPath());
                        FileStamp stamp = (FileStamp)entry.getValue();
                        out.writeLong(stamp.timestamp);
                        out.writeLong(stamp.size);
                        out.writeLong(stamp.contentCrc);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Cannot save CMake model file: " + file, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static State loadStateIfActual(@NotNull File currentProjectDir, @NotNull File modelFile, @NotNull List<CMakeProfileInfo> actualProfileInfos) {
        if (currentProjectDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(53);
        }
        if (modelFile == null) {
            CMakeWorkspace.$$$reportNull$$$0(54);
        }
        if (actualProfileInfos == null) {
            CMakeWorkspace.$$$reportNull$$$0(55);
        }
        if (!modelFile.exists()) {
            return null;
        }
        try {
            File savedProjectDir;
            String string;
            ClassLoaderObjectInputStream in;
            block22: {
                block21: {
                    in = new ClassLoaderObjectInputStream(CMakeWorkspace.class.getClassLoader(), (InputStream)new BufferedInputStream(new FileInputStream(modelFile)));
                    try {
                        int stateVersion = in.readInt();
                        if (stateVersion != CMakeWorkspace.getSerializationVersion()) {
                            State state = null;
                            return state;
                        }
                        if (in.readBoolean()) {
                        }
                        break block21;
                    }
                    catch (IOException ignore) {
                        State state = null;
                        return state;
                    }
                    string = (String)in.readObject();
                    break block22;
                }
                string = null;
            }
            String projectDirPath = string;
            File file = savedProjectDir = projectDirPath != null ? new File(projectDirPath) : null;
            if (!FileUtil.filesEqual((File)savedProjectDir, (File)currentProjectDir)) {
                return null;
            }
            ProfilesAndEnvHash profilesAndEnvHash = null;
            if (in.readBoolean()) {
                profilesAndEnvHash = new ProfilesAndEnvHash(in.readLong(), in.readLong());
            }
            State result = null;
            if (savedProjectDir == null) return result;
            CMakeModel model = in.readBoolean() ? CMakeModel.load((ObjectInputStream)in) : null;
            if (model == null) return result;
            int count = in.readInt();
            THashMap restoredProfileInfos = new THashMap(count);
            while (count-- > 0) {
                int profileIndex = in.readInt();
                if (profileIndex >= actualProfileInfos.size()) return null;
                CMakeProfileInfo cMakeProfileInfo = actualProfileInfos.get(profileIndex);
                CMakeProfileInfo info = cMakeProfileInfo;
                if (info == null) return null;
                if (info.getEnvironment() == null) {
                    return null;
                }
                restoredProfileInfos.put(profileIndex, info);
            }
            int count2 = in.readInt();
            Map cmakeFilesWithStamps = FileCollectionFactory.createCanonicalFileMap((int)count2);
            while (count2-- > 0) {
                cmakeFilesWithStamps.put(new File((String)in.readObject()), new FileStamp(in.readLong(), in.readLong(), in.readLong()));
            }
            result = new State(savedProjectDir, profilesAndEnvHash, model, (Map<Integer, CMakeProfileInfo>)restoredProfileInfos, cmakeFilesWithStamps);
            return result;
            finally {
                in.close();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.warn("Cannot load CMake model file: " + modelFile, (Throwable)e);
            return null;
        }
    }

    private void updateExecutionTargets() {
        ExecutionTargetManager manager = ExecutionTargetManager.getInstance((Project)this.myProject);
        if (manager.getActiveTarget() == DefaultExecutionTarget.INSTANCE) {
            manager.update();
        }
    }

    private void updateProjectName(@Nullable CMakeModel oldModel, @Nullable CMakeModel newModel) {
        ProjectEx projectImpl = (ProjectEx)this.myProject;
        String currentProjectName = projectImpl.getName();
        String defaultProjectName = ProjectKt.getStateStore((Project)projectImpl).getProjectBasePath().getFileName().toString();
        if (!(defaultProjectName.equals(currentProjectName) || oldModel != null && oldModel.getProjectName().equals(currentProjectName))) {
            return;
        }
        String newProjectName = null;
        if (newModel != null && (newProjectName = newModel.getProjectName()).equals("Project")) {
            newProjectName = null;
        }
        projectImpl.setProjectName(StringUtil.notNullize((String)newProjectName, (String)defaultProjectName));
    }

    @Nullable
    protected File beforeUpdateContentRoots(@Nullable File contentRoot) {
        boolean cmakeIsEnabled;
        File cmakeProjectDir = this.myState.projectDir;
        boolean bl = cmakeIsEnabled = cmakeProjectDir != null;
        if (cmakeIsEnabled) {
            this.setContentRoot(cmakeProjectDir.toPath(), contentRoot);
            return this.myContentRoot;
        }
        return this.getProjectPath().toFile();
    }

    @NotNull
    protected OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File contentRoot) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<File> resourceFiles = new ArrayList<File>();
        List<File> roots = CMakeWorkspace.getRoots(this.myState, contentRoot, resourceFiles);
        block0: for (File eachResourceFiles : this.myState.getAllResourceFiles()) {
            for (File eachRoot : roots) {
                if (!VfsUtilCore.isAncestor((File)eachRoot, (File)eachResourceFiles, (boolean)true)) continue;
                resourceFiles.add(eachResourceFiles);
                continue block0;
            }
        }
        List configurations = OCWorkspace.getInstance((Project)this.myProject).getConfigurations(CLIENT_KEY);
        OCRootsSynchronizer.RootsInfo rootsInfo = CMakeWorkspace.createRootsInfo((List)configurations, roots, resourceFiles, (List)ContainerUtil.emptyList());
        if (rootsInfo == null) {
            CMakeWorkspace.$$$reportNull$$$0(56);
        }
        return rootsInfo;
    }

    @NotNull
    public List<File> collectExcludeRoots(@Nullable File contentRoot, boolean includePotentialNotYetExistingExcludes) {
        boolean cmakeIsEnabled;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean bl = cmakeIsEnabled = this.myState.projectDir != null;
        if (!cmakeIsEnabled) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                CMakeWorkspace.$$$reportNull$$$0(57);
            }
            return list;
        }
        List<File> roots = CMakeWorkspace.getRoots(this.myState, contentRoot, null);
        ArrayList<File> result = new ArrayList<File>();
        this.collectProfilesGenerationDirs(this.getSettings().getProfiles()).forEach(eachGenerationDir -> {
            File toExclude = eachGenerationDir;
            if (roots.stream().anyMatch(eachRoot -> FileUtil.isAncestor((File)eachGenerationDir, (File)eachRoot, (boolean)false))) {
                toExclude = new File((File)eachGenerationDir, "CMakeFiles");
            }
            result.add(toExclude);
        });
        for (File eachCMakeRoot : roots) {
            File inSourceCMakeFiles = new File(eachCMakeRoot, "CMakeFiles");
            if (!includePotentialNotYetExistingExcludes && !inSourceCMakeFiles.exists()) continue;
            result.add(inSourceCMakeFiles);
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            CMakeWorkspace.$$$reportNull$$$0(58);
        }
        return arrayList;
    }

    @NotNull
    private static List<File> getRoots(@NotNull State state, @Nullable File contentRoot, @Nullable List<File> rootCMakeFiles) {
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(59);
        }
        ArrayList<File> result = new ArrayList<File>();
        ContainerUtil.addIfNotNull(result, (Object)contentRoot);
        ContainerUtil.addIfNotNull(result, (Object)state.projectDir);
        for (File eachDependencyFile : state.cmakeDependencyFilesWithStamps.keySet()) {
            if (!"CMakeLists.txt".equalsIgnoreCase(eachDependencyFile.getName())) continue;
            ContainerUtil.addIfNotNull(result, (Object)eachDependencyFile.getParentFile());
            if (rootCMakeFiles == null) continue;
            rootCMakeFiles.add(eachDependencyFile);
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            CMakeWorkspace.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    @Nullable
    public VirtualFile getEffectiveContentRoot() {
        VirtualFile result = super.getEffectiveContentRoot();
        if (result != null) {
            return result;
        }
        File root = this.myState.projectDir;
        return root == null ? null : LocalFileSystem.getInstance().findFileByIoFile(root);
    }

    @TestOnly
    static Element createStateElement(@Nullable Path projectDir) {
        return CMakeWorkspace.createStateElement(projectDir, null);
    }

    @TestOnly
    static Element createStateElement(@Nullable Path projectDir, @Nullable File contentRoot) {
        return CidrWorkspace.State.createStateElement((Path)projectDir, (File)contentRoot, (boolean)false);
    }

    @NotNull
    public Element getState() {
        Element element = this.getBaseState().createElement();
        if (element == null) {
            CMakeWorkspace.$$$reportNull$$$0(61);
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        boolean openingExisting;
        if (element == null) {
            CMakeWorkspace.$$$reportNull$$$0(62);
        }
        CidrWorkspace.State cppState = CidrWorkspace.State.loadStateElement((Element)element);
        CMakeProjectOpenProcessor.OpenProjectSpec openSpec = CMakeWorkspace.getAndClearSourceAndGenerationDirToOpen(this.myProject);
        boolean bl = openingExisting = openSpec == null || openSpec.generationDir == null && FileUtil.filesEqual((File)cppState.myProjectDir, (File)openSpec.sourceDir);
        if (!openingExisting) {
            cppState.myProjectDir = openSpec.sourceDir;
            this.updateSettingsFromOpenSpec(openSpec);
            cppState.myContentRoot = null;
            cppState.myIgnoreFilesOutsideOfProjectRoot = false;
        }
        this.loadBaseState(cppState);
        if (this.isInitialized()) {
            if (!FileUtil.filesEqual((File)this.myState.projectDir, (File)cppState.myProjectDir)) {
                if (cppState.myProjectDir == null) {
                    this.unloadWorkspace();
                } else {
                    this.selectProjectDir(cppState.myProjectDir);
                }
            } else {
                ApplicationManager.getApplication().runWriteAction(() -> ((CMakeWorkspace)this).updateContentRoots());
            }
        } else if (cppState.myProjectDir != null) {
            State loadedState = null;
            if (openingExisting) {
                File modelFile = (File)this.runReadActionCanceling(() -> this.getProjectCacheModelFile());
                List<CMakeProfileInfo> profileInfos = this.collectProfilesInfos(this.getSettings().getActiveProfiles(), false);
                loadedState = CMakeWorkspace.loadStateIfActual(cppState.myProjectDir, modelFile, profileInfos);
            }
            if (loadedState != null && OCWorkspace.getInstance((Project)this.myProject).getClientVersion(CLIENT_KEY) == CMakeWorkspace.getSerializationVersion()) {
                this.myState = loadedState;
                this.myStateWasLoaded = true;
            } else {
                this.myState = this.createInitialState(cppState.myProjectDir);
            }
            if (this.myProject.isInitialized()) {
                this.executePostStartup(() -> this.initialize(ReloadFlag.FORCE_RELOAD, false));
            }
        } else if (cppState.myContentRoot != null) {
            JpsProjectLoadingManager.getInstance((Project)this.myProject).jpsProjectLoaded(() -> ModalityUiUtil.invokeLaterIfNeeded(() -> WriteAction.run(() -> {
                if (CidrWorkspace.getInitializedWorkspaces((Project)this.getProject()).isEmpty()) {
                    this.updateContentRoots();
                }
            }), (ModalityState)ModalityState.NON_MODAL));
        }
    }

    @Nullable
    public File getModelProjectDir() {
        return this.myState.projectDir;
    }

    @Nullable
    public CMakeModel getModel() {
        return this.myState.model;
    }

    boolean isModelSettingsHashChanged(boolean alsoCheckEnvironment) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("if (myLastReloadWasCanceled [" + this.myLastReloadWasCanceled + "])");
        }
        if (this.myLastReloadWasCanceled) {
            return true;
        }
        State state = this.myState;
        if (state.myProfilesAndEnvHash == null) {
            return true;
        }
        ProfilesAndEnvHash hash = CMakeWorkspace.calcProfilesAndEnvHash(this.collectProfilesInfos(this.getSettings().getActiveProfiles(), false), alsoCheckEnvironment);
        if (LOG.isTraceEnabled()) {
            LOG.trace("State hash: " + state.myProfilesAndEnvHash + "; calculated hash: " + hash);
        }
        if (state.myProfilesAndEnvHash.profilesHash != hash.profilesHash) {
            return true;
        }
        return alsoCheckEnvironment && state.myProfilesAndEnvHash.envHash != hash.envHash;
    }

    @NotNull
    public List<CMakeTarget> getModelTargets() {
        CMakeModel model = this.myState.model;
        List<Object> list = model == null ? Collections.emptyList() : model.getTargets();
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(63);
        }
        return list;
    }

    @NotNull
    public Set<File> getCMakeDependencyFiles() {
        Set<File> set = this.myState.cmakeDependencyFilesWithStamps.keySet();
        if (set == null) {
            CMakeWorkspace.$$$reportNull$$$0(64);
        }
        return set;
    }

    @NotNull
    Map<File, FileStamp> getCMakeDependencyFilesWithStamps() {
        Map<File, FileStamp> map2 = this.myState.cmakeDependencyFilesWithStamps;
        if (map2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(65);
        }
        return map2;
    }

    @TestOnly
    @NotNull
    public Collection<File> getCMakeResourceFiles() {
        Set<File> set = this.myState.getAllResourceFiles();
        if (set == null) {
            CMakeWorkspace.$$$reportNull$$$0(66);
        }
        return set;
    }

    @Nullable
    public OCResolveConfiguration getResolveConfigurationFor(@Nullable CMakeConfiguration configuration) {
        return configuration == null ? null : OCWorkspace.getInstance((Project)this.myProject).getConfigurationById(CMakeWorkspace.getCMakeConfigurationId(configuration));
    }

    @Nullable
    public CMakeConfiguration getCMakeConfigurationFor(@Nullable OCResolveConfiguration configuration) {
        return configuration == null ? null : this.myState.cmakeConfigurationsIds.get(configuration.getUniqueId());
    }

    @NotNull
    private static String getCMakeConfigurationId(@NotNull CMakeConfiguration config) {
        if (config == null) {
            CMakeWorkspace.$$$reportNull$$$0(67);
        }
        String string = config.getProfileId() + "-" + config.getBuildType() + "-" + config.getTarget().getName();
        if (string == null) {
            CMakeWorkspace.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    public CMakeProfileInfo getProfileInfoFor(@NotNull CMakeConfiguration configuration) throws ExecutionException {
        CMakeProfileInfo result;
        if (configuration == null) {
            CMakeWorkspace.$$$reportNull$$$0(69);
        }
        if ((result = this.myState.profileInfos.get(configuration.getProfileId())) == null) {
            throw new ExecutionException(CLionCMakeBundle.message("cmake.profile.error.deleted", configuration.getProfileName()));
        }
        CMakeProfileInfo cMakeProfileInfo = result;
        if (cMakeProfileInfo == null) {
            CMakeWorkspace.$$$reportNull$$$0(70);
        }
        return cMakeProfileInfo;
    }

    @NotNull
    public Collection<CMakeProfileInfo> getProfileInfos() {
        Collection<CMakeProfileInfo> collection = Collections.unmodifiableCollection(this.myState.profileInfos.values());
        if (collection == null) {
            CMakeWorkspace.$$$reportNull$$$0(71);
        }
        return collection;
    }

    private void syncWithRemoteHosts(@NotNull List<CMakeProfileInfo> profileInfos, @NotNull Path projectDir) {
        if (profileInfos == null) {
            CMakeWorkspace.$$$reportNull$$$0(72);
        }
        if (projectDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(73);
        }
        ArrayList<CPPEnvironment> remoteEnvs = new ArrayList<CPPEnvironment>();
        ArrayList<String> excludeList = new ArrayList<String>();
        for (File path : (List)this.runReadActionCanceling(() -> this.collectProfilesGenerationDirs(this.mySettings.getProfiles()))) {
            excludeList.add(path.getPath());
        }
        for (CMakeProfileInfo info : profileInfos) {
            CPPEnvironment environment2 = info.getEnvironment();
            if (info.getEnvironmentAndCMakeProblems().hasProblems() || environment2 == null || !environment2.getHostMachine().isRemote()) continue;
            remoteEnvs.add(environment2);
        }
        CMakeRemoteUtil.syncToHosts(remoteEnvs, this.getProject(), projectDir.toString(), excludeList);
    }

    private void executePostStartup(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(74);
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(runnable2);
    }

    @NotNull
    public List<CidrToolEnvironment> getEnvironment() {
        ExecutionTarget selectedTarget = ExecutionTargetManager.getInstance((Project)this.myProject).getActiveTarget();
        String selectedProfileName = CMakeBuildProfileExecutionTarget.getProfileName(selectedTarget);
        List<CMakeSettings.Profile> activeProfiles = this.mySettings.getActiveProfiles();
        activeProfiles.stream().filter(profile -> profile.getName().equals(selectedProfileName)).findFirst().ifPresentOrElse(profile -> {
            activeProfiles.remove(profile);
            activeProfiles.add(0, (CMakeSettings.Profile)profile);
        }, Runnables.doNothing());
        List list = ContainerUtil.mapNotNull(activeProfiles, profile -> CPPToolchains.createCPPEnvironment((Project)this.myProject, (File)this.getProjectPath().toFile(), (String)profile.getToolchainName(), (EnvironmentProblems)new EnvironmentProblems(), (boolean)false, () -> {}));
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(75);
        }
        return list;
    }

    static {
        ourSerializationVersionInTests = 129003;
        ourReloadsCounter = new AtomicInteger(0);
        ourCheckCachesValidity = Ref.create((Object)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 47: 
            case 50: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 75: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 47: 
            case 50: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 75: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 47: 
            case 50: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openSpec";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileNamesWithSpecifiedDirs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileNames";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProjectDir";
                break;
            }
            case 24: 
            case 27: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeGeneration";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterGeneration";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 35: 
            case 38: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilesAndEnvHash";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 40: 
            case 45: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileInfos";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousState";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageSwitchBuilder";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesCollector";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyCalculatedStamps";
                break;
            }
            case 51: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProjectDir";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFile";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProfileInfos";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectCacheDir";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectCacheModelFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenMarkerDir";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenMarkerFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveProfileGenerationDirs";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileGenerationDirNames";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelConfigurationData";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateProject";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProfilesGenerationDirs";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProfilesInfos";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "updateOCWorkspace";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateFileStamps";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRootsInfo";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExcludeRoots";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelTargets";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeDependencyFiles";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeDependencyFilesWithStamps";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeResourceFiles";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeConfigurationId";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileInfoFor";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileInfos";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 47: 
            case 50: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 75: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forceReloadOnOpening";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateSettingsFromOpenSpec";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAndClearSourceAndGenerationDirToOpen";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProjectCacheDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearCaches";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveProfileGenerationDirs";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProfileGenerationDirNames";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setReloadInBackgroundInTests";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReload";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectProjectDir";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doReload";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateProject";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectProfilesGenerationDirs";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectProfilesInfos";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "determineEncoding";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createStateWithModel";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "needsCCBinFlag";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "updateOCWorkspace";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "calculateFileStamps";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "loadStateIfActual";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeConfigurationId";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getProfileInfoFor";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "syncWithRemoteHosts";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "executePostStartup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 30: 
            case 32: 
            case 34: 
            case 47: 
            case 50: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 75: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class State {
        @Nullable
        final File projectDir;
        @Nullable
        final ProfilesAndEnvHash myProfilesAndEnvHash;
        @Nullable
        final CMakeModel model;
        @NotNull
        final Map<Integer, CMakeProfileInfo> profileInfos;
        @NotNull
        final Map<File, FileStamp> cmakeDependencyFilesWithStamps;
        @NotNull
        final Map<String, CMakeConfiguration> cmakeConfigurationsIds;

        State(@Nullable File projectDir, @NotNull Map<File, FileStamp> cmakeDependencyFilesWithStamps) {
            if (cmakeDependencyFilesWithStamps == null) {
                State.$$$reportNull$$$0(0);
            }
            this(projectDir, null, null, Collections.emptyMap(), cmakeDependencyFilesWithStamps);
        }

        private State(@Nullable File projectDir, @Nullable ProfilesAndEnvHash profilesAndEnvHash, @Nullable CMakeModel model, @NotNull Map<Integer, CMakeProfileInfo> profileInfos, @NotNull Map<File, FileStamp> cmakeDependencyFilesWithStamps) {
            if (profileInfos == null) {
                State.$$$reportNull$$$0(1);
            }
            if (cmakeDependencyFilesWithStamps == null) {
                State.$$$reportNull$$$0(2);
            }
            this.projectDir = projectDir;
            this.myProfilesAndEnvHash = profilesAndEnvHash;
            this.model = model;
            this.profileInfos = ContainerUtil.unmodifiableOrEmptyMap(profileInfos);
            LOG.assertTrue(projectDir == null || cmakeDependencyFilesWithStamps.containsKey(new File(projectDir, "CMakeLists.txt")));
            this.cmakeDependencyFilesWithStamps = ContainerUtil.unmodifiableOrEmptyMap(cmakeDependencyFilesWithStamps);
            if (model != null) {
                HashMap<String, CMakeConfiguration> configIds = new HashMap<String, CMakeConfiguration>();
                for (CMakeTarget eachTarget : model.getTargets()) {
                    for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                        configIds.put(CMakeWorkspace.getCMakeConfigurationId(eachConfig), eachConfig);
                    }
                }
                this.cmakeConfigurationsIds = Collections.unmodifiableMap(configIds);
            } else {
                this.cmakeConfigurationsIds = Collections.emptyMap();
            }
        }

        @NotNull
        Set<File> getAllResourceFiles() {
            if (this.model == null) {
                Set<File> set = Collections.emptySet();
                if (set == null) {
                    State.$$$reportNull$$$0(3);
                }
                return set;
            }
            Set result = FileCollectionFactory.createCanonicalFileSet();
            result.addAll(this.model.getCMakeDependencyFiles());
            result.addAll(this.model.getHeaderAndResourceFiles());
            Set<File> set = Collections.unmodifiableSet(result);
            if (set == null) {
                State.$$$reportNull$$$0(4);
            }
            return set;
        }

        @NotNull
        private List<File> getAllGenerationDirs() {
            if (this.model == null) {
                List<File> list = Collections.emptyList();
                if (list == null) {
                    State.$$$reportNull$$$0(5);
                }
                return list;
            }
            List list = ContainerUtil.map(this.model.getConfigurationData(), data -> data.getGenerationDir());
            if (list == null) {
                State.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmakeDependencyFilesWithStamps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profileInfos";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$State";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllResourceFiles";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllGenerationDirs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ProfilesAndEnvHash {
        final long profilesHash;
        final long envHash;

        ProfilesAndEnvHash(long profilesHash, long envHash) {
            this.profilesHash = profilesHash;
            this.envHash = envHash;
        }

        public String toString() {
            return "ProfilesAndEnvHash{profilesHash=" + this.profilesHash + ", envHash=" + this.envHash + "}";
        }
    }

    static final class MyStartUpActivity
    implements StartupActivity.DumbAware {
        MyStartUpActivity() {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    CMakeWorkspace cMakeWorkspace;
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((cMakeWorkspace = (CMakeWorkspace)((Object)project.getServiceIfCreated(CMakeWorkspace.class))) != null && cMakeWorkspace.shouldLoadWorkspaceForProject()) {
                        cMakeWorkspace.unload(true);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$MyStartUpActivity$1", "projectClosed"));
                }
            });
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartUpActivity.$$$reportNull$$$0(0);
            }
            CMakeWorkspace.getInstance(project).load(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$MyStartUpActivity", "runActivity"));
        }
    }

    private class SettingsListener
    implements CMakeSettingsListener {
        public Boolean ignoreNextProfilesChangedEvent = false;

        private SettingsListener() {
        }

        @Override
        public void autoReloadChanged() {
            CMakeWorkspace.this.myWorkspaceWatcher.schedulePendingAutoReloads();
        }

        @Override
        public void profilesChanged(@NotNull List<CMakeSettings.Profile> old, @NotNull List<CMakeSettings.Profile> current) {
            if (old == null) {
                SettingsListener.$$$reportNull$$$0(0);
            }
            if (current == null) {
                SettingsListener.$$$reportNull$$$0(1);
            }
            if (this.ignoreNextProfilesChangedEvent.booleanValue()) {
                this.ignoreNextProfilesChangedEvent = false;
                return;
            }
            if (!this.sortedEnabledProfiles(old).equals(this.sortedEnabledProfiles(current))) {
                CMakeWorkspace.this.scheduleReload(CMakeWorkspaceReloadTask.updateRoots());
            }
        }

        private List<CMakeSettings.Profile> sortedEnabledProfiles(@NotNull List<CMakeSettings.Profile> profiles) {
            if (profiles == null) {
                SettingsListener.$$$reportNull$$$0(2);
            }
            return profiles.stream().filter(profile -> profile.getEnabled()).sorted(Comparator.comparing(CMakeSettings.Profile::getName)).collect(Collectors.toList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profiles";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$SettingsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "profilesChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sortedEnabledProfiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

