/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.CMakeLauncher;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationUtil;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRunConfigurationUtil;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeAppRunConfiguration
extends CLionRunConfiguration<CMakeConfiguration, CMakeTarget> {
    @Nullable
    private ExecutableData myExecutableData;
    @Nullable
    private String myExplicitBuildTargetName;
    @NonNls
    public static final String ALL_TARGET = "all";
    @NonNls
    public static final String INSTALL_TARGET = "install";
    @NonNls
    public static final String CLEAN_TARGET = "clean";

    public CMakeAppRunConfiguration(Project project, ConfigurationFactory factory, String name2) {
        super(project, factory, name2);
    }

    @NotNull
    public CMakeRunConfigurationType getType() {
        CMakeRunConfigurationType cMakeRunConfigurationType = (CMakeRunConfigurationType)super.getType();
        if (cMakeRunConfigurationType == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(0);
        }
        return cMakeRunConfigurationType;
    }

    public boolean canRunOn(@NotNull ExecutionTarget target) {
        if (target == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(1);
        }
        return target instanceof CMakeBuildProfileExecutionTarget;
    }

    @Nullable
    public OCResolveConfiguration getResolveConfiguration(@NotNull ExecutionTarget target) {
        if (target == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(2);
        }
        return CMakeRunConfigurationUtil.getResolveConfiguration(this, target);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.doCheckConfiguration(this.getBuildProfileIfActive(), false);
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
        super.checkSettingsBeforeRun();
        this.doCheckConfiguration(this.getBuildProfileIfActive(), true);
    }

    @Nullable
    private String getBuildProfileIfActive() {
        return this.isSelectedConfiguration() ? CMakeBuildProfileExecutionTarget.getProfileName(ExecutionTargetManager.getInstance((Project)this.getProject()).getActiveTarget()) : null;
    }

    public boolean isSelectedConfiguration() {
        RunnerAndConfigurationSettings selected = RunManager.getInstance((Project)this.getProject()).getSelectedConfiguration();
        return selected != null && Objects.equals(selected.getUniqueID(), RunnerAndConfigurationSettingsImpl.getUniqueIdFor((RunConfiguration)this));
    }

    private void doCheckConfiguration(@Nullable String buildProfile, boolean checkExecutableSpecified) throws RuntimeConfigurationException {
        BuildConfigurationProblems problems = new BuildConfigurationProblems();
        this.getBuildAndRunConfigurations(buildProfile, problems, checkExecutableSpecified);
        problems.throwAsConfigurationExceptions();
    }

    @Nullable
    public CMakeTarget getCMakeTarget() {
        CMakeBuildConfigurationHelper helper = this.getHelper();
        BuildTargetAndConfigurationData data = this.getTargetAndConfigurationData();
        return this.isBuildAllTargets() ? helper.createBuildAllVirtualTarget() : (CMakeTarget)helper.findTarget(data == null ? null : data.target);
    }

    @NotNull
    public List<String> getBuildProfiles() {
        List list = ContainerUtil.map((Collection)this.getHelper().getConfigurations(this.getCMakeTarget()), it -> it.getProfileName());
        if (list == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull ExecutionTarget target) {
        if (target == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(4);
        }
        return this.getBuildAndRunConfigurations(target, null, false);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull ExecutionTarget target, @Nullable BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        if (target == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(5);
        }
        return this.getBuildAndRunConfigurations(CMakeBuildProfileExecutionTarget.getProfileName(target), problems, checkExecutableSpecified);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull String buildProfileName) {
        if (buildProfileName == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(6);
        }
        return this.getBuildAndRunConfigurations(buildProfileName, null, false);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@Nullable String buildProfileName, @Nullable BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        return CMakeRunConfigurationUtil.getBuildAndRunConfigurations(this, buildProfileName, problems, checkExecutableSpecified);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditor<? extends CMakeAppRunConfiguration> settingsEditor = this.getType().createEditor(this.getProject());
        if (settingsEditor == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(7);
        }
        return settingsEditor;
    }

    @Nullable
    public CommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(8);
        }
        if (env == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(9);
        }
        return new CidrCommandLineState(env, (CidrLauncher)new CMakeLauncher(env, this));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(10);
        }
        super.writeExternal(element);
        if (this.myExecutableData != null) {
            this.myExecutableData.writeExternal(element);
        }
        if (this.myExplicitBuildTargetName != null) {
            element.setAttribute("EXPLICIT_BUILD_TARGET_NAME", this.myExplicitBuildTargetName);
            element.removeAttribute("PROJECT_NAME");
            element.removeAttribute("TARGET_NAME");
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(11);
        }
        super.readExternal(element);
        this.myExecutableData = ExecutableData.loadExternal((Element)element);
        this.myExplicitBuildTargetName = element.getAttributeValue("EXPLICIT_BUILD_TARGET_NAME");
    }

    @Nullable
    public ExecutableData getExecutableData() {
        return this.myExecutableData;
    }

    public void setExecutableData(@Nullable ExecutableData executableData) {
        this.myExecutableData = executableData;
    }

    public boolean isBuildAllTargets() {
        return ALL_TARGET.equals(this.myExplicitBuildTargetName);
    }

    public void setExplicitBuildTargetName(@Nullable String explicitBuildTargetName) {
        this.myExplicitBuildTargetName = explicitBuildTargetName;
    }

    @Override
    @Nullable
    public String getExplicitBuildTargetName() {
        return this.myExplicitBuildTargetName;
    }

    public RunConfiguration clone() {
        CMakeAppRunConfiguration result = (CMakeAppRunConfiguration)super.clone();
        result.myExecutableData = this.myExecutableData;
        result.myExplicitBuildTargetName = this.myExplicitBuildTargetName;
        return result;
    }

    public void onNewConfigurationCreated() {
        super.onNewConfigurationCreated();
        BuildTargetAndConfigurationData data = this.getTargetAndConfigurationData();
        if (data != null) {
            if (this.myExplicitBuildTargetName != null) {
                this.setTargetAndConfigurationData(new BuildTargetAndConfigurationData((BuildTargetData)null, data.configurationName));
            } else if (data.target != null && this.getHelper().findRunTarget(data.target) != null) {
                this.setExecutableData(new ExecutableData(data.target));
            }
        }
    }

    @NotNull
    public CMakeBuildConfigurationHelper getHelper() {
        CMakeBuildConfigurationHelper cMakeBuildConfigurationHelper = CMakeRunConfigurationType.getHelper(this.getProject());
        if (cMakeBuildConfigurationHelper == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(12);
        }
        return cMakeBuildConfigurationHelper;
    }

    @Nullable
    public static CMakeAppRunConfiguration getSelectedRunConfiguration(@Nullable Project project) {
        return (CMakeAppRunConfiguration)CidrRunConfigurationUtil.getSelectedRunConfiguration((Project)project, CMakeAppRunConfiguration.class);
    }

    @Nullable
    public static CMakeBuildProfileExecutionTarget getSelectedBuildProfile(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        ExecutionTarget executionTarget = ExecutionTargetManager.getActiveTarget((Project)project);
        return executionTarget instanceof CMakeBuildProfileExecutionTarget ? (CMakeBuildProfileExecutionTarget)executionTarget : null;
    }

    @Nullable
    public static Pair<CMakeAppRunConfiguration, CMakeBuildProfileExecutionTarget> getSelectedConfigurationAndTarget(@Nullable Project project) {
        CMakeAppRunConfiguration configuration = CMakeAppRunConfiguration.getSelectedRunConfiguration(project);
        CMakeBuildProfileExecutionTarget executionTarget = CMakeAppRunConfiguration.getSelectedBuildProfile(project);
        return configuration == null || executionTarget == null ? null : Pair.create((Object)configuration, (Object)((Object)executionTarget));
    }

    @Nullable
    public static BuildAndRunConfigurations getSelectedBuildAndRunConfigurations(@Nullable Project project) {
        Pair<CMakeAppRunConfiguration, CMakeBuildProfileExecutionTarget> configurationAndTarget = CMakeAppRunConfiguration.getSelectedConfigurationAndTarget(project);
        if (configurationAndTarget == null) {
            return null;
        }
        return ((CMakeAppRunConfiguration)configurationAndTarget.first).getBuildAndRunConfigurations((ExecutionTarget)configurationAndTarget.second);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProfileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildProfiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolveConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBuildAndRunConfigurations";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BuildAndRunConfigurations
    extends UserDataHolderBase {
        @NotNull
        public final CMakeConfiguration buildConfiguration;
        @Nullable
        public final CMakeConfiguration runConfiguration;
        @Nullable
        public final String runExecutable;
        @Nullable
        public final String explicitBuildTargetName;

        public BuildAndRunConfigurations(@NotNull CMakeConfiguration buildConfiguration, @Nullable CMakeConfiguration runConfiguration, @Nullable String runExecutable, @Nullable String explicitBuildTargetName) {
            if (buildConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(0);
            }
            this.buildConfiguration = buildConfiguration;
            this.runConfiguration = runConfiguration;
            this.runExecutable = runExecutable;
            this.explicitBuildTargetName = explicitBuildTargetName;
        }

        public BuildAndRunConfigurations(@NotNull CMakeConfiguration buildConfiguration) {
            if (buildConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(1);
            }
            this(buildConfiguration, null, null, null);
        }

        @NotNull
        public CMakeConfiguration getRunConfiguration() {
            CMakeConfiguration cMakeConfiguration = this.runConfiguration != null ? this.runConfiguration : this.buildConfiguration;
            if (cMakeConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(2);
            }
            return cMakeConfiguration;
        }

        @Deprecated
        @Nullable
        public File getRunFile() {
            if (this.runExecutable == null) {
                return this.getRunConfiguration().getProductFile();
            }
            return new File(this.runExecutable);
        }

        @Nullable
        public File getRunFile(@NotNull Project project) throws ExecutionException {
            if (project == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(3);
            }
            if (this.runExecutable == null) {
                return this.getRunConfiguration().getProductFile();
            }
            try {
                String expandedPath = MacroManager.getInstance().expandSilentMacros(this.runExecutable, true, SimpleDataContext.getProjectContext((Project)project));
                if (expandedPath != null) {
                    return new File(expandedPath);
                }
            }
            catch (Macro.ExecutionCancelledException e) {
                throw new ExecutionException((Throwable)e);
            }
            throw new ExecutionException(CLionCMakeBundle.message("cmake.run.configuration.bad.executable", this.runExecutable));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildConfiguration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration$BuildAndRunConfigurations";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration$BuildAndRunConfigurations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRunFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

