/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageRunner;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.gcov.GCovUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeGCovCoverageDataFileProvider;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageDataFileProvider;", "()V", "deleteCoverageData", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "getLocalCoverageDataPath", "", "isAvailable", "", "coverageRunnerId", "isCoverageDataExist", "intellij.clion.coverage"})
public final class CMakeGCovCoverageDataFileProvider
extends CidrCoverageDataFileProvider {
    @Override
    public boolean isAvailable(@NotNull RunConfiguration configuration, @NotNull String coverageRunnerId) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)coverageRunnerId, (String)"coverageRunnerId");
        return configuration instanceof CMakeAppRunConfiguration && (Intrinsics.areEqual((Object)coverageRunnerId, (Object)"gcov") || Intrinsics.areEqual((Object)coverageRunnerId, (Object)CMakeCoverageRunner.Companion.getID()));
    }

    @Override
    @Nullable
    public String getLocalCoverageDataPath(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = CMakeAppRunConfiguration.getSelectedBuildAndRunConfigurations(configuration.getProject());
        CMakeConfiguration runConfiguration = buildAndRunConfigurations != null ? buildAndRunConfigurations.getRunConfiguration() : null;
        Serializable serializable = runConfiguration;
        return serializable != null && (serializable = ((CMakeConfiguration)serializable).getConfigurationGenerationDir()) != null ? ((File)serializable).getAbsolutePath() : null;
    }

    @Override
    public boolean isCoverageDataExist(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        HostMachine host = environment2.getHostMachine();
        String string = this.getLocalCoverageDataPath(configuration);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String localDir = string2;
            boolean bl3 = false;
            Path path = host.getPath(localDir, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"host.getPath(localDir)");
            Path dirPath = path;
            HostMachine hostMachine = host;
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"host");
            return CollectionsKt.any((Iterable)GCovUtils.Companion.getGCovOrGCDAFiles(hostMachine, dirPath, true));
        }
        return false;
    }

    @Override
    public void deleteCoverageData(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        String string = this.getLocalCoverageDataPath(configuration);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String localDir = string2;
            boolean bl3 = false;
            Path path = environment2.getHostMachine().getPath(localDir, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.hostMachine.getPath(localDir)");
            Path dirPath = path;
            HostMachine hostMachine = environment2.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
            List<Path> filesToDelete = GCovUtils.Companion.getGCovOrGCDAFiles(hostMachine, dirPath, true);
            HostMachine hostMachine2 = environment2.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine2, (String)"environment.hostMachine");
            if (!CidrCoverageUtil.Companion.deleteFilesInBatchMode(hostMachine2, filesToDelete, ((Object)dirPath).toString())) {
                throw (Throwable)new ExecutionException(CidrCoverageBundle.message("coverage.failed.to.delete.data", new Object[0]));
            }
        }
    }
}

