/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import com.jetbrains.cidr.system.SystemUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GdbWithGdbServerProcess
extends CidrDebugProcess {
    protected final CidrRemoteDebugParameters myRemoteParameters;
    @Nullable
    private volatile BaseProcessHandler<?> myGdbServerProcess;

    public GdbWithGdbServerProcess(@NotNull RunParameters runParameters, @NotNull CidrRemoteDebugParameters remoteParameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws ExecutionException {
        if (runParameters == null) {
            GdbWithGdbServerProcess.$$$reportNull$$$0(0);
        }
        if (remoteParameters == null) {
            GdbWithGdbServerProcess.$$$reportNull$$$0(1);
        }
        if (session == null) {
            GdbWithGdbServerProcess.$$$reportNull$$$0(2);
        }
        if (consoleBuilder == null) {
            GdbWithGdbServerProcess.$$$reportNull$$$0(3);
        }
        super(runParameters, session, consoleBuilder);
        this.myRemoteParameters = remoteParameters;
    }

    @NotNull
    public DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            GdbWithGdbServerProcess.$$$reportNull$$$0(4);
        }
        String symbolFileName = this.myRemoteParameters.getSymbolFile();
        File symbolFile = new File(symbolFileName);
        DebuggerDriver.Inferior inferior = ((GDBDriver)driver).loadForRemote(this.myRemoteParameters.getRemoteCommand(), symbolFile, null, this.myRemoteParameters.driverPathMapping(), this.myRemoteParameters.getAdditionalCommands());
        if (inferior == null) {
            GdbWithGdbServerProcess.$$$reportNull$$$0(5);
        }
        return inferior;
    }

    public boolean isDetachDefault() {
        return true;
    }

    public void installServerProcess(final @NotNull BaseProcessHandler<?> gdbServerProcess) {
        if (gdbServerProcess == null) {
            GdbWithGdbServerProcess.$$$reportNull$$$0(6);
        }
        this.myGdbServerProcess = gdbServerProcess;
        gdbServerProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GdbWithGdbServerProcess.this.getSession().stop();
                GdbWithGdbServerProcess.this.printlnToConsole("GDB Server stopped, exit code " + event.getExitCode());
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(2);
                }
                GdbWithGdbServerProcess.this.getProcessHandler().notifyTextAvailable(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbWithGdbServerProcess$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                GdbWithGdbServerProcess.stopGdbServerProcess(GdbWithGdbServerProcess.this.myGdbServerProcess);
                event.getProcessHandler().removeProcessListener((ProcessListener)this);
            }

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.startNotified(event);
                gdbServerProcess.startNotify();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbWithGdbServerProcess$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected long doStartTarget(@NotNull DebuggerDriver.Inferior inferior) throws ExecutionException {
        if (inferior == null) {
            GdbWithGdbServerProcess.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            this.warmup();
            return null;
        }, CLionExecutionBundle.message("gdbserver.starting", new Object[0]), true, this.getProject());
        return super.doStartTarget(inferior);
    }

    protected void warmup() throws ExecutionException {
    }

    private static void stopGdbServerProcess(@Nullable BaseProcessHandler<?> gdbServerProcess) {
        if (gdbServerProcess == null || gdbServerProcess.isProcessTerminated()) {
            return;
        }
        try {
            gdbServerProcess.destroyProcess();
            gdbServerProcess.waitFor(5000L);
        }
        finally {
            SystemUtil.killProcessTree(gdbServerProcess);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbWithGdbServerProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbServerProcess";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferior";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbWithGdbServerProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doLoadTarget";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installServerProcess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doStartTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

