/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.manager;

import com.intellij.execution.configurations.RunConfigurationsSettings;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.execution.manager.CLionRunConfigurationManager;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLionRunConfigurationsSettings
implements RunConfigurationsSettings {
    @NotNull
    private final Project myProject;

    public CLionRunConfigurationsSettings(@NotNull Project project) {
        if (project == null) {
            CLionRunConfigurationsSettings.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public UnnamedConfigurable createConfigurable() {
        if (this.myProject.isDefault()) {
            return new EmptyConfigurable();
        }
        return new MyConfigurable(CLionRunConfigurationManager.getInstance(this.myProject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/execution/manager/CLionRunConfigurationsSettings", "<init>"));
    }

    private static class EmptyConfigurable
    implements UnnamedConfigurable {
        private EmptyConfigurable() {
        }

        @Nullable
        public JComponent createComponent() {
            return new JPanel();
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        public void reset() {
        }

        public void disposeUIResources() {
        }
    }

    private static class MyConfigurable
    implements UnnamedConfigurable {
        private final CLionRunConfigurationManager myManager;
        private JCheckBox myShouldGenerateConfigs;
        private JCheckBox myShouldDeleteObsoleteConfigs;

        MyConfigurable(CLionRunConfigurationManager manager) {
            this.myManager = manager;
        }

        public JComponent createComponent() {
            JPanel panel2 = new JPanel(new GridBagLayout());
            GridBag bag = new GridBag();
            bag.setDefaultAnchor(512);
            this.myShouldGenerateConfigs = new JCheckBox(CLionCMakeBundle.message("cmake.run.shouldGenerateConfigs", new Object[0]));
            panel2.add((Component)this.myShouldGenerateConfigs, bag.nextLine().next().weightx(1.0));
            this.myShouldDeleteObsoleteConfigs = new JCheckBox(CLionCMakeBundle.message("cmake.run.shouldDeleteObsoleteConfigs", new Object[0]));
            panel2.add((Component)this.myShouldDeleteObsoleteConfigs, bag.nextLine().next().weightx(1.0));
            return panel2;
        }

        public boolean isModified() {
            return this.myShouldGenerateConfigs.isSelected() != this.myManager.shouldGenerateConfigurations() || this.myShouldDeleteObsoleteConfigs.isSelected() != this.myManager.shouldDeleteObsoleteConfigurations();
        }

        public void apply() throws ConfigurationException {
            this.myManager.setShouldGenerateConfigurations(this.myShouldGenerateConfigs.isSelected());
            this.myManager.setShouldDeleteObsoleteConfigurations(this.myShouldDeleteObsoleteConfigs.isSelected());
        }

        public void reset() {
            this.myShouldGenerateConfigs.setSelected(this.myManager.shouldGenerateConfigurations());
            this.myShouldDeleteObsoleteConfigs.setSelected(this.myManager.shouldDeleteObsoleteConfigurations());
        }

        public void disposeUIResources() {
        }
    }
}

