/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.remote;

import com.intellij.util.JdomKt;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteRunConfigurationKt;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerSourceKind;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;", "", "kind", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind;", "(Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind;)V", "isGDB", "", "()Z", "isLLDB", "getKind", "()Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind;", "setKind", "getOrCreateDebuggerToolchain", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "readExternal", "", "element", "Lorg/jdom/Element;", "writeExternal", "intellij.clion.execution"})
public final class DebuggerData {
    @NotNull
    private DebuggerSourceKind kind;

    public final void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("version", "1");
        Element debugger = new Element("debugger");
        DebuggerSourceKind kind = this.kind;
        if (Intrinsics.areEqual((Object)kind, (Object)DebuggerSourceKind.Bundle.GDB.INSTANCE)) {
            debugger.setAttribute("kind", "GDB");
            debugger.setAttribute("isBundled", "true");
        } else if (Intrinsics.areEqual((Object)kind, (Object)DebuggerSourceKind.Bundle.LLDB.INSTANCE)) {
            debugger.setAttribute("kind", "LLDB");
            debugger.setAttribute("isBundled", "true");
        } else if (kind instanceof DebuggerSourceKind.Toolchain) {
            debugger.setAttribute("toolchainName", ((DebuggerSourceKind.Toolchain)kind).getToolchain().getName());
        } else if (kind instanceof DebuggerSourceKind.External) {
            debugger.setAttribute("kind", "GDB");
            debugger.setText(((DebuggerSourceKind.External)kind).getPath());
        }
        element.addContent(debugger);
    }

    public final void readExternal(@NotNull Element element) {
        int version;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element.getAttributeValue("version");
        int n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (version = 0);
        if (version == 1) {
            Element element2 = element.getChild("debugger");
            if (element2 == null) {
                return;
            }
            Element debugger = element2;
            String debuggerKind = debugger.getAttributeValue("kind");
            boolean isBundled = JdomKt.getAttributeBooleanValue((Element)debugger, (String)"isBundled");
            String toolchainName2 = debugger.getAttributeValue("toolchainName");
            String path = debugger.getText();
            this.kind = DebuggerSourceKind.Companion.fromData(debuggerKind, isBundled, toolchainName2, path);
        } else {
            String path = element.getAttributeValue("debugger");
            String toolchainName3 = element.getAttributeValue("toolchainName");
            boolean isBundled = path == null;
            this.kind = DebuggerSourceKind.Companion.fromData("GDB", isBundled, toolchainName3, path);
        }
    }

    @NotNull
    public final CPPToolchains.Toolchain getOrCreateDebuggerToolchain() {
        CPPToolchains.Toolchain toolchain;
        DebuggerSourceKind kind = this.kind;
        if (Intrinsics.areEqual((Object)kind, (Object)DebuggerSourceKind.Bundle.GDB.INSTANCE)) {
            CPPToolchains cPPToolchains = CPPToolchains.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"CPPToolchains.getInstance()");
            toolchain = CLionRemoteRunConfigurationKt.getOrCreateGDBToolchain(cPPToolchains, null);
        } else if (Intrinsics.areEqual((Object)kind, (Object)DebuggerSourceKind.Bundle.LLDB.INSTANCE)) {
            CPPToolchains cPPToolchains = CPPToolchains.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"CPPToolchains.getInstance()");
            toolchain = CLionRemoteRunConfigurationKt.getOrCreateLLDBToolchain(cPPToolchains);
        } else if (kind instanceof DebuggerSourceKind.Toolchain) {
            toolchain = ((DebuggerSourceKind.Toolchain)kind).getToolchain();
        } else if (kind instanceof DebuggerSourceKind.External) {
            CPPToolchains cPPToolchains = CPPToolchains.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"CPPToolchains.getInstance()");
            toolchain = CLionRemoteRunConfigurationKt.getOrCreateGDBToolchain(cPPToolchains, ((DebuggerSourceKind.External)kind).getPath());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return toolchain;
    }

    public final boolean isLLDB() {
        return this.kind.isLLDB();
    }

    public final boolean isGDB() {
        return !this.kind.isLLDB();
    }

    @NotNull
    public final DebuggerSourceKind getKind() {
        return this.kind;
    }

    public final void setKind(@NotNull DebuggerSourceKind debuggerSourceKind) {
        Intrinsics.checkNotNullParameter((Object)debuggerSourceKind, (String)"<set-?>");
        this.kind = debuggerSourceKind;
    }

    public DebuggerData(@NotNull DebuggerSourceKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.kind = kind;
    }
}

