/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.profiling;

import com.intellij.execution.ExecutionException;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.StatusText;
import com.jetbrains.cidr.cpp.CLionProfilingBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileNavigationData;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileError;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileFrame;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileProblemDescription;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileStack;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTree;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTreeNode;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryProfileUtil {
    private MemoryProfileUtil() {
    }

    @Nullable
    public static CidrToolEnvironment getEnvironment(@NotNull Project project) {
        if (project == null) {
            MemoryProfileUtil.$$$reportNull$$$0(0);
        }
        CMakeWorkspace workspace = CMakeWorkspace.getInstance(project);
        Pair<CMakeAppRunConfiguration, CMakeBuildProfileExecutionTarget> configurationWithTarget = CMakeAppRunConfiguration.getSelectedConfigurationAndTarget(project);
        if (configurationWithTarget == null) {
            return null;
        }
        CMakeAppRunConfiguration configuration = (CMakeAppRunConfiguration)configurationWithTarget.getFirst();
        CMakeBuildProfileExecutionTarget target = (CMakeBuildProfileExecutionTarget)((Object)configurationWithTarget.getSecond());
        if (configuration == null || target == null) {
            return null;
        }
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = configuration.getBuildAndRunConfigurations(target);
        if (buildAndRunConfigurations == null) {
            return null;
        }
        try {
            CMakeProfileInfo profileInfo = workspace.getProfileInfoFor(buildAndRunConfigurations.buildConfiguration);
            return profileInfo.getEnvironment();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static void deleteDirectorySilently(@NotNull Path directory, Logger logger) {
        if (directory == null) {
            MemoryProfileUtil.$$$reportNull$$$0(1);
        }
        try {
            if (!Files.exists(directory, new LinkOption[0])) {
                return;
            }
            PathKt.delete((Path)directory, (boolean)true);
        }
        catch (Exception e) {
            logger.warn("Cannot delete directory: " + directory, (Throwable)e);
        }
    }

    @NotNull
    public static List<Path> getFiles(@NotNull Path outputDirectory) throws IOException {
        if (outputDirectory == null) {
            MemoryProfileUtil.$$$reportNull$$$0(2);
        }
        Stream<Path> stream = Files.list(outputDirectory);
        List<Path> list = stream.collect(Collectors.toList());
        List<Path> list2 = list;
        if (list2 == null) {
            MemoryProfileUtil.$$$reportNull$$$0(3);
        }
        return list2;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Nullable
    public static MemoryProfileFrame getInnermostNavigatableStackFrame(@NotNull MemoryProfileError error) {
        if (error == null) {
            MemoryProfileUtil.$$$reportNull$$$0(4);
        }
        for (MemoryProfileProblemDescription description : error.getProblemDescriptions()) {
            MemoryProfileFrame frame;
            if (description.getStack().isEmpty() || (frame = MemoryProfileUtil.getInnermostNavigatableStackFrame(description.getStack())) == null) continue;
            return frame;
        }
        return null;
    }

    @Nullable
    public static MemoryProfileFrame getInnermostNavigatableStackFrame(@NotNull MemoryProfileStack stack) {
        if (stack == null) {
            MemoryProfileUtil.$$$reportNull$$$0(5);
        }
        return stack.getFrames().stream().filter(frame -> StringUtil.isNotEmpty((String)frame.getDirectory()) && StringUtil.isNotEmpty((String)frame.getFile())).findFirst().orElse(null);
    }

    public static void removeNode(@NotNull MemoryProfileTreeNode node2, @NotNull MemoryProfileTreeDataModel dataModel) {
        MemoryProfileTreeNode parentNode;
        if (node2 == null) {
            MemoryProfileUtil.$$$reportNull$$$0(6);
        }
        if (dataModel == null) {
            MemoryProfileUtil.$$$reportNull$$$0(7);
        }
        MemoryProfileTreeNode nodeToRemove = node2;
        for (parentNode = (MemoryProfileTreeNode)node2.getParent(); parentNode != null && parentNode != dataModel.getRoot() && parentNode.getChildCount() == 1; parentNode = (MemoryProfileTreeNode)parentNode.getParent()) {
            nodeToRemove = parentNode;
        }
        dataModel.removeNodeFromParent(nodeToRemove);
        dataModel.nodeChanged(parentNode);
    }

    @Nullable
    public static MemoryProfileNavigationData getNavigationData(@NotNull MemoryProfileFrame frame) {
        if (frame == null) {
            MemoryProfileUtil.$$$reportNull$$$0(8);
        }
        String directory = StringUtil.notNullize((String)frame.getDirectory());
        String fileName = StringUtil.notNullize((String)frame.getFile());
        String filePath = FileUtil.join((String[])new String[]{directory, fileName});
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return null;
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(virtualFile));
        if (document == null) {
            return null;
        }
        int lineNumber = StringUtil.parseInt((String)frame.getLine(), (int)-1) - 1;
        return new MemoryProfileNavigationData(virtualFile, document, lineNumber);
    }

    public static void showNotification(@NotNull String toolId, @NlsContexts.NotificationTitle @Nullable String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType notificationType, @NotNull Project project) {
        if (toolId == null) {
            MemoryProfileUtil.$$$reportNull$$$0(9);
        }
        if (message == null) {
            MemoryProfileUtil.$$$reportNull$$$0(10);
        }
        if (notificationType == null) {
            MemoryProfileUtil.$$$reportNull$$$0(11);
        }
        if (project == null) {
            MemoryProfileUtil.$$$reportNull$$$0(12);
        }
        NotificationGroup.toolWindowGroup((String)toolId, (String)"Run").createNotification(title, message, notificationType).notify(project);
    }

    public static void processOutputFromRemote(@NotNull @NlsSafe String toolName, final Runnable outputProcessor, @NotNull Project project) {
        if (toolName == null) {
            MemoryProfileUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            MemoryProfileUtil.$$$reportNull$$$0(14);
        }
        Task.Backgroundable task2 = new Task.Backgroundable(project, CLionProfilingBundle.message("memory.profile.process.output.from.remote", toolName), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                outputProcessor.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/profiling/MemoryProfileUtil$1", "run"));
            }
        };
        task2.queue();
    }

    public static void setTreeDataReady(@NotNull MemoryProfileTree tree) {
        if (tree == null) {
            MemoryProfileUtil.$$$reportNull$$$0(15);
        }
        MemoryProfileUtil.changeTreeStatus(tree, false, StatusText.getDefaultEmptyText());
    }

    public static void setTreeBusy(@NotNull MemoryProfileTree tree, @NotNull @Nls String emptyText) {
        if (tree == null) {
            MemoryProfileUtil.$$$reportNull$$$0(16);
        }
        if (emptyText == null) {
            MemoryProfileUtil.$$$reportNull$$$0(17);
        }
        MemoryProfileUtil.changeTreeStatus(tree, true, emptyText);
    }

    private static void changeTreeStatus(@NotNull MemoryProfileTree tree, boolean isBusy, @NotNull @Nls String emptyText) {
        if (tree == null) {
            MemoryProfileUtil.$$$reportNull$$$0(18);
        }
        if (emptyText == null) {
            MemoryProfileUtil.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            tree.setPaintBusy(isBusy);
            tree.getEmptyText().setText(emptyText);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/profiling/MemoryProfileUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/profiling/MemoryProfileUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteDirectorySilently";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInnermostNavigatableStackFrame";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationData";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processOutputFromRemote";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTreeDataReady";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setTreeBusy";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "changeTreeStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

