/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.profiling.tree;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileNavigationData;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileUtil;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileFrame;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTreeCellRenderer;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTreeNode;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfileStackFrameTreeNode
extends MemoryProfileTreeNode {
    @NotNull
    private final MemoryProfileFrame myFrame;
    @NotNull
    private final Project myProject;

    public MemoryProfileStackFrameTreeNode(@NotNull MemoryProfileFrame frame, @NotNull Project project) {
        if (frame == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(1);
        }
        super(frame);
        this.myFrame = frame;
        this.myProject = project;
    }

    @NotNull
    public MemoryProfileFrame getFrame() {
        MemoryProfileFrame memoryProfileFrame = this.myFrame;
        if (memoryProfileFrame == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(2);
        }
        return memoryProfileFrame;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AllIcons.Debugger.Frame;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        MemoryProfileNavigationData navigationData = MemoryProfileUtil.getNavigationData(this.myFrame);
        if (navigationData == null) {
            return null;
        }
        return navigationData.isLineNumberValid() ? new OpenFileDescriptor(this.myProject, navigationData.getVirtualFile(), navigationData.getLineNumber(), 0) : new OpenFileDescriptor(this.myProject, navigationData.getVirtualFile());
    }

    @Override
    public boolean canBeExcluded() {
        return false;
    }

    @Override
    protected void render(@NotNull MemoryProfileTreeCellRenderer renderer) {
        if (renderer == null) {
            MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(3);
        }
        @NlsSafe String pointer = this.myFrame.getInstructionPointer();
        @NlsSafe String file = this.myFrame.getFile();
        @NlsSafe String line = this.myFrame.getLine();
        if (StringUtil.isEmpty((String)pointer) && StringUtil.isEmpty((String)this.toString()) && StringUtil.isEmpty((String)file)) {
            MemoryProfileStackFrameTreeNode.appendEmptyText(renderer);
            return;
        }
        if (StringUtil.isNotEmpty((String)pointer)) {
            renderer.appendTextWithSeparator(pointer, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        renderer.appendTextWithSeparator(this.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (StringUtil.isNotEmpty((String)file)) {
            if (StringUtil.isNotEmpty((String)line)) {
                renderer.appendTextWithSeparator(file + ":" + line, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            } else {
                renderer.appendTextWithSeparator(file, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
        }
    }

    @Override
    @NlsSafe
    @NotNull
    public String toString() {
        if (StringUtil.isNotEmpty((String)this.myFrame.getFunction())) {
            String string = ValueRenderer.getShortenedType((String)this.myFrame.getFunction());
            if (string == null) {
                MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getBinary())) {
            String string = this.myFrame.getBinary();
            if (string == null) {
                MemoryProfileStackFrameTreeNode.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/profiling/tree/MemoryProfileStackFrameTreeNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/profiling/tree/MemoryProfileStackFrameTreeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

