/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.llvm;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.jetbrains.cidr.execution.coverage.CidrBranchCoverageFileData;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageEngine;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.CidrProjectData;
import com.jetbrains.cidr.execution.coverage.llvm.LLVMCoverageModel;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "()V", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "doParseModel", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel;", "inputPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "getDataFileExtension", "", "getId", "getPresentableName", "loadCoverageData", "Lcom/intellij/rt/coverage/data/ProjectData;", "sessionDataFile", "Ljava/io/File;", "coverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "parseModel", "Companion", "intellij.cidr.coverage"})
public final class LLVMCoverageRunner
extends CoverageRunner {
    @NotNull
    public static final String ID = "llvm-cov";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getPresentableName() {
        String string = CidrCoverageBundle.message("llvm.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.message(\"llvm.name\")");
        return string;
    }

    @NotNull
    public String getDataFileExtension() {
        return "json";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof CidrCoverageEngine;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite coverageSuite) {
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        CidrToolEnvironment cidrToolEnvironment = CidrCoverageUtil.Companion.getEnvironment(coverageSuite);
        if (cidrToolEnvironment == null) {
            cidrToolEnvironment = new CidrToolEnvironment();
        }
        CidrToolEnvironment environment2 = cidrToolEnvironment;
        Path path = environment2.getHostMachine().getPath(sessionDataFile.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.hostMachine.\u2026ath(sessionDataFile.path)");
        CoverageSuite coverageSuite2 = coverageSuite;
        LLVMCoverageModel model = this.parseModel(path, (Project)(coverageSuite2 != null ? coverageSuite2.getProject() : null));
        if (model == null) {
            return null;
        }
        CidrProjectData projectData = new CidrProjectData();
        for (LLVMCoverageModel.CoverageMapping mapping : model.getMappings()) {
            for (LLVMCoverageModel.FileMapping fileMapping : mapping.getFileMappings()) {
                boolean bl;
                CidrBranchCoverageFileData branchCoverageData;
                block13: {
                    int n;
                    int n2;
                    String canonicalFilePath = FileUtil.toCanonicalPath((String)environment2.toLocalPath(fileMapping.getName()));
                    ClassData fileData = projectData.getOrCreateClassData(canonicalFilePath);
                    LLVMCoverageModel.Segment segment = (LLVMCoverageModel.Segment)CollectionsKt.lastOrNull(fileMapping.getSegments());
                    int maxLine = segment != null ? segment.getBeginLine() : -1;
                    LineData[] lines = new LineData[maxLine + 1];
                    LLVMCoverageModel.Segment currentSegment = null;
                    for (LLVMCoverageModel.Segment nextSegment : fileMapping.getSegments()) {
                        int n3;
                        if (currentSegment != null && (n3 = currentSegment.getBeginLine()) <= (n2 = nextSegment.getBeginLine())) {
                            while (true) {
                                void lineIdx;
                                boolean exists = lines[lineIdx] != null;
                                LineData lineData = lines[lineIdx];
                                if (lineData == null) {
                                    lineData = new LineData((int)lineIdx, null);
                                }
                                LineData lineData2 = lineData;
                                long l = currentSegment.getCount();
                                long l2 = Integer.MAX_VALUE;
                                boolean bl2 = false;
                                int hits = (int)Math.min(l, l2);
                                if (exists) {
                                    SwitchData switchData;
                                    SwitchData switchData2 = lineData2.getSwitchData(0);
                                    if (switchData2 == null) {
                                        SwitchData switchData3 = lineData2.addSwitch(0, new int[0]);
                                        boolean bl3 = false;
                                        boolean bl4 = false;
                                        SwitchData it = switchData3;
                                        boolean bl5 = false;
                                        SwitchData switchData4 = it;
                                        Intrinsics.checkNotNullExpressionValue((Object)switchData4, (String)"it");
                                        switchData4.setDefaultHits(lineData2.getHits());
                                        switchData2 = switchData3;
                                    }
                                    SwitchData switchData5 = switchData = switchData2;
                                    Intrinsics.checkNotNullExpressionValue((Object)switchData5, (String)"switchData");
                                    int[] nArray = switchData5.getKeys();
                                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"switchData.keys");
                                    int[] nArray2 = ArraysKt.plus((int[])nArray, (int)currentSegment.getBeginColumn());
                                    int[] nArray3 = switchData.getHits();
                                    Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"switchData.hits");
                                    switchData.setKeysAndHits(nArray2, ArraysKt.plus((int[])nArray3, (int)hits));
                                } else {
                                    int switchData = lineData2.getHits();
                                    boolean bl6 = false;
                                    lineData2.setHits(Math.max(switchData, hits));
                                }
                                lines[lineIdx] = lineData2;
                                if (lineIdx == n2) break;
                                ++lineIdx;
                            }
                        }
                        currentSegment = nextSegment.getHasCount() ? nextSegment : null;
                    }
                    LineData[] $this$forEach$iv = lines;
                    boolean $i$f$forEach = false;
                    LineData[] lineIdx = $this$forEach$iv;
                    n2 = lineIdx.length;
                    for (n = 0; n < n2; ++n) {
                        LineData element$iv;
                        LineData it = element$iv = lineIdx[n];
                        boolean bl7 = false;
                        LineData lineData = it;
                        if (lineData == null) continue;
                        lineData.fillArrays();
                    }
                    fileData.setLines(lines);
                    LLVMCoverageModel.Summary summary = fileMapping.getSummary();
                    if ((summary != null ? summary.getBranches() : null) == null) continue;
                    String string = canonicalFilePath;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"canonicalFilePath");
                    branchCoverageData = projectData.getOrCreateBranchCoverageData(string);
                    branchCoverageData.setTotalBranches(fileMapping.getSummary().getBranches().getCount());
                    branchCoverageData.setCoveredBranches(fileMapping.getSummary().getBranches().getCovered());
                    if (branchCoverageData.getTotalBranches() != 0) continue;
                    LineData[] $this$any$iv = lines;
                    boolean $i$f$any = false;
                    LineData[] lineDataArray = $this$any$iv;
                    n = lineDataArray.length;
                    for (int i = 0; i < n; ++i) {
                        LineData element$iv;
                        LineData it = element$iv = lineDataArray[i];
                        boolean bl8 = false;
                        LineData lineData = it;
                        if (!((lineData != null ? Integer.valueOf(lineData.getHits()) : null) != null && it.getHits() > 0)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
                if (!bl) continue;
                branchCoverageData.setTotalBranches(1);
                branchCoverageData.setCoveredBranches(1);
            }
        }
        return projectData;
    }

    private final LLVMCoverageModel parseModel(Path inputPath, Project project) {
        try {
            return this.doParseModel(inputPath, project);
        }
        catch (LLVMCoverageModel.InvalidModelException e) {
            CidrCoverageLogKt.getCidrCoverageLog().warn((Throwable)e);
            return null;
        }
    }

    private final LLVMCoverageModel doParseModel(Path inputPath, Project project) {
        return (LLVMCoverageModel)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(inputPath){
            final /* synthetic */ Path $inputPath;

            public final LLVMCoverageModel compute() {
                return LLVMCoverageModel.Companion.fromFile(this.$inputPath);
            }
            {
                this.$inputPath = path;
            }
        }, CidrCoverageBundle.message("coverage.reading.output.data", new Object[0]), true, project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner$Companion;", "", "()V", "ID", "", "intellij.cidr.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

