/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.execution.Location;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.MathUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.execution.testing.CTestingBundle;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestInfoSerializer;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CidrTestListUpdater
implements Disposable,
ModificationTracker {
    public static final int TEST_DETECTION_PASS_RETRY_TIMEOUT = 100;
    public static final int TEST_DETECTION_PASS_RETRY_AFTER_WA_TIMEOUT = 1000;
    public static final int TEST_DETECTION_PASS_RETRY_TIMEOUT_MAX = 30000;
    public final Ref<Task.Backgroundable> myTask;
    public final HashMap<VirtualFile, CidrTestInfoForFile> myIndexedTests;
    public final LinkedList<VirtualFile> myScheduledFiles;
    public final MergingUpdateQueue myUpdateQueue;
    public final Project myProject;
    public final CidrTestFrameworkBase<?> myFramework;
    private final Deque<Runnable> myRunWhenIndexed;
    private final Object myRunAfterIndexedLock;
    private volatile int myMergingTimeSpan;
    private final AtomicBoolean myFirstScanPending;
    private final AtomicBoolean myNeedSaveFirstScanResults;
    private volatile int myTestInfoVersion;
    private volatile int myLocationResolveCount;
    private volatile int mySize;
    private volatile int myIndex;
    private static volatile Boolean ourSchedulingDisabledInTests = null;
    private static volatile boolean ourTaskExecutionDisabledInTests = false;

    CidrTestListUpdater(@NotNull CidrTestFrameworkBase<?> framework, @NotNull Project project) {
        if (framework == null) {
            CidrTestListUpdater.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CidrTestListUpdater.$$$reportNull$$$0(1);
        }
        this.myTask = new Ref();
        this.myIndexedTests = new HashMap();
        this.myScheduledFiles = new LinkedList();
        this.myRunWhenIndexed = new ArrayDeque<Runnable>();
        this.myRunAfterIndexedLock = new Object();
        this.myFirstScanPending = new AtomicBoolean(true);
        this.myNeedSaveFirstScanResults = new AtomicBoolean(true);
        this.myTestInfoVersion = 1;
        this.myLocationResolveCount = 0;
        this.mySize = 0;
        this.myIndex = 0;
        this.myFramework = framework;
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myMergingTimeSpan = 100;
        this.myUpdateQueue = new MergingUpdateQueue(this.myFramework.getFrameworkId() + " update", this.myMergingTimeSpan, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, true);
        ApplicationListener postponeIndexingOnWrite = new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                CidrTestListUpdater.this.myUpdateQueue.suspend();
            }

            public void afterWriteActionFinished(@NotNull Object action) {
                if (action == null) {
                    1.$$$reportNull$$$0(1);
                }
                CidrTestListUpdater.this.myUpdateQueue.resume();
                CidrTestListUpdater.this.myUpdateQueue.restartTimer();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "action";
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestListUpdater$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeWriteActionStart";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterWriteActionFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ApplicationManager.getApplication().addApplicationListener(postponeIndexingOnWrite, (Disposable)this);
    }

    public void dispose() {
        this.filterTestHoldersAndWriteIndexedTestInfo(true);
        this.myFramework.dropUpdater(this.myProject);
    }

    @NotNull
    public String getId() {
        String string = this.myFramework.getFrameworkId();
        if (string == null) {
            CidrTestListUpdater.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void scheduleUpdate(@NotNull VirtualFile fileToScan) {
        if (fileToScan == null) {
            CidrTestListUpdater.$$$reportNull$$$0(3);
        }
        if (this.myFramework.markOnlyNotScheduleForUpdate(fileToScan)) {
            return;
        }
        this.doScheduleUpdate(fileToScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doScheduleUpdate(@Nullable VirtualFile fileToScan) {
        if (ourSchedulingDisabledInTests == Boolean.TRUE) {
            return;
        }
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
            if (fileToScan != null) {
                this.myScheduledFiles.remove(fileToScan);
                this.myScheduledFiles.addFirst(fileToScan);
            }
            this.mySize = this.myIndex + this.myScheduledFiles.size();
        }
        this.myMergingTimeSpan = 100;
        this.scheduleUpdatePass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexing() {
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            return !this.myScheduledFiles.isEmpty();
        }
    }

    public boolean isIndexed() {
        return !this.isIndexing() && !this.myFirstScanPending.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleBulkUpdate(@NotNull HashSet<VirtualFile> mutableForUpdate) {
        boolean needUpdate;
        if (mutableForUpdate == null) {
            CidrTestListUpdater.$$$reportNull$$$0(4);
        }
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
            this.myScheduledFiles.forEach(file -> mutableForUpdate.remove(file));
            this.mySize = this.myIndex + this.myScheduledFiles.size();
            this.myScheduledFiles.addAll(mutableForUpdate);
            needUpdate = !this.myScheduledFiles.isEmpty();
        }
        if (needUpdate) {
            this.scheduleUpdatePass();
        }
    }

    private void initFirstScanUnderSyncIfNeed() {
        if (this.myFirstScanPending.compareAndSet(true, false)) {
            CidrTestListUpdater.fillCollectionWithTestFirst(this.myFramework.getPotentialTestHolderRoots(this.myProject), this.myScheduledFiles);
            ReadAction.run(() -> this.filterTestHoldersAndReadTestInfoForScheduledFiles());
        }
    }

    static void fillCollectionWithTestFirst(@NotNull Collection<VirtualFile> holders, @NotNull LinkedList<VirtualFile> collector) {
        if (holders == null) {
            CidrTestListUpdater.$$$reportNull$$$0(5);
        }
        if (collector == null) {
            CidrTestListUpdater.$$$reportNull$$$0(6);
        }
        holders.forEach(file -> {
            String lowName = StringUtil.toLowerCase((String)file.getName());
            if (StringUtil.contains((CharSequence)lowName, (CharSequence)"test") || StringUtil.endsWith((CharSequence)lowName, (CharSequence)".unit.cc")) {
                collector.addFirst((VirtualFile)file);
            } else {
                collector.addLast((VirtualFile)file);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleUpdatePass() {
        Ref<Task.Backgroundable> ref = this.myTask;
        synchronized (ref) {
            if (!this.myUpdateQueue.isEmpty() || this.myTask.get() != null || ourSchedulingDisabledInTests == Boolean.TRUE) {
                return;
            }
            this.myUpdateQueue.setMergingTimeSpan(this.myMergingTimeSpan);
            this.myTask.set((Object)this.getScanTask());
            CidrTestListUpdater.log(this.getId(), " schedule scan");
            this.myUpdateQueue.queue(new Update(this.getId() + " scan"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Ref<Task.Backgroundable> ref = CidrTestListUpdater.this.myTask;
                    synchronized (ref) {
                        Task.Backgroundable task = (Task.Backgroundable)CidrTestListUpdater.this.myTask.get();
                        if (task == null) {
                            CidrTestLog.LOG.warn(CidrTestListUpdater.this.getId() + " Warning: lost update");
                            return;
                        }
                        if (!CidrTestListUpdater.this.myFramework.canStartIndexing(CidrTestListUpdater.this.myProject)) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " postpone");
                            CidrTestListUpdater.this.increaseTimeForNextAttempt();
                            CidrTestListUpdater.this.myUpdateQueue.restartTimer();
                            CidrTestListUpdater.this.myUpdateQueue.queue((Update)this);
                            return;
                        }
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            if (!ourTaskExecutionDisabledInTests) {
                                CidrTestListUpdater.executeIndexingInBackground(false, task);
                            }
                            return;
                        }
                        CidrTestListUpdater.executeIndexingInBackground(Registry.is((String)"cidr.test.framework.showIndexingAsTask"), task);
                    }
                }
            });
        }
    }

    private static void executeIndexingInBackground(boolean asBackgroundTask, @NotNull Task.Backgroundable task) {
        if (task == null) {
            CidrTestListUpdater.$$$reportNull$$$0(7);
        }
        if (asBackgroundTask) {
            ProgressManager.getInstance().run((Task)task);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> task.run((ProgressIndicator)new ProgressIndicatorBase()));
        }
    }

    @NotNull
    @Contract(value=" -> new")
    private Task.Backgroundable getScanTask() {
        this.myFramework.indexingScheduled(this.myProject);
        return new Task.Backgroundable(this.myProject, CTestingBundle.message("test.finding.tests", this.myFramework.getFrameworkId()), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Ref<Task.Backgroundable> ref;
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                indicator.setFraction(CidrTestListUpdater.this.mySize == 0 ? 0.0 : (double)CidrTestListUpdater.this.myIndex / (double)CidrTestListUpdater.this.mySize);
                Iterator<VirtualFile> iterator = CidrTestListUpdater.this.getScheduledFilesIterator(indicator);
                try {
                    CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " start");
                    ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> CidrTestListUpdater.this.processTestInfo(iterator), (ProgressIndicator)new SensitiveProgressWrapper(indicator));
                    ref = CidrTestListUpdater.this.myTask;
                }
                catch (Throwable throwable) {
                    Ref<Task.Backgroundable> ref2 = CidrTestListUpdater.this.myTask;
                    synchronized (ref2) {
                        if (CidrTestListUpdater.this.myTask.get() == this) {
                            CidrTestListUpdater.this.myTask.set(null);
                        }
                        if (iterator.hasNext()) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " re-run scheduled");
                            CidrTestListUpdater.this.increaseTimeForNextAttempt();
                            CidrTestListUpdater.this.scheduleUpdatePass();
                        } else {
                            CidrTestListUpdater.this.myIndex = 0;
                            CidrTestListUpdater.this.myFramework.indexingFinished(this.myProject);
                            ApplicationManager.getApplication().executeOnPooledThread(() -> CidrTestListUpdater.this.runAfterIndexing());
                        }
                    }
                    throw throwable;
                }
                synchronized (ref) {
                    if (CidrTestListUpdater.this.myTask.get() == this) {
                        CidrTestListUpdater.this.myTask.set(null);
                    }
                    if (iterator.hasNext()) {
                        CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " re-run scheduled");
                        CidrTestListUpdater.this.increaseTimeForNextAttempt();
                        CidrTestListUpdater.this.scheduleUpdatePass();
                    } else {
                        CidrTestListUpdater.this.myIndex = 0;
                        CidrTestListUpdater.this.myFramework.indexingFinished(this.myProject);
                        ApplicationManager.getApplication().executeOnPooledThread(() -> CidrTestListUpdater.this.runAfterIndexing());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/execution/testing/CidrTestListUpdater$3", "run"));
            }
        };
    }

    private void increaseTimeForNextAttempt() {
        this.myMergingTimeSpan = MathUtil.clamp((int)(this.myMergingTimeSpan * 2), (int)1000, (int)30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterIndexing() {
        Object object = this.myRunAfterIndexedLock;
        synchronized (object) {
            while (true) {
                Runnable runnable;
                Deque<Runnable> deque = this.myRunWhenIndexed;
                synchronized (deque) {
                    if (this.myRunWhenIndexed.isEmpty()) {
                        break;
                    }
                    runnable = this.myRunWhenIndexed.peekFirst();
                }
                runnable.run();
                deque = this.myRunWhenIndexed;
                synchronized (deque) {
                    this.myRunWhenIndexed.removeFirst();
                }
            }
        }
    }

    protected void processTestInfo(@NotNull Iterator<VirtualFile> iterator) {
        if (iterator == null) {
            CidrTestListUpdater.$$$reportNull$$$0(8);
        }
        if (this.myFramework.consumeTestInfo(this.myProject, iterator, null, (Processor<Pair<PsiFile, CidrTestInfoForFile>>)((Processor)fileTestInfoPair -> {
            this.myFramework.initInfo((PsiFile)fileTestInfoPair.first, (CidrTestInfoForFile)((Object)((Object)fileTestInfoPair.second)));
            return true;
        }))) {
            CidrTestListUpdater.log(this.getId(), " scan finished");
            this.filterTestHoldersAndWriteIndexedTestInfo(this.myNeedSaveFirstScanResults.compareAndSet(true, false));
        }
    }

    @NotNull
    protected Iterator<VirtualFile> getScheduledFilesIterator(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CidrTestListUpdater.$$$reportNull$$$0(9);
        }
        return new Iterator<VirtualFile>(){
            private VirtualFile myProcessingFile = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                LinkedList<VirtualFile> linkedList = CidrTestListUpdater.this.myScheduledFiles;
                synchronized (linkedList) {
                    if (this.myProcessingFile != null) {
                        if (!CidrTestListUpdater.this.myScheduledFiles.remove(this.myProcessingFile)) {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Warning: lost processing file:", this.myProcessingFile);
                        } else {
                            CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Processed:", this.myProcessingFile);
                        }
                        this.myProcessingFile = null;
                    }
                    return !CidrTestListUpdater.this.myScheduledFiles.isEmpty();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VirtualFile next() {
                LinkedList<VirtualFile> linkedList = CidrTestListUpdater.this.myScheduledFiles;
                synchronized (linkedList) {
                    this.myProcessingFile = !CidrTestListUpdater.this.myScheduledFiles.isEmpty() ? CidrTestListUpdater.this.myScheduledFiles.peek() : null;
                    CidrTestListUpdater.log(CidrTestListUpdater.this.getId(), " Processing file:", this.myProcessingFile == null ? "(null)" : this.myProcessingFile);
                    if (CidrTestListUpdater.this.mySize > 0 && this.myProcessingFile != null) {
                        indicator.setFraction((double)CidrTestListUpdater.this.myIndex++ / (double)CidrTestListUpdater.this.mySize);
                        indicator.setText2(this.myProcessingFile.getPresentableUrl());
                    }
                    return this.myProcessingFile;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterTestHoldersAndWriteIndexedTestInfo(boolean saveTestInfo) {
        CidrTestLog.LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        Condition<VirtualFile> potentialValidTestHolder = this.myFramework.isPotentialValidTestHolder(this.myProject);
        HashMap<VirtualFile, CidrTestInfoForFile> hashMap = this.myIndexedTests;
        synchronized (hashMap) {
            ArrayList<Map.Entry<VirtualFile, CidrTestInfoForFile>> entries = new ArrayList<Map.Entry<VirtualFile, CidrTestInfoForFile>>(this.myIndexedTests.entrySet());
            CidrTestInfoSerializer serializer = new CidrTestInfoSerializer(this.myProject, this.myFramework);
            entries.forEach((Consumer<Map.Entry<VirtualFile, CidrTestInfoForFile>>)((Consumer<Map.Entry>)entry -> {
                VirtualFile virtualFile = (VirtualFile)entry.getKey();
                if (!potentialValidTestHolder.value((Object)virtualFile)) {
                    CidrTestListUpdater.log(this.getId(), " remove info about ", virtualFile);
                    this.myIndexedTests.remove(virtualFile);
                } else if (saveTestInfo) {
                    CidrTestListUpdater.log(this.getId(), " save info about ", virtualFile);
                    serializer.writeTestInfo(virtualFile, (CidrTestInfoForFile)((Object)((Object)entry.getValue())));
                }
            }));
        }
    }

    public void incTestInfoVersion() {
        ++this.myTestInfoVersion;
    }

    public long getModificationCount() {
        return this.myTestInfoVersion;
    }

    @NotNull
    public List<Location> getLocation(@NotNull Computable<List<Location>> findLocationsInScope) {
        if (findLocationsInScope == null) {
            CidrTestListUpdater.$$$reportNull$$$0(10);
        }
        ++this.myLocationResolveCount;
        List<Location> list = CidrTestFrameworkBase.getFromSymbols(Collections.emptyList(), this.myProject, findLocationsInScope);
        if (list == null) {
            CidrTestListUpdater.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static void log(@NonNls @NotNull String message, Object ... details) {
        if (message == null) {
            CidrTestListUpdater.$$$reportNull$$$0(12);
        }
        if (details == null) {
            CidrTestListUpdater.$$$reportNull$$$0(13);
        }
        CidrTestLog.LOG.debug(message, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenIndexed(Runnable runnable) {
        Deque<Runnable> deque = this.myRunWhenIndexed;
        synchronized (deque) {
            if (this.myFirstScanPending.get()) {
                this.doScheduleUpdate(null);
            }
            if (this.isIndexing()) {
                this.myRunWhenIndexed.addLast(runnable);
                return;
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterTestHoldersAndReadTestInfoForScheduledFiles() {
        CidrTestLog.LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            HashSet filesWithActualTestInfo = new HashSet();
            CidrTestInfoSerializer serializer = new CidrTestInfoSerializer(this.myProject, this.myFramework);
            int scheduledSize = this.myScheduledFiles.size();
            this.myScheduledFiles.forEach(vf -> {
                Pair<Boolean, CidrTestInfoForFile> actualAndTestInfo = serializer.filterTestHoldersAndReadTestInfo((VirtualFile)vf);
                if (this.myScheduledFiles.size() != scheduledSize) {
                    CidrTestLog.LOG.error("Concurrent modification while loading test info: " + this.myScheduledFiles.size() + " -> " + scheduledSize);
                }
                if (actualAndTestInfo != null) {
                    if (actualAndTestInfo.second != null) {
                        this.myIndexedTests.put((VirtualFile)vf, (CidrTestInfoForFile)((Object)((Object)actualAndTestInfo.second)));
                    }
                    if (((Boolean)actualAndTestInfo.first).booleanValue()) {
                        filesWithActualTestInfo.add(vf);
                    }
                }
            });
            this.myScheduledFiles.removeAll(filesWithActualTestInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void dropTestInfo() {
        Object object = this.myTask;
        synchronized (object) {
            this.myUpdateQueue.cancelAllUpdates();
            this.myTask.set(null);
        }
        object = this.myScheduledFiles;
        synchronized (object) {
            this.myIndexedTests.clear();
            this.myFirstScanPending.set(true);
            this.myScheduledFiles.clear();
            this.mySize = 0;
            this.myIndex = 0;
        }
    }

    @TestOnly
    public Iterator<VirtualFile> getScheduledFilesIterator() {
        return this.getScheduledFilesIterator((ProgressIndicator)new EmptyProgressIndicator());
    }

    @TestOnly
    public Collection<VirtualFile> getProcessingQueue() {
        return this.myScheduledFiles;
    }

    @TestOnly
    public void processTestInfoDirectly(@NotNull Iterator<VirtualFile> iterator) {
        if (iterator == null) {
            CidrTestListUpdater.$$$reportNull$$$0(14);
        }
        this.processTestInfo(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void initFirstScanIfNeedDirectly() {
        LinkedList<VirtualFile> linkedList = this.myScheduledFiles;
        synchronized (linkedList) {
            this.initFirstScanUnderSyncIfNeed();
        }
    }

    @TestOnly
    public long getLocationResolveCount() {
        return this.myLocationResolveCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public boolean waitForIndexingToFinish() throws TimeoutException {
        if (ourSchedulingDisabledInTests == Boolean.TRUE) {
            return true;
        }
        Semaphore s = new Semaphore(1);
        Deque<Runnable> deque = this.myRunWhenIndexed;
        synchronized (deque) {
            if (!this.isIndexing() && this.myRunWhenIndexed.isEmpty()) {
                if (!this.myFirstScanPending.get()) {
                    return true;
                }
                this.doScheduleUpdate(null);
            }
            this.myRunWhenIndexed.addLast(() -> ((Semaphore)s).up());
        }
        long limit = 900000L;
        int step = 100;
        while (!s.waitFor((long)step)) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            if ((limit -= (long)step) > 0L) continue;
            PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
            throw new TimeoutException();
        }
        Deque<Runnable> deque2 = this.myRunWhenIndexed;
        synchronized (deque2) {
            return this.myRunWhenIndexed.isEmpty();
        }
    }

    @TestOnly
    public static void setSchedulingDisabledInTests(Boolean schedulingDisabledInTests) {
        if (ourSchedulingDisabledInTests == null || schedulingDisabledInTests == null) {
            ourSchedulingDisabledInTests = schedulingDisabledInTests;
        }
    }

    @TestOnly
    public static Boolean getSchedulingDisabledInTests() {
        return ourSchedulingDisabledInTests;
    }

    @TestOnly
    public static void setTaskExecutionDisabledInTests(boolean taskExecutionDisabledInTests) {
        ourTaskExecutionDisabledInTests = taskExecutionDisabledInTests;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestListUpdater";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToScan";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutableForUpdate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findLocationsInScope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestListUpdater";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleBulkUpdate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillCollectionWithTestFirst";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeIndexingInBackground";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTestInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScheduledFilesIterator";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processTestInfoDirectly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

