/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCBasicHighlighter
extends OCAnnotator {
    @Override
    public void visitDefineDirective(OCDefineDirectiveImpl directive) {
        this.highlight(directive.getNameIdentifier(), OCHighlightingKeys.MACRONAME);
    }

    @Override
    public void visitMacroReferenceElement(OCMacroReferenceElementImpl element) {
        this.highlight(element, OCHighlightingKeys.MACRONAME);
    }

    @Override
    public void visitMacroCall(OCMacroCall macroCall) {
        this.highlight(macroCall.getMacroReferenceElement(), OCHighlightingKeys.MACRONAME);
        super.visitMacroCall(macroCall);
    }

    public void visitComment(@NotNull PsiComment comment) {
        IElementType tt;
        ASTNode node;
        if (comment == null) {
            OCBasicHighlighter.$$$reportNull$$$0(0);
        }
        if ((node = comment.getNode()) != null && (tt = node.getElementType()) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT && this.getHolder() != null) {
            this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(OCHighlightingKeys.CONDITIONALLY_NOT_COMPILED).create();
        }
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression) {
        OCFileHighlighter fhl = null;
        Lexer lexer = null;
        String text = null;
        for (ASTNode child = expression.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!OCTokenTypes.RAW_STRING_LITERALS.contains(OCElementUtil.getElementType(child))) continue;
            if (fhl == null) {
                OCLexerSettings lexerSettings = OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.CPP).forHighlighting().build();
                fhl = new OCFileHighlighter(lexerSettings);
                lexer = fhl.getHighlightingLexer();
                text = expression.getContainingFile().getText();
            }
            TextRange range = child.getTextRange();
            lexer.start(text, range.getStartOffset(), range.getEndOffset());
            while (lexer.getTokenType() != null) {
                TextRange tr = new TextRange(lexer.getTokenStart(), lexer.getTokenEnd());
                TextAttributesKey[] ta = fhl.getTokenHighlights(lexer.getTokenType());
                if (ta.length > 0) {
                    this.highlight(tr, ta[0]);
                }
                lexer.advance();
            }
        }
    }

    private void highlightVirtSpecifier(@NotNull OCElement element) {
        if (element == null) {
            OCBasicHighlighter.$$$reportNull$$$0(1);
        }
        if (!element.getContainingOCFile().isCpp()) {
            return;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!OCTokenTypes.CPP_VIRTUAL_SPECIFIERS.contains(OCElementUtil.getElementType(child))) continue;
            this.highlight(child, OCHighlightingKeys.OC_KEYWORD);
        }
    }

    @Override
    public void visitDeclarator(@NotNull OCDeclarator declarator) {
        if (declarator == null) {
            OCBasicHighlighter.$$$reportNull$$$0(2);
        }
        this.highlightVirtSpecifier(declarator);
    }

    @Override
    public void visitStructLike(@NotNull OCStructLike struct) {
        if (struct == null) {
            OCBasicHighlighter.$$$reportNull$$$0(3);
        }
        this.highlightVirtSpecifier(struct);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struct";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCBasicHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightVirtSpecifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDeclarator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitStructLike";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

