/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class OCQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler {
    private static final TokenSet CONCATENATABLE_STRING = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.STRING_LITERAL});

    public OCQuoteHandler() {
        super(new IElementType[]{OCTokenTypes.STRING_LITERAL, OCTokenTypes.CHARACTER_LITERAL});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (OCQuoteHandler.isInsideNumericLiteral(iterator)) {
            return false;
        }
        boolean openingQuote = super.isOpeningQuote(iterator, offset);
        if (openingQuote && !iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                openingQuote = false;
            }
            iterator.advance();
        }
        return openingQuote;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (OCQuoteHandler.isInsideNumericLiteral(iterator)) {
            return false;
        }
        boolean closingQuote = super.isClosingQuote(iterator, offset);
        if (closingQuote && !iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                closingQuote = false;
            }
            iterator.retreat();
        }
        return closingQuote;
    }

    private static boolean isInsideNumericLiteral(HighlighterIterator iterator) {
        boolean insideNumeric = false;
        if (iterator.getStart() > 0) {
            iterator.retreat();
            insideNumeric = OCTokenTypes.ALL_NUMERIC.contains(iterator.getTokenType());
            iterator.advance();
        }
        return insideNumeric;
    }

    @NotNull
    public TokenSet getConcatenatableStringTokenTypes() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            OCQuoteHandler.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "";
    }

    public TokenSet getStringTokenTypes() {
        return CONCATENATABLE_STRING;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            OCQuoteHandler.$$$reportNull$$$0(1);
        }
        return OCQuoteHandler.isAppropriateElementTypeForLiteralStatic(tokenType);
    }

    public static boolean isAppropriateElementTypeForLiteralStatic(IElementType tokenType) {
        return OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tokenType) || tokenType == OCTokenTypes.SEMICOLON || tokenType == OCTokenTypes.COMMA || tokenType == OCTokenTypes.RPAR || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.STRING_LITERAL || tokenType == OCTokenTypes.CHARACTER_LITERAL;
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCQuoteHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenatableStringTokenTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCQuoteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateElementTypeForLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

