/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingComparable;
import com.intellij.psi.WeighingService;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class SymbolProximityComparator
implements Comparator<Object> {
    public static final Key<Weigher<OCSymbol, ProximityLocation>> WEIGHER_KEY = Key.create((String)"symbolProximity");
    private final PsiElement myContext;
    private final Map<OCSymbol, WeighingComparable<OCSymbol, ProximityLocation>> myProximities;
    private static final Key<Module> MODULE_BY_LOCATION = Key.create((String)"ModuleByLocation");

    public SymbolProximityComparator(@Nullable PsiElement context) {
        this.myContext = context;
        this.myProximities = FactoryMap.create(key -> SymbolProximityComparator.getProximity(key, this.myContext));
    }

    @Override
    public int compare(Object o1, Object o2) {
        OCSymbol element2;
        OCSymbol element1 = o1 instanceof OCSymbol ? (OCSymbol)o1 : null;
        OCSymbol oCSymbol = element2 = o2 instanceof OCSymbol ? (OCSymbol)o2 : null;
        if (element1 == null) {
            return element2 == null ? 0 : 1;
        }
        if (element2 == null) {
            return -1;
        }
        WeighingComparable<OCSymbol, ProximityLocation> proximity1 = this.myProximities.get(element1);
        WeighingComparable<OCSymbol, ProximityLocation> proximity2 = this.myProximities.get(element2);
        if (proximity1 == null || proximity2 == null) {
            return 0;
        }
        if (!proximity1.equals(proximity2)) {
            return -proximity1.compareTo(proximity2);
        }
        return 0;
    }

    @Nullable
    public static WeighingComparable<OCSymbol, ProximityLocation> getProximity(OCSymbol element, PsiElement context) {
        if (element == null) {
            return null;
        }
        Module contextModule = context != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)context) : null;
        return WeighingService.weigh(WEIGHER_KEY, (Object)element, (Object)new ProximityLocation(context, contextModule));
    }

    @Nullable
    public static WeighingComparable<OCSymbol, ProximityLocation> getProximity(OCSymbol element, PsiElement context, ProcessingContext processingContext) {
        if (element == null) {
            return null;
        }
        if (context == null) {
            return null;
        }
        Module contextModule = (Module)processingContext.get(MODULE_BY_LOCATION);
        if (contextModule == null) {
            contextModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            processingContext.put(MODULE_BY_LOCATION, (Object)contextModule);
        }
        if (contextModule == null) {
            return null;
        }
        return WeighingService.weigh(WEIGHER_KEY, (Object)element, (Object)new ProximityLocation(context, contextModule, processingContext));
    }
}

