/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.parameterInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCFunctionCallPlace<T extends PsiElement> {
    @NotNull
    private final T myElement;
    private static final Pattern LINE_BREAKS = Pattern.compile("\\s*\n+\\s*");

    public OCFunctionCallPlace(@NotNull T element) {
        if (element == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    protected static void collectInitializationOptions(@NotNull OCType type, @NotNull OCElement place, @NotNull Collection<OCFunctionCallOption> result) {
        if (type == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(1);
        }
        if (place == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(2);
        }
        if (result == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(3);
        }
        if (!place.getContainingOCFile().getKind().isCpp() || !type.isInstanceable()) {
            return;
        }
        if (type instanceof OCStructType) {
            OCFunctionCallPlace.collectConstructorCallOptions(type, place, result);
        } else {
            if (!(type instanceof OCCppReferenceType)) {
                OCFunctionType t = new OCFunctionType(OCVoidType.instance(), Collections.emptyList());
                result.add(new OCFunctionCallOption(new OCFunctionParameterInfo(t, null), -2));
            }
            OCFunctionType init = new OCFunctionType(OCVoidType.instance(), Collections.singletonList(type), Collections.singletonList("<unnamed>"));
            result.add(new OCFunctionCallOption(new OCFunctionParameterInfo(init, null), -1));
        }
    }

    protected static void collectConstructorCallOptions(@NotNull OCType rt, @NotNull PsiElement place, @NotNull Collection<OCFunctionCallOption> result) {
        Collection functionSymbols;
        if (rt == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(4);
        }
        if (place == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(5);
        }
        if (result == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(6);
        }
        if (rt instanceof OCStructType) {
            CommonProcessors.CollectProcessor constructors = new CommonProcessors.CollectProcessor();
            ((OCStructType)rt).getSymbol().processConstructors((Processor<? super OCFunctionSymbol>)constructors, OCResolveContext.forPsi(place));
            functionSymbols = constructors.getResults();
        } else {
            functionSymbols = null;
        }
        OCFunctionCallPlace.collectCallOptions(result, place, functionSymbols, null);
    }

    protected static void collectCallOptions(@NotNull Collection<OCFunctionCallOption> result, @NotNull PsiElement place, @Nullable Collection<OCSymbol> functionSymbols, @Nullable OCType qualifierType) {
        if (result == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(7);
        }
        if (place == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(8);
        }
        if (functionSymbols != null) {
            for (OCSymbol symbol : functionSymbols) {
                OCType type;
                OCFunctionSymbol s;
                OCFunctionDefinition funcDef;
                if (symbol == null || (funcDef = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, OCFunctionDefinition.class)) != null && (s = funcDef.getSymbol()) != null && s.getKind() == OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION && symbol.isSameSymbol(s, place.getProject()) || !OCVisibility.isVisible(symbol, place, qualifierType, place.getProject()) || !((type = symbol.getType().resolve(place).getTerminalType()) instanceof OCFunctionType)) continue;
                OCFunctionType funType = (OCFunctionType)type;
                List defaultValues = null;
                if (symbol instanceof OCFunctionSymbol && !funType.hasNoParameters()) {
                    List<OCDeclaratorSymbol> params = ((OCFunctionSymbol)symbol).getParameterSymbols(OCResolveContext.forPsi(place));
                    defaultValues = ContainerUtil.map(params, symbol1 -> {
                        OCExpressionSymbol initializer = symbol1.getInitializerExpression();
                        if (initializer == null) {
                            return null;
                        }
                        return LINE_BREAKS.matcher(initializer.getPresentableName()).replaceAll(" ");
                    });
                }
                OCFunctionParameterInfo info = new OCFunctionParameterInfo(funType, defaultValues);
                result.add(new OCFunctionCallOption(info, symbol.getOffset()));
            }
        }
    }

    @NotNull
    public T getElement() {
        T t = this.myElement;
        if (t == null) {
            OCFunctionCallPlace.$$$reportNull$$$0(9);
        }
        return t;
    }

    public abstract void collectCallOptions(@NotNull Collection<OCFunctionCallOption> var1);

    @NotNull
    public abstract List<OCExpression> getArgumentExpressions();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rt";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectInitializationOptions";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectConstructorCallOptions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectCallOptions";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

