/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.surround.OCSurroundUtil;
import com.jetbrains.cidr.lang.editor.surround.OCSurrounder;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OCStatementSurrounder<T extends OCStatement>
extends OCSurrounder {
    OCStatementSurrounder() {
    }

    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        if (project == null) {
            OCStatementSurrounder.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCStatementSurrounder.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            OCStatementSurrounder.$$$reportNull$$$0(2);
        }
        return this.doSurroundElements(project, elements, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextRange doSurroundElements(Project project, PsiElement[] elements, @Nullable Object chosenElement) {
        PsiElement container = elements[0].getParent();
        if ((elements = OCSurroundUtil.moveDeclarationsOut(container, elements, true)).length == 0) {
            return null;
        }
        T newStatement = this.upcast(OCElementFactory.statementFromText(this.getStatementTemplate(project, elements[0]), container));
        newStatement = this.upcast((OCStatement)container.addBefore(newStatement, elements[0]));
        this.insertOldElements(elements, container, newStatement, chosenElement);
        TextRange toSelect = this.getSelectionRange(newStatement);
        Document document = newStatement.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            return toSelect;
        }
        RangeMarker selectionMarker = document.createRangeMarker(toSelect);
        try {
            OCChangeUtil.reformatElementAfterInsertionIfNeed(newStatement);
            TextRange textRange = TextRange.create((Segment)selectionMarker);
            return textRange;
        }
        finally {
            selectionMarker.dispose();
        }
    }

    protected void insertOldElements(PsiElement[] elements, PsiElement container, T newStatement, @Nullable Object chosenElement) {
        PsiElement insertBeforeNode = this.getInsertionPlace(newStatement);
        PsiElement firstElement = elements[0];
        PsiElement lastElement = elements[elements.length - 1];
        insertBeforeNode.addRangeBefore(firstElement, lastElement, insertBeforeNode.getLastChild());
        if (OCElementUtil.getElementType(lastElement) == OCTokenTypes.EOL_COMMENT) {
            insertBeforeNode.addBefore(OCElementFactory.newlineFromText(lastElement), insertBeforeNode.getLastChild());
        }
        container.deleteChildRange(firstElement, lastElement);
    }

    private T upcast(OCStatement t) {
        return (T)t;
    }

    @NonNls
    protected abstract String getStatementTemplate(Project var1, PsiElement var2);

    protected abstract PsiElement getInsertionPlace(T var1);

    protected abstract TextRange getSelectionRange(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/surround/OCStatementSurrounder";
        objectArray[2] = "surroundElements";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

