/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCGenerateGetterSetterContext
extends OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> {
    private Mode myMode;

    public OCGenerateGetterSetterContext(OCStructSymbol parent, PsiElement context, Mode mode) {
        super(parent, context);
        this.myMode = mode;
    }

    public boolean hasGetter(OCDeclaratorSymbol field) {
        Project project = this.getProject();
        return !((OCStructSymbol)this.getParent()).processFunctions(OCNameSuggester.getCppGetterName(field, project), (Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol function) {
                return function.getParameterSymbols().isEmpty();
            }
        });
    }

    public boolean hasSetter(final OCDeclaratorSymbol field) {
        final Project project = this.getProject();
        return !((OCStructSymbol)this.getParent()).processFunctions(OCNameSuggester.getCppSetterName(field, project), (Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol function) {
                if (function.getParameterSymbols().size() == 1) {
                    OCType type = function.getParameterSymbols().get(0).getType();
                    while (type instanceof OCCppReferenceType) {
                        type = ((OCCppReferenceType)type).getRefType();
                    }
                    if (new OCTypeEqualityAfterResolvingVisitor(field.getType(), false, false, true, true, OCResolveContext.forSymbol(function, project)).equal(type)) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public boolean needGetter(OCDeclaratorSymbol field) {
        return (this.myMode == Mode.GETTER || this.myMode == Mode.GETTER_SETTER) && !this.hasGetter(field) && !OCGenerateGetterSetterContext.isMultiArray(field, OCResolveContext.forPsi(this.getContext()));
    }

    public boolean needSetter(OCDeclaratorSymbol field) {
        return (this.myMode == Mode.SETTER || this.myMode == Mode.GETTER_SETTER) && !this.hasSetter(field) && !OCGenerateGetterSetterContext.isReadOnly(field) && !OCGenerateGetterSetterContext.isArray(field, OCResolveContext.forPsi(this.getContext()));
    }

    private static boolean isMultiArray(OCDeclaratorSymbol field, @NotNull OCResolveContext context) {
        OCType fieldType;
        if (context == null) {
            OCGenerateGetterSetterContext.$$$reportNull$$$0(0);
        }
        if (!((fieldType = field.getType().resolve(context)) instanceof OCArrayType)) {
            return false;
        }
        return ((OCArrayType)fieldType).getRefType().resolve(context) instanceof OCArrayType;
    }

    private static boolean isArray(OCDeclaratorSymbol field, @NotNull OCResolveContext context) {
        if (context == null) {
            OCGenerateGetterSetterContext.$$$reportNull$$$0(1);
        }
        return field.getType().resolve(context) instanceof OCArrayType;
    }

    private static boolean isReadOnly(OCDeclaratorSymbol field) {
        return field.isConst() || field.getType() instanceof OCCppReferenceType && ((OCCppReferenceType)field.getType()).isReferenceToConst();
    }

    @Override
    @NotNull
    public Collection<OCDeclaratorSymbol> getMemberCandidates() {
        ArrayList<OCDeclaratorSymbol> list = new ArrayList<OCDeclaratorSymbol>();
        ((OCStructSymbol)this.getParent()).processFields((Processor<? super OCDeclaratorSymbol>)((Processor)field -> {
            if (field.getKind() == OCSymbolKind.STRUCT_FIELD && !OCCodeInsightUtil.isUnnamed(field) && (this.needGetter((OCDeclaratorSymbol)field) || this.needSetter((OCDeclaratorSymbol)field))) {
                list.add((OCDeclaratorSymbol)field);
            }
            return true;
        }));
        ArrayList<OCDeclaratorSymbol> arrayList = list;
        if (arrayList == null) {
            OCGenerateGetterSetterContext.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/actions/OCGenerateGetterSetterContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/actions/OCGenerateGetterSetterContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMultiArray";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isArray";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Mode {
        GETTER,
        SETTER,
        GETTER_SETTER;

    }
}

