/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCObjCActionContext<M extends OCMemberSymbol>
extends OCActionContext<OCClassSymbol, M> {
    protected OCClassSymbol myInterfaceSymbol;
    protected OCImplementationSymbol myImplementationSymbol;
    protected OCObjectType myType;

    public OCObjCActionContext(OCClassSymbol symbol, @NotNull PsiElement context, OCObjectType type) {
        if (context == null) {
            OCObjCActionContext.$$$reportNull$$$0(0);
        }
        super(symbol, context);
        this.myInterfaceSymbol = symbol != null ? symbol.getInterfaceOrProtocol(this.getProject()) : null;
        this.myImplementationSymbol = symbol != null ? symbol.getImplementation(this.getProject()) : null;
        this.myType = type;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.myImplementationSymbol != null && this.myInterfaceSymbol != null && this.getType() != null;
    }

    @Override
    public List<? extends OCSymbol> getSymbolsToModify() {
        return Arrays.asList(this.myInterfaceSymbol, this.myImplementationSymbol);
    }

    @Override
    @NotNull
    public Collection<M> getMemberCandidates() {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.myInterfaceSymbol.processMembers(this.getMemberSymbolClass(), collector);
        Collection collection = collector.getResults();
        if (collection == null) {
            OCObjCActionContext.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    protected Class getMemberSymbolClass() {
        return OCMemberSymbol.class;
    }

    public OCClassSymbol getInterfaceSymbol() {
        return this.myInterfaceSymbol;
    }

    public OCImplementationSymbol getImplementationSymbol() {
        return this.myImplementationSymbol;
    }

    public OCObjectType getType() {
        return this.myType;
    }

    @Override
    public Map<OCSymbol, OCSymbol> createParentsMap(Collection<M> candidates) {
        HashMap<OCSymbol, OCSymbol> map = new HashMap<OCSymbol, OCSymbol>();
        for (OCMemberSymbol candidate : candidates) {
            OCClassSymbol parent = candidate.getParent();
            map.put(candidate, parent);
            if (parent.getCategoryName() == null) continue;
            map.put(parent, parent.getMainInterface(this.getProject()));
        }
        for (OCObjectType type = this.myType; type != null; type = type.getSuperType()) {
            for (OCProtocolSymbol protocol : type.getAllProtocols()) {
                if (map.containsKey(protocol)) continue;
                map.put(protocol, type.getClassSymbol());
            }
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/actions/OCObjCActionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/actions/OCObjCActionContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

